/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.ConstraintValidatorFactory;
import javax.validation.MessageInterpolator;
import javax.validation.TraversableResolver;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import javax.validation.bootstrap.ProviderSpecificBootstrap;
import javax.validation.spi.ConfigurationState;
import org.apache.bval.jsr303.ApacheFactoryContext;
import org.apache.bval.jsr303.ApacheValidationProvider;
import org.apache.bval.jsr303.ApacheValidatorConfiguration;
import org.apache.bval.jsr303.ConstraintCached;
import org.apache.bval.jsr303.ConstraintDefaults;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.bval.jsr303.xml.AnnotationIgnores;
import org.apache.bval.jsr303.xml.MetaConstraint;
import org.apache.bval.jsr303.xml.ValidationMappingParser;
import org.apache.bval.util.AccessStrategy;
import org.apache.commons.lang.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApacheValidatorFactory
implements ValidatorFactory,
Cloneable {
    private static volatile ApacheValidatorFactory DEFAULT_FACTORY;
    private static final ConstraintDefaults defaultConstraints;
    private MessageInterpolator messageResolver;
    private TraversableResolver traversableResolver;
    private ConstraintValidatorFactory constraintValidatorFactory;
    private final Map<String, String> properties;
    private final AnnotationIgnores annotationIgnores = new AnnotationIgnores();
    private final ConstraintCached constraintsCache = new ConstraintCached();
    private final Map<Class<?>, Class<?>[]> defaultSequences;
    private final Map<Class<?>, List<AccessStrategy>> validAccesses;
    private final Map<Class<?>, List<MetaConstraint<?, ? extends Annotation>>> constraintMap;

    public static synchronized ApacheValidatorFactory getDefault() {
        if (DEFAULT_FACTORY == null) {
            ProviderSpecificBootstrap provider = Validation.byProvider(ApacheValidationProvider.class);
            ApacheValidatorConfiguration configuration = (ApacheValidatorConfiguration)provider.configure();
            DEFAULT_FACTORY = (ApacheValidatorFactory)configuration.buildValidatorFactory();
        }
        return DEFAULT_FACTORY;
    }

    public static void setDefault(ApacheValidatorFactory aDefaultFactory) {
        DEFAULT_FACTORY = aDefaultFactory;
    }

    public ApacheValidatorFactory(ConfigurationState configurationState) {
        this.properties = new HashMap<String, String>();
        this.defaultSequences = new HashMap();
        this.validAccesses = new HashMap();
        this.constraintMap = new HashMap();
        this.configure(configurationState);
    }

    protected void configure(ConfigurationState configuration) {
        this.getProperties().putAll(configuration.getProperties());
        this.setMessageInterpolator(configuration.getMessageInterpolator());
        this.setTraversableResolver(configuration.getTraversableResolver());
        this.setConstraintValidatorFactory(configuration.getConstraintValidatorFactory());
        ValidationMappingParser parser = new ValidationMappingParser(this);
        parser.processMappingConfig(configuration.getMappingStreams());
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    protected MessageInterpolator getDefaultMessageInterpolator() {
        return this.messageResolver;
    }

    public Validator getValidator() {
        return this.usingContext().getValidator();
    }

    public ApacheFactoryContext usingContext() {
        return new ApacheFactoryContext(this);
    }

    public synchronized ApacheValidatorFactory clone() {
        try {
            return (ApacheValidatorFactory)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public final void setMessageInterpolator(MessageInterpolator messageResolver) {
        this.messageResolver = messageResolver;
    }

    public MessageInterpolator getMessageInterpolator() {
        return this.messageResolver != null ? this.messageResolver : this.getDefaultMessageInterpolator();
    }

    public final void setTraversableResolver(TraversableResolver traversableResolver) {
        this.traversableResolver = traversableResolver;
    }

    public TraversableResolver getTraversableResolver() {
        return this.traversableResolver;
    }

    public final void setConstraintValidatorFactory(ConstraintValidatorFactory constraintValidatorFactory) {
        this.constraintValidatorFactory = constraintValidatorFactory;
    }

    public ConstraintValidatorFactory getConstraintValidatorFactory() {
        return this.constraintValidatorFactory;
    }

    public <T> T unwrap(Class<T> type) {
        if (type.isInstance(this)) {
            ApacheValidatorFactory result = this;
            return (T)result;
        }
        if (!type.isInterface() && !Modifier.isAbstract(type.getModifiers())) {
            return SecureActions.newInstance(type);
        }
        try {
            Class cls = ClassUtils.getClass((String)(type.getName() + "Impl"));
            if (type.isAssignableFrom(cls)) {
                Class implClass = cls;
                return SecureActions.newInstance(implClass);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        throw new ValidationException("Type " + type + " not supported");
    }

    public ConstraintDefaults getDefaultConstraints() {
        return defaultConstraints;
    }

    public AnnotationIgnores getAnnotationIgnores() {
        return this.annotationIgnores;
    }

    public ConstraintCached getConstraintsCache() {
        return this.constraintsCache;
    }

    public void addMetaConstraint(Class<?> beanClass, MetaConstraint<?, ?> metaConstraint) {
        List<MetaConstraint<?, Annotation>> slot = this.constraintMap.get(beanClass);
        if (slot != null) {
            slot.add(metaConstraint);
        } else {
            ArrayList constraintList = new ArrayList();
            constraintList.add(metaConstraint);
            this.constraintMap.put(beanClass, constraintList);
        }
    }

    public void addValid(Class<?> beanClass, AccessStrategy accessStrategy) {
        List<AccessStrategy> slot = this.validAccesses.get(beanClass);
        if (slot != null) {
            slot.add(accessStrategy);
        } else {
            ArrayList<AccessStrategy> tmpList = new ArrayList<AccessStrategy>();
            tmpList.add(accessStrategy);
            this.validAccesses.put(beanClass, tmpList);
        }
    }

    public void addDefaultSequence(Class<?> beanClass, Class<?>[] groupSequence) {
        this.defaultSequences.put(beanClass, groupSequence);
    }

    public <T> List<MetaConstraint<T, ? extends Annotation>> getMetaConstraints(Class<T> beanClass) {
        List<MetaConstraint<T, ? extends Annotation>> slot = this.constraintMap.get(beanClass);
        if (slot != null) {
            return slot;
        }
        return Collections.EMPTY_LIST;
    }

    public List<AccessStrategy> getValidAccesses(Class<?> beanClass) {
        List<AccessStrategy> slot = this.validAccesses.get(beanClass);
        if (slot != null) {
            return slot;
        }
        return Collections.emptyList();
    }

    public Class<?>[] getDefaultSequence(Class<?> beanClass) {
        return this.defaultSequences.get(beanClass);
    }

    static {
        defaultConstraints = new ConstraintDefaults();
    }
}

