/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr.metadata;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.validation.ConstraintValidator;
import org.apache.bval.jsr.metadata.AnnotationBehavior;
import org.apache.bval.jsr.metadata.AnnotationBehaviorMergeStrategy;
import org.apache.bval.jsr.metadata.HasAnnotationBehavior;
import org.apache.bval.util.Validate;

public class ValidatorMapping<A extends Annotation>
implements HasAnnotationBehavior {
    private static final ValidatorMapping EMPTY = new ValidatorMapping("empty", Collections.emptyList());
    private final String source;
    private final List<Class<? extends ConstraintValidator<A, ?>>> validatorTypes;
    private final AnnotationBehavior annotationBehavior;

    public static <A extends Annotation> ValidatorMapping<A> empty() {
        return EMPTY;
    }

    public static <A extends Annotation> ValidatorMapping<A> merge(List<? extends ValidatorMapping<A>> validatorMappings, AnnotationBehaviorMergeStrategy annotationBehaviorMergeStrategy) {
        AnnotationBehavior behavior = (AnnotationBehavior)annotationBehaviorMergeStrategy.apply(validatorMappings);
        List nonEmpty = validatorMappings.stream().filter(m -> !m.isEmpty()).collect(Collectors.toList());
        if (nonEmpty.size() <= 1) {
            ValidatorMapping simpleResult;
            ValidatorMapping validatorMapping = simpleResult = nonEmpty.isEmpty() ? ValidatorMapping.empty() : (ValidatorMapping)nonEmpty.get(0);
            if (simpleResult.hasBehavior(behavior)) {
                return simpleResult;
            }
        }
        String source = nonEmpty.stream().map(ValidatorMapping::getSource).collect(Collectors.joining(";", "[", "]"));
        return new ValidatorMapping<A>(source, nonEmpty.stream().map(ValidatorMapping::getValidatorTypes).flatMap(Collection::stream).distinct().collect(Collectors.toList()), behavior);
    }

    public ValidatorMapping(String source, List<Class<? extends ConstraintValidator<A, ?>>> validatorTypes) {
        this(source, validatorTypes, AnnotationBehavior.ABSTAIN);
    }

    public ValidatorMapping(String source, List<Class<? extends ConstraintValidator<A, ?>>> validatorTypes, AnnotationBehavior annotationBehavior) {
        this.source = Objects.toString(source, "unspecified");
        this.validatorTypes = Collections.unmodifiableList(Validate.notNull(validatorTypes, "validatorTypes", new Object[0]));
        this.annotationBehavior = Validate.notNull(annotationBehavior, "annotationBehavior", new Object[0]);
    }

    public List<Class<? extends ConstraintValidator<A, ?>>> getValidatorTypes() {
        return this.validatorTypes;
    }

    @Override
    public AnnotationBehavior getAnnotationBehavior() {
        return this.annotationBehavior;
    }

    public boolean isEmpty() {
        return this.validatorTypes.isEmpty();
    }

    public String getSource() {
        return this.source;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!this.getClass().isInstance(obj)) {
            return false;
        }
        ValidatorMapping other = (ValidatorMapping)obj;
        return this.getSource().equals(other.getSource()) && this.getAnnotationBehavior() == other.getAnnotationBehavior() && this.getValidatorTypes().equals(other.getValidatorTypes());
    }

    public int hashCode() {
        return Objects.hash(this.getSource(), this.getAnnotationBehavior(), this.getValidatorTypes());
    }

    public String toString() {
        return String.format("%s[source: %s; annotationBehavior: %s; validatorTypes: %s]", ValidatorMapping.class.getSimpleName(), this.getSource(), this.getAnnotationBehavior(), this.getValidatorTypes());
    }

    public boolean hasBehavior(AnnotationBehavior annotationBehavior) {
        return this.getAnnotationBehavior() == annotationBehavior;
    }
}

