/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import java.io.IOException;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;

public class BookieService
extends ServerLifecycleComponent {
    public static final String NAME = "bookie-server";
    private final BookieServer server;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger) throws Exception {
        super(NAME, conf, statsLogger);
        this.server = new BookieServer(conf.getServerConf(), statsLogger);
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler handler) {
        super.setExceptionHandler(handler);
        this.server.setExceptionHandler(handler);
    }

    public BookieServer getServer() {
        return this.server;
    }

    protected void doStart() {
        try {
            this.server.start();
        }
        catch (InterruptedException exc) {
            throw new RuntimeException("Failed to start bookie server", exc);
        }
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.server.shutdown();
    }
}

