/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto.checksum;

import com.scurrilous.circe.checksum.Crc32cIntChecksum;
import com.scurrilous.circe.crc.Sse42Crc32C;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.concurrent.FastThreadLocal;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.commons.lang3.mutable.MutableInt;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class CRC32CDigestManager
extends DigestManager {
    private static final Logger log = LoggerFactory.getLogger(CRC32CDigestManager.class);
    private static final FastThreadLocal<MutableInt> currentCrc = new FastThreadLocal<MutableInt>(){

        protected MutableInt initialValue() throws Exception {
            return new MutableInt(0);
        }
    };

    public CRC32CDigestManager(long ledgerId, boolean useV2Protocol, ByteBufAllocator allocator) {
        super(ledgerId, useV2Protocol, allocator);
        if (!Sse42Crc32C.isSupported()) {
            log.error("Sse42Crc32C is not supported, will use a slower CRC32C implementation.");
        }
    }

    @Override
    int getMacCodeLength() {
        return 4;
    }

    @Override
    void populateValueAndReset(ByteBuf buf) {
        MutableInt current = (MutableInt)currentCrc.get();
        buf.writeInt(current.intValue());
        current.setValue(0);
    }

    @Override
    void update(ByteBuf data) {
        MutableInt current = (MutableInt)currentCrc.get();
        int lastCrc = current.intValue();
        current.setValue(Crc32cIntChecksum.resumeChecksum((int)lastCrc, (ByteBuf)data));
    }
}

