/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerLayout {
    private static final Logger log = LoggerFactory.getLogger(LedgerLayout.class);
    public static final int LAYOUT_MIN_COMPAT_VERSION = 1;
    public static final int LAYOUT_FORMAT_VERSION = 2;
    private static final String splitter = ":";
    private static final String lSplitter = "\n";
    private final String managerFactoryClass;
    private final int managerVersion;
    private final int layoutFormatVersion;

    public LedgerLayout(String managerFactoryCls, int managerVersion) {
        this(managerFactoryCls, managerVersion, 2);
    }

    LedgerLayout(String managerFactoryCls, int managerVersion, int layoutVersion) {
        this.managerFactoryClass = managerFactoryCls;
        this.managerVersion = managerVersion;
        this.layoutFormatVersion = layoutVersion;
    }

    public byte[] serialize() throws IOException {
        String s = this.layoutFormatVersion + lSplitter + this.managerFactoryClass + splitter + this.managerVersion;
        if (log.isDebugEnabled()) {
            log.debug("Serialized layout info: {}", (Object)s);
        }
        return s.getBytes("UTF-8");
    }

    public static LedgerLayout parseLayout(byte[] bytes) throws IOException {
        String layout = new String(bytes, "UTF-8");
        if (log.isDebugEnabled()) {
            log.debug("Parsing Layout: {}", (Object)layout);
        }
        String[] lines = layout.split(lSplitter);
        try {
            int layoutFormatVersion = Integer.parseInt(lines[0]);
            if (2 < layoutFormatVersion || 1 > layoutFormatVersion) {
                throw new IOException("Metadata version not compatible. Expected 2, but got " + layoutFormatVersion);
            }
            if (lines.length < 2) {
                throw new IOException("Ledger manager and its version absent from layout: " + layout);
            }
            String[] parts = lines[1].split(splitter);
            if (parts.length != 2) {
                throw new IOException("Invalid Ledger Manager defined in layout : " + layout);
            }
            String managerFactoryCls = parts[0];
            int managerVersion = Integer.parseInt(parts[1]);
            return new LedgerLayout(managerFactoryCls, managerVersion, layoutFormatVersion);
        }
        catch (NumberFormatException e) {
            throw new IOException("Could not parse layout '" + layout + "'", e);
        }
    }

    public String getManagerFactoryClass() {
        return this.managerFactoryClass;
    }

    public int getManagerVersion() {
        return this.managerVersion;
    }

    public int getLayoutFormatVersion() {
        return this.layoutFormatVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerLayout)) {
            return false;
        }
        LedgerLayout other = (LedgerLayout)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$managerFactoryClass = this.getManagerFactoryClass();
        String other$managerFactoryClass = other.getManagerFactoryClass();
        if (this$managerFactoryClass == null ? other$managerFactoryClass != null : !this$managerFactoryClass.equals(other$managerFactoryClass)) {
            return false;
        }
        if (this.getManagerVersion() != other.getManagerVersion()) {
            return false;
        }
        return this.getLayoutFormatVersion() == other.getLayoutFormatVersion();
    }

    protected boolean canEqual(Object other) {
        return other instanceof LedgerLayout;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $managerFactoryClass = this.getManagerFactoryClass();
        result = result * 59 + ($managerFactoryClass == null ? 43 : $managerFactoryClass.hashCode());
        result = result * 59 + this.getManagerVersion();
        result = result * 59 + this.getLayoutFormatVersion();
        return result;
    }

    public String toString() {
        return "LedgerLayout(managerFactoryClass=" + this.getManagerFactoryClass() + ", managerVersion=" + this.getManagerVersion() + ", layoutFormatVersion=" + this.getLayoutFormatVersion() + ")";
    }
}

