/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.EnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.ZoneawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieNode;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.stats.StatsLogger;

public class ZoneawareEnsemblePlacementPolicy
extends ZoneawareEnsemblePlacementPolicyImpl
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    ZoneawareEnsemblePlacementPolicyImpl slave = null;

    @Override
    public EnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger) {
        if (conf.getNetworkTopologyStabilizePeriodSeconds() > 0) {
            ClientConfiguration confClone = new ClientConfiguration(conf);
            confClone.setNetworkTopologyStabilizePeriodSeconds(0);
            super.initialize(confClone, optionalDnsResolver, timer, featureProvider, statsLogger);
            this.slave = new ZoneawareEnsemblePlacementPolicyImpl();
            this.slave.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger);
        } else {
            super.initialize(conf, optionalDnsResolver, timer, featureProvider, statsLogger);
            this.slave = null;
        }
        return this;
    }

    @Override
    public void uninitalize() {
        super.uninitalize();
        if (null != this.slave) {
            this.slave.uninitalize();
        }
    }

    @Override
    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> writableBookies, Set<BookieSocketAddress> readOnlyBookies) {
        Set deadBookies = super.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        if (null != this.slave) {
            deadBookies = this.slave.onClusterChanged((Set)writableBookies, (Set)readOnlyBookies);
        }
        return deadBookies;
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<List<BookieSocketAddress>> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.newEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, excludeBookies);
        }
    }

    @Override
    public EnsemblePlacementPolicy.PlacementResult<BookieSocketAddress> replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, List<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        try {
            return super.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
        catch (BKException.BKNotEnoughBookiesException bnebe) {
            if (this.slave == null) {
                throw bnebe;
            }
            return this.slave.replaceBookie(ensembleSize, writeQuorumSize, ackQuorumSize, customMetadata, currentEnsemble, bookieToReplace, excludeBookies);
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        super.handleBookiesThatLeft((Set)leftBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatLeft((Set)leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        super.handleBookiesThatJoined((Set)joinedBookies);
        if (null != this.slave) {
            this.slave.handleBookiesThatJoined((Set)joinedBookies);
        }
    }
}

