/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transformservice.launcher;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.ByteStreams;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransformServiceLauncher {
    private static final @UnknownKeyFor @NonNull @Initialized Logger LOG = LoggerFactory.getLogger(TransformServiceLauncher.class);
    private static final @UnknownKeyFor @NonNull @Initialized String DEFAULT_PROJECT_NAME = "apache.beam.transform.service";
    private static final @UnknownKeyFor @NonNull @Initialized String COMMAND_POSSIBLE_VALUES = "\"up\", \"down\" and \"ps\"";
    private static @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized TransformServiceLauncher> launchers = new HashMap<String, TransformServiceLauncher>();
    private @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> dockerComposeStartCommandPrefix = new ArrayList<String>();
    private @UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized String> environmentVariables = new HashMap<String, String>();
    private static final @UnknownKeyFor @NonNull @Initialized int DEFAULT_START_WAIT_TIME = 50000;
    private static final @UnknownKeyFor @NonNull @Initialized int STATUS_LOGGER_WAIT_TIME = 3000;

    private TransformServiceLauncher(@Nullable @UnknownKeyFor @Initialized String projectName, @UnknownKeyFor @NonNull @Initialized int port, @Nullable @UnknownKeyFor @Initialized String pythonRequirementsFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        String tmpDirLocation = System.getProperty("java.io.tmpdir");
        Path tmpDirPath = Paths.get(tmpDirLocation, projectName);
        Files.createDirectories(tmpDirPath, new FileAttribute[0]);
        String tmpDir = tmpDirPath.toFile().getAbsolutePath();
        File dockerComposeFile = Paths.get(tmpDir, "docker-compose.yml").toFile();
        try (FileOutputStream fout = new FileOutputStream(dockerComposeFile);){
            ByteStreams.copy((InputStream)this.getClass().getResourceAsStream("/docker-compose.yml"), (OutputStream)fout);
        }
        File envFile = Paths.get(tmpDir, ".env").toFile();
        try (FileOutputStream fout = new FileOutputStream(envFile);){
            ByteStreams.copy((InputStream)this.getClass().getResourceAsStream("/.env"), (OutputStream)fout);
        }
        File credentialsDir = Paths.get(tmpDir, "credentials_dir").toFile();
        if (credentialsDir.exists()) {
            LOG.info("Reusing the existing credentials directory " + credentialsDir.getAbsolutePath());
        } else {
            LOG.info("Creating a temporary directory for storing credentials: " + credentialsDir.getAbsolutePath());
            if (!credentialsDir.mkdir()) {
                throw new IOException("Could not create a temporary directory for storing credentials: " + credentialsDir.getAbsolutePath());
            }
            LOG.info("Copying the Google Application Default Credentials file.");
            File applicationDefaultCredentialsFileCopied = Paths.get(credentialsDir.getAbsolutePath(), "application_default_credentials.json").toFile();
            boolean isWindows = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("windows");
            String applicationDefaultFilePathSuffix = isWindows ? "\\gcloud\\application_default_credentials.json" : "/.config/gcloud/application_default_credentials.json";
            String applicationDefaultFilePath = System.getProperty("user.home") + applicationDefaultFilePathSuffix;
            File applicationDefaultCredentialsFile = Paths.get(applicationDefaultFilePath, new String[0]).toFile();
            if (applicationDefaultCredentialsFile.exists()) {
                org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.io.Files.copy((File)applicationDefaultCredentialsFile, (File)applicationDefaultCredentialsFileCopied);
            } else {
                LOG.error("GCP credentials will not be available for the transform service since the Google Cloud application default credentials file could not be found at the expected location {}.", (Object)applicationDefaultFilePath);
            }
        }
        File dependenciesDir = Paths.get(tmpDir, "dependencies_dir").toFile();
        Path updatedRequirementsFilePath = Paths.get(dependenciesDir.toString(), "requirements.txt");
        if (dependenciesDir.exists()) {
            LOG.info("Reusing the existing dependencies directory " + dependenciesDir.getAbsolutePath());
        } else {
            LOG.info("Creating a temporary directory for storing dependencies: " + dependenciesDir.getAbsolutePath());
            if (!dependenciesDir.mkdir()) {
                throw new IOException("Could not create a temporary directory for storing dependencies: " + dependenciesDir.getAbsolutePath());
            }
            File file = updatedRequirementsFilePath.toFile();
            if (!file.createNewFile()) {
                throw new IOException("Could not create the new requirements file " + updatedRequirementsFilePath);
            }
            if (pythonRequirementsFile != null) {
                Path requirementsFilePath = Paths.get(pythonRequirementsFile, new String[0]);
                ArrayList updatedLines = new ArrayList();
                try (Stream<String> lines = Files.lines(requirementsFilePath);){
                    lines.forEachOrdered(line -> {
                        Path dependencyFilePath = Paths.get(line, new String[0]);
                        if (Files.exists(dependencyFilePath, new LinkOption[0])) {
                            Path fileName = dependencyFilePath.getFileName();
                            if (fileName == null) {
                                throw new IllegalArgumentException("Could not determine the filename of the local artifact " + dependencyFilePath);
                            }
                            try {
                                Files.copy(dependencyFilePath, Paths.get(dependenciesDir.toString(), fileName.toString()), new CopyOption[0]);
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                            updatedLines.add(fileName.toString());
                        } else {
                            updatedLines.add(line);
                        }
                    });
                }
                var16_21 = null;
                try (BufferedWriter writer = Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);){
                    for (String line2 : updatedLines) {
                        writer.write(line2);
                        writer.newLine();
                    }
                    writer.flush();
                }
                catch (Throwable throwable) {
                    var16_21 = throwable;
                    throw throwable;
                }
            }
        }
        this.environmentVariables.put("CREDENTIALS_VOLUME", credentialsDir.getAbsolutePath());
        this.environmentVariables.put("DEPENDENCIES_VOLUME", dependenciesDir.getAbsolutePath());
        this.environmentVariables.put("TRANSFORM_SERVICE_PORT", String.valueOf(port));
        Path updatedRequirementsFileName = updatedRequirementsFilePath.getFileName();
        if (updatedRequirementsFileName == null) {
            throw new IllegalArgumentException("Could not determine the file name of the updated requirements file " + updatedRequirementsFilePath);
        }
        this.environmentVariables.put("PYTHON_REQUIREMENTS_FILE_NAME", updatedRequirementsFileName.toString());
        this.dockerComposeStartCommandPrefix.add("docker-compose");
        this.dockerComposeStartCommandPrefix.add("-p");
        this.dockerComposeStartCommandPrefix.add(projectName);
        this.dockerComposeStartCommandPrefix.add("-f");
        this.dockerComposeStartCommandPrefix.add(dockerComposeFile.getAbsolutePath());
    }

    public void setBeamVersion(@UnknownKeyFor @NonNull @Initialized String beamVersion) {
        this.environmentVariables.put("BEAM_VERSION", beamVersion);
    }

    public static synchronized @UnknownKeyFor @NonNull @Initialized TransformServiceLauncher forProject(@Nullable @UnknownKeyFor @Initialized String projectName, @UnknownKeyFor @NonNull @Initialized int port, @Nullable @UnknownKeyFor @Initialized String pythonRequirementsFile) throws @UnknownKeyFor @NonNull @Initialized IOException {
        if (projectName == null || projectName.isEmpty()) {
            projectName = DEFAULT_PROJECT_NAME;
        }
        if (!launchers.containsKey(projectName)) {
            launchers.put(projectName, new TransformServiceLauncher(projectName, port, pythonRequirementsFile));
        }
        return launchers.get(projectName);
    }

    private void runDockerComposeCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> command) throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.runDockerComposeCommand(command, null);
    }

    private void runDockerComposeCommand(@UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> command, @Nullable @UnknownKeyFor @Initialized File outputOverride) throws @UnknownKeyFor @NonNull @Initialized IOException {
        ArrayList<String> shellCommand = new ArrayList<String>();
        shellCommand.addAll(this.dockerComposeStartCommandPrefix);
        shellCommand.addAll(command);
        System.out.println("Executing command: " + String.join((CharSequence)" ", command));
        ProcessBuilder processBuilder = new ProcessBuilder(shellCommand).redirectError(ProcessBuilder.Redirect.INHERIT);
        if (outputOverride != null) {
            processBuilder.redirectOutput(outputOverride);
        } else {
            processBuilder.redirectOutput(ProcessBuilder.Redirect.INHERIT);
        }
        Map<String, String> env = processBuilder.environment();
        env.putAll(this.environmentVariables);
        processBuilder.start();
        try {
            this.wait(3000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized void start() throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        this.runDockerComposeCommand((List<String>)ImmutableList.of((Object)"up", (Object)"-d"));
    }

    public synchronized void shutdown() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.runDockerComposeCommand((List<String>)ImmutableList.of((Object)"down"));
    }

    public synchronized void status() throws @UnknownKeyFor @NonNull @Initialized IOException {
        this.runDockerComposeCommand((List<String>)ImmutableList.of((Object)"ps"));
    }

    public synchronized void waitTillUp(@UnknownKeyFor @NonNull @Initialized int timeout) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        timeout = timeout <= 0 ? 50000 : timeout;
        long startTime = System.currentTimeMillis();
        while (System.currentTimeMillis() - startTime < (long)timeout) {
            String output;
            String statusFileName = this.getStatus();
            try {
                this.wait(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((output = String.join((CharSequence)" ", Files.readAllLines(Paths.get(statusFileName, new String[0])))).isEmpty() || !output.contains("transform-service")) continue;
            return;
        }
        throw new TimeoutException("Transform Service did not start in " + timeout / 1000 + " seconds.");
    }

    private synchronized @UnknownKeyFor @NonNull @Initialized String getStatus() throws @UnknownKeyFor @NonNull @Initialized IOException {
        File outputOverride = File.createTempFile("output_override", null);
        outputOverride.deleteOnExit();
        this.runDockerComposeCommand((List<String>)ImmutableList.of((Object)"ps"), outputOverride);
        return outputOverride.getAbsolutePath();
    }

    public static void main(@UnknownKeyFor @NonNull @Initialized String @UnknownKeyFor @NonNull @Initialized [] args) throws @UnknownKeyFor @NonNull @Initialized IOException, @UnknownKeyFor @NonNull @Initialized TimeoutException {
        ArgConfig config = new ArgConfig();
        CmdLineParser parser = new CmdLineParser((Object)config);
        try {
            parser.parseArgument(args);
        }
        catch (CmdLineException e) {
            System.err.println(e.getMessage());
            System.err.println("Valid options are:");
            parser.printUsage((OutputStream)System.err);
            System.err.println();
            return;
        }
        if (config.command.isEmpty()) {
            throw new IllegalArgumentException("\"command\" argument must be specified, Valid values are \"up\", \"down\" and \"ps\"");
        }
        if (config.beamVersion.isEmpty()) {
            throw new IllegalArgumentException("\"beam_version\" argument must be specified.");
        }
        System.out.println("===================================================");
        System.out.println("Starting the Beam Transform Service at " + (config.port < 0 ? "the default port." : "port " + Integer.toString(config.port) + "."));
        System.out.println("===================================================");
        String pythonRequirementsFile = !config.pythonRequirementsFile.isEmpty() ? config.pythonRequirementsFile : null;
        TransformServiceLauncher service = TransformServiceLauncher.forProject(config.projectName, config.port, pythonRequirementsFile);
        if (!config.beamVersion.isEmpty()) {
            service.setBeamVersion(config.beamVersion);
        }
        if (config.command.equals("up")) {
            service.start();
            service.waitTillUp(-1);
        } else if (config.command.equals("down")) {
            service.shutdown();
        } else if (config.command.equals("ps")) {
            service.status();
        } else {
            throw new IllegalArgumentException(String.format("Unknown command \"%s\". Possible values are {}", config.command));
        }
    }

    private static class ArgConfig {
        static final @UnknownKeyFor @NonNull @Initialized String PROJECT_NAME_ARG_NAME = "project_name";
        static final @UnknownKeyFor @NonNull @Initialized String COMMAND_ARG_NAME = "command";
        static final @UnknownKeyFor @NonNull @Initialized String PORT_ARG_NAME = "port";
        static final @UnknownKeyFor @NonNull @Initialized String BEAM_VERSION_ARG_NAME = "beam_version";
        static final @UnknownKeyFor @NonNull @Initialized String PYTHON_REQUIREMENTS_FILE_ARG_NAME = "python_requirements_file";
        @Option(name="--project_name", usage="Docker compose project name")
        private @UnknownKeyFor @NonNull @Initialized String projectName = "";
        @Option(name="--command", usage="Command to execute")
        private @UnknownKeyFor @NonNull @Initialized String command = "";
        @Option(name="--port", usage="Port for the transform service")
        private @UnknownKeyFor @NonNull @Initialized int port = -1;
        @Option(name="--beam_version", usage="Beam version to use.")
        private @UnknownKeyFor @NonNull @Initialized String beamVersion = "";
        @Option(name="--python_requirements_file", usage="Extra Python packages in the form of an requirements file.")
        private @UnknownKeyFor @NonNull @Initialized String pythonRequirementsFile = "";

        private ArgConfig() {
        }
    }
}

