/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.function.Supplier;
import org.apache.beam.sdk.io.kinesis.KinesisClientThrottledException;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.RateLimitPolicy;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.BackOffUtils;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RateLimitPolicyFactory
extends Serializable {
    public RateLimitPolicy getRateLimitPolicy();

    public static RateLimitPolicyFactory withoutLimiter() {
        return () -> new RateLimitPolicy(){};
    }

    public static RateLimitPolicyFactory withDefaultRateLimiter() {
        return RateLimitPolicyFactory.withDefaultRateLimiter(Duration.millis((long)100L), Duration.millis((long)500L), Duration.standardSeconds((long)1L));
    }

    public static RateLimitPolicyFactory withDefaultRateLimiter(Duration emptySuccessBaseDelay, Duration throttledBaseDelay, Duration maxDelay) {
        return () -> new DefaultRateLimiter(emptySuccessBaseDelay, throttledBaseDelay, maxDelay);
    }

    public static RateLimitPolicyFactory withFixedDelay() {
        return DelayIntervalRateLimiter::new;
    }

    public static RateLimitPolicyFactory withFixedDelay(Duration delay) {
        return () -> new DelayIntervalRateLimiter(() -> delay);
    }

    public static RateLimitPolicyFactory withDelay(Supplier<Duration> delay) {
        return () -> new DelayIntervalRateLimiter(delay);
    }

    public static class DefaultRateLimiter
    implements RateLimitPolicy {
        private static final Logger LOG = LoggerFactory.getLogger(DefaultRateLimiter.class);
        private final Sleeper sleeper;
        private final BackOff throttled;
        private final BackOff emptySuccess;

        @VisibleForTesting
        DefaultRateLimiter(BackOff emptySuccess, BackOff throttled, Sleeper sleeper) {
            this.emptySuccess = emptySuccess;
            this.throttled = throttled;
            this.sleeper = sleeper;
        }

        public DefaultRateLimiter(BackOff emptySuccess, BackOff throttled) {
            this(emptySuccess, throttled, Sleeper.DEFAULT);
        }

        public DefaultRateLimiter(Duration emptySuccessBaseDelay, Duration throttledBaseDelay, Duration maxDelay) {
            this(FluentBackoff.DEFAULT.withInitialBackoff(emptySuccessBaseDelay).withMaxBackoff(maxDelay).backoff(), FluentBackoff.DEFAULT.withInitialBackoff(throttledBaseDelay).withMaxBackoff(maxDelay).backoff());
        }

        @Override
        public void onSuccess(List<KinesisRecord> records) throws InterruptedException {
            try {
                if (records.isEmpty()) {
                    BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.emptySuccess);
                } else {
                    this.emptySuccess.reset();
                }
                this.throttled.reset();
            }
            catch (IOException e) {
                LOG.warn("Error applying onSuccess rate limit policy", (Throwable)e);
            }
        }

        @Override
        public void onThrottle(KinesisClientThrottledException e) throws InterruptedException {
            try {
                BackOffUtils.next((Sleeper)this.sleeper, (BackOff)this.throttled);
            }
            catch (IOException ioe) {
                LOG.warn("Error applying onThrottle rate limit policy", (Throwable)e);
            }
        }
    }

    public static class DelayIntervalRateLimiter
    implements RateLimitPolicy {
        private static final Supplier<Duration> DEFAULT_DELAY = () -> Duration.standardSeconds((long)1L);
        private final Supplier<Duration> delay;

        public DelayIntervalRateLimiter() {
            this(DEFAULT_DELAY);
        }

        public DelayIntervalRateLimiter(Supplier<Duration> delay) {
            this.delay = delay;
        }

        @Override
        public void onSuccess(List<KinesisRecord> records) throws InterruptedException {
            Thread.sleep(this.delay.get().getMillis());
        }
    }
}

