/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.clientlibrary.lib.worker.InitialPositionInStream;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.base.Preconditions;
import org.joda.time.Instant;

class StartingPoint
implements Serializable {
    private final InitialPositionInStream position;
    private final Instant timestamp;

    public StartingPoint(InitialPositionInStream position) {
        this.position = Preconditions.checkNotNull(position, "position");
        this.timestamp = null;
    }

    public StartingPoint(Instant timestamp) {
        this.timestamp = Preconditions.checkNotNull(timestamp, "timestamp");
        this.position = null;
    }

    public InitialPositionInStream getPosition() {
        return this.position;
    }

    public String getPositionName() {
        return this.position != null ? this.position.name() : ShardIteratorType.AT_TIMESTAMP.name();
    }

    public Instant getTimestamp() {
        return this.timestamp != null ? this.timestamp : null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StartingPoint that = (StartingPoint)o;
        return this.position == that.position && Objects.equals(this.timestamp, that.timestamp);
    }

    public int hashCode() {
        return Objects.hash(this.position, this.timestamp);
    }

    public String toString() {
        if (this.timestamp == null) {
            return this.position.toString();
        }
        return "Starting at timestamp " + this.timestamp;
    }
}

