/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.UnboundedSource;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.DynamicCheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReader;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.KinesisRecord;
import org.apache.beam.sdk.io.kinesis.KinesisRecordCoder;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.StaticCheckpointGenerator;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.base.Preconditions;
import org.apache.beam.sdks.java.io.kinesis.repackaged.com.google.common.collect.Lists;
import org.joda.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisSource
extends UnboundedSource<KinesisRecord, KinesisReaderCheckpoint> {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisSource.class);
    private final AWSClientsProvider awsClientsProvider;
    private final String streamName;
    private final Duration upToDateThreshold;
    private CheckpointGenerator initialCheckpointGenerator;

    KinesisSource(AWSClientsProvider awsClientsProvider, String streamName, StartingPoint startingPoint, Duration upToDateThreshold) {
        this(awsClientsProvider, new DynamicCheckpointGenerator(streamName, startingPoint), streamName, upToDateThreshold);
    }

    private KinesisSource(AWSClientsProvider awsClientsProvider, CheckpointGenerator initialCheckpoint, String streamName, Duration upToDateThreshold) {
        this.awsClientsProvider = awsClientsProvider;
        this.initialCheckpointGenerator = initialCheckpoint;
        this.streamName = streamName;
        this.upToDateThreshold = upToDateThreshold;
        this.validate();
    }

    public List<KinesisSource> split(int desiredNumSplits, PipelineOptions options) throws Exception {
        KinesisReaderCheckpoint checkpoint = this.initialCheckpointGenerator.generate(SimplifiedKinesisClient.from(this.awsClientsProvider));
        ArrayList<KinesisSource> sources = Lists.newArrayList();
        for (KinesisReaderCheckpoint partition : checkpoint.splitInto(desiredNumSplits)) {
            sources.add(new KinesisSource(this.awsClientsProvider, new StaticCheckpointGenerator(partition), this.streamName, this.upToDateThreshold));
        }
        return sources;
    }

    public UnboundedSource.UnboundedReader<KinesisRecord> createReader(PipelineOptions options, KinesisReaderCheckpoint checkpointMark) {
        CheckpointGenerator checkpointGenerator = this.initialCheckpointGenerator;
        if (checkpointMark != null) {
            checkpointGenerator = new StaticCheckpointGenerator(checkpointMark);
        }
        LOG.info("Creating new reader using {}", (Object)checkpointGenerator);
        return new KinesisReader(SimplifiedKinesisClient.from(this.awsClientsProvider), checkpointGenerator, this, this.upToDateThreshold);
    }

    public Coder<KinesisReaderCheckpoint> getCheckpointMarkCoder() {
        return SerializableCoder.of(KinesisReaderCheckpoint.class);
    }

    public void validate() {
        Preconditions.checkNotNull(this.awsClientsProvider);
        Preconditions.checkNotNull(this.initialCheckpointGenerator);
    }

    public Coder<KinesisRecord> getOutputCoder() {
        return KinesisRecordCoder.of();
    }

    String getStreamName() {
        return this.streamName;
    }
}

