/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.beam.sdk.io.kinesis.GetKinesisRecordsResult;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StartingPointShardsFinder
implements Serializable {
    private static final Logger LOG = LoggerFactory.getLogger(StartingPointShardsFinder.class);

    StartingPointShardsFinder() {
    }

    Set<Shard> findShardsAtStartingPoint(SimplifiedKinesisClient kinesis, String streamName, StartingPoint startingPoint) throws TransientKinesisException {
        Sets.SetView expiredShards;
        List<Shard> allShards = kinesis.listShards(streamName);
        Set<Shard> initialShards = this.findInitialShardsWithoutParents(streamName, allShards);
        HashSet<Shard> startingPointShards = new HashSet<Shard>();
        do {
            Set<Shard> validShards = this.validateShards(kinesis, initialShards, streamName, startingPoint);
            startingPointShards.addAll(validShards);
            expiredShards = Sets.difference(initialShards, validShards);
            if (!expiredShards.isEmpty()) {
                LOG.info("Following shards expired for {} stream at '{}' starting point: {}", new Object[]{streamName, startingPoint, expiredShards});
            }
            initialShards = this.findNextShards(allShards, (Set<Shard>)expiredShards);
        } while (!expiredShards.isEmpty());
        return startingPointShards;
    }

    private Set<Shard> findNextShards(List<Shard> allShards, Set<Shard> expiredShards) {
        HashSet<Shard> nextShards = new HashSet<Shard>();
        for (Shard expiredShard : expiredShards) {
            boolean successorFound = false;
            for (Shard shard : allShards) {
                if (Objects.equals(expiredShard.getShardId(), shard.getParentShardId())) {
                    nextShards.add(shard);
                    successorFound = true;
                    continue;
                }
                if (!Objects.equals(expiredShard.getShardId(), shard.getAdjacentParentShardId())) continue;
                successorFound = true;
            }
            if (successorFound) continue;
            throw new IllegalStateException("No successors were found for shard: " + expiredShard);
        }
        return nextShards;
    }

    private Set<Shard> findInitialShardsWithoutParents(String streamName, List<Shard> allShards) {
        HashSet<String> shardIds = new HashSet<String>();
        for (Shard shard : allShards) {
            shardIds.add(shard.getShardId());
        }
        LOG.info("Stream {} has following shards: {}", (Object)streamName, shardIds);
        HashSet<Shard> shardsWithoutParents = new HashSet<Shard>();
        for (Shard shard : allShards) {
            if (shardIds.contains(shard.getParentShardId())) continue;
            shardsWithoutParents.add(shard);
        }
        return shardsWithoutParents;
    }

    private Set<Shard> validateShards(SimplifiedKinesisClient kinesis, Iterable<Shard> rootShards, String streamName, StartingPoint startingPoint) throws TransientKinesisException {
        HashSet<Shard> validShards = new HashSet<Shard>();
        ShardIteratorType shardIteratorType = ShardIteratorType.fromValue((String)startingPoint.getPositionName());
        for (Shard shard : rootShards) {
            String shardIterator = kinesis.getShardIterator(streamName, shard.getShardId(), shardIteratorType, null, startingPoint.getTimestamp());
            GetKinesisRecordsResult records = kinesis.getRecords(shardIterator, streamName, shard.getShardId());
            if (records.getNextShardIterator() == null && records.getRecords().isEmpty()) continue;
            validShards.add(shard);
        }
        return validShards;
    }
}

