/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.services.kinesis.model.Shard;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.beam.sdk.io.kinesis.CheckpointGenerator;
import org.apache.beam.sdk.io.kinesis.KinesisReaderCheckpoint;
import org.apache.beam.sdk.io.kinesis.ShardCheckpoint;
import org.apache.beam.sdk.io.kinesis.SimplifiedKinesisClient;
import org.apache.beam.sdk.io.kinesis.StartingPoint;
import org.apache.beam.sdk.io.kinesis.StartingPointShardsFinder;
import org.apache.beam.sdk.io.kinesis.TransientKinesisException;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class DynamicCheckpointGenerator
implements CheckpointGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(DynamicCheckpointGenerator.class);
    private final String streamName;
    private final StartingPoint startingPoint;
    private final StartingPointShardsFinder startingPointShardsFinder;

    public DynamicCheckpointGenerator(String streamName, StartingPoint startingPoint) {
        this.streamName = streamName;
        this.startingPoint = startingPoint;
        this.startingPointShardsFinder = new StartingPointShardsFinder();
    }

    public DynamicCheckpointGenerator(String streamName, StartingPoint startingPoint, StartingPointShardsFinder startingPointShardsFinder) {
        this.streamName = (String)Preconditions.checkNotNull((Object)streamName, (Object)"streamName");
        this.startingPoint = (StartingPoint)Preconditions.checkNotNull((Object)startingPoint, (Object)"startingPoint");
        this.startingPointShardsFinder = (StartingPointShardsFinder)Preconditions.checkNotNull((Object)startingPointShardsFinder, (Object)"startingPointShardsFinder");
    }

    @Override
    public KinesisReaderCheckpoint generate(SimplifiedKinesisClient kinesis) throws TransientKinesisException {
        Set<Shard> shardsAtStartingPoint = this.startingPointShardsFinder.findShardsAtStartingPoint(kinesis, this.streamName, this.startingPoint);
        LOG.info("Creating a checkpoint with following shards {} at {}", shardsAtStartingPoint, (Object)this.startingPoint.getTimestamp());
        return new KinesisReaderCheckpoint(shardsAtStartingPoint.stream().map(shard -> new ShardCheckpoint(this.streamName, shard.getShardId(), this.startingPoint)).collect(Collectors.toList()));
    }

    public String toString() {
        return String.format("Checkpoint generator for %s: %s", this.streamName, this.startingPoint);
    }
}

