/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.cloudwatch.AmazonCloudWatch;
import com.amazonaws.services.cloudwatch.AmazonCloudWatchClientBuilder;
import com.amazonaws.services.kinesis.AmazonKinesis;
import com.amazonaws.services.kinesis.AmazonKinesisClientBuilder;
import com.amazonaws.services.kinesis.producer.IKinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducer;
import com.amazonaws.services.kinesis.producer.KinesisProducerConfiguration;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.kinesis.AWSClientsProvider;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

class BasicKinesisProvider
implements AWSClientsProvider {
    private final String accessKey;
    private final String secretKey;
    private final Regions region;
    @Nullable
    private final String serviceEndpoint;

    BasicKinesisProvider(String accessKey, String secretKey, Regions region, @Nullable String serviceEndpoint) {
        Preconditions.checkArgument((accessKey != null ? 1 : 0) != 0, (Object)"accessKey can not be null");
        Preconditions.checkArgument((secretKey != null ? 1 : 0) != 0, (Object)"secretKey can not be null");
        Preconditions.checkArgument((region != null ? 1 : 0) != 0, (Object)"region can not be null");
        this.accessKey = accessKey;
        this.secretKey = secretKey;
        this.region = region;
        this.serviceEndpoint = serviceEndpoint;
    }

    private AWSCredentialsProvider getCredentialsProvider() {
        return new AWSStaticCredentialsProvider((AWSCredentials)new BasicAWSCredentials(this.accessKey, this.secretKey));
    }

    @Override
    public AmazonKinesis getKinesisClient() {
        AmazonKinesisClientBuilder clientBuilder = (AmazonKinesisClientBuilder)AmazonKinesisClientBuilder.standard().withCredentials(this.getCredentialsProvider());
        if (this.serviceEndpoint == null) {
            clientBuilder.withRegion(this.region);
        } else {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
        }
        return (AmazonKinesis)clientBuilder.build();
    }

    @Override
    public AmazonCloudWatch getCloudWatchClient() {
        AmazonCloudWatchClientBuilder clientBuilder = (AmazonCloudWatchClientBuilder)AmazonCloudWatchClientBuilder.standard().withCredentials(this.getCredentialsProvider());
        if (this.serviceEndpoint == null) {
            clientBuilder.withRegion(this.region);
        } else {
            clientBuilder.withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(this.serviceEndpoint, this.region.getName()));
        }
        return (AmazonCloudWatch)clientBuilder.build();
    }

    @Override
    public IKinesisProducer createKinesisProducer(KinesisProducerConfiguration config) {
        config.setRegion(this.region.getName());
        config.setCredentialsProvider(this.getCredentialsProvider());
        return new KinesisProducer(config);
    }
}

