/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.io.Serializable;
import java.sql.Array;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import java.util.TimeZone;
import java.util.UUID;
import java.util.function.BiFunction;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.LogicalTypes;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.FixedPrecisionNumeric;
import org.apache.beam.sdk.schemas.logicaltypes.FixedString;
import org.apache.beam.sdk.schemas.logicaltypes.VariableBytes;
import org.apache.beam.sdk.schemas.logicaltypes.VariableString;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.chrono.ISOChronology;

@Experimental(value=Experimental.Kind.SCHEMAS)
class SchemaUtil {
    private static final @UnknownKeyFor @NonNull @Initialized EnumMap<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.TypeName, @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor> RESULTSET_FIELD_EXTRACTORS = new EnumMap(ImmutableMap.builder().put((Object)Schema.TypeName.BOOLEAN, ResultSet::getBoolean).put((Object)Schema.TypeName.BYTE, ResultSet::getByte).put((Object)Schema.TypeName.BYTES, ResultSet::getBytes).put((Object)Schema.TypeName.DATETIME, ResultSet::getTimestamp).put((Object)Schema.TypeName.DECIMAL, ResultSet::getBigDecimal).put((Object)Schema.TypeName.DOUBLE, ResultSet::getDouble).put((Object)Schema.TypeName.FLOAT, ResultSet::getFloat).put((Object)Schema.TypeName.INT16, ResultSet::getShort).put((Object)Schema.TypeName.INT32, ResultSet::getInt).put((Object)Schema.TypeName.INT64, ResultSet::getLong).put((Object)Schema.TypeName.STRING, ResultSet::getString).build());
    private static final @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor DATE_EXTRACTOR = SchemaUtil.createDateExtractor();
    private static final @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor TIME_EXTRACTOR = SchemaUtil.createTimeExtractor();
    private static final @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor TIMESTAMP_EXTRACTOR = SchemaUtil.createTimestampExtractor();
    private static final @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor OBJECT_EXTRACTOR = SchemaUtil.createObjectExtractor();

    SchemaUtil() {
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamFieldConverter jdbcTypeToBeamFieldConverter(@UnknownKeyFor @NonNull @Initialized JDBCType jdbcType, @UnknownKeyFor @NonNull @Initialized String className) {
        switch (jdbcType) {
            case ARRAY: {
                return SchemaUtil.beamArrayField();
            }
            case BIGINT: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.INT64);
            }
            case BINARY: {
                return SchemaUtil.beamLogicalField(JDBCType.BINARY.getName(), LogicalTypes::fixedOrVariableBytes);
            }
            case BIT: {
                return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_BIT_TYPE);
            }
            case BOOLEAN: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.BOOLEAN);
            }
            case CHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.CHAR.getName(), FixedString::of);
            }
            case DATE: {
                return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_DATE_TYPE);
            }
            case DECIMAL: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.DECIMAL);
            }
            case DOUBLE: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.DOUBLE);
            }
            case FLOAT: {
                return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_FLOAT_TYPE);
            }
            case INTEGER: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.INT32);
            }
            case LONGNVARCHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.LONGNVARCHAR.getName(), VariableString::of);
            }
            case LONGVARBINARY: {
                return SchemaUtil.beamLogicalField(JDBCType.LONGVARBINARY.getName(), VariableBytes::of);
            }
            case LONGVARCHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.LONGVARCHAR.getName(), VariableString::of);
            }
            case NCHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.NCHAR.getName(), FixedString::of);
            }
            case NUMERIC: {
                return SchemaUtil.beamLogicalNumericField();
            }
            case NVARCHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.NVARCHAR.getName(), VariableString::of);
            }
            case REAL: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.FLOAT);
            }
            case SMALLINT: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.INT16);
            }
            case TIME: {
                return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_TIME_TYPE);
            }
            case TIMESTAMP: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.DATETIME);
            }
            case TIMESTAMP_WITH_TIMEZONE: {
                return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_TIMESTAMP_WITH_TIMEZONE_TYPE);
            }
            case TINYINT: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.BYTE);
            }
            case VARBINARY: {
                return SchemaUtil.beamLogicalField(JDBCType.VARBINARY.getName(), VariableBytes::of);
            }
            case VARCHAR: {
                return SchemaUtil.beamLogicalField(JDBCType.VARCHAR.getName(), VariableString::of);
            }
            case BLOB: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.BYTES);
            }
            case CLOB: {
                return SchemaUtil.beamFieldOfType(Schema.FieldType.STRING);
            }
            case OTHER: 
            case JAVA_OBJECT: {
                if (UUID.class.getName().equals(className)) {
                    return SchemaUtil.beamFieldOfType(LogicalTypes.JDBC_UUID_TYPE);
                }
                return SchemaUtil.beamFieldOfType(LogicalTypes.OTHER_AS_STRING_TYPE);
            }
        }
        throw new UnsupportedOperationException("Converting " + jdbcType + " to Beam schema type is not supported");
    }

    static @UnknownKeyFor @NonNull @Initialized Schema toBeamSchema(@UnknownKeyFor @NonNull @Initialized ResultSetMetaData md) throws @UnknownKeyFor @NonNull @Initialized SQLException {
        Schema.Builder schemaBuilder = Schema.builder();
        for (int i = 1; i <= md.getColumnCount(); ++i) {
            JDBCType jdbcType = JDBCType.valueOf(md.getColumnType(i));
            String className = md.getColumnClassName(i);
            BeamFieldConverter fieldConverter = SchemaUtil.jdbcTypeToBeamFieldConverter(jdbcType, className);
            schemaBuilder.addField(fieldConverter.create(i, md));
        }
        return schemaBuilder.build();
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamFieldConverter beamFieldOfType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        return (index, md) -> {
            String label = md.getColumnLabel(index);
            return Schema.Field.of((String)label, (Schema.FieldType)fieldType).withNullable(md.isNullable(index) == 1);
        };
    }

    private static <InputT, BaseT> @UnknownKeyFor @NonNull @Initialized BeamFieldConverter beamLogicalField(@UnknownKeyFor @NonNull @Initialized String identifier, @UnknownKeyFor @NonNull @Initialized BiFunction<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized Integer, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT>> constructor) {
        return (index, md) -> {
            int size = md.getPrecision(index);
            Schema.FieldType fieldType = Schema.FieldType.logicalType((Schema.LogicalType)((Schema.LogicalType)constructor.apply(identifier, size)));
            return SchemaUtil.beamFieldOfType(fieldType).create(index, md);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamFieldConverter beamLogicalNumericField() {
        return (index, md) -> {
            int precision = md.getPrecision(index);
            if (precision == Integer.MAX_VALUE || precision == -1) {
                return Schema.Field.of((String)md.getColumnLabel(index), (Schema.FieldType)Schema.FieldType.DECIMAL).withNullable(md.isNullable(index) == 1);
            }
            int scale = md.getScale(index);
            Schema.FieldType fieldType = Schema.FieldType.logicalType((Schema.LogicalType)FixedPrecisionNumeric.of((int)precision, (int)scale));
            return SchemaUtil.beamFieldOfType(fieldType).create(index, md);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized BeamFieldConverter beamArrayField() {
        return (index, md) -> {
            JDBCType elementJdbcType = JDBCType.valueOf(md.getColumnTypeName(index));
            String elementClassName = md.getColumnClassName(index);
            BeamFieldConverter elementFieldConverter = SchemaUtil.jdbcTypeToBeamFieldConverter(elementJdbcType, elementClassName);
            String label = md.getColumnLabel(index);
            Schema.FieldType elementBeamType = elementFieldConverter.create(index, md).getType();
            return Schema.Field.of((String)label, (Schema.FieldType)Schema.FieldType.array((Schema.FieldType)elementBeamType)).withNullable(md.isNullable(index) == 1);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createFieldExtractor(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType fieldType) {
        Schema.TypeName typeName = fieldType.getTypeName();
        switch (typeName) {
            case ARRAY: 
            case ITERABLE: {
                Schema.FieldType elementType = (Schema.FieldType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)fieldType.getCollectionElementType());
                ResultSetFieldExtractor elementExtractor = SchemaUtil.createFieldExtractor(elementType);
                return SchemaUtil.createArrayExtractor(elementExtractor);
            }
            case DATETIME: {
                return TIMESTAMP_EXTRACTOR;
            }
            case LOGICAL_TYPE: {
                return SchemaUtil.createLogicalTypeExtractor((Schema.LogicalType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)fieldType.getLogicalType()));
            }
        }
        if (!RESULTSET_FIELD_EXTRACTORS.containsKey(typeName)) {
            throw new UnsupportedOperationException("BeamRowMapper does not have support for fields of type " + fieldType);
        }
        return RESULTSET_FIELD_EXTRACTORS.get(typeName);
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createArrayExtractor(@UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor elementExtractor) {
        return (rs, index) -> {
            Array arrayVal = rs.getArray(index);
            if (arrayVal == null) {
                return null;
            }
            ArrayList<@Nullable Object> arrayElements = new ArrayList<Object>();
            ResultSet arrayRs = (ResultSet)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)arrayVal.getResultSet());
            while (arrayRs.next()) {
                arrayElements.add(elementExtractor.extract(arrayRs, 1));
            }
            return arrayElements;
        };
    }

    private static <InputT, BaseT> @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createLogicalTypeExtractor(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.LogicalType<InputT, BaseT> fieldType) {
        String logicalTypeName = fieldType.getIdentifier();
        if (Objects.equals(fieldType, LogicalTypes.JDBC_UUID_TYPE.getLogicalType())) {
            return OBJECT_EXTRACTOR;
        }
        if (logicalTypeName.equals("DATE")) {
            return DATE_EXTRACTOR;
        }
        if (logicalTypeName.equals("TIME")) {
            return TIME_EXTRACTOR;
        }
        if (logicalTypeName.equals("TIMESTAMP_EXTRACTOR")) {
            return TIMESTAMP_EXTRACTOR;
        }
        ResultSetFieldExtractor extractor = SchemaUtil.createFieldExtractor(fieldType.getBaseType());
        return (rs, index) -> {
            Object v = org.apache.beam.sdk.util.Preconditions.checkStateNotNull((Object)extractor.extract(rs, index));
            return fieldType.toInputType(v);
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createDateExtractor() {
        return (rs, i) -> {
            LocalDate date = rs.getObject((int)i, LocalDate.class);
            if (date == null) {
                return null;
            }
            ZonedDateTime zdt = date.atStartOfDay(ZoneOffset.UTC);
            return new DateTime(zdt.toInstant().toEpochMilli(), (Chronology)ISOChronology.getInstanceUTC());
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createTimeExtractor() {
        return (rs, i) -> {
            Time time = rs.getTime(i, Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
            if (time == null) {
                return null;
            }
            return new DateTime(time.getTime(), (Chronology)ISOChronology.getInstanceUTC()).withDate(new org.joda.time.LocalDate(0L));
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createTimestampExtractor() {
        return (rs, i) -> {
            Timestamp ts = rs.getTimestamp(i, Calendar.getInstance(TimeZone.getTimeZone(ZoneOffset.UTC)));
            if (ts == null) {
                return null;
            }
            return new DateTime(ts.toInstant().toEpochMilli(), (Chronology)ISOChronology.getInstanceUTC());
        };
    }

    private static @UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor createObjectExtractor() {
        return ResultSet::getObject;
    }

    public static @UnknownKeyFor @NonNull @Initialized boolean compareSchemaField(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field a, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field b) {
        if (!a.getName().equalsIgnoreCase(b.getName())) {
            return false;
        }
        return SchemaUtil.compareSchemaFieldType(a.getType(), b.getType());
    }

    static @UnknownKeyFor @NonNull @Initialized boolean checkNullabilityForFields(@UnknownKeyFor @NonNull @Initialized List<// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.Field> fields) {
        return fields.stream().anyMatch(field -> field.getType().getNullable() == false);
    }

    static @UnknownKeyFor @NonNull @Initialized boolean compareSchemaFieldType(// Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType a, // Could not load outer class - annotation placement on inner may be incorrect
    @UnknownKeyFor @NonNull @Initialized Schema.FieldType b) {
        if (a.getTypeName().equals((Object)b.getTypeName())) {
            if (!a.getTypeName().isLogicalType()) {
                return true;
            }
            Schema.LogicalType aLogicalType = (Schema.LogicalType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)a.getLogicalType());
            Schema.LogicalType bLogicalType = (Schema.LogicalType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)b.getLogicalType());
            return SchemaUtil.compareSchemaFieldType(aLogicalType.getBaseType(), bLogicalType.getBaseType());
        }
        if (a.getTypeName().isLogicalType()) {
            Schema.LogicalType aLogicalType = (Schema.LogicalType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)a.getLogicalType());
            return aLogicalType.getBaseType().getTypeName().equals((Object)b.getTypeName());
        }
        if (b.getTypeName().isLogicalType()) {
            Schema.LogicalType bLogicalType = (Schema.LogicalType)org.apache.beam.sdk.util.Preconditions.checkArgumentNotNull((Object)b.getLogicalType());
            return bLogicalType.getBaseType().getTypeName().equals((Object)a.getTypeName());
        }
        return false;
    }

    static class FieldWithIndex
    implements Serializable {
        private final // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field;
        private final @UnknownKeyFor @NonNull @Initialized Integer index;

        private FieldWithIndex(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Integer index) {
            this.field = field;
            this.index = index;
        }

        static @UnknownKeyFor @NonNull @Initialized FieldWithIndex of(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field field, @UnknownKeyFor @NonNull @Initialized Integer index) {
            Preconditions.checkArgument((field != null ? 1 : 0) != 0);
            Preconditions.checkArgument((index != null ? 1 : 0) != 0);
            return new FieldWithIndex(field, index);
        }

        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field getField() {
            return this.field;
        }

        public @UnknownKeyFor @NonNull @Initialized Integer getIndex() {
            return this.index;
        }
    }

    static final class BeamRowMapper
    implements JdbcIO.RowMapper<Row> {
        private final @UnknownKeyFor @NonNull @Initialized Schema schema;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor> fieldExtractors;

        public static @UnknownKeyFor @NonNull @Initialized BeamRowMapper of(@UnknownKeyFor @NonNull @Initialized Schema schema) {
            List<ResultSetFieldExtractor> fieldExtractors = IntStream.range(0, schema.getFieldCount()).mapToObj(i -> SchemaUtil.createFieldExtractor(schema.getField(i).getType())).collect(Collectors.toList());
            return new BeamRowMapper(schema, fieldExtractors);
        }

        private BeamRowMapper(@UnknownKeyFor @NonNull @Initialized Schema schema, @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized ResultSetFieldExtractor> fieldExtractors) {
            this.schema = schema;
            this.fieldExtractors = fieldExtractors;
        }

        @Override
        public @UnknownKeyFor @NonNull @Initialized Row mapRow(@UnknownKeyFor @NonNull @Initialized ResultSet rs) throws @UnknownKeyFor @NonNull @Initialized Exception {
            Row.Builder rowBuilder = Row.withSchema((Schema)this.schema);
            for (int i = 0; i < this.schema.getFieldCount(); ++i) {
                Object value = this.fieldExtractors.get(i).extract(rs, i + 1);
                if (rs.wasNull()) {
                    rowBuilder.addValue(null);
                    continue;
                }
                rowBuilder.addValue(value);
            }
            return rowBuilder.build();
        }
    }

    @FunctionalInterface
    static interface BeamFieldConverter
    extends Serializable {
        public // Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized Schema.Field create(@UnknownKeyFor @NonNull @Initialized int var1, @UnknownKeyFor @NonNull @Initialized ResultSetMetaData var2) throws @UnknownKeyFor @NonNull @Initialized SQLException;
    }

    @FunctionalInterface
    static interface ResultSetFieldExtractor
    extends Serializable {
        public @Nullable @UnknownKeyFor @Initialized Object extract(@UnknownKeyFor @NonNull @Initialized ResultSet var1, @UnknownKeyFor @NonNull @Initialized Integer var2) throws @UnknownKeyFor @NonNull @Initialized SQLException;
    }
}

