/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.jdbc;

import java.sql.Date;
import java.sql.JDBCType;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Calendar;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import javax.sql.DataSource;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.jdbc.JdbcIO;
import org.apache.beam.sdk.io.jdbc.SchemaUtil;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.joda.time.DateTime;

class JdbcUtil {
    private static Map<Schema.TypeName, JdbcIO.PreparedStatementSetCaller> typeNamePsSetCallerMap = new EnumMap<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>((Map<Schema.TypeName, JdbcIO.PreparedStatementSetCaller>)ImmutableMap.builder().put((Object)Schema.TypeName.BYTE, (element, ps, i, fieldWithIndex) -> ps.setByte(i + 1, element.getByte(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.INT16, (element, ps, i, fieldWithIndex) -> ps.setInt(i + 1, element.getInt16(fieldWithIndex.getIndex().intValue()).shortValue())).put((Object)Schema.TypeName.INT64, (element, ps, i, fieldWithIndex) -> ps.setLong(i + 1, element.getInt64(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.DECIMAL, (element, ps, i, fieldWithIndex) -> ps.setBigDecimal(i + 1, element.getDecimal(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.FLOAT, (element, ps, i, fieldWithIndex) -> ps.setFloat(i + 1, element.getFloat(fieldWithIndex.getIndex().intValue()).floatValue())).put((Object)Schema.TypeName.DOUBLE, (element, ps, i, fieldWithIndex) -> ps.setDouble(i + 1, element.getDouble(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.DATETIME, (element, ps, i, fieldWithIndex) -> ps.setTimestamp(i + 1, new Timestamp(element.getDateTime(fieldWithIndex.getIndex().intValue()).getMillis()))).put((Object)Schema.TypeName.BOOLEAN, (element, ps, i, fieldWithIndex) -> ps.setBoolean(i + 1, element.getBoolean(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.BYTES, (Object)JdbcUtil.createBytesCaller()).put((Object)Schema.TypeName.INT32, (element, ps, i, fieldWithIndex) -> ps.setInt(i + 1, element.getInt32(fieldWithIndex.getIndex().intValue()))).put((Object)Schema.TypeName.STRING, (Object)JdbcUtil.createStringCaller()).build());

    JdbcUtil() {
    }

    static String generateStatement(String tableName, List<Schema.Field> fields) {
        String fieldNames = IntStream.range(0, fields.size()).mapToObj(index -> ((Schema.Field)fields.get(index)).getName()).collect(Collectors.joining(", "));
        String valuePlaceholder = IntStream.range(0, fields.size()).mapToObj(index -> "?").collect(Collectors.joining(", "));
        return String.format("INSERT INTO %s(%s) VALUES(%s)", tableName, fieldNames, valuePlaceholder);
    }

    static JdbcIO.PreparedStatementSetCaller getPreparedStatementSetCaller(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ARRAY: 
            case ITERABLE: {
                return (element, ps, i, fieldWithIndex) -> ps.setArray(i + 1, ps.getConnection().createArrayOf(fieldType.getCollectionElementType().getTypeName().name(), element.getArray(fieldWithIndex.getIndex().intValue()).toArray()));
            }
            case LOGICAL_TYPE: {
                String logicalTypeName = fieldType.getLogicalType().getIdentifier();
                JDBCType jdbcType = JDBCType.valueOf(logicalTypeName);
                switch (jdbcType) {
                    case DATE: {
                        return (element, ps, i, fieldWithIndex) -> ps.setDate(i + 1, new Date(JdbcUtil.getDateOrTimeOnly(element.getDateTime(fieldWithIndex.getIndex().intValue()).toDateTime(), true).getTime().getTime()));
                    }
                    case TIME: {
                        return (element, ps, i, fieldWithIndex) -> ps.setTime(i + 1, new Time(JdbcUtil.getDateOrTimeOnly(element.getDateTime(fieldWithIndex.getIndex().intValue()).toDateTime(), false).getTime().getTime()));
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        return (element, ps, i, fieldWithIndex) -> {
                            Calendar calendar = JdbcUtil.withTimestampAndTimezone(element.getDateTime(fieldWithIndex.getIndex().intValue()).toDateTime());
                            ps.setTimestamp(i + 1, new Timestamp(calendar.getTime().getTime()), calendar);
                        };
                    }
                }
                return JdbcUtil.getPreparedStatementSetCaller(fieldType.getLogicalType().getBaseType());
            }
        }
        if (typeNamePsSetCallerMap.containsKey(fieldType.getTypeName())) {
            return typeNamePsSetCallerMap.get(fieldType.getTypeName());
        }
        throw new RuntimeException(fieldType.getTypeName().name() + " in schema is not supported while writing. Please provide statement and preparedStatementSetter");
    }

    private static JdbcIO.PreparedStatementSetCaller createBytesCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), element.getBytes(fieldWithIndex.getIndex().intValue()).length);
            ps.setBytes(i + 1, element.getBytes(fieldWithIndex.getIndex().intValue()));
        };
    }

    private static JdbcIO.PreparedStatementSetCaller createStringCaller() {
        return (element, ps, i, fieldWithIndex) -> {
            JdbcUtil.validateLogicalTypeLength(fieldWithIndex.getField(), element.getString(fieldWithIndex.getIndex().intValue()).length());
            ps.setString(i + 1, element.getString(fieldWithIndex.getIndex().intValue()));
        };
    }

    private static void validateLogicalTypeLength(Schema.Field field, Integer length) {
        try {
            if (field.getType().getTypeName().isLogicalType() && field.getType().getLogicalType().getArgument() != null) {
                int maxLimit = (Integer)field.getType().getLogicalType().getArgument();
                if (length >= maxLimit) {
                    throw new RuntimeException(String.format("Length of Schema.Field[%s] data exceeds database column capacity", field.getName()));
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private static Calendar getDateOrTimeOnly(DateTime dateTime, boolean wantDateOnly) {
        Calendar cal = Calendar.getInstance();
        cal.setTimeZone(TimeZone.getTimeZone(dateTime.getZone().getID()));
        if (wantDateOnly) {
            cal.set(1, dateTime.getYear());
            cal.set(2, dateTime.getMonthOfYear() - 1);
            cal.set(5, dateTime.getDayOfMonth());
            cal.set(11, 0);
            cal.set(12, 0);
            cal.set(13, 0);
            cal.set(14, 0);
        } else {
            cal.set(1, 1970);
            cal.set(2, 0);
            cal.set(5, 1);
            cal.set(11, dateTime.getHourOfDay());
            cal.set(12, dateTime.getMinuteOfHour());
            cal.set(13, dateTime.getSecondOfMinute());
            cal.set(14, dateTime.getMillisOfSecond());
        }
        return cal;
    }

    private static Calendar withTimestampAndTimezone(DateTime dateTime) {
        Calendar calendar = Calendar.getInstance(TimeZone.getTimeZone(dateTime.getZone().getID()));
        calendar.setTimeInMillis(dateTime.getMillis());
        return calendar;
    }

    static Integer[] getBounds(PBegin input, String table, SerializableFunction<Void, DataSource> providerFunctionFn, String partitionColumn) {
        final Integer[] bounds = new Integer[]{0, 0};
        ((PCollection)input.apply(String.format("Read min and max value by %s", partitionColumn), JdbcIO.read().withDataSourceProviderFn(providerFunctionFn).withQuery(String.format("select min(%1$s), max(%1$s) from %2$s", partitionColumn, table)).withRowMapper(resultSet -> String.join((CharSequence)",", Arrays.asList(resultSet.getString(1), resultSet.getString(2)))).withOutputParallelization(false).withCoder((Coder<String>)StringUtf8Coder.of()))).apply((PTransform)ParDo.of((DoFn)new DoFn<String, String>(){

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) {
                List elements = Splitter.on((char)',').splitToList((CharSequence)context.element());
                bounds[0] = Integer.parseInt(Objects.requireNonNull((String)elements.get(0)));
                bounds[1] = Integer.parseInt(Objects.requireNonNull((String)elements.get(1)));
                context.output((Object)((String)context.element()));
            }
        }));
        return bounds;
    }

    static class PartitioningFn
    extends DoFn<List<Integer>, KV<String, Integer>> {
        PartitioningFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            List params = (List)c.element();
            Integer lowerBound = (Integer)params.get(0);
            Integer upperBound = (Integer)params.get(1);
            Integer numPartitions = (Integer)params.get(2);
            if (lowerBound > upperBound) {
                throw new RuntimeException(String.format("Lower bound [%s] is higher than upper bound [%s]", lowerBound, upperBound));
            }
            int stride = (upperBound - lowerBound) / numPartitions + 1;
            for (int i = lowerBound.intValue(); i < upperBound - stride; i += stride) {
                String range = String.format("%s,%s", i, i + stride);
                KV kvRange = KV.of((Object)range, (Object)1);
                c.output((Object)kvRange);
            }
            if (upperBound - lowerBound > stride * (numPartitions - 1)) {
                int indexFrom = (numPartitions - 1) * stride;
                int indexTo = upperBound + 1;
                String range = String.format("%s,%s", indexFrom, indexTo);
                KV kvRange = KV.of((Object)range, (Object)1);
                c.output((Object)kvRange);
            }
        }
    }

    static class BeamRowPreparedStatementSetter
    implements JdbcIO.PreparedStatementSetter<Row> {
        BeamRowPreparedStatementSetter() {
        }

        @Override
        public void setParameters(Row row, PreparedStatement statement) {
            Schema schema = row.getSchema();
            List fieldTypes = schema.getFields();
            IntStream.range(0, fieldTypes.size()).forEachOrdered(i -> {
                Schema.FieldType type = ((Schema.Field)fieldTypes.get(i)).getType();
                try {
                    JdbcUtil.getPreparedStatementSetCaller(type).set(row, statement, i, SchemaUtil.FieldWithIndex.of(schema.getField(i), i));
                }
                catch (SQLException throwables) {
                    throwables.printStackTrace();
                    throw new RuntimeException(String.format("Unable to create prepared statement for type: %s", type), throwables);
                }
            });
        }
    }
}

