/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite;

import java.util.List;
import org.apache.beam.sdk.io.gcp.pubsublite.PubsubLiteReadSchemaTransformProvider;
import org.apache.beam.sdk.schemas.annotations.SchemaFieldDescription;
import org.apache.beam.sdk.schemas.transforms.providers.ErrorHandling;
import org.checkerframework.checker.nullness.qual.Nullable;

final class AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration
extends PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration {
    private final String format;
    private final @Nullable String schema;
    private final @Nullable String project;
    private final String subscriptionName;
    private final String location;
    private final @Nullable ErrorHandling errorHandling;
    private final @Nullable List<String> attributes;
    private final @Nullable String attributeMap;
    private final @Nullable String attributeId;

    private AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration(String format, @Nullable String schema, @Nullable String project, String subscriptionName, String location, @Nullable ErrorHandling errorHandling, @Nullable List<String> attributes, @Nullable String attributeMap, @Nullable String attributeId) {
        this.format = format;
        this.schema = schema;
        this.project = project;
        this.subscriptionName = subscriptionName;
        this.location = location;
        this.errorHandling = errorHandling;
        this.attributes = attributes;
        this.attributeMap = attributeMap;
        this.attributeId = attributeId;
    }

    @Override
    @SchemaFieldDescription(value="The encoding format for the data stored in Pubsub Lite. Valid options are: RAW,AVRO,JSON")
    public String getFormat() {
        return this.format;
    }

    @Override
    @SchemaFieldDescription(value="The schema in which the data is encoded in the Kafka topic. For AVRO data, this is a schema defined with AVRO schema syntax (https://avro.apache.org/docs/1.10.2/spec.html#schemas). For JSON data, this is a schema defined with JSON-schema syntax (https://json-schema.org/).")
    public @Nullable String getSchema() {
        return this.schema;
    }

    @Override
    @SchemaFieldDescription(value="The GCP project where the Pubsub Lite reservation resides. This can be a project number of a project ID.")
    public @Nullable String getProject() {
        return this.project;
    }

    @Override
    @SchemaFieldDescription(value="The name of the subscription to consume data. This will be concatenated with the project and location parameters to build a full subscription path.")
    public String getSubscriptionName() {
        return this.subscriptionName;
    }

    @Override
    @SchemaFieldDescription(value="The region or zone where the Pubsub Lite reservation resides.")
    public String getLocation() {
        return this.location;
    }

    @Override
    @SchemaFieldDescription(value="This option specifies whether and where to output unwritable rows.")
    public @Nullable ErrorHandling getErrorHandling() {
        return this.errorHandling;
    }

    @Override
    @SchemaFieldDescription(value="List of attribute keys whose values will be flattened into the output message as additional fields.  For example, if the format is `RAW` and attributes is `[\"a\", \"b\"]` then this read will produce elements of the form `Row(payload=..., a=..., b=...)`")
    public @Nullable List<String> getAttributes() {
        return this.attributes;
    }

    @Override
    @SchemaFieldDescription(value="Name of a field in which to store the full set of attributes associated with this message.  For example, if the format is `RAW` and `attribute_map` is set to `\"attrs\"` then this read will produce elements of the form `Row(payload=..., attrs=...)` where `attrs` is a Map type of string to string. If both `attributes` and `attribute_map` are set, the overlapping attribute values will be present in both the flattened structure and the attribute map.")
    public @Nullable String getAttributeMap() {
        return this.attributeMap;
    }

    @Override
    @SchemaFieldDescription(value="The attribute on incoming Pubsub Lite messages to use as a unique record identifier. When specified, the value of this attribute (which can be any string that uniquely identifies the record) will be used for deduplication of messages. If not provided, we cannot guarantee that no duplicate data will be delivered on the Pub/Sub stream. In this case, deduplication of the stream will be strictly best effort.")
    public @Nullable String getAttributeId() {
        return this.attributeId;
    }

    public String toString() {
        return "PubsubLiteReadSchemaTransformConfiguration{format=" + this.format + ", schema=" + this.schema + ", project=" + this.project + ", subscriptionName=" + this.subscriptionName + ", location=" + this.location + ", errorHandling=" + this.errorHandling + ", attributes=" + this.attributes + ", attributeMap=" + this.attributeMap + ", attributeId=" + this.attributeId + "}";
    }

    public boolean equals(@Nullable Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration) {
            PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration that = (PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration)o;
            return this.format.equals(that.getFormat()) && (this.schema == null ? that.getSchema() == null : this.schema.equals(that.getSchema())) && (this.project == null ? that.getProject() == null : this.project.equals(that.getProject())) && this.subscriptionName.equals(that.getSubscriptionName()) && this.location.equals(that.getLocation()) && (this.errorHandling == null ? that.getErrorHandling() == null : this.errorHandling.equals(that.getErrorHandling())) && (this.attributes == null ? that.getAttributes() == null : this.attributes.equals(that.getAttributes())) && (this.attributeMap == null ? that.getAttributeMap() == null : this.attributeMap.equals(that.getAttributeMap())) && (this.attributeId == null ? that.getAttributeId() == null : this.attributeId.equals(that.getAttributeId()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.format.hashCode();
        h$ *= 1000003;
        h$ ^= this.schema == null ? 0 : this.schema.hashCode();
        h$ *= 1000003;
        h$ ^= this.project == null ? 0 : this.project.hashCode();
        h$ *= 1000003;
        h$ ^= this.subscriptionName.hashCode();
        h$ *= 1000003;
        h$ ^= this.location.hashCode();
        h$ *= 1000003;
        h$ ^= this.errorHandling == null ? 0 : this.errorHandling.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributes == null ? 0 : this.attributes.hashCode();
        h$ *= 1000003;
        h$ ^= this.attributeMap == null ? 0 : this.attributeMap.hashCode();
        h$ *= 1000003;
        return h$ ^= this.attributeId == null ? 0 : this.attributeId.hashCode();
    }

    static final class Builder
    extends PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder {
        private String format;
        private @Nullable String schema;
        private @Nullable String project;
        private String subscriptionName;
        private String location;
        private @Nullable ErrorHandling errorHandling;
        private @Nullable List<String> attributes;
        private @Nullable String attributeMap;
        private @Nullable String attributeId;

        Builder() {
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setFormat(String format) {
            if (format == null) {
                throw new NullPointerException("Null format");
            }
            this.format = format;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setSchema(String schema) {
            this.schema = schema;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setProject(String project) {
            this.project = project;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setSubscriptionName(String subscriptionName) {
            if (subscriptionName == null) {
                throw new NullPointerException("Null subscriptionName");
            }
            this.subscriptionName = subscriptionName;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setLocation(String location) {
            if (location == null) {
                throw new NullPointerException("Null location");
            }
            this.location = location;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setErrorHandling(ErrorHandling errorHandling) {
            this.errorHandling = errorHandling;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setAttributes(List<String> attributes) {
            this.attributes = attributes;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setAttributeMap(String attributeMap) {
            this.attributeMap = attributeMap;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration.Builder setAttributeId(String attributeId) {
            this.attributeId = attributeId;
            return this;
        }

        @Override
        public PubsubLiteReadSchemaTransformProvider.PubsubLiteReadSchemaTransformConfiguration build() {
            if (this.format == null || this.subscriptionName == null || this.location == null) {
                StringBuilder missing = new StringBuilder();
                if (this.format == null) {
                    missing.append(" format");
                }
                if (this.subscriptionName == null) {
                    missing.append(" subscriptionName");
                }
                if (this.location == null) {
                    missing.append(" location");
                }
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_PubsubLiteReadSchemaTransformProvider_PubsubLiteReadSchemaTransformConfiguration(this.format, this.schema, this.project, this.subscriptionName, this.location, this.errorHandling, this.attributes, this.attributeMap, this.attributeId);
        }
    }
}

