/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.time.DateTimeException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.LocalTime;

public final class CivilTimeEncoder {
    private static final int NANO_LENGTH = 30;
    private static final int MICRO_LENGTH = 20;
    private static final int NANO_SHIFT = 0;
    private static final int MICRO_SHIFT = 0;
    private static final int SECOND_SHIFT = 0;
    private static final int MINUTE_SHIFT = 6;
    private static final int HOUR_SHIFT = 12;
    private static final int DAY_SHIFT = 17;
    private static final int MONTH_SHIFT = 22;
    private static final int YEAR_SHIFT = 26;
    private static final long NANO_MASK = 0x3FFFFFFFL;
    private static final long MICRO_MASK = 1048575L;
    private static final long SECOND_MASK = 63L;
    private static final long MINUTE_MASK = 4032L;
    private static final long HOUR_MASK = 126976L;
    private static final long DAY_MASK = 0x3E0000L;
    private static final long MONTH_MASK = 0x3C00000L;
    private static final long YEAR_MASK = 0xFFFC000000L;
    private static final long TIME_SECONDS_MASK = 131071L;
    private static final long TIME_MICROS_MASK = 0x1FFFFFFFFFL;
    private static final long TIME_NANOS_MASK = 0x7FFFFFFFFFFFL;
    private static final long DATETIME_SECONDS_MASK = 0xFFFFFFFFFFL;
    private static final long DATETIME_MICROS_MASK = 0xFFFFFFFFFFFFFFFL;

    public static int encodePacked32TimeSeconds(LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        int bitFieldTimeSeconds = 0;
        bitFieldTimeSeconds |= time.getHourOfDay() << 12;
        bitFieldTimeSeconds |= time.getMinuteOfHour() << 6;
        return bitFieldTimeSeconds |= time.getSecondOfMinute() << 0;
    }

    public static int encodePacked32TimeSeconds(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        int bitFieldTimeSeconds = 0;
        bitFieldTimeSeconds |= time.getHour() << 12;
        bitFieldTimeSeconds |= time.getMinute() << 6;
        return bitFieldTimeSeconds |= time.getSecond() << 0;
    }

    public static LocalTime decodePacked32TimeSeconds(int bitFieldTimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeSeconds, 131071L);
        int hourOfDay = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 126976L, 12);
        int minuteOfHour = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 4032L, 6);
        int secondOfMinute = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 63L, 0);
        LocalTime time = new LocalTime(hourOfDay, minuteOfHour, secondOfMinute);
        CivilTimeEncoder.checkValidTimeSeconds(time);
        return time;
    }

    public static java.time.LocalTime decodePacked32TimeSecondsAsJavaTime(int bitFieldTimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeSeconds, 131071L);
        int hourOfDay = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 126976L, 12);
        int minuteOfHour = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 4032L, 6);
        int secondOfMinute = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeSeconds, 63L, 0);
        try {
            return java.time.LocalTime.of(hourOfDay, minuteOfHour, secondOfMinute);
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static long encodePacked64TimeMicros(LocalTime time) {
        CivilTimeEncoder.checkValidTimeMillis(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 20 | (long)time.getMillisOfSecond() * 1000L;
    }

    public static long encodePacked64TimeMicros(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeMicros(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 20 | (long)time.getNano() / 1000L;
    }

    public static LocalTime decodePacked64TimeMicros(long bitFieldTimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeMicros, 0x1FFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeMicros >> 20);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        LocalTime time = timeSeconds.withMillisOfSecond(microOfSecond / 1000);
        CivilTimeEncoder.checkValidTimeMillis(time);
        return time;
    }

    public static java.time.LocalTime decodePacked64TimeMicrosAsJavaTime(long bitFieldTimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeMicros, 0x1FFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeMicros >> 20);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        return timeSeconds.withNano(microOfSecond * 1000);
    }

    public static long encodePacked64TimeNanos(LocalTime time) {
        CivilTimeEncoder.checkValidTimeMillis(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 30 | (long)time.getMillisOfSecond() * 1000000L;
    }

    public static long encodePacked64TimeNanos(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeNanos(time);
        return (long)CivilTimeEncoder.encodePacked32TimeSeconds(time) << 30 | (long)time.getNano();
    }

    public static LocalTime decodePacked64TimeNanos(long bitFieldTimeNanos) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeNanos, 0x7FFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeNanos >> 30);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int nanoOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeNanos, 0x3FFFFFFFL, 0);
        CivilTimeEncoder.checkValidNanoOfSecond(nanoOfSecond);
        LocalTime time = timeSeconds.withMillisOfSecond(nanoOfSecond / 1000000);
        CivilTimeEncoder.checkValidTimeMillis(time);
        return time;
    }

    public static java.time.LocalTime decodePacked64TimeNanosAsJavaTime(long bitFieldTimeNanos) {
        CivilTimeEncoder.checkValidBitField(bitFieldTimeNanos, 0x7FFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldTimeNanos >> 30);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int nanoOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldTimeNanos, 0x3FFFFFFFL, 0);
        CivilTimeEncoder.checkValidNanoOfSecond(nanoOfSecond);
        return timeSeconds.withNano(nanoOfSecond);
    }

    public static long encodePacked64DatetimeSeconds(org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        long bitFieldDatetimeSeconds = 0L;
        bitFieldDatetimeSeconds |= (long)dateTime.getYear() << 26;
        bitFieldDatetimeSeconds |= (long)dateTime.getMonthOfYear() << 22;
        bitFieldDatetimeSeconds |= (long)dateTime.getDayOfMonth() << 17;
        return bitFieldDatetimeSeconds |= (long)CivilTimeEncoder.encodePacked32TimeSeconds(dateTime.toLocalTime());
    }

    public static long encodePacked64DatetimeSeconds(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        long bitFieldDatetimeSeconds = 0L;
        bitFieldDatetimeSeconds |= (long)dateTime.getYear() << 26;
        bitFieldDatetimeSeconds |= (long)dateTime.getMonthValue() << 22;
        bitFieldDatetimeSeconds |= (long)dateTime.getDayOfMonth() << 17;
        return bitFieldDatetimeSeconds |= (long)CivilTimeEncoder.encodePacked32TimeSeconds(dateTime.toLocalTime());
    }

    public static org.joda.time.LocalDateTime decodePacked64DatetimeSeconds(long bitFieldDatetimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeSeconds, 0xFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldDatetimeSeconds & 0x1FFFFL);
        LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSeconds(bitFieldTimeSeconds);
        int year = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0xFFFC000000L, 26);
        int monthOfYear = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3C00000L, 22);
        int dayOfMonth = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3E0000L, 17);
        org.joda.time.LocalDateTime dateTime = new org.joda.time.LocalDateTime(year, monthOfYear, dayOfMonth, timeSeconds.getHourOfDay(), timeSeconds.getMinuteOfHour(), timeSeconds.getSecondOfMinute());
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        return dateTime;
    }

    public static LocalDateTime decodePacked64DatetimeSecondsAsJavaTime(long bitFieldDatetimeSeconds) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeSeconds, 0xFFFFFFFFFFL);
        int bitFieldTimeSeconds = (int)(bitFieldDatetimeSeconds & 0x1FFFFL);
        java.time.LocalTime timeSeconds = CivilTimeEncoder.decodePacked32TimeSecondsAsJavaTime(bitFieldTimeSeconds);
        int year = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0xFFFC000000L, 26);
        int monthOfYear = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3C00000L, 22);
        int dayOfMonth = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeSeconds, 0x3E0000L, 17);
        try {
            LocalDateTime dateTime = LocalDateTime.of(year, monthOfYear, dayOfMonth, timeSeconds.getHour(), timeSeconds.getMinute(), timeSeconds.getSecond());
            CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
            return dateTime;
        }
        catch (DateTimeException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public static long encodePacked64DatetimeMicros(org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeMillis(dateTime);
        return CivilTimeEncoder.encodePacked64DatetimeSeconds(dateTime) << 20 | (long)dateTime.getMillisOfSecond() * 1000L;
    }

    public static long encodePacked64DatetimeMicros(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return CivilTimeEncoder.encodePacked64DatetimeSeconds(dateTime) << 20 | (long)dateTime.getNano() / 1000L;
    }

    public static org.joda.time.LocalDateTime decodePacked64DatetimeMicros(long bitFieldDatetimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeMicros, 0xFFFFFFFFFFFFFFFL);
        long bitFieldDatetimeSeconds = bitFieldDatetimeMicros >> 20;
        org.joda.time.LocalDateTime dateTimeSeconds = CivilTimeEncoder.decodePacked64DatetimeSeconds(bitFieldDatetimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        org.joda.time.LocalDateTime dateTime = dateTimeSeconds.withMillisOfSecond(microOfSecond / 1000);
        CivilTimeEncoder.checkValidDateTimeMillis(dateTime);
        return dateTime;
    }

    public static LocalDateTime decodePacked64DatetimeMicrosAsJavaTime(long bitFieldDatetimeMicros) {
        CivilTimeEncoder.checkValidBitField(bitFieldDatetimeMicros, 0xFFFFFFFFFFFFFFFL);
        long bitFieldDatetimeSeconds = bitFieldDatetimeMicros >> 20;
        LocalDateTime dateTimeSeconds = CivilTimeEncoder.decodePacked64DatetimeSecondsAsJavaTime(bitFieldDatetimeSeconds);
        int microOfSecond = CivilTimeEncoder.getFieldFromBitField(bitFieldDatetimeMicros, 1048575L, 0);
        CivilTimeEncoder.checkValidMicroOfSecond(microOfSecond);
        LocalDateTime dateTime = dateTimeSeconds.withNano(microOfSecond * 1000);
        CivilTimeEncoder.checkValidDateTimeMicros(dateTime);
        return dateTime;
    }

    private static int getFieldFromBitField(long bitField, long mask, int shift) {
        return (int)((bitField & mask) >> shift);
    }

    private static void checkValidTimeSeconds(LocalTime time) {
        Preconditions.checkArgument((time.getHourOfDay() >= 0 && time.getHourOfDay() <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getMinuteOfHour() >= 0 && time.getMinuteOfHour() <= 59 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getSecondOfMinute() >= 0 && time.getSecondOfMinute() <= 59 ? 1 : 0) != 0);
    }

    private static void checkValidTimeSeconds(java.time.LocalTime time) {
        Preconditions.checkArgument((time.getHour() >= 0 && time.getHour() <= 23 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getMinute() >= 0 && time.getMinute() <= 59 ? 1 : 0) != 0);
        Preconditions.checkArgument((time.getSecond() >= 0 && time.getSecond() <= 59 ? 1 : 0) != 0);
    }

    private static void checkValidTimeMillis(LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        Preconditions.checkArgument((time.getMillisOfSecond() >= 0 && time.getMillisOfSecond() <= 999 ? 1 : 0) != 0);
    }

    private static void checkValidTimeMicros(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
        Preconditions.checkArgument((boolean)time.equals(time.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidTimeNanos(java.time.LocalTime time) {
        CivilTimeEncoder.checkValidTimeSeconds(time);
    }

    private static void checkValidDateTimeSeconds(org.joda.time.LocalDateTime dateTime) {
        Preconditions.checkArgument((dateTime.getYear() >= 1 && dateTime.getYear() <= 9999 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getMonthOfYear() >= 1 && dateTime.getMonthOfYear() <= 12 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getDayOfMonth() >= 1 && dateTime.getDayOfMonth() <= 31 ? 1 : 0) != 0);
        CivilTimeEncoder.checkValidTimeSeconds(dateTime.toLocalTime());
    }

    private static void checkValidDateTimeSeconds(LocalDateTime dateTime) {
        Preconditions.checkArgument((dateTime.getYear() >= 1 && dateTime.getYear() <= 9999 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getMonthValue() >= 1 && dateTime.getMonthValue() <= 12 ? 1 : 0) != 0);
        Preconditions.checkArgument((dateTime.getDayOfMonth() >= 1 && dateTime.getDayOfMonth() <= 31 ? 1 : 0) != 0);
        CivilTimeEncoder.checkValidTimeSeconds(dateTime.toLocalTime());
    }

    private static void checkValidDateTimeMillis(org.joda.time.LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        Preconditions.checkArgument((dateTime.getMillisOfSecond() >= 0 && dateTime.getMillisOfSecond() <= 999 ? 1 : 0) != 0);
    }

    private static void checkValidDateTimeMicros(LocalDateTime dateTime) {
        CivilTimeEncoder.checkValidDateTimeSeconds(dateTime);
        Preconditions.checkArgument((boolean)dateTime.equals(dateTime.truncatedTo(ChronoUnit.MICROS)));
    }

    private static void checkValidMicroOfSecond(int microOfSecond) {
        Preconditions.checkArgument((microOfSecond >= 0 && microOfSecond <= 999999 ? 1 : 0) != 0);
    }

    private static void checkValidNanoOfSecond(int nanoOfSecond) {
        Preconditions.checkArgument((nanoOfSecond >= 0 && nanoOfSecond <= 999999999 ? 1 : 0) != 0);
    }

    private static void checkValidBitField(long bitField, long mask) {
        Preconditions.checkArgument(((bitField & (mask ^ 0xFFFFFFFFFFFFFFFFL)) == 0L ? 1 : 0) != 0);
    }

    private CivilTimeEncoder() {
    }
}

