/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.testing;

import com.google.api.client.http.HttpHeaders;
import com.google.api.client.http.HttpResponseException;
import com.google.api.core.ApiFuture;
import com.google.api.core.ApiFutures;
import com.google.api.services.bigquery.model.Dataset;
import com.google.api.services.bigquery.model.DatasetReference;
import com.google.api.services.bigquery.model.TableDataInsertAllResponse;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TableRow;
import com.google.api.services.bigquery.model.TableSchema;
import com.google.cloud.bigquery.storage.v1.AppendRowsResponse;
import com.google.cloud.bigquery.storage.v1.BatchCommitWriteStreamsResponse;
import com.google.cloud.bigquery.storage.v1.FinalizeWriteStreamResponse;
import com.google.cloud.bigquery.storage.v1.FlushRowsResponse;
import com.google.cloud.bigquery.storage.v1.ProtoRows;
import com.google.cloud.bigquery.storage.v1.WriteStream;
import com.google.errorprone.annotations.FormatMethod;
import com.google.errorprone.annotations.FormatString;
import com.google.protobuf.ByteString;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.ErrorContainer;
import org.apache.beam.sdk.io.gcp.bigquery.InsertRetryPolicy;
import org.apache.beam.sdk.io.gcp.bigquery.TableRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.testing.FakeJobService;
import org.apache.beam.sdk.io.gcp.testing.TableContainer;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.PaneInfo;
import org.apache.beam.sdk.values.FailsafeValueInSingleWindow;
import org.apache.beam.sdk.values.ValueInSingleWindow;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.HashBasedTable;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Table;
import org.joda.time.Instant;
import org.junit.Assert;

@Internal
public class FakeDatasetService
implements BigQueryServices.DatasetService,
Serializable {
    static Table<String, String, Map<String, TableContainer>> tables;
    static Map<String, Stream> writeStreams;
    Map<String, List<String>> insertErrors = Maps.newHashMap();
    static AtomicInteger insertCount;

    @Override
    public void close() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp() {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            tables = HashBasedTable.create();
            insertCount = new AtomicInteger(0);
            writeStreams = Maps.newHashMap();
            FakeJobService.setUp();
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    @Override
    public com.google.api.services.bigquery.model.Table getTable(TableReference tableRef) throws InterruptedException, IOException {
        if (tableRef.getProjectId() == null) {
            throw new NullPointerException(String.format("tableRef is missing projectId: %s", tableRef));
        }
        return this.getTable(tableRef, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.api.services.bigquery.model.Table getTable(TableReference tableRef, @Nullable List<String> selectedFields) throws InterruptedException, IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            com.google.api.services.bigquery.model.Table table = (tableContainer = (TableContainer)dataset.get(tableRef.getTableId())) == null ? null : tableContainer.getTable();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<TableRow> getAllRows(String projectId, String datasetId, String tableId) throws InterruptedException, IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.getTableContainer(projectId, datasetId, tableId).getRows();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> getAllIds(String projectId, String datasetId, String tableId) throws InterruptedException, IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return this.getTableContainer(projectId, datasetId, tableId).getIds();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TableContainer getTableContainer(String projectId, String datasetId, String tableId) throws InterruptedException, IOException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such dataset was set", projectId, datasetId);
            }
            if ((tableContainer = (TableContainer)dataset.get(tableId)) == null) {
                this.throwNotFound("Tried to get a table %s:%s.%s, but no such table was set", projectId, datasetId, tableId);
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return tableContainer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteTable(TableReference tableRef) throws IOException, InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableRef);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)tableRef.getProjectId(), (Object)tableRef.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableRef.getProjectId(), tableRef.getDatasetId());
            }
            dataset.remove(tableRef.getTableId());
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    private static void validateWholeTableReference(TableReference tableReference) throws IOException {
        Pattern tableRegexp = Pattern.compile("[-\\w]{1,1024}");
        if (!tableRegexp.matcher(tableReference.getTableId()).matches()) {
            throw new IOException(String.format("invalid table ID %s. Table IDs must be alphanumeric (plus underscores) and must be at most 1024 characters long. Also, table decorators cannot be used.", tableReference.getTableId()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createTable(com.google.api.services.bigquery.model.Table table) throws IOException {
        TableReference tableReference = table.getTableReference();
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            dataset.computeIfAbsent(tableReference.getTableId(), k -> {
                TableContainer tableContainer = new TableContainer(table);
                String streamName = String.format("projects/%s/datasets/%s/tables/%s/streams/_default", tableReference.getProjectId(), tableReference.getDatasetId(), BigQueryHelpers.stripPartitionDecorator(tableReference.getTableId()));
                writeStreams.put(streamName, new Stream(streamName, tableContainer, WriteStream.Type.COMMITTED));
                return tableContainer;
            });
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateTableSchema(TableReference tableReference, TableSchema tableSchema) throws IOException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer;
            Map dataset = (Map)tables.get((Object)tableReference.getProjectId(), (Object)tableReference.getDatasetId());
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", tableReference.getProjectId(), tableReference.getDatasetId());
            }
            if ((tableContainer = (TableContainer)dataset.get(tableReference.getTableId())) == null) {
                this.throwNotFound("Tried to get a table %s, but no such table existed", tableReference);
            }
            tableContainer.table.setSchema(tableSchema);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    @Override
    public boolean isTableEmpty(TableReference tableRef) throws IOException, InterruptedException {
        Long numBytes = this.getTable(tableRef).getNumBytes();
        return numBytes == null || numBytes == 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dataset getDataset(String projectId, String datasetId) throws IOException, InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Map dataset = (Map)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                this.throwNotFound("Tried to get a dataset %s:%s, but no such table was set", projectId, datasetId);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return new Dataset().setDatasetReference(new DatasetReference().setDatasetId(datasetId).setProjectId(projectId));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createDataset(String projectId, String datasetId, String location, String description, Long defaultTableExpirationMs) throws IOException, InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            HashMap dataset = (HashMap)tables.get((Object)projectId, (Object)datasetId);
            if (dataset == null) {
                dataset = new HashMap();
                tables.put((Object)projectId, (Object)datasetId, dataset);
            }
            // ** MonitorExit[var6_6] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteDataset(String projectId, String datasetId) throws IOException, InterruptedException {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            tables.remove((Object)projectId, (Object)datasetId);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public int getInsertCount() {
        return insertCount.get();
    }

    public long insertAll(TableReference ref, List<TableRow> rowList, @Nullable List<String> insertIdList) throws IOException, InterruptedException {
        ArrayList windowedRows = Lists.newArrayList();
        for (TableRow row : rowList) {
            windowedRows.add(FailsafeValueInSingleWindow.of((Object)row, (Instant)GlobalWindow.TIMESTAMP_MAX_VALUE, (BoundedWindow)GlobalWindow.INSTANCE, (PaneInfo)PaneInfo.ON_TIME_AND_ONLY_FIRING, (Object)row));
        }
        return this.insertAll(ref, windowedRows, insertIdList, InsertRetryPolicy.alwaysRetry(), null, null, false, false, false, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <T> long insertAll(TableReference ref, List<FailsafeValueInSingleWindow<TableRow, TableRow>> rowList, @Nullable List<String> insertIdList, InsertRetryPolicy retryPolicy, List<ValueInSingleWindow<T>> failedInserts, ErrorContainer<T> errorContainer, boolean skipInvalidRows, boolean ignoreUnknownValues, boolean ignoreInsertIds, List<ValueInSingleWindow<TableRow>> successfulRows) throws IOException, InterruptedException {
        Map<TableRow, List<TableDataInsertAllResponse.InsertErrors>> insertErrors = this.getInsertErrors();
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            if (ignoreInsertIds) {
                insertIdList = null;
            }
            if (insertIdList != null) {
                Assert.assertEquals((long)rowList.size(), (long)insertIdList.size());
            }
            long dataSize = 0L;
            TableContainer tableContainer = this.getTableContainer(ref.getProjectId(), ref.getDatasetId(), BigQueryHelpers.stripPartitionDecorator(ref.getTableId()));
            for (int i = 0; i < rowList.size(); ++i) {
                TableRow row = (TableRow)rowList.get(i).getValue();
                List<TableDataInsertAllResponse.InsertErrors> allErrors = insertErrors.get(row);
                boolean shouldInsert = true;
                if (allErrors != null) {
                    for (TableDataInsertAllResponse.InsertErrors errors : allErrors) {
                        if (retryPolicy.shouldRetry(new InsertRetryPolicy.Context(errors))) continue;
                        shouldInsert = false;
                    }
                }
                if (shouldInsert) {
                    dataSize = insertIdList == null ? (dataSize += tableContainer.addRow(row, null)) : (dataSize += tableContainer.addRow(row, insertIdList.get(i)));
                    if (successfulRows == null) continue;
                    successfulRows.add((ValueInSingleWindow<TableRow>)ValueInSingleWindow.of((Object)row, (Instant)rowList.get(i).getTimestamp(), (BoundedWindow)rowList.get(i).getWindow(), (PaneInfo)rowList.get(i).getPane()));
                    continue;
                }
                errorContainer.add(failedInserts, allErrors.get(allErrors.size() - 1), ref, rowList.get(i));
            }
            insertCount.addAndGet(1);
            // ** MonitorExit[var12_12] (shouldn't be in output)
            return dataSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public com.google.api.services.bigquery.model.Table patchTableDescription(TableReference tableReference, @Nullable String tableDescription) throws IOException, InterruptedException {
        FakeDatasetService.validateWholeTableReference(tableReference);
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer = this.getTableContainer(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
            tableContainer.getTable().setDescription(tableDescription);
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return tableContainer.getTable();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public WriteStream createWriteStream(String tableUrn, WriteStream.Type type) throws IOException, InterruptedException {
        TableReference tableReference = BigQueryHelpers.parseTableUrn(BigQueryHelpers.stripPartitionDecorator(tableUrn));
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            TableContainer tableContainer = this.getTableContainer(tableReference.getProjectId(), tableReference.getDatasetId(), tableReference.getTableId());
            String streamName = UUID.randomUUID().toString();
            writeStreams.put(streamName, new Stream(streamName, tableContainer, type));
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return WriteStream.newBuilder().setName(streamName).build();
        }
    }

    @Override
    public BigQueryServices.StreamAppendClient getStreamAppendClient(final String streamName, final Descriptors.Descriptor descriptor) {
        return new BigQueryServices.StreamAppendClient(){
            private Descriptors.Descriptor protoDescriptor;
            {
                this.protoDescriptor = descriptor;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public ApiFuture<AppendRowsResponse> appendRows(long offset, ProtoRows rows) throws Exception {
                Class<FakeDatasetService> clazz = FakeDatasetService.class;
                synchronized (FakeDatasetService.class) {
                    Stream stream = writeStreams.get(streamName);
                    if (stream == null) {
                        throw new RuntimeException("No such stream: " + streamName);
                    }
                    ArrayList tableRows = Lists.newArrayListWithExpectedSize((int)rows.getSerializedRowsCount());
                    for (ByteString bytes : rows.getSerializedRowsList()) {
                        DynamicMessage msg = DynamicMessage.parseFrom((Descriptors.Descriptor)this.protoDescriptor, (ByteString)bytes);
                        if (msg.getUnknownFields() != null && !msg.getUnknownFields().asMap().isEmpty()) {
                            throw new RuntimeException("Unknown fields set in append! " + msg.getUnknownFields());
                        }
                        tableRows.add(TableRowToStorageApiProto.tableRowFromMessage((Message)DynamicMessage.parseFrom((Descriptors.Descriptor)this.protoDescriptor, (ByteString)bytes)));
                    }
                    stream.appendRows(offset, tableRows);
                    // ** MonitorExit[var4_3] (shouldn't be in output)
                    return ApiFutures.immediateFuture((Object)AppendRowsResponse.newBuilder().build());
                }
            }

            @Override
            public void close() throws Exception {
            }

            @Override
            public void pin() {
            }

            @Override
            public void unpin() throws Exception {
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<FlushRowsResponse> flush(String streamName, long offset) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Stream stream = writeStreams.get(streamName);
            if (stream == null) {
                throw new RuntimeException("No such stream: " + streamName);
            }
            stream.flush(offset);
            // ** MonitorExit[var4_3] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)FlushRowsResponse.newBuilder().build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<FinalizeWriteStreamResponse> finalizeWriteStream(String streamName) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            Stream stream = writeStreams.get(streamName);
            if (stream == null) {
                throw new RuntimeException("No such stream: " + streamName);
            }
            long numRows = stream.finalizeStream();
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)FinalizeWriteStreamResponse.newBuilder().setRowCount(numRows).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApiFuture<BatchCommitWriteStreamsResponse> commitWriteStreams(String tableUrn, Iterable<String> writeStreamNames) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (String streamName : writeStreamNames) {
                Stream stream = writeStreams.get(streamName);
                if (stream == null) {
                    throw new RuntimeException("No such stream: " + streamName);
                }
                stream.commit();
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return ApiFutures.immediateFuture((Object)BatchCommitWriteStreamsResponse.newBuilder().setCommitTime(Timestamp.newBuilder().build()).build());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void failOnInsert(Map<TableRow, List<TableDataInsertAllResponse.InsertErrors>> insertErrors) {
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (Map.Entry<TableRow, List<TableDataInsertAllResponse.InsertErrors>> entry : insertErrors.entrySet()) {
                ArrayList errorStrings = Lists.newArrayList();
                for (TableDataInsertAllResponse.InsertErrors errors : entry.getValue()) {
                    errorStrings.add(BigQueryHelpers.toJsonString(errors));
                }
                this.insertErrors.put(BigQueryHelpers.toJsonString(entry.getKey()), errorStrings);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<TableRow, List<TableDataInsertAllResponse.InsertErrors>> getInsertErrors() {
        HashMap parsedInsertErrors = Maps.newHashMap();
        Class<FakeDatasetService> clazz = FakeDatasetService.class;
        synchronized (FakeDatasetService.class) {
            for (Map.Entry<String, List<String>> entry : this.insertErrors.entrySet()) {
                TableRow tableRow = BigQueryHelpers.fromJsonString(entry.getKey(), TableRow.class);
                ArrayList allErrors = Lists.newArrayList();
                for (String errorsString : entry.getValue()) {
                    allErrors.add(BigQueryHelpers.fromJsonString(errorsString, TableDataInsertAllResponse.InsertErrors.class));
                }
                parsedInsertErrors.put(tableRow, allErrors);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return parsedInsertErrors;
        }
    }

    @FormatMethod
    void throwNotFound(@FormatString String format, Object ... args) throws IOException {
        throw new IOException(String.format(format, args), (Throwable)new HttpResponseException.Builder(404, String.format(format, args), new HttpHeaders()).build());
    }

    static class Stream {
        final String streamName;
        final List<TableRow> stream;
        final TableContainer tableContainer;
        final WriteStream.Type type;
        long nextFlushPosition;
        boolean finalized;

        Stream(String streamName, TableContainer tableContainer, WriteStream.Type type) {
            this.streamName = streamName;
            this.stream = Lists.newArrayList();
            this.tableContainer = tableContainer;
            this.type = type;
            this.finalized = false;
            this.nextFlushPosition = 0L;
        }

        long finalizeStream() {
            this.finalized = true;
            return this.stream.size();
        }

        void appendRows(long position, List<TableRow> rowsToAppend) {
            if (this.finalized) {
                throw new RuntimeException("Stream already finalized.");
            }
            if (position != -1L && position != (long)this.stream.size()) {
                throw new RuntimeException("Bad append: " + position + " + for stream " + this.streamName + " expected " + this.stream.size());
            }
            this.stream.addAll(rowsToAppend);
            if (this.type == WriteStream.Type.COMMITTED) {
                for (TableRow row : rowsToAppend) {
                    this.tableContainer.addRow(row, "");
                }
            }
        }

        void flush(long position) {
            Preconditions.checkState((this.type == WriteStream.Type.BUFFERED ? 1 : 0) != 0);
            Preconditions.checkState((!this.finalized ? 1 : 0) != 0);
            if (position >= (long)this.stream.size()) {
                throw new RuntimeException("");
            }
            while (this.nextFlushPosition <= position) {
                this.tableContainer.addRow(this.stream.get((int)this.nextFlushPosition), "");
                ++this.nextFlushPosition;
            }
        }

        void commit() {
            if (!this.finalized) {
                throw new RuntimeException("Can't commit unfinalized stream.");
            }
            Preconditions.checkState((this.type == WriteStream.Type.PENDING ? 1 : 0) != 0);
            this.stream.forEach(tr -> this.tableContainer.addRow((TableRow)tr, null));
        }
    }
}

