/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.StatusCode;
import com.google.auto.value.AutoValue;
import com.google.cloud.ServiceFactory;
import com.google.cloud.Timestamp;
import com.google.cloud.spanner.AbortedException;
import com.google.cloud.spanner.DatabaseId;
import com.google.cloud.spanner.Dialect;
import com.google.cloud.spanner.ErrorCode;
import com.google.cloud.spanner.KeySet;
import com.google.cloud.spanner.Mutation;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.PartitionOptions;
import com.google.cloud.spanner.Spanner;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Statement;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.OptionalInt;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_CreateTransaction;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Read;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadAll;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_ReadChangeStream;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_SpannerIO_Write;
import org.apache.beam.sdk.io.gcp.spanner.BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.CreateTransactionFn;
import org.apache.beam.sdk.io.gcp.spanner.MutationCellCounter;
import org.apache.beam.sdk.io.gcp.spanner.MutationGroup;
import org.apache.beam.sdk.io.gcp.spanner.MutationKeyEncoder;
import org.apache.beam.sdk.io.gcp.spanner.MutationSizeEstimator;
import org.apache.beam.sdk.io.gcp.spanner.MutationUtils;
import org.apache.beam.sdk.io.gcp.spanner.NaiveSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.ReadSpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerSchema;
import org.apache.beam.sdk.io.gcp.spanner.SpannerWriteResult;
import org.apache.beam.sdk.io.gcp.spanner.StructUtils;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamMetrics;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.ChangeStreamsConstants;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.NameGenerator;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.action.ActionFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dao.DaoFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.CleanUpReadChangeStreamDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.DetectNewPartitionsDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.InitializeDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.PostProcessingMetricsDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.dofn.ReadChangeStreamPartitionDoFn;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.mapper.MapperFactory;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.model.DataChangeRecord;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.ThroughputEstimator;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.Flatten;
import org.apache.beam.sdk.transforms.Impulse;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.WithTimestamps;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.DefaultTrigger;
import org.apache.beam.sdk.transforms.windowing.GlobalWindow;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.sdk.util.FluentBackoff;
import org.apache.beam.sdk.util.Sleeper;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionList;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.UnsignedBytes;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class SpannerIO {
    private static final Logger LOG = LoggerFactory.getLogger(SpannerIO.class);
    private static final long DEFAULT_BATCH_SIZE_BYTES = 0x100000L;
    private static final int DEFAULT_MAX_NUM_MUTATIONS = 5000;
    private static final int DEFAULT_MAX_NUM_ROWS = 500;
    private static final int DEFAULT_GROUPING_FACTOR = 1000;

    public static Read read() {
        return new AutoValue_SpannerIO_Read.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setReadOperation(ReadOperation.create()).setBatching(true).build();
    }

    public static ReadAll readAll() {
        return new AutoValue_SpannerIO_ReadAll.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).setBatching(true).build();
    }

    @Experimental
    public static CreateTransaction createTransaction() {
        return new AutoValue_SpannerIO_CreateTransaction.Builder().setSpannerConfig(SpannerConfig.create()).setTimestampBound(TimestampBound.strong()).build();
    }

    @Experimental
    public static Write write() {
        return new AutoValue_SpannerIO_Write.Builder().setSpannerConfig(SpannerConfig.create()).setBatchSizeBytes(0x100000L).setMaxNumMutations(5000L).setMaxNumRows(500L).setFailureMode(FailureMode.FAIL_FAST).build();
    }

    @Experimental
    public static ReadChangeStream readChangeStream() {
        return new AutoValue_SpannerIO_ReadChangeStream.Builder().setSpannerConfig(SpannerConfig.create()).setChangeStreamName("").setRpcPriority(ChangeStreamsConstants.DEFAULT_RPC_PRIORITY).setInclusiveStartAt(ChangeStreamsConstants.DEFAULT_INCLUSIVE_START_AT).setInclusiveEndAt(ChangeStreamsConstants.DEFAULT_INCLUSIVE_END_AT).build();
    }

    private SpannerIO() {
    }

    @VisibleForTesting
    static class WriteToSpannerFn
    extends DoFn<Iterable<MutationGroup>, Void> {
        private final SpannerConfig spannerConfig;
        private final FailureMode failureMode;
        private transient SpannerAccessor spannerAccessor;
        private static final int ABORTED_RETRY_ATTEMPTS = 5;
        private final String errString = "Transaction aborted. Database schema probably changed during transaction, retry may succeed.";
        @VisibleForTesting
        static Sleeper sleeper = Sleeper.DEFAULT;
        private final Counter mutationGroupBatchesReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_received");
        private final Counter mutationGroupBatchesWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_success");
        private final Counter mutationGroupBatchesWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_group_batches_write_fail");
        private final Counter mutationGroupsReceived = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_received");
        private final Counter mutationGroupsWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_success");
        private final Counter mutationGroupsWriteFail = Metrics.counter(WriteGrouped.class, (String)"mutation_groups_write_fail");
        private final Counter spannerWriteSuccess = Metrics.counter(WriteGrouped.class, (String)"spanner_write_success");
        private final Counter spannerWriteFail = Metrics.counter(WriteGrouped.class, (String)"spanner_write_fail");
        private final Distribution spannerWriteLatency = Metrics.distribution(WriteGrouped.class, (String)"spanner_write_latency_ms");
        private final Counter spannerWriteTimeouts = Metrics.counter(WriteGrouped.class, (String)"spanner_write_timeouts");
        private final Counter spannerWriteRetries = Metrics.counter(WriteGrouped.class, (String)"spanner_write_retries");
        private final TupleTag<MutationGroup> failedTag;
        private transient FluentBackoff bundleWriteBackoff;
        private transient String projectId;
        private transient ServiceCallMetric serviceCallMetric;

        WriteToSpannerFn(SpannerConfig spannerConfig, FailureMode failureMode, TupleTag<MutationGroup> failedTag) {
            this.spannerConfig = spannerConfig;
            this.failureMode = failureMode;
            this.failedTag = failedTag;
        }

        @DoFn.Setup
        public void setup() {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.spannerConfig);
            this.bundleWriteBackoff = FluentBackoff.DEFAULT.withMaxCumulativeBackoff((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).withInitialBackoff(((Duration)this.spannerConfig.getMaxCumulativeBackoff().get()).dividedBy(60L));
            this.projectId = this.spannerConfig.getProjectId() == null || this.spannerConfig.getProjectId().get() == null || ((String)this.spannerConfig.getProjectId().get()).isEmpty() ? SpannerOptions.getDefaultProjectId() : (String)this.spannerConfig.getProjectId().get();
        }

        @DoFn.Teardown
        public void teardown() {
            this.spannerAccessor.close();
        }

        @DoFn.StartBundle
        public void startBundle() {
            this.serviceCallMetric = this.createServiceCallMetric(this.projectId, (String)this.spannerConfig.getDatabaseId().get(), (String)this.spannerConfig.getInstanceId().get(), "Write");
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Iterable mutations = (Iterable)c.element();
            try {
                this.mutationGroupBatchesReceived.inc();
                this.mutationGroupsReceived.inc((long)Iterables.size((Iterable)mutations));
                Iterable batch = Iterables.concat((Iterable)mutations);
                this.writeMutations(batch);
                this.mutationGroupBatchesWriteSuccess.inc();
                this.mutationGroupsWriteSuccess.inc((long)Iterables.size((Iterable)mutations));
                return;
            }
            catch (SpannerException e) {
                this.mutationGroupBatchesWriteFail.inc();
                if (this.failureMode != FailureMode.REPORT_FAILURES) {
                    if (this.failureMode == FailureMode.FAIL_FAST) {
                        this.mutationGroupsWriteFail.inc((long)Iterables.size((Iterable)mutations));
                        throw e;
                    }
                    throw new IllegalArgumentException("Unknown failure mode " + (Object)((Object)this.failureMode));
                }
                for (MutationGroup mg : mutations) {
                    try {
                        this.spannerWriteRetries.inc();
                        this.writeMutations(mg);
                        this.mutationGroupsWriteSuccess.inc();
                    }
                    catch (SpannerException e2) {
                        this.mutationGroupsWriteFail.inc();
                        LOG.warn("Failed to write the mutation group: " + mg, (Throwable)e2);
                        c.output(this.failedTag, (Object)mg);
                    }
                }
                return;
            }
        }

        private void spannerWriteWithRetryIfSchemaChange(Iterable<Mutation> batch) throws SpannerException {
            int retry = 1;
            while (true) {
                try {
                    if (this.spannerConfig.getRpcPriority() != null && this.spannerConfig.getRpcPriority().get() != null) {
                        this.spannerAccessor.getDatabaseClient().writeAtLeastOnceWithOptions(batch, new Options.TransactionOption[]{Options.priority((Options.RpcPriority)((Options.RpcPriority)this.spannerConfig.getRpcPriority().get()))});
                    } else {
                        this.spannerAccessor.getDatabaseClient().writeAtLeastOnce(batch);
                    }
                    this.serviceCallMetric.call("ok");
                    return;
                }
                catch (AbortedException e) {
                    this.serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                    if (retry >= 5) {
                        throw e;
                    }
                    if (!e.isRetryable() && !e.getMessage().contains("Transaction aborted. Database schema probably changed during transaction, retry may succeed.")) {
                        throw e;
                    }
                }
                catch (SpannerException e) {
                    this.serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                    throw e;
                }
                ++retry;
            }
        }

        private ServiceCallMetric createServiceCallMetric(String projectId, String databaseId, String tableId, String method) {
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "Spanner");
            baseLabels.put("METHOD", method);
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)projectId, (String)databaseId, (String)tableId));
            baseLabels.put("SPANNER_PROJECT_ID", projectId);
            baseLabels.put("SPANNER_DATABASE_ID", databaseId);
            baseLabels.put("SPANNER_INSTANCE_ID", tableId);
            ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
            return serviceCallMetric;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void writeMutations(Iterable<Mutation> mutations) throws SpannerException, IOException {
            BackOff backoff = this.bundleWriteBackoff.backoff();
            long mutationsSize = Iterables.size(mutations);
            while (true) {
                Stopwatch timer = Stopwatch.createStarted();
                try {
                    this.spannerWriteWithRetryIfSchemaChange(mutations);
                    this.spannerWriteSuccess.inc();
                    return;
                }
                catch (SpannerException exception) {
                    if (exception.getErrorCode() == ErrorCode.DEADLINE_EXCEEDED) {
                        this.spannerWriteTimeouts.inc();
                        long sleepTimeMsecs = backoff.nextBackOffMillis();
                        if (sleepTimeMsecs == -1L) {
                            LOG.error("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner. Aborting after too many retries.", (Object)mutationsSize);
                            this.spannerWriteFail.inc();
                            throw exception;
                        }
                        LOG.info("DEADLINE_EXCEEDED writing batch of {} mutations to Cloud Spanner, retrying after backoff of {}ms\n({})", new Object[]{mutationsSize, sleepTimeMsecs, exception.getMessage()});
                        this.spannerWriteRetries.inc();
                        try {
                            sleeper.sleep(sleepTimeMsecs);
                        }
                        catch (InterruptedException interruptedException) {}
                        continue;
                    }
                    this.spannerWriteFail.inc();
                    throw exception;
                }
                finally {
                    this.spannerWriteLatency.update(timer.elapsed(TimeUnit.MILLISECONDS));
                    continue;
                }
                break;
            }
        }
    }

    @VisibleForTesting
    static class BatchableMutationFilterFn
    extends DoFn<MutationGroup, MutationGroup> {
        private final PCollectionView<SpannerSchema> schemaView;
        private final TupleTag<Iterable<MutationGroup>> unbatchableMutationsTag;
        private final long batchSizeBytes;
        private final long maxNumMutations;
        private final long maxNumRows;
        private final Counter batchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"batchable_mutation_groups");
        private final Counter unBatchableMutationGroupsCounter = Metrics.counter(WriteGrouped.class, (String)"unbatchable_mutation_groups");

        BatchableMutationFilterFn(PCollectionView<SpannerSchema> schemaView, TupleTag<Iterable<MutationGroup>> unbatchableMutationsTag, long batchSizeBytes, long maxNumMutations, long maxNumRows) {
            this.schemaView = schemaView;
            this.unbatchableMutationsTag = unbatchableMutationsTag;
            this.batchSizeBytes = batchSizeBytes;
            this.maxNumMutations = maxNumMutations;
            this.maxNumRows = maxNumRows;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            MutationGroup mg = (MutationGroup)c.element();
            if (mg.primary().getOperation() == Mutation.Op.DELETE && !MutationUtils.isPointDelete(mg.primary())) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
                return;
            }
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = Iterables.size((Iterable)mg);
            if (groupSize >= this.batchSizeBytes || groupCells >= this.maxNumMutations || groupRows >= this.maxNumRows) {
                c.output(this.unbatchableMutationsTag, Arrays.asList(mg));
                this.unBatchableMutationGroupsCounter.inc();
            } else {
                c.output((Object)mg);
                this.batchableMutationGroupsCounter.inc();
            }
        }
    }

    @VisibleForTesting
    static class GatherSortCreateBatchesFn
    extends DoFn<MutationGroup, Iterable<MutationGroup>> {
        private final long maxBatchSizeBytes;
        private final long maxBatchNumMutations;
        private final long maxBatchNumRows;
        private final long maxSortableSizeBytes;
        private final long maxSortableNumMutations;
        private final long maxSortableNumRows;
        private final PCollectionView<SpannerSchema> schemaView;
        private final ArrayList<MutationGroupContainer> mutationsToSort = new ArrayList();
        private long sortableSizeBytes = 0L;
        private long sortableNumCells = 0L;
        private long sortableNumRows = 0L;

        GatherSortCreateBatchesFn(long maxBatchSizeBytes, long maxNumMutations, long maxNumRows, long groupingFactor, PCollectionView<SpannerSchema> schemaView) {
            this.maxBatchSizeBytes = maxBatchSizeBytes;
            this.maxBatchNumMutations = maxNumMutations;
            this.maxBatchNumRows = maxNumRows;
            if (groupingFactor <= 0L) {
                groupingFactor = 1L;
            }
            this.maxSortableSizeBytes = maxBatchSizeBytes * groupingFactor;
            this.maxSortableNumMutations = maxNumMutations * groupingFactor;
            this.maxSortableNumRows = maxNumRows * groupingFactor;
            this.schemaView = schemaView;
            this.initSorter();
        }

        private synchronized void initSorter() {
            this.mutationsToSort.clear();
            this.sortableSizeBytes = 0L;
            this.sortableNumCells = 0L;
            this.sortableNumRows = 0L;
        }

        @DoFn.FinishBundle
        public synchronized void finishBundle(DoFn.FinishBundleContext c) throws Exception {
            this.sortAndOutputBatches(new OutputReceiverForFinishBundle(c));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void sortAndOutputBatches(DoFn.OutputReceiver<Iterable<MutationGroup>> out) throws IOException {
            try {
                if (this.mutationsToSort.isEmpty()) {
                    return;
                }
                if (this.maxSortableNumMutations == this.maxBatchNumMutations) {
                    this.outputBatch(out, 0, this.mutationsToSort.size());
                    return;
                }
                this.mutationsToSort.sort(Comparator.naturalOrder());
                int batchStart = 0;
                int batchEnd = 0;
                long batchSizeBytes = 0L;
                long batchCells = 0L;
                long batchRows = 0L;
                while (batchEnd < this.mutationsToSort.size()) {
                    MutationGroupContainer mg = this.mutationsToSort.get(batchEnd);
                    if (batchCells + mg.numCells > this.maxBatchNumMutations || batchSizeBytes + mg.sizeBytes > this.maxBatchSizeBytes || batchRows + mg.numRows > this.maxBatchNumRows) {
                        this.outputBatch(out, batchStart, batchEnd);
                        batchStart = batchEnd;
                        batchSizeBytes = 0L;
                        batchCells = 0L;
                        batchRows = 0L;
                    }
                    ++batchEnd;
                    batchSizeBytes += mg.sizeBytes;
                    batchCells += mg.numCells;
                    batchRows += mg.numRows;
                }
                if (batchStart < batchEnd) {
                    this.outputBatch(out, batchStart, this.mutationsToSort.size());
                }
            }
            finally {
                this.initSorter();
            }
        }

        private void outputBatch(DoFn.OutputReceiver<Iterable<MutationGroup>> out, int batchStart, int batchEnd) {
            out.output((Object)this.mutationsToSort.subList(batchStart, batchEnd).stream().map(o -> o.mutationGroup).collect(Collectors.toList()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @DoFn.ProcessElement
        public synchronized void processElement(DoFn.ProcessContext c, DoFn.OutputReceiver<Iterable<MutationGroup>> out) throws Exception {
            SpannerSchema spannerSchema = (SpannerSchema)c.sideInput(this.schemaView);
            MutationKeyEncoder encoder = new MutationKeyEncoder(spannerSchema);
            MutationGroup mg = (MutationGroup)c.element();
            long groupSize = MutationSizeEstimator.sizeOf(mg);
            long groupCells = MutationCellCounter.countOf(spannerSchema, mg);
            long groupRows = mg.size();
            GatherSortCreateBatchesFn gatherSortCreateBatchesFn = this;
            synchronized (gatherSortCreateBatchesFn) {
                if (this.sortableNumCells + groupCells > this.maxSortableNumMutations || this.sortableSizeBytes + groupSize > this.maxSortableSizeBytes || this.sortableNumRows + groupRows > this.maxSortableNumRows) {
                    this.sortAndOutputBatches(out);
                }
                this.mutationsToSort.add(new MutationGroupContainer(mg, groupSize, groupCells, groupRows, encoder.encodeTableNameAndKey(mg.primary())));
                this.sortableSizeBytes += groupSize;
                this.sortableNumCells += groupCells;
                this.sortableNumRows += groupRows;
            }
        }

        private static class OutputReceiverForFinishBundle
        implements DoFn.OutputReceiver<Iterable<MutationGroup>> {
            private final DoFn.FinishBundleContext c;

            OutputReceiverForFinishBundle(DoFn.FinishBundleContext c) {
                this.c = c;
            }

            public void output(Iterable<MutationGroup> output) {
                this.outputWithTimestamp(output, Instant.now());
            }

            public void outputWithTimestamp(Iterable<MutationGroup> output, Instant timestamp) {
                this.c.output(output, timestamp, (BoundedWindow)GlobalWindow.INSTANCE);
            }
        }

        private static final class MutationGroupContainer
        implements Comparable<MutationGroupContainer> {
            final MutationGroup mutationGroup;
            final long sizeBytes;
            final long numCells;
            final long numRows;
            final byte[] encodedKey;

            MutationGroupContainer(MutationGroup mutationGroup, long sizeBytes, long numCells, long numRows, byte[] encodedKey) {
                this.mutationGroup = mutationGroup;
                this.sizeBytes = sizeBytes;
                this.numCells = numCells;
                this.numRows = numRows;
                this.encodedKey = encodedKey;
            }

            @Override
            public int compareTo(MutationGroupContainer o) {
                return UnsignedBytes.lexicographicalComparator().compare(this.encodedKey, o.encodedKey);
            }
        }
    }

    private static class ToMutationGroupFn
    extends DoFn<Mutation, MutationGroup> {
        private ToMutationGroupFn() {
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) {
            Mutation value = (Mutation)c.element();
            c.output((Object)MutationGroup.create(value, new Mutation[0]));
        }
    }

    public static interface SpannerChangeStreamOptions
    extends StreamingOptions {
        public String getMetadataTable();

        public void setMetadataTable(String var1);
    }

    @AutoValue
    public static abstract class ReadChangeStream
    extends PTransform<PBegin, PCollection<DataChangeRecord>> {
        abstract SpannerConfig getSpannerConfig();

        abstract String getChangeStreamName();

        abstract @Nullable String getMetadataInstance();

        abstract @Nullable String getMetadataDatabase();

        abstract @Nullable String getMetadataTable();

        abstract Timestamp getInclusiveStartAt();

        abstract @Nullable Timestamp getInclusiveEndAt();

        abstract // Could not load outer class - annotation placement on inner may be incorrect
        @Nullable Options.RpcPriority getRpcPriority();

        @Deprecated
        abstract @Nullable Double getTraceSampleProbability();

        abstract Builder toBuilder();

        public ReadChangeStream withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public ReadChangeStream withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public ReadChangeStream withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public ReadChangeStream withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public ReadChangeStream withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public ReadChangeStream withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public ReadChangeStream withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public ReadChangeStream withChangeStreamName(String changeStreamName) {
            return this.toBuilder().setChangeStreamName(changeStreamName).build();
        }

        public ReadChangeStream withMetadataInstance(String metadataInstance) {
            return this.toBuilder().setMetadataInstance(metadataInstance).build();
        }

        public ReadChangeStream withMetadataDatabase(String metadataDatabase) {
            return this.toBuilder().setMetadataDatabase(metadataDatabase).build();
        }

        public ReadChangeStream withMetadataTable(String metadataTable) {
            return this.toBuilder().setMetadataTable(metadataTable).build();
        }

        public ReadChangeStream withInclusiveStartAt(Timestamp timestamp) {
            return this.toBuilder().setInclusiveStartAt(timestamp).build();
        }

        public ReadChangeStream withInclusiveEndAt(Timestamp timestamp) {
            return this.toBuilder().setInclusiveEndAt(timestamp).build();
        }

        public ReadChangeStream withRpcPriority(Options.RpcPriority rpcPriority) {
            return this.toBuilder().setRpcPriority(rpcPriority).build();
        }

        @Deprecated
        public ReadChangeStream withTraceSampleProbability(Double probability) {
            return this.toBuilder().setTraceSampleProbability(probability).build();
        }

        public PCollection<DataChangeRecord> expand(PBegin input) {
            Preconditions.checkArgument((this.getSpannerConfig() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the spanner config to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getProjectId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the project ID to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getInstanceId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the instance ID to be set.");
            Preconditions.checkArgument((this.getSpannerConfig().getDatabaseId() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the database ID to be set.");
            Preconditions.checkArgument((this.getChangeStreamName() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the name of the change stream to be set.");
            Preconditions.checkArgument((this.getInclusiveStartAt() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the start time to be set.");
            Preconditions.checkArgument((this.getInclusiveEndAt() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the end time to be set. If you'd like to process the stream without an end time, you can omit this parameter.");
            if (this.getMetadataInstance() != null) {
                Preconditions.checkArgument((this.getMetadataDatabase() != null ? 1 : 0) != 0, (Object)"SpannerIO.readChangeStream() requires the metadata database to be set if metadata instance is set.");
            }
            if (this.getInclusiveEndAt() != null && this.getInclusiveStartAt().toSqlTimestamp().after(this.getInclusiveEndAt().toSqlTimestamp())) {
                throw new IllegalArgumentException("Start time cannot be after end time.");
            }
            DatabaseId changeStreamDatabaseId = DatabaseId.of((String)((String)this.getSpannerConfig().getProjectId().get()), (String)((String)this.getSpannerConfig().getInstanceId().get()), (String)((String)this.getSpannerConfig().getDatabaseId().get()));
            String partitionMetadataInstanceId = (String)MoreObjects.firstNonNull((Object)this.getMetadataInstance(), (Object)changeStreamDatabaseId.getInstanceId().getInstance());
            String partitionMetadataDatabaseId = (String)MoreObjects.firstNonNull((Object)this.getMetadataDatabase(), (Object)changeStreamDatabaseId.getDatabase());
            String partitionMetadataTableName = (String)MoreObjects.firstNonNull((Object)this.getMetadataTable(), (Object)NameGenerator.generatePartitionMetadataTableName(partitionMetadataDatabaseId));
            SpannerConfig changeStreamSpannerConfig = this.getSpannerConfig();
            if (changeStreamSpannerConfig.getRetryableCodes() == null) {
                ImmutableSet defaultRetryableCodes = ImmutableSet.of((Object)StatusCode.Code.UNAVAILABLE, (Object)StatusCode.Code.ABORTED);
                changeStreamSpannerConfig = changeStreamSpannerConfig.toBuilder().setRetryableCodes((ImmutableSet<StatusCode.Code>)defaultRetryableCodes).build();
            }
            if (changeStreamSpannerConfig.getExecuteStreamingSqlRetrySettings() == null) {
                changeStreamSpannerConfig = changeStreamSpannerConfig.toBuilder().setExecuteStreamingSqlRetrySettings(RetrySettings.newBuilder().setTotalTimeout(org.threeten.bp.Duration.ofMinutes((long)5L)).setInitialRpcTimeout(org.threeten.bp.Duration.ofMinutes((long)1L)).setMaxRpcTimeout(org.threeten.bp.Duration.ofMinutes((long)1L)).build()).build();
            }
            SpannerConfig partitionMetadataSpannerConfig = changeStreamSpannerConfig.toBuilder().setInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)partitionMetadataInstanceId)).setDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)partitionMetadataDatabaseId)).build();
            String changeStreamName = this.getChangeStreamName();
            Timestamp startTimestamp = this.getInclusiveStartAt();
            Timestamp endTimestamp = this.getInclusiveEndAt().compareTo(ChangeStreamsConstants.MAX_INCLUSIVE_END_AT) > 0 ? ChangeStreamsConstants.MAX_INCLUSIVE_END_AT : this.getInclusiveEndAt();
            MapperFactory mapperFactory = new MapperFactory();
            ChangeStreamMetrics metrics = new ChangeStreamMetrics();
            ThroughputEstimator throughputEstimator = new ThroughputEstimator();
            Options.RpcPriority rpcPriority = (Options.RpcPriority)MoreObjects.firstNonNull((Object)this.getRpcPriority(), (Object)Options.RpcPriority.HIGH);
            DaoFactory daoFactory = new DaoFactory(changeStreamSpannerConfig, changeStreamName, partitionMetadataSpannerConfig, partitionMetadataTableName, rpcPriority, input.getPipeline().getOptions().getJobName());
            ActionFactory actionFactory = new ActionFactory();
            InitializeDoFn initializeDoFn = new InitializeDoFn(daoFactory, mapperFactory, startTimestamp, endTimestamp);
            DetectNewPartitionsDoFn detectNewPartitionsDoFn = new DetectNewPartitionsDoFn(daoFactory, mapperFactory, actionFactory, metrics);
            ReadChangeStreamPartitionDoFn readChangeStreamPartitionDoFn = new ReadChangeStreamPartitionDoFn(daoFactory, mapperFactory, actionFactory, metrics, throughputEstimator);
            PostProcessingMetricsDoFn postProcessingMetricsDoFn = new PostProcessingMetricsDoFn(metrics);
            LOG.info("Partition metadata table that will be used is " + partitionMetadataTableName);
            ((SpannerChangeStreamOptions)input.getPipeline().getOptions().as(SpannerChangeStreamOptions.class)).setMetadataTable(partitionMetadataTableName);
            PCollection impulseOut = (PCollection)input.apply((PTransform)Impulse.create());
            PCollection results = (PCollection)((PCollection)((PCollection)((PCollection)impulseOut.apply("Initialize the connector", (PTransform)ParDo.of((DoFn)initializeDoFn))).apply("Detect new partitions", (PTransform)ParDo.of((DoFn)detectNewPartitionsDoFn))).apply("Read change stream partition", (PTransform)ParDo.of((DoFn)readChangeStreamPartitionDoFn))).apply("Gather metrics", (PTransform)ParDo.of((DoFn)postProcessingMetricsDoFn));
            ((PCollection)((PCollection)impulseOut.apply((PTransform)WithTimestamps.of((SerializableFunction & Serializable)e -> GlobalWindow.INSTANCE.maxTimestamp()))).apply((PTransform)Wait.on((PCollection[])new PCollection[]{results}))).apply((PTransform)ParDo.of((DoFn)new CleanUpReadChangeStreamDoFn(daoFactory)));
            return results;
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setChangeStreamName(String var1);

            abstract Builder setMetadataInstance(String var1);

            abstract Builder setMetadataDatabase(String var1);

            abstract Builder setMetadataTable(String var1);

            abstract Builder setInclusiveStartAt(Timestamp var1);

            abstract Builder setInclusiveEndAt(Timestamp var1);

            abstract Builder setRpcPriority(Options.RpcPriority var1);

            abstract Builder setTraceSampleProbability(Double var1);

            abstract ReadChangeStream build();
        }
    }

    public static class WriteGrouped
    extends PTransform<PCollection<MutationGroup>, SpannerWriteResult> {
        private final Write spec;
        private static final TupleTag<MutationGroup> BATCHABLE_MUTATIONS_TAG = new TupleTag<MutationGroup>("batchableMutations"){};
        private static final TupleTag<Iterable<MutationGroup>> UNBATCHABLE_MUTATIONS_TAG = new TupleTag<Iterable<MutationGroup>>("unbatchableMutations"){};
        private static final TupleTag<Void> MAIN_OUT_TAG = new TupleTag<Void>("mainOut"){};
        private static final TupleTag<MutationGroup> FAILED_MUTATIONS_TAG = new TupleTag<MutationGroup>("failedMutations"){};
        private static final SerializableCoder<MutationGroup> CODER = SerializableCoder.of(MutationGroup.class);

        public WriteGrouped(Write spec) {
            this.spec = spec;
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.spec.populateDisplayDataWithParamaters(builder);
        }

        public SpannerWriteResult expand(PCollection<MutationGroup> input) {
            PCollection batches;
            PCollectionView dialectView = this.spec.getDialectView();
            if (dialectView == null) {
                dialectView = (PCollectionView)((PCollection)input.getPipeline().apply("CreateSingleton", (PTransform)Create.of((Object)Dialect.GOOGLE_STANDARD_SQL, (Object[])new Dialect[0]))).apply("As PCollectionView", (PTransform)View.asSingleton());
            }
            if (this.spec.getBatchSizeBytes() <= 1L || this.spec.getMaxNumMutations() <= 1L || this.spec.getMaxNumRows() <= 1L) {
                LOG.info("Batching of mutationGroups is disabled");
                TypeDescriptor<Iterable<MutationGroup>> descriptor = new TypeDescriptor<Iterable<MutationGroup>>(){};
                batches = (PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)descriptor).via(ImmutableList::of));
            } else {
                PCollection schemaSeed = (PCollection)input.getPipeline().apply("Create Seed", (PTransform)Create.of((Object)null, (Object[])new Void[0]));
                if (this.spec.getSchemaReadySignal() != null) {
                    schemaSeed = (PCollection)schemaSeed.apply("Wait for schema", (PTransform)Wait.on((PCollection[])new PCollection[]{this.spec.getSchemaReadySignal()}));
                }
                PCollectionView schemaView = (PCollectionView)((PCollection)schemaSeed.apply("Read information schema", (PTransform)ParDo.of((DoFn)new ReadSpannerSchema(this.spec.getSpannerConfig(), (PCollectionView<Dialect>)dialectView)).withSideInputs(new PCollectionView[]{dialectView}))).apply("Schema View", (PTransform)View.asSingleton());
                PCollectionTuple filteredMutations = (PCollectionTuple)((PCollection)input.apply("RewindowIntoGlobal", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)DefaultTrigger.of()).discardingFiredPanes())).apply("Filter Unbatchable Mutations", (PTransform)ParDo.of((DoFn)new BatchableMutationFilterFn((PCollectionView<SpannerSchema>)schemaView, UNBATCHABLE_MUTATIONS_TAG, this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows())).withSideInputs(new PCollectionView[]{schemaView}).withOutputTags(BATCHABLE_MUTATIONS_TAG, TupleTagList.of(UNBATCHABLE_MUTATIONS_TAG)));
                PCollection batchedMutations = (PCollection)filteredMutations.get(BATCHABLE_MUTATIONS_TAG).apply("Gather Sort And Create Batches", (PTransform)ParDo.of((DoFn)new GatherSortCreateBatchesFn(this.spec.getBatchSizeBytes(), this.spec.getMaxNumMutations(), this.spec.getMaxNumRows(), this.spec.getGroupingFactor().orElse(input.isBounded() == PCollection.IsBounded.BOUNDED ? 1000 : 1), (PCollectionView<SpannerSchema>)schemaView)).withSideInputs(new PCollectionView[]{schemaView}));
                batches = (PCollection)PCollectionList.of((PCollection)filteredMutations.get(UNBATCHABLE_MUTATIONS_TAG)).and(batchedMutations).apply("Merge", (PTransform)Flatten.pCollections());
            }
            PCollectionTuple result = (PCollectionTuple)batches.apply("Write batches to Spanner", (PTransform)ParDo.of((DoFn)new WriteToSpannerFn(this.spec.getSpannerConfig(), this.spec.getFailureMode(), FAILED_MUTATIONS_TAG)).withOutputTags(MAIN_OUT_TAG, TupleTagList.of(FAILED_MUTATIONS_TAG)));
            return new SpannerWriteResult(input.getPipeline(), (PCollection<Void>)result.get(MAIN_OUT_TAG), (PCollection<MutationGroup>)result.get(FAILED_MUTATIONS_TAG), FAILED_MUTATIONS_TAG);
        }

        @VisibleForTesting
        static MutationGroup decode(byte[] bytes) {
            ByteArrayInputStream bis = new ByteArrayInputStream(bytes);
            try {
                return (MutationGroup)CODER.decode((InputStream)bis);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }

        @VisibleForTesting
        static byte[] encode(MutationGroup g) {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                CODER.encode((Serializable)g, (OutputStream)bos);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return bos.toByteArray();
        }
    }

    static class WriteRows
    extends PTransform<PCollection<Row>, PDone> {
        private final Write write;
        private final Mutation.Op operation;
        private final String table;

        private WriteRows(Write write, Mutation.Op operation, String table) {
            this.write = write;
            this.operation = operation;
            this.table = table;
        }

        public static WriteRows of(Write write, Mutation.Op operation, String table) {
            return new WriteRows(write, operation, table);
        }

        public PDone expand(PCollection<Row> input) {
            ((PCollection)input.apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Mutation.class)).via(MutationUtils.beamRowToMutationFn(this.operation, this.table)))).apply((PTransform)this.write);
            return PDone.in((Pipeline)input.getPipeline());
        }
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Mutation>, SpannerWriteResult> {
        abstract SpannerConfig getSpannerConfig();

        abstract long getBatchSizeBytes();

        abstract long getMaxNumMutations();

        abstract long getMaxNumRows();

        abstract FailureMode getFailureMode();

        abstract @Nullable PCollection<?> getSchemaReadySignal();

        abstract OptionalInt getGroupingFactor();

        abstract @Nullable PCollectionView<Dialect> getDialectView();

        abstract Builder toBuilder();

        public Write withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Write withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Write withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Write withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Write withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Write withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Write withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Write withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Write withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public Write withEmulatorHost(ValueProvider<String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public Write withEmulatorHost(String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public Write withDialectView(PCollectionView<Dialect> dialect) {
            return this.toBuilder().setDialectView(dialect).build();
        }

        public Write withCommitDeadline(Duration commitDeadline) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withCommitDeadline(commitDeadline));
        }

        public Write withMaxCumulativeBackoff(Duration maxCumulativeBackoff) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withMaxCumulativeBackoff(maxCumulativeBackoff));
        }

        @VisibleForTesting
        Write withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public WriteGrouped grouped() {
            return new WriteGrouped(this);
        }

        public Write withBatchSizeBytes(long batchSizeBytes) {
            return this.toBuilder().setBatchSizeBytes(batchSizeBytes).build();
        }

        public Write withFailureMode(FailureMode failureMode) {
            return this.toBuilder().setFailureMode(failureMode).build();
        }

        public Write withMaxNumMutations(long maxNumMutations) {
            return this.toBuilder().setMaxNumMutations(maxNumMutations).build();
        }

        public Write withMaxNumRows(long maxNumRows) {
            return this.toBuilder().setMaxNumRows(maxNumRows).build();
        }

        public Write withSchemaReadySignal(PCollection<?> signal) {
            return this.toBuilder().setSchemaReadySignal(signal).build();
        }

        public Write withGroupingFactor(int groupingFactor) {
            return this.toBuilder().setGroupingFactor(groupingFactor).build();
        }

        public Write withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public Write withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        public SpannerWriteResult expand(PCollection<Mutation> input) {
            this.getSpannerConfig().validate();
            return (SpannerWriteResult)((PCollection)input.apply("To mutation group", (PTransform)ParDo.of((DoFn)new ToMutationGroupFn()))).apply("Write mutations to Cloud Spanner", (PTransform)new WriteGrouped(this));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            this.populateDisplayDataWithParamaters(builder);
        }

        private void populateDisplayDataWithParamaters(DisplayData.Builder builder) {
            this.getSpannerConfig().populateDisplayData(builder);
            builder.add(DisplayData.item((String)"batchSizeBytes", (Long)this.getBatchSizeBytes()).withLabel("Max batch size in bytes"));
            builder.add(DisplayData.item((String)"maxNumMutations", (Long)this.getMaxNumMutations()).withLabel("Max number of mutated cells in each batch"));
            builder.add(DisplayData.item((String)"maxNumRows", (Long)this.getMaxNumRows()).withLabel("Max number of rows in each batch"));
            builder.add(DisplayData.item((String)"groupingFactor", (String)(this.getGroupingFactor().isPresent() ? Integer.toString(this.getGroupingFactor().getAsInt()) : "DEFAULT")).withLabel("Number of batches to sort over"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setBatchSizeBytes(long var1);

            abstract Builder setMaxNumMutations(long var1);

            abstract Builder setMaxNumRows(long var1);

            abstract Builder setFailureMode(FailureMode var1);

            abstract Builder setSchemaReadySignal(PCollection<?> var1);

            abstract Builder setGroupingFactor(int var1);

            abstract Builder setDialectView(PCollectionView<Dialect> var1);

            abstract Write build();
        }
    }

    public static enum FailureMode {
        FAIL_FAST,
        REPORT_FAILURES;

    }

    @AutoValue
    public static abstract class CreateTransaction
    extends PTransform<PInput, PCollectionView<Transaction>> {
        abstract SpannerConfig getSpannerConfig();

        abstract @Nullable TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public PCollectionView<Transaction> expand(PInput input) {
            this.getSpannerConfig().validate();
            PCollection collection = (PCollection)input.getPipeline().apply((PTransform)Create.of((Object)1, (Object[])new Integer[0]));
            if (input instanceof PCollection) {
                collection = (PCollection)collection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{(PCollection)input}));
            } else if (!(input instanceof PBegin)) {
                throw new RuntimeException("input must be PBegin or PCollection");
            }
            return (PCollectionView)((PCollection)collection.apply("Create transaction", (PTransform)ParDo.of((DoFn)new CreateTransactionFn(this.getSpannerConfig(), this.getTimestampBound())))).apply("As PCollectionView", (PTransform)View.asSingleton());
        }

        public CreateTransaction withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public CreateTransaction withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public CreateTransaction withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public CreateTransaction withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public CreateTransaction withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public CreateTransaction withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public CreateTransaction withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public CreateTransaction withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public CreateTransaction withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public CreateTransaction withEmulatorHost(ValueProvider<String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public CreateTransaction withEmulatorHost(String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        @VisibleForTesting
        CreateTransaction withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public CreateTransaction withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            public abstract Builder setSpannerConfig(SpannerConfig var1);

            public abstract Builder setTimestampBound(TimestampBound var1);

            public abstract CreateTransaction build();
        }
    }

    static class ReadRows
    extends PTransform<PBegin, PCollection<Row>> {
        Read read;
        Schema schema;

        public ReadRows(Read read, Schema schema) {
            super("Read rows");
            this.read = read;
            this.schema = schema;
        }

        public PCollection<Row> expand(PBegin input) {
            return ((PCollection)((PCollection)input.apply((PTransform)this.read)).apply((PTransform)MapElements.into((TypeDescriptor)TypeDescriptor.of(Row.class)).via((SerializableFunction & Serializable)struct -> StructUtils.structToBeamRow(struct, this.schema)))).setRowSchema(this.schema);
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        abstract ReadOperation getReadOperation();

        abstract @Nullable TimestampBound getTimestampBound();

        abstract @Nullable PCollectionView<Transaction> getTransaction();

        abstract @Nullable PartitionOptions getPartitionOptions();

        abstract Boolean getBatching();

        abstract Builder toBuilder();

        public Read withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public Read withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public Read withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public Read withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public Read withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public Read withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public Read withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        public Read withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public Read withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public Read withEmulatorHost(ValueProvider<String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public Read withEmulatorHost(String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public Read withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        @VisibleForTesting
        Read withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public Read withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public Read withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public Read withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public Read withTable(String table) {
            return this.withReadOperation(this.getReadOperation().withTable(table));
        }

        public Read withReadOperation(ReadOperation operation) {
            return this.toBuilder().setReadOperation(operation).build();
        }

        public Read withColumns(String ... columns) {
            return this.withColumns(Arrays.asList(columns));
        }

        public Read withColumns(List<String> columns) {
            return this.withReadOperation(this.getReadOperation().withColumns(columns));
        }

        public Read withQuery(Statement statement) {
            return this.withReadOperation(this.getReadOperation().withQuery(statement));
        }

        public Read withQuery(String sql) {
            return this.withQuery(Statement.of((String)sql));
        }

        public Read withQueryName(String queryName) {
            return this.withReadOperation(this.getReadOperation().withQueryName(queryName));
        }

        public Read withKeySet(KeySet keySet) {
            return this.withReadOperation(this.getReadOperation().withKeySet(keySet));
        }

        public Read withIndex(String index) {
            return this.withReadOperation(this.getReadOperation().withIndex(index));
        }

        public Read withPartitionOptions(PartitionOptions partitionOptions) {
            return this.withReadOperation(this.getReadOperation().withPartitionOptions(partitionOptions));
        }

        public Read withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public Read withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        public PCollection<Struct> expand(PBegin input) {
            this.getSpannerConfig().validate();
            Preconditions.checkArgument((this.getTimestampBound() != null ? 1 : 0) != 0, (Object)"SpannerIO.read() runs in a read only transaction and requires timestamp to be set with withTimestampBound or withTimestamp method");
            if (this.getReadOperation().getQuery() == null) {
                if (this.getReadOperation().getTable() != null) {
                    Preconditions.checkNotNull(this.getReadOperation().getColumns(), (Object)"For a read operation SpannerIO.read() requires a list of columns to set with withColumns method");
                    Preconditions.checkArgument((!this.getReadOperation().getColumns().isEmpty() ? 1 : 0) != 0, (Object)"For a read operation SpannerIO.read() requires a non-empty list of columns to set with withColumns method");
                } else {
                    throw new IllegalArgumentException("SpannerIO.read() requires configuring query or read operation.");
                }
            }
            ReadAll readAll = SpannerIO.readAll().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound()).withBatching(this.getBatching()).withTransaction(this.getTransaction());
            return (PCollection)((PCollection)input.apply((PTransform)Create.of((Object)this.getReadOperation(), (Object[])new ReadOperation[0]))).apply("Execute query", (PTransform)readAll);
        }

        SerializableFunction<Struct, Row> getFormatFn() {
            return (SerializableFunction & Serializable)input -> Row.withSchema((Schema)Schema.builder().addInt64Field("Key").build()).withFieldValue("Key", (Object)3L).build();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setReadOperation(ReadOperation var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setPartitionOptions(PartitionOptions var1);

            abstract Builder setBatching(Boolean var1);

            abstract Read build();
        }
    }

    @AutoValue
    public static abstract class ReadAll
    extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
        abstract SpannerConfig getSpannerConfig();

        abstract @Nullable PCollectionView<Transaction> getTransaction();

        abstract @Nullable TimestampBound getTimestampBound();

        abstract Builder toBuilder();

        public ReadAll withSpannerConfig(SpannerConfig spannerConfig) {
            return this.toBuilder().setSpannerConfig(spannerConfig).build();
        }

        public ReadAll withProjectId(String projectId) {
            return this.withProjectId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)projectId));
        }

        public ReadAll withProjectId(ValueProvider<String> projectId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withProjectId(projectId));
        }

        public ReadAll withInstanceId(String instanceId) {
            return this.withInstanceId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)instanceId));
        }

        public ReadAll withInstanceId(ValueProvider<String> instanceId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withInstanceId(instanceId));
        }

        public ReadAll withDatabaseId(String databaseId) {
            return this.withDatabaseId((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)databaseId));
        }

        public ReadAll withHost(ValueProvider<String> host) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withHost(host));
        }

        public ReadAll withHost(String host) {
            return this.withHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)host));
        }

        public ReadAll withEmulatorHost(ValueProvider<String> emulatorHost) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withEmulatorHost(emulatorHost));
        }

        public ReadAll withEmulatorHost(String emulatorHost) {
            return this.withEmulatorHost((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)emulatorHost));
        }

        public ReadAll withDatabaseId(ValueProvider<String> databaseId) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withDatabaseId(databaseId));
        }

        @VisibleForTesting
        ReadAll withServiceFactory(ServiceFactory<Spanner, SpannerOptions> serviceFactory) {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withServiceFactory(serviceFactory));
        }

        public ReadAll withTransaction(PCollectionView<Transaction> transaction) {
            return this.toBuilder().setTransaction(transaction).build();
        }

        public ReadAll withTimestamp(Timestamp timestamp) {
            return this.withTimestampBound(TimestampBound.ofReadTimestamp((Timestamp)timestamp));
        }

        public ReadAll withTimestampBound(TimestampBound timestampBound) {
            return this.toBuilder().setTimestampBound(timestampBound).build();
        }

        public ReadAll withBatching(boolean batching) {
            return this.toBuilder().setBatching(batching).build();
        }

        public ReadAll withLowPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.LOW));
        }

        public ReadAll withHighPriority() {
            SpannerConfig config = this.getSpannerConfig();
            return this.withSpannerConfig(config.withRpcPriority(Options.RpcPriority.HIGH));
        }

        abstract Boolean getBatching();

        public PCollection<Struct> expand(PCollection<ReadOperation> input) {
            PTransform readTransform = this.getBatching() != false ? BatchSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound()) : NaiveSpannerRead.create(this.getSpannerConfig(), this.getTransaction(), this.getTimestampBound());
            return (PCollection)((PCollection)input.apply("Reshuffle", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Cloud Spanner", readTransform);
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSpannerConfig(SpannerConfig var1);

            abstract Builder setTransaction(PCollectionView<Transaction> var1);

            abstract Builder setTimestampBound(TimestampBound var1);

            abstract Builder setBatching(Boolean var1);

            abstract ReadAll build();
        }
    }
}

