/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner;

import com.google.auto.value.AutoValue;
import com.google.cloud.spanner.BatchReadOnlyTransaction;
import com.google.cloud.spanner.Options;
import com.google.cloud.spanner.Partition;
import com.google.cloud.spanner.ResultSet;
import com.google.cloud.spanner.SpannerException;
import com.google.cloud.spanner.SpannerOptions;
import com.google.cloud.spanner.Struct;
import com.google.cloud.spanner.TimestampBound;
import java.util.HashMap;
import java.util.List;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.gcp.spanner.AutoValue_BatchSpannerRead;
import org.apache.beam.sdk.io.gcp.spanner.ReadOperation;
import org.apache.beam.sdk.io.gcp.spanner.SpannerAccessor;
import org.apache.beam.sdk.io.gcp.spanner.SpannerConfig;
import org.apache.beam.sdk.io.gcp.spanner.SpannerIO;
import org.apache.beam.sdk.io.gcp.spanner.Transaction;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
abstract class BatchSpannerRead
extends PTransform<PCollection<ReadOperation>, PCollection<Struct>> {
    BatchSpannerRead() {
    }

    public static BatchSpannerRead create(SpannerConfig spannerConfig, PCollectionView<Transaction> txView, TimestampBound timestampBound) {
        return new AutoValue_BatchSpannerRead(spannerConfig, txView, timestampBound);
    }

    abstract SpannerConfig getSpannerConfig();

    abstract @Nullable PCollectionView<Transaction> getTxView();

    abstract TimestampBound getTimestampBound();

    public PCollection<Struct> expand(PCollection<ReadOperation> input) {
        PCollectionView txView = this.getTxView();
        if (txView == null) {
            Pipeline begin = input.getPipeline();
            SpannerIO.CreateTransaction createTx = SpannerIO.createTransaction().withSpannerConfig(this.getSpannerConfig()).withTimestampBound(this.getTimestampBound());
            txView = (PCollectionView)begin.apply((PTransform)createTx);
        }
        return (PCollection)((PCollection)((PCollection)input.apply("Generate Partitions", (PTransform)ParDo.of((DoFn)new GeneratePartitionsFn(this.getSpannerConfig(), txView)).withSideInputs(new PCollectionView[]{txView}))).apply("Shuffle partitions", (PTransform)Reshuffle.viaRandomKey())).apply("Read from Partitions", (PTransform)ParDo.of((DoFn)new ReadFromPartitionFn(this.getSpannerConfig(), (PCollectionView<? extends Transaction>)txView)).withSideInputs(new PCollectionView[]{txView}));
    }

    private static class ReadFromPartitionFn
    extends DoFn<Partition, Struct> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;
        private transient String projectId;
        private transient ServiceCallMetric serviceCallMetric;

        public ReadFromPartitionFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
            this.projectId = this.config.getProjectId() == null || this.config.getProjectId().get() == null || ((String)this.config.getProjectId().get()).isEmpty() ? SpannerOptions.getDefaultProjectId() : (String)this.config.getProjectId().get();
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.StartBundle
        public void startBundle() throws Exception {
            this.serviceCallMetric = this.createServiceCallMetric(this.projectId, (String)this.config.getDatabaseId().get(), (String)this.config.getInstanceId().get());
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction batchTx = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            Partition p = (Partition)c.element();
            try (ResultSet resultSet = batchTx.execute(p);){
                while (resultSet.next()) {
                    Struct s = resultSet.getCurrentRowAsStruct();
                    c.output((Object)s);
                }
            }
            catch (SpannerException e) {
                this.serviceCallMetric.call(e.getErrorCode().getGrpcStatusCode().toString());
                throw e;
            }
            this.serviceCallMetric.call("ok");
        }

        private ServiceCallMetric createServiceCallMetric(String projectId, String databaseId, String tableId) {
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "Spanner");
            baseLabels.put("METHOD", "Read");
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.spannerTable((String)projectId, (String)databaseId, (String)tableId));
            baseLabels.put("SPANNER_PROJECT_ID", projectId);
            baseLabels.put("SPANNER_DATABASE_ID", databaseId);
            baseLabels.put("SPANNER_INSTANCE_ID", tableId);
            ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
            return serviceCallMetric;
        }
    }

    @VisibleForTesting
    static class GeneratePartitionsFn
    extends DoFn<ReadOperation, Partition> {
        private final SpannerConfig config;
        private final PCollectionView<? extends Transaction> txView;
        private transient SpannerAccessor spannerAccessor;

        public GeneratePartitionsFn(SpannerConfig config, PCollectionView<? extends Transaction> txView) {
            this.config = config;
            this.txView = txView;
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.spannerAccessor = SpannerAccessor.getOrCreate(this.config);
        }

        @DoFn.Teardown
        public void teardown() throws Exception {
            this.spannerAccessor.close();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext c) throws Exception {
            Transaction tx = (Transaction)c.sideInput(this.txView);
            BatchReadOnlyTransaction context = this.spannerAccessor.getBatchClient().batchReadOnlyTransaction(tx.transactionId());
            for (Partition p : this.execute((ReadOperation)c.element(), context)) {
                c.output((Object)p);
            }
        }

        private List<Partition> execute(ReadOperation op, BatchReadOnlyTransaction tx) {
            if (this.config.getRpcPriority() != null && this.config.getRpcPriority().get() != null) {
                return this.executeWithPriority(op, tx, (Options.RpcPriority)this.config.getRpcPriority().get());
            }
            return this.executeWithoutPriority(op, tx);
        }

        private List<Partition> executeWithoutPriority(ReadOperation op, BatchReadOnlyTransaction tx) {
            if (op.getQuery() != null) {
                return tx.partitionQuery(op.getPartitionOptions(), op.getQuery(), new Options.QueryOption[0]);
            }
            if (op.getIndex() != null) {
                return tx.partitionReadUsingIndex(op.getPartitionOptions(), op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
            }
            return tx.partitionRead(op.getPartitionOptions(), op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[0]);
        }

        private List<Partition> executeWithPriority(ReadOperation op, BatchReadOnlyTransaction tx, Options.RpcPriority rpcPriority) {
            if (op.getQuery() != null) {
                return tx.partitionQuery(op.getPartitionOptions(), op.getQuery(), new Options.QueryOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
            }
            if (op.getIndex() != null) {
                return tx.partitionReadUsingIndex(op.getPartitionOptions(), op.getTable(), op.getIndex(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
            }
            return tx.partitionRead(op.getPartitionOptions(), op.getTable(), op.getKeySet(), op.getColumns(), new Options.ReadOption[]{Options.priority((Options.RpcPriority)rpcPriority)});
        }
    }
}

