/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsub;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Map;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.pubsub.PubsubMessage;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;

public class PubsubMessageWithMessageIdCoder
extends CustomCoder<PubsubMessage> {
    private static final Coder<byte[]> PAYLOAD_CODER = ByteArrayCoder.of();
    private static final Coder<String> MESSAGE_ID_CODER = StringUtf8Coder.of();

    public static PubsubMessageWithMessageIdCoder of() {
        return new PubsubMessageWithMessageIdCoder();
    }

    public void encode(PubsubMessage value, OutputStream outStream) throws IOException {
        PAYLOAD_CODER.encode((Object)value.getPayload(), outStream);
        MESSAGE_ID_CODER.encode((Object)value.getMessageId(), outStream);
    }

    public PubsubMessage decode(InputStream inStream) throws IOException {
        byte[] payload = (byte[])PAYLOAD_CODER.decode(inStream);
        String messageId = (String)MESSAGE_ID_CODER.decode(inStream);
        return new PubsubMessage(payload, (Map<String, String>)ImmutableMap.of(), messageId);
    }
}

