/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import org.apache.beam.sdk.io.gcp.bigquery.AutoValue_StorageApiWritePayload;
import org.apache.beam.sdk.io.gcp.bigquery.BeamRowToStorageApiProto;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryServices;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryUtils;
import org.apache.beam.sdk.io.gcp.bigquery.DynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiDynamicDestinations;
import org.apache.beam.sdk.io.gcp.bigquery.StorageApiWritePayload;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.Row;

class StorageApiDynamicDestinationsBeamRow<T, DestinationT>
extends StorageApiDynamicDestinations<T, DestinationT> {
    private final Schema schema;
    private final SerializableFunction<T, Row> toRow;

    StorageApiDynamicDestinationsBeamRow(DynamicDestinations<T, DestinationT> inner, Schema schema, SerializableFunction<T, Row> toRow) {
        super(inner);
        this.schema = schema;
        this.toRow = toRow;
    }

    @Override
    public StorageApiDynamicDestinations.MessageConverter<T> getMessageConverter(DestinationT destination, BigQueryServices.DatasetService datasetService) throws Exception {
        return new StorageApiDynamicDestinations.MessageConverter<T>(){
            final Descriptors.Descriptor descriptor;
            final long descriptorHash;
            {
                this.descriptor = BeamRowToStorageApiProto.getDescriptorFromSchema(StorageApiDynamicDestinationsBeamRow.this.schema);
                this.descriptorHash = BigQueryUtils.hashSchemaDescriptorDeterministic(this.descriptor);
            }

            @Override
            public StorageApiDynamicDestinations.DescriptorWrapper getSchemaDescriptor() {
                return new StorageApiDynamicDestinations.DescriptorWrapper(this.descriptor, this.descriptorHash);
            }

            @Override
            public void refreshSchema(long expectedHash) {
            }

            @Override
            public StorageApiWritePayload toMessage(T element) {
                DynamicMessage msg = BeamRowToStorageApiProto.messageFromBeamRow(this.descriptor, (Row)StorageApiDynamicDestinationsBeamRow.this.toRow.apply(element));
                return new AutoValue_StorageApiWritePayload(msg.toByteArray(), this.descriptorHash);
            }
        };
    }
}

