/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.pubsublite.internal;

import com.google.cloud.pubsublite.Offset;
import com.google.cloud.pubsublite.proto.ComputeMessageStatsResponse;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteProgress;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.OffsetByteRange;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TopicBacklogReader;
import org.apache.beam.sdk.io.gcp.pubsublite.internal.TrackerWithProgress;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.transforms.splittabledofn.SplitResult;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Stopwatch;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

class OffsetByteRangeTracker
extends TrackerWithProgress {
    private final TopicBacklogReader unownedBacklogReader;
    private final Duration minTrackingTime;
    private final long minBytesReceived;
    private final Stopwatch stopwatch;
    private OffsetByteRange range;
    @Nullable
    private Long lastClaimed;

    public OffsetByteRangeTracker(OffsetByteRange range, TopicBacklogReader unownedBacklogReader, Stopwatch stopwatch, Duration minTrackingTime, long minBytesReceived) {
        Preconditions.checkArgument((range.getRange().getTo() == Long.MAX_VALUE ? 1 : 0) != 0, (Object)"May only construct OffsetByteRangeTracker with an unbounded range with no progress.");
        Preconditions.checkArgument((range.getByteCount() == 0L ? 1 : 0) != 0, (Object)"May only construct OffsetByteRangeTracker with an unbounded range with no progress.");
        this.unownedBacklogReader = unownedBacklogReader;
        this.minTrackingTime = minTrackingTime;
        this.minBytesReceived = minBytesReceived;
        this.stopwatch = stopwatch.reset().start();
        this.range = range;
    }

    public RestrictionTracker.IsBounded isBounded() {
        return RestrictionTracker.IsBounded.UNBOUNDED;
    }

    public boolean tryClaim(OffsetByteProgress position) {
        long toClaim = position.lastOffset().value();
        Preconditions.checkArgument((this.lastClaimed == null || toClaim > this.lastClaimed ? 1 : 0) != 0, (String)"Trying to claim offset %s while last attempted was %s", (long)position.lastOffset().value(), (Object)this.lastClaimed);
        Preconditions.checkArgument((toClaim >= this.range.getRange().getFrom() ? 1 : 0) != 0, (String)"Trying to claim offset %s before start of the range %s", (long)toClaim, (Object)this.range);
        if (this.range.getRange().getTo() != Long.MAX_VALUE) {
            boolean isRangeEmpty = this.range.getRange().getTo() == this.range.getRange().getFrom();
            boolean isValidClosedRange = this.nextOffset() == this.range.getRange().getTo();
            Preconditions.checkState((isRangeEmpty || isValidClosedRange ? 1 : 0) != 0, (Object)"Violated class precondition: offset range improperly split. Please report a beam bug.");
            return false;
        }
        this.lastClaimed = toClaim;
        this.range = OffsetByteRange.of(this.range.getRange(), this.range.getByteCount() + position.batchBytes());
        return true;
    }

    public OffsetByteRange currentRestriction() {
        return this.range;
    }

    private long nextOffset() {
        Preconditions.checkState((this.lastClaimed == null || this.lastClaimed < Long.MAX_VALUE ? 1 : 0) != 0);
        return this.lastClaimed == null ? this.currentRestriction().getRange().getFrom() : this.lastClaimed + 1L;
    }

    private boolean receivedEnough() {
        Duration duration = Duration.millis((long)this.stopwatch.elapsed(TimeUnit.MILLISECONDS));
        if (duration.isLongerThan((ReadableDuration)this.minTrackingTime)) {
            return true;
        }
        return this.currentRestriction().getByteCount() >= this.minBytesReceived;
    }

    @Nullable
    public SplitResult<OffsetByteRange> trySplit(double fractionOfRemainder) {
        if (this.range.getRange().getTo() != Long.MAX_VALUE) {
            return null;
        }
        if (!this.receivedEnough()) {
            return null;
        }
        this.range = OffsetByteRange.of(new OffsetRange(this.currentRestriction().getRange().getFrom(), this.nextOffset()), this.range.getByteCount());
        return SplitResult.of((Object)this.range, (Object)OffsetByteRange.of(new OffsetRange(this.nextOffset(), Long.MAX_VALUE), 0L));
    }

    public void checkDone() throws IllegalStateException {
        if (this.range.getRange().getFrom() == this.range.getRange().getTo()) {
            return;
        }
        Preconditions.checkState((this.lastClaimed != null ? 1 : 0) != 0, (String)"Last attempted offset should not be null. No work was claimed in non-empty range %s.", (Object)this.range);
        long lastClaimedNotNull = (Long)Preconditions.checkNotNull((Object)this.lastClaimed);
        Preconditions.checkState((lastClaimedNotNull >= this.range.getRange().getTo() - 1L ? 1 : 0) != 0, (String)"Last attempted offset was %s in range %s, claiming work in [%s, %s) was not attempted", (Object)lastClaimedNotNull, (Object)this.range, (Object)(lastClaimedNotNull + 1L), (Object)this.range.getRange().getTo());
    }

    public RestrictionTracker.Progress getProgress() {
        ComputeMessageStatsResponse stats = this.unownedBacklogReader.computeMessageStats(Offset.of((long)this.nextOffset()));
        return RestrictionTracker.Progress.from((double)this.range.getByteCount(), (double)stats.getMessageBytes());
    }
}

