/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.InstantCoder;
import org.apache.beam.sdk.coders.NullableCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.coders.TextualIntegerCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.joda.time.Instant;

public class HealthcareIOErrorCoder<T>
extends CustomCoder<HealthcareIOError<T>> {
    private final Coder<T> originalCoder;
    private static final NullableCoder<String> STRING_CODER = NullableCoder.of((Coder)StringUtf8Coder.of());
    private static final NullableCoder<Integer> INTEGER_CODER = NullableCoder.of((Coder)TextualIntegerCoder.of());
    private static final NullableCoder<Instant> INSTANT_CODER = NullableCoder.of((Coder)InstantCoder.of());

    HealthcareIOErrorCoder(Coder<T> originalCoder) {
        this.originalCoder = NullableCoder.of(originalCoder);
    }

    public static <T> HealthcareIOErrorCoder<T> of(Coder<T> originalCoder) {
        return new HealthcareIOErrorCoder<T>(originalCoder);
    }

    public void encode(HealthcareIOError<T> value, OutputStream outStream) throws IOException {
        this.originalCoder.encode(value.getDataResource(), outStream);
        STRING_CODER.encode((Object)value.getErrorMessage(), outStream);
        STRING_CODER.encode((Object)value.getStackTrace(), outStream);
        INSTANT_CODER.encode((Object)value.getObservedTime(), outStream);
        INTEGER_CODER.encode((Object)value.getStatusCode(), outStream);
    }

    public HealthcareIOError<T> decode(InputStream inStream) throws IOException {
        Object dataResource = this.originalCoder.decode(inStream);
        String errorMessage = (String)STRING_CODER.decode(inStream);
        String stackTrace = (String)STRING_CODER.decode(inStream);
        Instant observedTime = (Instant)INSTANT_CODER.decode(inStream);
        Integer statusCode = (Integer)INTEGER_CODER.decode(inStream);
        return new HealthcareIOError<Object>(dataResource, errorMessage, stackTrace, observedTime, statusCode);
    }
}

