/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import com.google.auto.value.AutoValue;
import com.google.gson.JsonArray;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.gcp.healthcare.AutoValue_FhirIOPatientEverything_PatientEverythingParameter;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOError;
import org.apache.beam.sdk.io.gcp.healthcare.HealthcareIOErrorCoder;
import org.apache.beam.sdk.io.gcp.healthcare.HttpHealthcareApiClient;
import org.apache.beam.sdk.io.gcp.healthcare.JsonArrayCoder;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.schemas.AutoValueSchema;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Throwables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FhirIOPatientEverything
extends PTransform<PCollection<PatientEverythingParameter>, Result> {
    public static final TupleTag<JsonArray> OUT = new TupleTag<JsonArray>(){};
    public static final TupleTag<HealthcareIOError<String>> DEAD_LETTER = new TupleTag<HealthcareIOError<String>>(){};

    public Result expand(PCollection<PatientEverythingParameter> input) {
        PCollectionTuple results = (PCollectionTuple)input.apply("GetPatientEverything", (PTransform)ParDo.of((DoFn)new GetPatientEverythingFn()).withOutputTags(OUT, TupleTagList.of(DEAD_LETTER)));
        return new Result(results);
    }

    static class GetPatientEverythingFn
    extends DoFn<PatientEverythingParameter, JsonArray> {
        private static final Counter GET_PATIENT_EVERYTHING_ERROR_COUNT = Metrics.counter(GetPatientEverythingFn.class, (String)"fhirio/get_patient_everything_error_count");
        private static final Counter GET_PATIENT_EVERYTHING_SUCCESS_COUNT = Metrics.counter(GetPatientEverythingFn.class, (String)"fhirio/get_patient_everything_success_count");
        private static final Distribution GET_PATIENT_EVERYTHING_LATENCY_MS = Metrics.distribution(GetPatientEverythingFn.class, (String)"fhirio/get_patient_everything_latency_ms");
        private static final Logger LOG = LoggerFactory.getLogger(GetPatientEverythingFn.class);
        private HealthcareApiClient client;

        GetPatientEverythingFn() {
        }

        @DoFn.Setup
        public void instantiateHealthcareClient() throws IOException {
            this.client = new HttpHealthcareApiClient();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            PatientEverythingParameter patientEverythingParameter = (PatientEverythingParameter)context.element();
            try {
                context.output((Object)this.getPatientEverything(patientEverythingParameter.getResourceName(), patientEverythingParameter.getFilters()));
            }
            catch (IllegalArgumentException | NoSuchElementException e) {
                GET_PATIENT_EVERYTHING_ERROR_COUNT.inc();
                LOG.warn(String.format("Error executing GetPatientEverything: FHIR resources writing to Dead Letter Queue. Cause: %s Stack Trace: %s", e.getMessage(), Throwables.getStackTraceAsString((Throwable)e)));
                context.output(DEAD_LETTER, HealthcareIOError.of(patientEverythingParameter.toString(), e));
            }
        }

        private JsonArray getPatientEverything(String resourceName, @Nullable Map<String, String> filters) {
            long start = Instant.now().toEpochMilli();
            HashMap<String, Object> filterObjects = new HashMap<String, Object>();
            if (filters != null) {
                filterObjects.putAll(filters);
            }
            HttpHealthcareApiClient.FhirResourcePagesIterator iter = HttpHealthcareApiClient.FhirResourcePagesIterator.ofPatientEverything(this.client, resourceName, filterObjects);
            JsonArray result = new JsonArray();
            while (iter.hasNext()) {
                result.addAll(iter.next());
            }
            GET_PATIENT_EVERYTHING_LATENCY_MS.update(Instant.now().toEpochMilli() - start);
            GET_PATIENT_EVERYTHING_SUCCESS_COUNT.inc();
            return result;
        }
    }

    public static class Result
    implements POutput,
    PInput {
        private final PCollection<JsonArray> patientCompartments;
        private final PCollection<HealthcareIOError<String>> failedReads;
        PCollectionTuple pct;

        static Result of(PCollectionTuple pct) throws IllegalArgumentException {
            if (pct.has(OUT) && pct.has(DEAD_LETTER)) {
                return new Result(pct);
            }
            throw new IllegalArgumentException("The PCollection tuple must have the FhirIOPatientEverything.OUT and FhirIOPatientEverything.DEAD_LETTER tuple tags");
        }

        private Result(PCollectionTuple pct) {
            this.pct = pct;
            this.patientCompartments = pct.get(OUT).setCoder((Coder)JsonArrayCoder.of());
            this.failedReads = pct.get(DEAD_LETTER).setCoder(HealthcareIOErrorCoder.of(StringUtf8Coder.of()));
        }

        public PCollection<HealthcareIOError<String>> getFailedReads() {
            return this.failedReads;
        }

        public PCollection<JsonArray> getPatientCompartments() {
            return this.patientCompartments;
        }

        public Pipeline getPipeline() {
            return this.pct.getPipeline();
        }

        public Map<TupleTag<?>, PValue> expand() {
            return ImmutableMap.of(OUT, this.patientCompartments, DEAD_LETTER, this.failedReads);
        }

        public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        }
    }

    @DefaultSchema(value=AutoValueSchema.class)
    @AutoValue
    public static abstract class PatientEverythingParameter
    implements Serializable {
        abstract String getResourceName();

        abstract @Nullable Map<String, String> getFilters();

        static Builder builder() {
            return new AutoValue_FhirIOPatientEverything_PatientEverythingParameter.Builder();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setResourceName(String var1);

            abstract Builder setFilters(Map<String, String> var1);

            abstract PatientEverythingParameter build();
        }
    }
}

