/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigtable;

import com.google.bigtable.admin.v2.GetTableRequest;
import com.google.bigtable.v2.MutateRowResponse;
import com.google.bigtable.v2.MutateRowsRequest;
import com.google.bigtable.v2.Mutation;
import com.google.bigtable.v2.ReadRowsRequest;
import com.google.bigtable.v2.Row;
import com.google.bigtable.v2.RowRange;
import com.google.bigtable.v2.RowSet;
import com.google.bigtable.v2.SampleRowKeysRequest;
import com.google.bigtable.v2.SampleRowKeysResponse;
import com.google.cloud.bigtable.config.BigtableOptions;
import com.google.cloud.bigtable.grpc.BigtableSession;
import com.google.cloud.bigtable.grpc.BigtableTableName;
import com.google.cloud.bigtable.grpc.async.BulkMutation;
import com.google.cloud.bigtable.grpc.scanner.ResultScanner;
import com.google.protobuf.ByteString;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import org.apache.beam.runners.core.metrics.GcpResourceIdentifiers;
import org.apache.beam.runners.core.metrics.MonitoringInfoConstants;
import org.apache.beam.runners.core.metrics.ServiceCallMetric;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableIO;
import org.apache.beam.sdk.io.gcp.bigtable.BigtableService;
import org.apache.beam.sdk.io.gcp.bigtable.VendoredListenableFutureAdapter;
import org.apache.beam.sdk.io.range.ByteKeyRange;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.io.Closer;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.FutureCallback;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.Futures;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.util.concurrent.MoreExecutors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BigtableServiceImpl
implements BigtableService {
    private static final Logger LOG = LoggerFactory.getLogger(BigtableServiceImpl.class);
    private final BigtableOptions options;

    public BigtableServiceImpl(BigtableOptions options) {
        this.options = options;
    }

    @Override
    public BigtableOptions getBigtableOptions() {
        return this.options;
    }

    @Override
    public BigtableWriterImpl openForWriting(String tableId) throws IOException {
        BigtableSession session = new BigtableSession(this.options);
        BigtableTableName tableName = this.options.getInstanceName().toTableName(tableId);
        return new BigtableWriterImpl(session, tableName);
    }

    @Override
    public boolean tableExists(String tableId) throws IOException {
        boolean bl;
        BigtableSession session = new BigtableSession(this.options);
        Throwable throwable = null;
        try {
            GetTableRequest getTable = GetTableRequest.newBuilder().setName(this.options.getInstanceName().toTableNameStr(tableId)).build();
            session.getTableAdminClient().getTable(getTable);
            bl = true;
        }
        catch (Throwable throwable2) {
            try {
                try {
                    throwable = throwable2;
                    throw throwable2;
                }
                catch (Throwable throwable3) {
                    BigtableServiceImpl.$closeResource(throwable, (AutoCloseable)session);
                    throw throwable3;
                }
            }
            catch (StatusRuntimeException e) {
                if (e.getStatus().getCode() == Status.Code.NOT_FOUND) {
                    return false;
                }
                String message = String.format("Error checking whether table %s (BigtableOptions %s) exists", tableId, this.options);
                LOG.error(message, (Throwable)e);
                throw new IOException(message, e);
            }
        }
        BigtableServiceImpl.$closeResource(throwable, (AutoCloseable)session);
        return bl;
    }

    public String toString() {
        return MoreObjects.toStringHelper(BigtableServiceImpl.class).add("options", (Object)this.options).toString();
    }

    @Override
    public BigtableService.Reader createReader(BigtableIO.BigtableSource source) throws IOException {
        BigtableSession session = new BigtableSession(this.options);
        return new BigtableReaderImpl(session, source);
    }

    @Override
    public List<SampleRowKeysResponse> getSampleRowKeys(BigtableIO.BigtableSource source) throws IOException {
        try (BigtableSession session = new BigtableSession(this.options);){
            SampleRowKeysRequest request = SampleRowKeysRequest.newBuilder().setTableName(this.options.getInstanceName().toTableNameStr((String)source.getTableId().get())).build();
            List list = session.getDataClient().sampleRowKeys(request);
            return list;
        }
    }

    @VisibleForTesting
    static class BigtableWriterImpl
    implements BigtableService.Writer {
        private BigtableSession session;
        private BulkMutation bulkMutation;
        private BigtableTableName tableName;

        BigtableWriterImpl(BigtableSession session, BigtableTableName tableName) {
            this.session = session;
            this.bulkMutation = session.createBulkMutation(tableName);
            this.tableName = tableName;
        }

        @Override
        public void flush() throws IOException {
            if (this.bulkMutation != null) {
                try {
                    this.bulkMutation.flush();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IOException(e);
                }
            }
        }

        @Override
        public void close() throws IOException {
            block6: {
                try {
                    if (this.bulkMutation == null) break block6;
                    try {
                        this.bulkMutation.flush();
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new IOException(e);
                    }
                    this.bulkMutation = null;
                }
                finally {
                    if (this.session != null) {
                        this.session.close();
                        this.session = null;
                    }
                }
            }
        }

        @Override
        public CompletionStage<MutateRowResponse> writeRecord(KV<ByteString, Iterable<Mutation>> record) throws IOException {
            MutateRowsRequest.Entry request = MutateRowsRequest.Entry.newBuilder().setRowKey((ByteString)record.getKey()).addAllMutations((Iterable)record.getValue()).build();
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "BigTable");
            baseLabels.put("METHOD", "google.bigtable.v2.MutateRows");
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.bigtableResource((String)this.session.getOptions().getProjectId(), (String)this.session.getOptions().getInstanceId(), (String)this.tableName.getTableId()));
            baseLabels.put("BIGTABLE_PROJECT_ID", this.session.getOptions().getProjectId());
            baseLabels.put("INSTANCE_ID", this.session.getOptions().getInstanceId());
            baseLabels.put("TABLE_ID", GcpResourceIdentifiers.bigtableTableID((String)this.session.getOptions().getProjectId(), (String)this.session.getOptions().getInstanceId(), (String)this.tableName.getTableId()));
            final ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
            final CompletableFuture<MutateRowResponse> result = new CompletableFuture<MutateRowResponse>();
            Futures.addCallback(new VendoredListenableFutureAdapter(this.bulkMutation.add(request)), (FutureCallback)new FutureCallback<MutateRowResponse>(){

                public void onSuccess(MutateRowResponse mutateRowResponse) {
                    result.complete(mutateRowResponse);
                    serviceCallMetric.call("ok");
                }

                public void onFailure(Throwable throwable) {
                    if (throwable instanceof StatusRuntimeException) {
                        serviceCallMetric.call(((StatusRuntimeException)throwable).getStatus().getCode().value());
                    } else {
                        serviceCallMetric.call("unknown");
                    }
                    result.completeExceptionally(throwable);
                }
            }, (Executor)MoreExecutors.directExecutor());
            return result;
        }
    }

    @VisibleForTesting
    static class BigtableReaderImpl
    implements BigtableService.Reader {
        private BigtableSession session;
        private final BigtableIO.BigtableSource source;
        private ResultScanner<Row> results;
        private Row currentRow;

        @VisibleForTesting
        BigtableReaderImpl(BigtableSession session, BigtableIO.BigtableSource source) {
            this.session = session;
            this.source = source;
        }

        @Override
        public boolean start() throws IOException {
            RowSet.Builder rowSetBuilder = RowSet.newBuilder();
            for (ByteKeyRange sourceRange : this.source.getRanges()) {
                rowSetBuilder = rowSetBuilder.addRowRanges(RowRange.newBuilder().setStartKeyClosed(ByteString.copyFrom((ByteBuffer)sourceRange.getStartKey().getValue())).setEndKeyOpen(ByteString.copyFrom((ByteBuffer)sourceRange.getEndKey().getValue())));
            }
            RowSet rowSet = rowSetBuilder.build();
            String tableNameSr = this.session.getOptions().getInstanceName().toTableNameStr((String)this.source.getTableId().get());
            HashMap<String, String> baseLabels = new HashMap<String, String>();
            baseLabels.put("PTRANSFORM", "");
            baseLabels.put("SERVICE", "BigTable");
            baseLabels.put("METHOD", "google.bigtable.v2.ReadRows");
            baseLabels.put("RESOURCE", GcpResourceIdentifiers.bigtableResource((String)this.session.getOptions().getProjectId(), (String)this.session.getOptions().getInstanceId(), (String)((String)this.source.getTableId().get())));
            baseLabels.put("BIGTABLE_PROJECT_ID", this.session.getOptions().getProjectId());
            baseLabels.put("INSTANCE_ID", this.session.getOptions().getInstanceId());
            baseLabels.put("TABLE_ID", GcpResourceIdentifiers.bigtableTableID((String)this.session.getOptions().getProjectId(), (String)this.session.getOptions().getInstanceId(), (String)((String)this.source.getTableId().get())));
            ServiceCallMetric serviceCallMetric = new ServiceCallMetric(MonitoringInfoConstants.Urns.API_REQUEST_COUNT, baseLabels);
            ReadRowsRequest.Builder requestB = ReadRowsRequest.newBuilder().setRows(rowSet).setTableName(tableNameSr);
            if (this.source.getRowFilter() != null) {
                requestB.setFilter(this.source.getRowFilter());
            }
            try {
                this.results = this.session.getDataClient().readRows(requestB.build());
                serviceCallMetric.call("ok");
            }
            catch (StatusRuntimeException e) {
                serviceCallMetric.call(e.getStatus().getCode().value());
                throw e;
            }
            return this.advance();
        }

        @Override
        public boolean advance() throws IOException {
            this.currentRow = (Row)this.results.next();
            return this.currentRow != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            if (this.session == null) {
                return;
            }
            try (Closer closer = Closer.create();){
                if (this.results != null) {
                    closer.register(this.results);
                    this.results = null;
                }
                this.session.close();
            }
            finally {
                this.session = null;
            }
        }

        @Override
        public Row getCurrentRow() throws NoSuchElementException {
            if (this.currentRow == null) {
                throw new NoSuchElementException();
            }
            return this.currentRow;
        }
    }
}

