/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import com.google.api.services.bigquery.model.Clustering;
import com.google.api.services.bigquery.model.TableReference;
import com.google.api.services.bigquery.model.TimePartitioning;
import java.io.Serializable;
import java.util.Objects;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryHelpers;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TableDestination
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final String tableSpec;
    private final @Nullable String tableDescription;
    private final @Nullable String jsonTimePartitioning;
    private final @Nullable String jsonClustering;

    public TableDestination(String tableSpec, @Nullable String tableDescription) {
        this(tableSpec, tableDescription, (String)null, (String)null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription) {
        this(tableReference, tableDescription, (String)null, (String)null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription, TimePartitioning timePartitioning) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, (String)null);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, TimePartitioning timePartitioning) {
        this(tableSpec, tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, (String)null);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, TimePartitioning timePartitioning, Clustering clustering) {
        this(tableSpec, tableDescription, timePartitioning != null ? BigQueryHelpers.toJsonString(timePartitioning) : null, clustering != null ? BigQueryHelpers.toJsonString(clustering) : null);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, @Nullable String jsonTimePartitioning) {
        this(tableSpec, tableDescription, jsonTimePartitioning, (String)null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription, @Nullable String jsonTimePartitioning) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, jsonTimePartitioning, (String)null);
    }

    public TableDestination(TableReference tableReference, @Nullable String tableDescription, @Nullable String jsonTimePartitioning, @Nullable String jsonClustering) {
        this(BigQueryHelpers.toTableSpec(tableReference), tableDescription, jsonTimePartitioning, jsonClustering);
    }

    public TableDestination(String tableSpec, @Nullable String tableDescription, @Nullable String jsonTimePartitioning, @Nullable String jsonClustering) {
        this.tableSpec = tableSpec;
        this.tableDescription = tableDescription;
        this.jsonTimePartitioning = jsonTimePartitioning;
        this.jsonClustering = jsonClustering;
    }

    public TableDestination withTableReference(TableReference tableReference) {
        return new TableDestination(tableReference, this.tableDescription, this.jsonTimePartitioning, this.jsonClustering);
    }

    public String getTableSpec() {
        return this.tableSpec;
    }

    public String getTableUrn() {
        TableReference table = this.getTableReference();
        return String.format("projects/%s/datasets/%s/tables/%s", table.getProjectId(), table.getDatasetId(), table.getTableId());
    }

    public TableReference getTableReference() {
        return BigQueryHelpers.parseTableSpec(this.tableSpec);
    }

    public String getJsonTimePartitioning() {
        return this.jsonTimePartitioning;
    }

    public TimePartitioning getTimePartitioning() {
        if (this.jsonTimePartitioning == null) {
            return null;
        }
        return BigQueryHelpers.fromJsonString(this.jsonTimePartitioning, TimePartitioning.class);
    }

    public String getJsonClustering() {
        return this.jsonClustering;
    }

    public Clustering getClustering() {
        if (this.jsonClustering == null) {
            return null;
        }
        return BigQueryHelpers.fromJsonString(this.jsonClustering, Clustering.class);
    }

    public @Nullable String getTableDescription() {
        return this.tableDescription;
    }

    public String toString() {
        String toString = "tableSpec: " + this.tableSpec;
        if (this.tableDescription != null) {
            toString = toString + " tableDescription: " + this.tableDescription;
        }
        return toString;
    }

    public boolean equals(@Nullable Object o) {
        if (!(o instanceof TableDestination)) {
            return false;
        }
        TableDestination other = (TableDestination)o;
        return Objects.equals(this.tableSpec, other.tableSpec) && Objects.equals(this.tableDescription, other.tableDescription) && Objects.equals(this.jsonTimePartitioning, other.jsonTimePartitioning);
    }

    public int hashCode() {
        return Objects.hash(this.tableSpec, this.tableDescription, this.jsonTimePartitioning);
    }
}

