/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.bigquery;

import java.io.IOException;
import org.apache.avro.Schema;
import org.apache.avro.file.DataFileWriter;
import org.apache.avro.io.DatumWriter;
import org.apache.beam.sdk.io.gcp.bigquery.AvroWriteRequest;
import org.apache.beam.sdk.io.gcp.bigquery.BigQueryRowWriter;
import org.apache.beam.sdk.transforms.SerializableFunction;

class AvroRowWriter<AvroT, T>
extends BigQueryRowWriter<T> {
    private final DataFileWriter<AvroT> writer;
    private final Schema schema;
    private final SerializableFunction<AvroWriteRequest<T>, AvroT> toAvroRecord;

    AvroRowWriter(String basename, Schema schema, SerializableFunction<AvroWriteRequest<T>, AvroT> toAvroRecord, SerializableFunction<Schema, DatumWriter<AvroT>> writerFactory) throws Exception {
        super(basename, "application/octet-stream");
        this.schema = schema;
        this.toAvroRecord = toAvroRecord;
        this.writer = new DataFileWriter((DatumWriter)writerFactory.apply((Object)schema)).create(schema, this.getOutputStream());
    }

    @Override
    public void write(T element) throws IOException {
        AvroWriteRequest<T> writeRequest = new AvroWriteRequest<T>(element, this.schema);
        this.writer.append(this.toAvroRecord.apply(writeRequest));
    }

    public Schema getSchema() {
        return this.schema;
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
        super.close();
    }
}

