/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.healthcare;

import java.util.Optional;
import org.apache.beam.sdk.io.gcp.healthcare.FhirIO;
import org.apache.beam.sdk.options.ValueProvider;

final class AutoValue_FhirIO_Write
extends FhirIO.Write {
    private final ValueProvider<String> fhirStore;
    private final FhirIO.Write.WriteMethod writeMethod;
    private final Optional<FhirIO.Import.ContentStructure> contentStructure;
    private final Optional<ValueProvider<String>> importGcsTempPath;
    private final Optional<ValueProvider<String>> importGcsDeadLetterPath;

    private AutoValue_FhirIO_Write(ValueProvider<String> fhirStore, FhirIO.Write.WriteMethod writeMethod, Optional<FhirIO.Import.ContentStructure> contentStructure, Optional<ValueProvider<String>> importGcsTempPath, Optional<ValueProvider<String>> importGcsDeadLetterPath) {
        this.fhirStore = fhirStore;
        this.writeMethod = writeMethod;
        this.contentStructure = contentStructure;
        this.importGcsTempPath = importGcsTempPath;
        this.importGcsDeadLetterPath = importGcsDeadLetterPath;
    }

    @Override
    ValueProvider<String> getFhirStore() {
        return this.fhirStore;
    }

    @Override
    FhirIO.Write.WriteMethod getWriteMethod() {
        return this.writeMethod;
    }

    @Override
    Optional<FhirIO.Import.ContentStructure> getContentStructure() {
        return this.contentStructure;
    }

    @Override
    Optional<ValueProvider<String>> getImportGcsTempPath() {
        return this.importGcsTempPath;
    }

    @Override
    Optional<ValueProvider<String>> getImportGcsDeadLetterPath() {
        return this.importGcsDeadLetterPath;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof FhirIO.Write) {
            FhirIO.Write that = (FhirIO.Write)((Object)o);
            return this.fhirStore.equals(that.getFhirStore()) && this.writeMethod.equals((Object)that.getWriteMethod()) && this.contentStructure.equals(that.getContentStructure()) && this.importGcsTempPath.equals(that.getImportGcsTempPath()) && this.importGcsDeadLetterPath.equals(that.getImportGcsDeadLetterPath());
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.fhirStore.hashCode();
        h$ *= 1000003;
        h$ ^= this.writeMethod.hashCode();
        h$ *= 1000003;
        h$ ^= this.contentStructure.hashCode();
        h$ *= 1000003;
        h$ ^= this.importGcsTempPath.hashCode();
        h$ *= 1000003;
        return h$ ^= this.importGcsDeadLetterPath.hashCode();
    }

    static final class Builder
    extends FhirIO.Write.Builder {
        private ValueProvider<String> fhirStore;
        private FhirIO.Write.WriteMethod writeMethod;
        private Optional<FhirIO.Import.ContentStructure> contentStructure = Optional.empty();
        private Optional<ValueProvider<String>> importGcsTempPath = Optional.empty();
        private Optional<ValueProvider<String>> importGcsDeadLetterPath = Optional.empty();

        Builder() {
        }

        @Override
        FhirIO.Write.Builder setFhirStore(ValueProvider<String> fhirStore) {
            if (fhirStore == null) {
                throw new NullPointerException("Null fhirStore");
            }
            this.fhirStore = fhirStore;
            return this;
        }

        @Override
        FhirIO.Write.Builder setWriteMethod(FhirIO.Write.WriteMethod writeMethod) {
            if (writeMethod == null) {
                throw new NullPointerException("Null writeMethod");
            }
            this.writeMethod = writeMethod;
            return this;
        }

        @Override
        FhirIO.Write.Builder setContentStructure(FhirIO.Import.ContentStructure contentStructure) {
            this.contentStructure = Optional.of(contentStructure);
            return this;
        }

        @Override
        FhirIO.Write.Builder setImportGcsTempPath(ValueProvider<String> importGcsTempPath) {
            this.importGcsTempPath = Optional.of(importGcsTempPath);
            return this;
        }

        @Override
        FhirIO.Write.Builder setImportGcsDeadLetterPath(ValueProvider<String> importGcsDeadLetterPath) {
            this.importGcsDeadLetterPath = Optional.of(importGcsDeadLetterPath);
            return this;
        }

        @Override
        FhirIO.Write build() {
            String missing = "";
            if (this.fhirStore == null) {
                missing = missing + " fhirStore";
            }
            if (this.writeMethod == null) {
                missing = missing + " writeMethod";
            }
            if (!missing.isEmpty()) {
                throw new IllegalStateException("Missing required properties:" + missing);
            }
            return new AutoValue_FhirIO_Write(this.fhirStore, this.writeMethod, this.contentStructure, this.importGcsTempPath, this.importGcsDeadLetterPath);
        }
    }
}

