/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.fn.harness.control;

import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import org.apache.beam.fn.harness.control.BundleProgressReporter;
import org.apache.beam.runners.core.metrics.DistributionData;
import org.apache.beam.runners.core.metrics.MonitoringInfoEncodings;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Distribution;
import org.apache.beam.sdk.metrics.MetricName;
import org.apache.beam.vendor.grpc.v1p60p1.com.google.protobuf.ByteString;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class Metrics {
    public static @UnknownKeyFor @NonNull @Initialized BundleCounter bundleProcessingThreadCounter(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized MetricName name) {
        return new BundleProcessingThreadCounter(shortId, name);
    }

    public static @UnknownKeyFor @NonNull @Initialized BundleDistribution bundleProcessingThreadDistribution(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized MetricName name) {
        return new BundleProcessingThreadDistribution(shortId, name);
    }

    @NotThreadSafe
    private static class BundleProcessingThreadDistribution
    implements BundleDistribution {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;
        private final @UnknownKeyFor @NonNull @Initialized String shortId;
        @Nullable
        private @UnknownKeyFor @org.checkerframework.checker.nullness.qual.Nullable @Initialized DistributionData lastReportedValue;
        private @UnknownKeyFor @NonNull @Initialized AtomicReference<@UnknownKeyFor @NonNull @Initialized DistributionData> lazyData;
        private @UnknownKeyFor @NonNull @Initialized DistributionData data;

        public BundleProcessingThreadDistribution(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.shortId = shortId;
            this.name = name;
            this.data = DistributionData.EMPTY;
            this.lazyData = new AtomicReference<DistributionData>(this.data);
            this.lastReportedValue = null;
        }

        public void update(@UnknownKeyFor @NonNull @Initialized long value) {
            this.data = this.data.combine(value);
            this.lazyData.lazySet(this.data);
        }

        public void update(@UnknownKeyFor @NonNull @Initialized long sum, @UnknownKeyFor @NonNull @Initialized long count, @UnknownKeyFor @NonNull @Initialized long min, @UnknownKeyFor @NonNull @Initialized long max) {
            this.data = this.data.combine(sum, count, min, max);
            this.lazyData.lazySet(this.data);
        }

        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }

        @Override
        public void updateIntermediateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            DistributionData valueToReport = this.lazyData.get();
            if (valueToReport.equals(this.lastReportedValue)) {
                return;
            }
            monitoringData.put(this.shortId, MonitoringInfoEncodings.encodeInt64Distribution(this.lazyData.get()));
            this.lastReportedValue = valueToReport;
        }

        @Override
        public void updateFinalMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            if (this.data.equals(this.lastReportedValue)) {
                return;
            }
            monitoringData.put(this.shortId, MonitoringInfoEncodings.encodeInt64Distribution(this.data));
            this.lastReportedValue = this.data;
        }

        @Override
        public void reset() {
            if (this.lastReportedValue != null && this.lastReportedValue != DistributionData.EMPTY) {
                this.data = DistributionData.EMPTY;
                this.lazyData.set(DistributionData.EMPTY);
                this.lastReportedValue = DistributionData.EMPTY;
            }
        }
    }

    @NotThreadSafe
    private static class BundleProcessingThreadCounter
    implements BundleCounter {
        private final @UnknownKeyFor @NonNull @Initialized MetricName name;
        private final @UnknownKeyFor @NonNull @Initialized String shortId;
        private @UnknownKeyFor @NonNull @Initialized boolean hasReportedValue;
        private @UnknownKeyFor @NonNull @Initialized long lastReportedValue;
        private final @UnknownKeyFor @NonNull @Initialized AtomicLong lazyCount;
        private @UnknownKeyFor @NonNull @Initialized long count;

        public BundleProcessingThreadCounter(@UnknownKeyFor @NonNull @Initialized String shortId, @UnknownKeyFor @NonNull @Initialized MetricName name) {
            this.shortId = shortId;
            this.name = name;
            this.lazyCount = new AtomicLong();
        }

        public void inc() {
            ++this.count;
            this.lazyCount.lazySet(this.count);
        }

        public void inc(@UnknownKeyFor @NonNull @Initialized long n) {
            this.count += n;
            this.lazyCount.lazySet(this.count);
        }

        public void dec() {
            --this.count;
            this.lazyCount.lazySet(this.count);
        }

        public void dec(@UnknownKeyFor @NonNull @Initialized long n) {
            this.count -= n;
            this.lazyCount.lazySet(this.count);
        }

        public @UnknownKeyFor @NonNull @Initialized MetricName getName() {
            return this.name;
        }

        @Override
        public void updateIntermediateMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            long valueToReport = this.lazyCount.get();
            if (this.hasReportedValue && valueToReport == this.lastReportedValue) {
                return;
            }
            monitoringData.put(this.shortId, MonitoringInfoEncodings.encodeInt64Counter(valueToReport));
            this.lastReportedValue = valueToReport;
            this.hasReportedValue = true;
        }

        @Override
        public void updateFinalMonitoringData(@UnknownKeyFor @NonNull @Initialized Map<@UnknownKeyFor @NonNull @Initialized String, @UnknownKeyFor @NonNull @Initialized ByteString> monitoringData) {
            if (this.hasReportedValue && this.count == this.lastReportedValue) {
                return;
            }
            monitoringData.put(this.shortId, MonitoringInfoEncodings.encodeInt64Counter(this.count));
            this.lastReportedValue = this.count;
            this.hasReportedValue = true;
        }

        @Override
        public void reset() {
            if (this.hasReportedValue) {
                this.count = 0L;
                this.lazyCount.set(this.count);
                this.lastReportedValue = 0L;
            }
        }
    }

    public static interface BundleDistribution
    extends BundleProgressReporter,
    Distribution {
    }

    public static interface BundleCounter
    extends BundleProgressReporter,
    Counter {
    }
}

