/*
 * Decompiled with CFR 0.152.
 */
package org.github.jamm;

import java.lang.instrument.Instrumentation;
import java.util.function.Predicate;
import org.github.jamm.MemoryLayoutSpecification;
import org.github.jamm.MemoryMeterInstrumentation;
import org.github.jamm.MemoryMeterSpec;
import org.github.jamm.MemoryMeterUnsafe;
import org.github.jamm.Unmetered;

public abstract class MemoryMeter {
    static final MemoryLayoutSpecification SPEC = MemoryLayoutSpecification.getEffectiveMemoryLayoutSpecification();
    final Guess guess;
    final byte byteBufferMode;
    final boolean ignoreOuterClassReference;
    final boolean ignoreKnownSingletons;
    final boolean ignoreNonStrongReferences;
    final boolean ignoreDontMeasure;
    final Predicate<Class<?>> ignoreClassPredicate;
    final ClassValue<Boolean> ignoreClass = new ClassValue<Boolean>(){

        @Override
        protected Boolean computeValue(Class<?> type) {
            return MemoryMeter.this.ignoreClassPredicate.test(type);
        }
    };
    static final byte BB_MODE_NORMAL = 0;
    static final byte BB_MODE_OMIT_SHARED = 1;
    static final byte BB_MODE_SHALLOW = 2;
    static final byte BB_MODE_HEAP_ONLY_NO_SLICE = 3;
    private static final Class<?> clsJLRModule = MemoryMeter.maybeGetClass("java.lang.reflect.Module");
    private static final Class<?> clsJLMModuleDescriptor = MemoryMeter.maybeGetClass("java.lang.module.ModuleDescriptor");
    private static final Class<?> clsJLRAccessibleObject = MemoryMeter.maybeGetClass("java.lang.reflect.AccessibleObject");
    private static final Class<?> clsSRAAnnotationInvocationHandler = MemoryMeter.maybeGetClass("sun.reflect.annotation.AnnotationInvocationHandler");
    private static final Class<?> clsSRAAnnotationType = MemoryMeter.maybeGetClass("sun.reflect.annotation.AnnotationType");
    private static final Class<?> clsJIRUnsafeFieldAccessorImpl = MemoryMeter.maybeGetClass("jdk.internal.reflect.UnsafeFieldAccessorImpl");
    private static final Class<?> clsJIRDelegatingMethodAccessorImpl = MemoryMeter.maybeGetClass("jdk.internal.reflect.DelegatingMethodAccessorImpl");

    public static void premain(String options, Instrumentation inst) {
        MemoryMeterInstrumentation.instrumentation = inst;
    }

    public static void agentmain(String options, Instrumentation inst) {
        MemoryMeterInstrumentation.instrumentation = inst;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder unbuild() {
        return new Builder(this.guess, this.byteBufferMode, this.ignoreOuterClassReference, this.ignoreKnownSingletons, this.ignoreNonStrongReferences, this.ignoreDontMeasure);
    }

    MemoryMeter(Builder builder) {
        this.guess = builder.guess;
        this.byteBufferMode = builder.byteBufferMode;
        this.ignoreOuterClassReference = builder.ignoreOuterClassReference;
        this.ignoreKnownSingletons = builder.ignoreKnownSingletons;
        this.ignoreNonStrongReferences = builder.ignoreNonStrongReferences;
        this.ignoreDontMeasure = builder.ignoreDontMeasure;
        Predicate<Class> pred = c -> false;
        if (this.ignoreKnownSingletons) {
            pred = pred.or(MemoryMeter::checkKnownSingleton);
        }
        if (!this.ignoreDontMeasure) {
            pred = pred.or(MemoryMeter::isAnnotationPresent);
        }
        this.ignoreClassPredicate = pred;
    }

    private static boolean checkKnownSingleton(Class<?> cls) {
        return cls == Class.class || cls.isEnum() || Thread.class.isAssignableFrom(cls);
    }

    private static boolean isAnnotationPresent(Class<?> cls) {
        if (cls == null) {
            return false;
        }
        if (cls.isAnnotationPresent(Unmetered.class)) {
            return true;
        }
        Class<?>[] interfaces = cls.getInterfaces();
        for (int i = 0; i < interfaces.length; ++i) {
            if (!MemoryMeter.isAnnotationPresent(cls.getInterfaces()[i])) continue;
            return true;
        }
        return MemoryMeter.isAnnotationPresent(cls.getSuperclass());
    }

    public Guess getGuess() {
        return this.guess;
    }

    public String toString() {
        return this.getClass().getName() + "{byteBufferMode=" + this.byteBufferMode + ", guess=" + (Object)((Object)this.guess) + ", ignoreOuterClassReference=" + this.ignoreOuterClassReference + ", ignoreKnownSingletons=" + this.ignoreKnownSingletons + ", ignoreNonStrongReferences=" + this.ignoreNonStrongReferences + ", ignoreDontMeasure=" + this.ignoreDontMeasure + ", spec=" + SPEC + '}';
    }

    public long sizeOfArray(byte[] bytes) {
        return this.sizeOfArray(bytes.length, Byte.TYPE);
    }

    public long sizeOfArray(short[] shorts) {
        return this.sizeOfArray(shorts.length, Short.TYPE);
    }

    public long sizeOfArray(char[] chars) {
        return this.sizeOfArray(chars.length, Character.TYPE);
    }

    public long sizeOfArray(int[] ints) {
        return this.sizeOfArray(ints.length, Integer.TYPE);
    }

    public long sizeOfArray(long[] longs) {
        return this.sizeOfArray(longs.length, Long.TYPE);
    }

    public long sizeOfArray(float[] floats) {
        return this.sizeOfArray(floats.length, Float.TYPE);
    }

    public long sizeOfArray(double[] doubles) {
        return this.sizeOfArray(doubles.length, Double.TYPE);
    }

    public long sizeOfArray(Object[] objects) {
        return this.sizeOfArray(objects.length, Object.class);
    }

    public long sizeOfArray(int length, Class<?> type) {
        long sz = SPEC.getArrayHeaderSize();
        return MemoryMeter.roundTo(sz += (long)MemoryMeter.sizeOfField(type) * (long)length, SPEC.getObjectAlignment());
    }

    public abstract long measure(Object var1);

    public abstract long measureDeep(Object var1);

    private static Class<?> maybeGetClass(String name) {
        try {
            return Class.forName(name);
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static boolean skipClass(Class<?> cls) {
        return cls == null || cls == Class.class || cls == clsJLRModule || cls == clsJLMModuleDescriptor || cls == clsJLRAccessibleObject || cls == clsSRAAnnotationInvocationHandler || cls == clsSRAAnnotationType || cls == clsJIRUnsafeFieldAccessorImpl || cls == clsJIRDelegatingMethodAccessorImpl;
    }

    static int sizeOfField(Class<?> type) {
        if (!type.isPrimitive()) {
            return SPEC.getReferenceSize();
        }
        if (type == Boolean.TYPE || type == Byte.TYPE) {
            return 1;
        }
        if (type == Character.TYPE || type == Short.TYPE) {
            return 2;
        }
        if (type == Float.TYPE || type == Integer.TYPE) {
            return 4;
        }
        if (type == Double.TYPE || type == Long.TYPE) {
            return 8;
        }
        throw new IllegalStateException();
    }

    static long roundTo(long x, int multiple) {
        return (x + (long)multiple - 1L) / (long)multiple * (long)multiple;
    }

    public static class Builder {
        private Guess guess = Guess.BEST;
        private byte byteBufferMode = 0;
        private boolean ignoreOuterClassReference;
        private boolean ignoreKnownSingletons;
        private boolean ignoreNonStrongReferences;
        private boolean ignoreDontMeasure;

        private Builder() {
        }

        private Builder(Guess guess, byte byteBufferMode, boolean ignoreOuterClassReference, boolean ignoreKnownSingletons, boolean ignoreNonStrongReferences, boolean ignoreDontMeasure) {
            this.guess = guess;
            this.byteBufferMode = byteBufferMode;
            this.ignoreOuterClassReference = ignoreOuterClassReference;
            this.ignoreKnownSingletons = ignoreKnownSingletons;
            this.ignoreNonStrongReferences = ignoreNonStrongReferences;
            this.ignoreDontMeasure = ignoreDontMeasure;
        }

        public MemoryMeter build() {
            return this.guess.createMeter(this);
        }

        public Builder omitSharedBufferOverhead() {
            this.byteBufferMode = 1;
            return this;
        }

        public Builder onlyShallowByteBuffers() {
            this.byteBufferMode = (byte)2;
            return this;
        }

        public Builder byteBuffersHeapOnlyNoSlice() {
            this.byteBufferMode = (byte)3;
            return this;
        }

        public Builder ignoreDontMeasure() {
            this.ignoreDontMeasure = true;
            return this;
        }

        public Builder withGuessing(Guess guess) {
            this.guess = guess;
            return this;
        }

        @Deprecated
        public Builder ignoreOuterClassReference() {
            this.ignoreOuterClassReference = true;
            return this;
        }

        public Builder ignoreKnownSingletons() {
            this.ignoreKnownSingletons = true;
            return this;
        }

        @Deprecated
        public Builder ignoreNonStrongReferences() {
            this.ignoreNonStrongReferences = true;
            return this;
        }
    }

    public static enum Guess {
        BEST{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                if (MemoryMeterUnsafe.hasUnsafe()) {
                    return new MemoryMeterUnsafe(builder);
                }
                return new MemoryMeterSpec(builder);
            }
        }
        ,
        NEVER{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                throw new IllegalStateException("Instrumentation is not set; Jamm must be set as -javaagent");
            }
        }
        ,
        FALLBACK_SPEC{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                return new MemoryMeterSpec(builder);
            }
        }
        ,
        FALLBACK_UNSAFE{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                if (MemoryMeterUnsafe.hasUnsafe()) {
                    return new MemoryMeterUnsafe(builder);
                }
                throw new IllegalStateException("Instrumentation is not set and sun.misc.Unsafe could not be obtained; Jamm must be set as -javaagent, or the SecurityManager must permit access to sun.misc.Unsafe");
            }
        }
        ,
        FALLBACK_BEST{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                if (MemoryMeterUnsafe.hasUnsafe()) {
                    return new MemoryMeterUnsafe(builder);
                }
                return new MemoryMeterSpec(builder);
            }
        }
        ,
        ALWAYS_SPEC{

            @Override
            MemoryMeter createMeter(Builder builder) {
                return new MemoryMeterSpec(builder);
            }
        }
        ,
        ALWAYS_UNSAFE{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterUnsafe.hasUnsafe()) {
                    return new MemoryMeterUnsafe(builder);
                }
                throw new IllegalStateException("Unsafe not available; the SecurityManager must permit access to sun.misc.Unsafe");
            }
        }
        ,
        ALWAYS_INSTRUMENTATION{

            @Override
            MemoryMeter createMeter(Builder builder) {
                if (MemoryMeterInstrumentation.hasInstrumentation()) {
                    return new MemoryMeterInstrumentation(builder);
                }
                throw new IllegalStateException("Instrumentation is not set; Jamm must be set as -javaagent");
            }
        };


        abstract MemoryMeter createMeter(Builder var1);
    }
}

