/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.data;

import java.util.Map;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.common.Timestamp;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.data.AttachmentValue;
import org.apache.beam.vendor.grpc.v1p43p2.io.opencensus.metrics.data.Exemplar;

final class AutoValue_Exemplar
extends Exemplar {
    private final double value;
    private final Timestamp timestamp;
    private final Map<String, AttachmentValue> attachments;

    AutoValue_Exemplar(double value, Timestamp timestamp, Map<String, AttachmentValue> attachments) {
        this.value = value;
        if (timestamp == null) {
            throw new NullPointerException("Null timestamp");
        }
        this.timestamp = timestamp;
        if (attachments == null) {
            throw new NullPointerException("Null attachments");
        }
        this.attachments = attachments;
    }

    @Override
    public double getValue() {
        return this.value;
    }

    @Override
    public Timestamp getTimestamp() {
        return this.timestamp;
    }

    @Override
    public Map<String, AttachmentValue> getAttachments() {
        return this.attachments;
    }

    public String toString() {
        return "Exemplar{value=" + this.value + ", timestamp=" + this.timestamp + ", attachments=" + this.attachments + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Exemplar) {
            Exemplar that = (Exemplar)o;
            return Double.doubleToLongBits(this.value) == Double.doubleToLongBits(that.getValue()) && this.timestamp.equals(that.getTimestamp()) && this.attachments.equals(that.getAttachments());
        }
        return false;
    }

    public int hashCode() {
        int h2 = 1;
        h2 *= 1000003;
        h2 = (int)((long)h2 ^ (Double.doubleToLongBits(this.value) >>> 32 ^ Double.doubleToLongBits(this.value)));
        h2 *= 1000003;
        h2 ^= this.timestamp.hashCode();
        h2 *= 1000003;
        return h2 ^= this.attachments.hashCode();
    }
}

