/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.values;

import java.util.Collections;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaRegistry;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.PValueBase;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.WindowingStrategy;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PCollection<T>
extends PValueBase
implements PValue {
    private CoderOrFailure<T> coderOrFailure = new CoderOrFailure(null, "No Coder was specified, and Coder Inference did not occur");
    private @Nullable TypeDescriptor<T> typeDescriptor;
    private WindowingStrategy<?, ?> windowingStrategy;
    private IsBounded isBounded;
    private final TupleTag<?> tag;

    @Override
    public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        this.coderOrFailure = this.inferCoderOrFail(input, transform, this.getPipeline().getCoderRegistry(), this.getPipeline().getSchemaRegistry());
        super.finishSpecifyingOutput(transformName, input, transform);
    }

    @Override
    public void finishSpecifying(PInput input, PTransform<?, ?> transform) {
        if (this.isFinishedSpecifying()) {
            return;
        }
        this.coderOrFailure = this.inferCoderOrFail(input, transform, this.getPipeline().getCoderRegistry(), this.getPipeline().getSchemaRegistry());
        this.getCoder();
        super.finishSpecifying(input, transform);
    }

    public @Nullable TypeDescriptor<T> getTypeDescriptor() {
        if (this.typeDescriptor != null) {
            return this.typeDescriptor;
        }
        if (((CoderOrFailure)this.coderOrFailure).coder != null) {
            return ((CoderOrFailure)this.coderOrFailure).coder.getEncodedTypeDescriptor();
        }
        return null;
    }

    private CoderOrFailure<T> inferCoderOrFail(PInput input, PTransform<?, ?> transform, CoderRegistry coderRegistry, SchemaRegistry schemaRegistry) {
        if (((CoderOrFailure)this.coderOrFailure).coder != null) {
            return this.coderOrFailure;
        }
        try {
            return new CoderOrFailure(transform.getDefaultOutputCoder(input, this), null);
        }
        catch (CannotProvideCoderException exc) {
            CannotProvideCoderException inferFromTokenException;
            CannotProvideCoderException inputCoderException;
            block11: {
                inputCoderException = exc;
                TypeDescriptor<T> token = this.getTypeDescriptor();
                if (token != null) {
                    try {
                        SchemaCoder<T> schemaCoder = SchemaCoder.of(schemaRegistry.getSchema(token), token, schemaRegistry.getToRowFunction(token), schemaRegistry.getFromRowFunction(token));
                        return new CoderOrFailure<T>(schemaCoder, null);
                    }
                    catch (NoSuchSchemaException schemaCoder) {
                        // empty catch block
                    }
                }
                inferFromTokenException = null;
                if (token != null) {
                    try {
                        return new CoderOrFailure<T>(coderRegistry.getCoder(token), null);
                    }
                    catch (CannotProvideCoderException exc2) {
                        inferFromTokenException = exc2;
                        if (!(transform instanceof ParDo.MultiOutput) || exc2.getReason() != CannotProvideCoderException.ReasonCode.TYPE_ERASURE) break block11;
                        inferFromTokenException = new CannotProvideCoderException(exc2.getMessage() + " If this error occurs for an output of the producing ParDo, verify that the TupleTag for this output is constructed with proper type information (see TupleTag Javadoc) or explicitly set the Coder to use if this is not possible.");
                    }
                }
            }
            StringBuilder messageBuilder = new StringBuilder().append("Unable to return a default Coder for ").append(this).append(". Correct one of the following root causes:");
            messageBuilder.append("\n  No Coder has been manually specified; ").append(" you may do so using .setCoder().");
            if (inferFromTokenException != null) {
                messageBuilder.append("\n  Inferring a Coder from the CoderRegistry failed: ").append(inferFromTokenException.getMessage());
            }
            if (inputCoderException != null) {
                messageBuilder.append("\n  Using the default output Coder from the producing PTransform failed: ").append(inputCoderException.getMessage());
            }
            return new CoderOrFailure(null, messageBuilder.toString());
        }
    }

    @Override
    public String getName() {
        return super.getName();
    }

    @Override
    public final Map<TupleTag<?>, PValue> expand() {
        return Collections.singletonMap(this.tag, this);
    }

    @Override
    public PCollection<T> setName(String name) {
        super.setName(name);
        return this;
    }

    public Coder<T> getCoder() {
        Preconditions.checkState(((CoderOrFailure)this.coderOrFailure).coder != null, ((CoderOrFailure)this.coderOrFailure).failure);
        return ((CoderOrFailure)this.coderOrFailure).coder;
    }

    public PCollection<T> setCoder(Coder<T> coder) {
        Preconditions.checkState(!this.isFinishedSpecifying(), "cannot change the Coder of %s once it's been used", (Object)this);
        Preconditions.checkArgument(coder != null, "Cannot setCoder(null)");
        this.coderOrFailure = new CoderOrFailure<T>(coder, null);
        return this;
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public PCollection<T> setRowSchema(Schema schema) {
        return this.setCoder(SchemaCoder.of(schema));
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public PCollection<T> setSchema(Schema schema, TypeDescriptor<T> typeDescriptor, SerializableFunction<T, Row> toRowFunction, SerializableFunction<Row, T> fromRowFunction) {
        return this.setCoder(SchemaCoder.of(schema, typeDescriptor, toRowFunction, fromRowFunction));
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public boolean hasSchema() {
        return ((CoderOrFailure)this.coderOrFailure).coder != null && ((CoderOrFailure)this.coderOrFailure).coder instanceof SchemaCoder;
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public Schema getSchema() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getSchema when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getSchema();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public SerializableFunction<T, Row> getToRowFunction() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getToRowFunction when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getToRowFunction();
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public SerializableFunction<Row, T> getFromRowFunction() {
        if (!this.hasSchema()) {
            throw new IllegalStateException("Cannot call getFromRowFunction when there is no schema");
        }
        return ((SchemaCoder)this.getCoder()).getFromRowFunction();
    }

    public <OutputT extends POutput> OutputT apply(PTransform<? super PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(this, t);
    }

    public <OutputT extends POutput> OutputT apply(String name, PTransform<? super PCollection<T>, OutputT> t) {
        return Pipeline.applyTransform(name, this, t);
    }

    public WindowingStrategy<?, ?> getWindowingStrategy() {
        return this.windowingStrategy;
    }

    public IsBounded isBounded() {
        return this.isBounded;
    }

    private PCollection(Pipeline p, WindowingStrategy<?, ?> windowingStrategy, IsBounded isBounded) {
        super(p);
        this.windowingStrategy = windowingStrategy;
        this.isBounded = isBounded;
        this.tag = new TupleTag();
    }

    private PCollection(Pipeline p, WindowingStrategy<?, ?> windowingStrategy, IsBounded isBounded, TupleTag<?> tag) {
        super(p);
        this.windowingStrategy = windowingStrategy;
        this.isBounded = isBounded;
        this.tag = tag;
    }

    public PCollection<T> setTypeDescriptor(TypeDescriptor<T> typeDescriptor) {
        this.typeDescriptor = typeDescriptor;
        return this;
    }

    @Internal
    public PCollection<T> setWindowingStrategyInternal(WindowingStrategy<?, ?> windowingStrategy) {
        this.windowingStrategy = windowingStrategy;
        return this;
    }

    @Internal
    public PCollection<T> setIsBoundedInternal(IsBounded isBounded) {
        this.isBounded = isBounded;
        return this;
    }

    @Internal
    public static <T> PCollection<T> createPrimitiveOutputInternal(Pipeline pipeline, WindowingStrategy<?, ?> windowingStrategy, IsBounded isBounded, @Nullable Coder<T> coder) {
        PCollection<T> res = new PCollection<T>(pipeline, windowingStrategy, isBounded);
        if (coder != null) {
            res.setCoder(coder);
        }
        return res;
    }

    @Internal
    public static <T> PCollection<T> createPrimitiveOutputInternal(Pipeline pipeline, WindowingStrategy<?, ?> windowingStrategy, IsBounded isBounded, @Nullable Coder<T> coder, TupleTag<?> tag) {
        PCollection<T> res = new PCollection<T>(pipeline, windowingStrategy, isBounded, tag);
        if (coder != null) {
            res.setCoder(coder);
        }
        return res;
    }

    private static class CoderOrFailure<T> {
        private final @Nullable Coder<T> coder;
        private final @Nullable String failure;

        public CoderOrFailure(@Nullable Coder<T> coder, @Nullable String failure) {
            this.coder = coder;
            this.failure = failure;
        }
    }

    public static enum IsBounded {
        BOUNDED,
        UNBOUNDED;


        public IsBounded and(IsBounded that) {
            if (this == BOUNDED && that == BOUNDED) {
                return BOUNDED;
            }
            return UNBOUNDED;
        }
    }
}

