/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StructuredCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;

public class ShardedKey<K> {
    private final K key;
    private final byte[] shardId;

    protected ShardedKey(K key, byte[] shardId) {
        this.key = key;
        this.shardId = shardId;
    }

    public static <K> ShardedKey<K> of(K key, byte[] shardId) {
        Preconditions.checkArgument(key != null, "Key should not be null!");
        Preconditions.checkArgument(shardId != null, "Shard id should not be null!");
        return new ShardedKey<K>(key, shardId);
    }

    public K getKey() {
        return this.key;
    }

    public String toString() {
        return "ShardedKey{key=" + this.key + ", shardId=" + Arrays.toString(this.shardId) + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ShardedKey) {
            ShardedKey that = (ShardedKey)o;
            return this.key.equals(that.key) && Arrays.equals(this.shardId, that.shardId);
        }
        return false;
    }

    public int hashCode() {
        int hash = 1;
        hash *= 1000003;
        hash ^= this.key.hashCode();
        hash *= 1000003;
        return hash ^= Arrays.hashCode(this.shardId);
    }

    public static class Coder<K>
    extends StructuredCoder<ShardedKey<K>> {
        private final ByteArrayCoder shardCoder = ByteArrayCoder.of();
        private final org.apache.beam.sdk.coders.Coder<K> keyCoder;

        private Coder(org.apache.beam.sdk.coders.Coder<K> coder) {
            this.keyCoder = coder;
        }

        public static <K> Coder<K> of(org.apache.beam.sdk.coders.Coder<K> keyCoder) {
            return new Coder<K>(keyCoder);
        }

        public org.apache.beam.sdk.coders.Coder<K> getKeyCoder() {
            return this.keyCoder;
        }

        @Override
        public void encode(ShardedKey<K> shardedKey, OutputStream outStream) throws IOException {
            this.shardCoder.encode(((ShardedKey)shardedKey).shardId, outStream);
            this.keyCoder.encode(((ShardedKey)shardedKey).key, outStream);
        }

        @Override
        public ShardedKey<K> decode(InputStream inStream) throws IOException {
            byte[] shardId = this.shardCoder.decode(inStream);
            K key = this.keyCoder.decode(inStream);
            return ShardedKey.of(key, shardId);
        }

        @Override
        public List<? extends org.apache.beam.sdk.coders.Coder<?>> getCoderArguments() {
            return Collections.singletonList(this.keyCoder);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            Coder.verifyDeterministic(this, "Key coder must be deterministic", this.keyCoder);
        }

        @Override
        public boolean consistentWithEquals() {
            return this.keyCoder.consistentWithEquals();
        }

        @Override
        public boolean isRegisterByteSizeObserverCheap(ShardedKey<K> shardedKey) {
            return this.shardCoder.isRegisterByteSizeObserverCheap(((ShardedKey)shardedKey).shardId) && this.keyCoder.isRegisterByteSizeObserverCheap(((ShardedKey)shardedKey).key);
        }

        @Override
        public Object structuralValue(ShardedKey<K> shardedKey) {
            return ShardedKey.of(this.keyCoder.structuralValue(((ShardedKey)shardedKey).key), ((ShardedKey)shardedKey).shardId);
        }

        @Override
        public void registerByteSizeObserver(ShardedKey<K> shardedKey, ElementByteSizeObserver observer) throws Exception {
            this.shardCoder.registerByteSizeObserver(((ShardedKey)shardedKey).shardId, observer);
            this.keyCoder.registerByteSizeObserver(((ShardedKey)shardedKey).key, observer);
        }
    }
}

