/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.util;

import org.apache.beam.sdk.util.BackOff;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Duration;

public final class FluentBackoff {
    private static final double DEFAULT_EXPONENT = 1.5;
    private static final double DEFAULT_RANDOMIZATION_FACTOR = 0.5;
    private static final Duration DEFAULT_MIN_BACKOFF = Duration.standardSeconds(1L);
    private static final Duration DEFAULT_MAX_BACKOFF = Duration.standardDays(1000L);
    private static final int DEFAULT_MAX_RETRIES = Integer.MAX_VALUE;
    private static final Duration DEFAULT_MAX_CUM_BACKOFF = Duration.standardDays(1000L);
    private final double exponent;
    private final Duration initialBackoff;
    private final Duration maxBackoff;
    private final Duration maxCumulativeBackoff;
    private final int maxRetries;
    public static final FluentBackoff DEFAULT = new FluentBackoff(1.5, DEFAULT_MIN_BACKOFF, DEFAULT_MAX_BACKOFF, DEFAULT_MAX_CUM_BACKOFF, Integer.MAX_VALUE);

    public BackOff backoff() {
        return new BackoffImpl(this);
    }

    public FluentBackoff withExponent(double exponent) {
        Preconditions.checkArgument(exponent > 0.0, "exponent %s must be greater than 0", (Object)exponent);
        return new FluentBackoff(exponent, this.initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public FluentBackoff withInitialBackoff(Duration initialBackoff) {
        Preconditions.checkArgument(initialBackoff.isLongerThan(Duration.ZERO), "initialBackoff %s must be at least 1 millisecond", (Object)initialBackoff);
        return new FluentBackoff(this.exponent, initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public FluentBackoff withMaxBackoff(Duration maxBackoff) {
        Preconditions.checkArgument(maxBackoff.getMillis() > 0L, "maxBackoff %s must be at least 1 millisecond", (Object)maxBackoff);
        return new FluentBackoff(this.exponent, this.initialBackoff, maxBackoff, this.maxCumulativeBackoff, this.maxRetries);
    }

    public FluentBackoff withMaxCumulativeBackoff(Duration maxCumulativeBackoff) {
        Preconditions.checkArgument(maxCumulativeBackoff.isLongerThan(Duration.ZERO), "maxCumulativeBackoff %s must be at least 1 millisecond", (Object)maxCumulativeBackoff);
        return new FluentBackoff(this.exponent, this.initialBackoff, this.maxBackoff, maxCumulativeBackoff, this.maxRetries);
    }

    public FluentBackoff withMaxRetries(int maxRetries) {
        Preconditions.checkArgument(maxRetries >= 0, "maxRetries %s cannot be negative", maxRetries);
        return new FluentBackoff(this.exponent, this.initialBackoff, this.maxBackoff, this.maxCumulativeBackoff, maxRetries);
    }

    public String toString() {
        return MoreObjects.toStringHelper(FluentBackoff.class).add("exponent", this.exponent).add("initialBackoff", this.initialBackoff).add("maxBackoff", this.maxBackoff).add("maxRetries", this.maxRetries).add("maxCumulativeBackoff", this.maxCumulativeBackoff).toString();
    }

    private FluentBackoff(double exponent, Duration initialBackoff, Duration maxBackoff, Duration maxCumulativeBackoff, int maxRetries) {
        this.exponent = exponent;
        this.initialBackoff = initialBackoff;
        this.maxBackoff = maxBackoff;
        this.maxRetries = maxRetries;
        this.maxCumulativeBackoff = maxCumulativeBackoff;
    }

    private static class BackoffImpl
    implements BackOff {
        private final FluentBackoff backoffConfig;
        private Duration currentCumulativeBackoff;
        private int currentRetry;

        @Override
        public void reset() {
            this.currentRetry = 0;
            this.currentCumulativeBackoff = Duration.ZERO;
        }

        @Override
        public long nextBackOffMillis() {
            if (this.currentRetry >= this.backoffConfig.maxRetries) {
                return -1L;
            }
            if (this.currentCumulativeBackoff.compareTo(this.backoffConfig.maxCumulativeBackoff) >= 0) {
                return -1L;
            }
            double currentIntervalMillis = Math.min((double)this.backoffConfig.initialBackoff.getMillis() * Math.pow(this.backoffConfig.exponent, this.currentRetry), (double)this.backoffConfig.maxBackoff.getMillis());
            double randomOffset = (Math.random() * 2.0 - 1.0) * 0.5 * currentIntervalMillis;
            long nextBackoffMillis = Math.round(currentIntervalMillis + randomOffset);
            Duration remainingCumulative = this.backoffConfig.maxCumulativeBackoff.minus(this.currentCumulativeBackoff);
            nextBackoffMillis = Math.min(nextBackoffMillis, remainingCumulative.getMillis());
            this.currentCumulativeBackoff = this.currentCumulativeBackoff.plus(Duration.millis(nextBackoffMillis));
            ++this.currentRetry;
            return nextBackoffMillis;
        }

        private BackoffImpl(FluentBackoff backoffConfig) {
            this.backoffConfig = backoffConfig;
            this.reset();
        }

        public String toString() {
            return MoreObjects.toStringHelper(BackoffImpl.class).add("backoffConfig", this.backoffConfig).add("currentRetry", this.currentRetry).add("currentCumulativeBackoff", this.currentCumulativeBackoff).toString();
        }
    }
}

