/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterFirst
extends Trigger.OnceTrigger {
    AfterFirst(List<Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    public static AfterFirst of(Trigger.OnceTrigger ... triggers) {
        return new AfterFirst(Arrays.asList(triggers));
    }

    public static AfterFirst of(List<Trigger> triggers) {
        return new AfterFirst(triggers);
    }

    @Override
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MAX_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isAfter(subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    protected Trigger.OnceTrigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return new AfterFirst(continuationTriggers);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterFirst.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

