/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.windowing;

import java.util.Arrays;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.joda.time.Instant;

@Experimental(value=Experimental.Kind.TRIGGER)
public class AfterAll
extends Trigger.OnceTrigger {
    private AfterAll(List<Trigger> subTriggers) {
        super(subTriggers);
        Preconditions.checkArgument(subTriggers.size() > 1);
    }

    public static AfterAll of(Trigger.OnceTrigger ... triggers) {
        return new AfterAll(Arrays.asList(triggers));
    }

    public static AfterAll of(List<Trigger> triggers) {
        return new AfterAll(triggers);
    }

    @Override
    @Internal
    public Instant getWatermarkThatGuaranteesFiring(BoundedWindow window) {
        Instant deadline = BoundedWindow.TIMESTAMP_MIN_VALUE;
        for (Trigger subTrigger : this.subTriggers) {
            Instant subDeadline = subTrigger.getWatermarkThatGuaranteesFiring(window);
            if (!deadline.isBefore(subDeadline)) continue;
            deadline = subDeadline;
        }
        return deadline;
    }

    @Override
    protected Trigger.OnceTrigger getContinuationTrigger(List<Trigger> continuationTriggers) {
        return new AfterAll(continuationTriggers);
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder("AfterAll.of(");
        Joiner.on(", ").appendTo(builder, (Iterable<?>)this.subTriggers);
        builder.append(")");
        return builder.toString();
    }
}

