/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.reflect;

import com.google.auto.value.AutoValue;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.state.State;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_BundleMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_FieldAccessDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetInitialRestrictionMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetInitialWatermarkEstimatorStateMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetRestrictionCoderMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetSizeMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_GetWatermarkEstimatorStateCoderMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_LifecycleMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_NewTrackerMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_NewWatermarkEstimatorMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_OnTimerFamilyMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_OnTimerMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_OnWindowExpirationMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_BundleFinalizerParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_ElementParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_FinishBundleContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_KeyParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_OnTimerContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_OnWindowExpirationContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_OutputReceiverParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_PaneInfoParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_PipelineOptionsParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_ProcessContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_RestrictionParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_RestrictionTrackerParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_SchemaElementParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_SideInputParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_StartBundleContextParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_StateParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TaggedOutputReceiverParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimeDomainParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimerFamilyParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimerIdParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimerParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_TimestampParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_WatermarkEstimatorParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_WatermarkEstimatorStateParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_Parameter_WindowParameter;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_ProcessElementMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_SplitRestrictionMethod;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_StateDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_TimerDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_TimerFamilyDeclaration;
import org.apache.beam.sdk.transforms.reflect.AutoValue_DoFnSignature_TruncateRestrictionMethod;
import org.apache.beam.sdk.transforms.windowing.BoundedWindow;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Predicates;
import org.checkerframework.checker.nullness.qual.Nullable;

@AutoValue
@Internal
public abstract class DoFnSignature {
    public abstract Class<? extends DoFn<?, ?>> fnClass();

    public abstract PCollection.IsBounded isBoundedPerElement();

    public abstract ProcessElementMethod processElement();

    public abstract Map<String, StateDeclaration> stateDeclarations();

    public abstract @Nullable BundleMethod startBundle();

    public abstract @Nullable BundleMethod finishBundle();

    public abstract @Nullable LifecycleMethod setup();

    public abstract @Nullable LifecycleMethod teardown();

    public abstract @Nullable OnWindowExpirationMethod onWindowExpiration();

    public abstract Map<String, TimerDeclaration> timerDeclarations();

    public abstract Map<String, TimerFamilyDeclaration> timerFamilyDeclarations();

    public abstract @Nullable Map<String, FieldAccessDeclaration> fieldAccessDeclarations();

    public abstract @Nullable GetInitialRestrictionMethod getInitialRestriction();

    public abstract @Nullable SplitRestrictionMethod splitRestriction();

    public abstract @Nullable TruncateRestrictionMethod truncateRestriction();

    public abstract @Nullable GetRestrictionCoderMethod getRestrictionCoder();

    public abstract @Nullable GetWatermarkEstimatorStateCoderMethod getWatermarkEstimatorStateCoder();

    public abstract @Nullable GetInitialWatermarkEstimatorStateMethod getInitialWatermarkEstimatorState();

    public abstract @Nullable NewWatermarkEstimatorMethod newWatermarkEstimator();

    public abstract @Nullable NewTrackerMethod newTracker();

    public abstract @Nullable GetSizeMethod getSize();

    public abstract @Nullable Map<String, OnTimerMethod> onTimerMethods();

    public abstract @Nullable Map<String, OnTimerFamilyMethod> onTimerFamilyMethods();

    @Deprecated
    public boolean isStateful() {
        return this.stateDeclarations().size() > 0;
    }

    public boolean usesState() {
        return this.stateDeclarations().size() > 0;
    }

    public boolean usesTimers() {
        return this.timerDeclarations().size() > 0 || this.timerFamilyDeclarations().size() > 0;
    }

    static Builder builder() {
        return new AutoValue_DoFnSignature.Builder();
    }

    @AutoValue
    public static abstract class GetWatermarkEstimatorStateCoderMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> coderT();

        static GetWatermarkEstimatorStateCoderMethod create(Method targetMethod, TypeDescriptor<?> coderT) {
            return new AutoValue_DoFnSignature_GetWatermarkEstimatorStateCoderMethod(targetMethod, coderT);
        }
    }

    @AutoValue
    public static abstract class NewWatermarkEstimatorMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> watermarkEstimatorT();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static NewWatermarkEstimatorMethod create(Method targetMethod, TypeDescriptor<?> watermarkEstimatorT, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_NewWatermarkEstimatorMethod(targetMethod, watermarkEstimatorT, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class GetInitialWatermarkEstimatorStateMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> watermarkEstimatorStateT();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static GetInitialWatermarkEstimatorStateMethod create(Method targetMethod, TypeDescriptor<?> watermarkEstimatorStateT, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_GetInitialWatermarkEstimatorStateMethod(targetMethod, watermarkEstimatorStateT, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class GetRestrictionCoderMethod
    implements DoFnMethod {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> coderT();

        static GetRestrictionCoderMethod create(Method targetMethod, TypeDescriptor<?> coderT) {
            return new AutoValue_DoFnSignature_GetRestrictionCoderMethod(targetMethod, coderT);
        }
    }

    @AutoValue
    public static abstract class GetSizeMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static GetSizeMethod create(Method targetMethod, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_GetSizeMethod(targetMethod, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class NewTrackerMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> trackerT();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static NewTrackerMethod create(Method targetMethod, TypeDescriptor<?> trackerT, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_NewTrackerMethod(targetMethod, trackerT, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class TruncateRestrictionMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static TruncateRestrictionMethod create(Method targetMethod, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_TruncateRestrictionMethod(targetMethod, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class SplitRestrictionMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static SplitRestrictionMethod create(Method targetMethod, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_SplitRestrictionMethod(targetMethod, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class GetInitialRestrictionMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract TypeDescriptor<?> restrictionT();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static GetInitialRestrictionMethod create(Method targetMethod, TypeDescriptor<?> restrictionT, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_GetInitialRestrictionMethod(targetMethod, restrictionT, windowT, extraParameters);
        }
    }

    @AutoValue
    public static abstract class LifecycleMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract List<Parameter> extraParameters();

        static LifecycleMethod create(Method targetMethod, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_LifecycleMethod(null, targetMethod, extraParameters);
        }
    }

    @AutoValue
    public static abstract class FieldAccessDeclaration {
        public abstract String id();

        public abstract Field field();

        static FieldAccessDeclaration create(String id, Field field) {
            field.setAccessible(true);
            return new AutoValue_DoFnSignature_FieldAccessDeclaration(id, field);
        }
    }

    @AutoValue
    public static abstract class StateDeclaration {
        public abstract String id();

        public abstract Field field();

        public abstract TypeDescriptor<? extends State> stateType();

        static StateDeclaration create(String id, Field field, TypeDescriptor<? extends State> stateType) {
            field.setAccessible(true);
            return new AutoValue_DoFnSignature_StateDeclaration(id, field, stateType);
        }
    }

    @AutoValue
    public static abstract class BundleMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract List<Parameter> extraParameters();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        static BundleMethod create(Method targetMethod, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_BundleMethod(targetMethod, extraParameters, null);
        }
    }

    @AutoValue
    public static abstract class TimerFamilyDeclaration {
        public static final String PREFIX = "tfs-";

        public abstract String id();

        public abstract Field field();

        static TimerFamilyDeclaration create(String id, Field field) {
            return new AutoValue_DoFnSignature_TimerFamilyDeclaration(id, field);
        }
    }

    @AutoValue
    public static abstract class TimerDeclaration {
        public static final String PREFIX = "ts-";

        public abstract String id();

        public abstract Field field();

        static TimerDeclaration create(String id, Field field) {
            return new AutoValue_DoFnSignature_TimerDeclaration(id, field);
        }
    }

    @AutoValue
    public static abstract class OnWindowExpirationMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        public abstract boolean requiresStableInput();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static OnWindowExpirationMethod create(Method targetMethod, boolean requiresStableInput, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_OnWindowExpirationMethod(targetMethod, requiresStableInput, windowT, Collections.unmodifiableList(extraParameters));
        }
    }

    @AutoValue
    public static abstract class OnTimerFamilyMethod
    implements MethodWithExtraParameters {
        public abstract String id();

        @Override
        public abstract Method targetMethod();

        public abstract boolean requiresStableInput();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static OnTimerFamilyMethod create(Method targetMethod, String id, boolean requiresStableInput, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_OnTimerFamilyMethod(id, targetMethod, requiresStableInput, windowT, Collections.unmodifiableList(extraParameters));
        }
    }

    @AutoValue
    public static abstract class OnTimerMethod
    implements MethodWithExtraParameters {
        public abstract String id();

        @Override
        public abstract Method targetMethod();

        public abstract boolean requiresStableInput();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        @Override
        public abstract List<Parameter> extraParameters();

        static OnTimerMethod create(Method targetMethod, String id, boolean requiresStableInput, TypeDescriptor<? extends BoundedWindow> windowT, List<Parameter> extraParameters) {
            return new AutoValue_DoFnSignature_OnTimerMethod(id, targetMethod, requiresStableInput, windowT, Collections.unmodifiableList(extraParameters));
        }
    }

    @AutoValue
    public static abstract class ProcessElementMethod
    implements MethodWithExtraParameters {
        @Override
        public abstract Method targetMethod();

        @Override
        public abstract List<Parameter> extraParameters();

        public abstract boolean requiresStableInput();

        public abstract boolean requiresTimeSortedInput();

        public abstract @Nullable TypeDescriptor<?> trackerT();

        public abstract @Nullable TypeDescriptor<?> watermarkEstimatorT();

        @Override
        public abstract @Nullable TypeDescriptor<? extends BoundedWindow> windowT();

        public abstract boolean hasReturnValue();

        static ProcessElementMethod create(Method targetMethod, List<Parameter> extraParameters, boolean requiresStableInput, boolean requiresTimeSortedInput, TypeDescriptor<?> trackerT, TypeDescriptor<?> watermarkEstimatorT, @Nullable TypeDescriptor<? extends BoundedWindow> windowT, boolean hasReturnValue) {
            return new AutoValue_DoFnSignature_ProcessElementMethod(targetMethod, Collections.unmodifiableList(extraParameters), requiresStableInput, requiresTimeSortedInput, trackerT, watermarkEstimatorT, windowT, hasReturnValue);
        }

        public @Nullable List<Parameter.SchemaElementParameter> getSchemaElementParameters() {
            return this.extraParameters().stream().filter(Predicates.instanceOf(Parameter.SchemaElementParameter.class)::apply).map(Parameter.SchemaElementParameter.class::cast).collect(Collectors.toList());
        }

        public @Nullable List<Parameter.SideInputParameter> getSideInputParameters() {
            return this.extraParameters().stream().filter(Predicates.instanceOf(Parameter.SideInputParameter.class)::apply).map(Parameter.SideInputParameter.class::cast).collect(Collectors.toList());
        }

        public @Nullable Parameter.OutputReceiverParameter getMainOutputReceiver() {
            Optional<Parameter> parameter = this.extraParameters().stream().filter(Predicates.instanceOf(Parameter.OutputReceiverParameter.class)::apply).findFirst();
            return parameter.isPresent() ? (Parameter.OutputReceiverParameter)parameter.get() : null;
        }

        public boolean isSplittable() {
            return this.extraParameters().stream().anyMatch(Predicates.instanceOf(Parameter.RestrictionTrackerParameter.class)::apply);
        }
    }

    public static abstract class Parameter {
        private static final StartBundleContextParameter START_BUNDLE_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_StartBundleContextParameter();
        private static final FinishBundleContextParameter FINISH_BUNDLE_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_FinishBundleContextParameter();
        private static final ProcessContextParameter PROCESS_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_ProcessContextParameter();
        private static final OnTimerContextParameter ON_TIMER_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_OnTimerContextParameter();
        private static final TimestampParameter TIMESTAMP_PARAMETER = new AutoValue_DoFnSignature_Parameter_TimestampParameter();
        private static final TimerIdParameter TIMER_ID_PARAMETER = new AutoValue_DoFnSignature_Parameter_TimerIdParameter();
        private static final PaneInfoParameter PANE_INFO_PARAMETER = new AutoValue_DoFnSignature_Parameter_PaneInfoParameter();
        private static final TimeDomainParameter TIME_DOMAIN_PARAMETER = new AutoValue_DoFnSignature_Parameter_TimeDomainParameter();
        private static final TaggedOutputReceiverParameter TAGGED_OUTPUT_RECEIVER_PARAMETER = new AutoValue_DoFnSignature_Parameter_TaggedOutputReceiverParameter();
        private static final PipelineOptionsParameter PIPELINE_OPTIONS_PARAMETER = new AutoValue_DoFnSignature_Parameter_PipelineOptionsParameter();
        private static final BundleFinalizerParameter BUNDLE_FINALIZER_PARAMETER = new AutoValue_DoFnSignature_Parameter_BundleFinalizerParameter();
        private static final OnWindowExpirationContextParameter ON_WINDOW_EXPIRATION_CONTEXT_PARAMETER = new AutoValue_DoFnSignature_Parameter_OnWindowExpirationContextParameter();

        private Parameter() {
        }

        public <ResultT> ResultT match(Cases<ResultT> cases) {
            if (this instanceof StartBundleContextParameter) {
                return cases.dispatch((StartBundleContextParameter)this);
            }
            if (this instanceof FinishBundleContextParameter) {
                return cases.dispatch((FinishBundleContextParameter)this);
            }
            if (this instanceof ProcessContextParameter) {
                return cases.dispatch((ProcessContextParameter)this);
            }
            if (this instanceof OnTimerContextParameter) {
                return cases.dispatch((OnTimerContextParameter)this);
            }
            if (this instanceof WindowParameter) {
                return cases.dispatch((WindowParameter)this);
            }
            if (this instanceof PaneInfoParameter) {
                return cases.dispatch((PaneInfoParameter)this);
            }
            if (this instanceof RestrictionParameter) {
                return cases.dispatch((RestrictionParameter)this);
            }
            if (this instanceof RestrictionTrackerParameter) {
                return cases.dispatch((RestrictionTrackerParameter)this);
            }
            if (this instanceof WatermarkEstimatorParameter) {
                return cases.dispatch((WatermarkEstimatorParameter)this);
            }
            if (this instanceof WatermarkEstimatorStateParameter) {
                return cases.dispatch((WatermarkEstimatorStateParameter)this);
            }
            if (this instanceof StateParameter) {
                return cases.dispatch((StateParameter)this);
            }
            if (this instanceof TimerParameter) {
                return cases.dispatch((TimerParameter)this);
            }
            if (this instanceof PipelineOptionsParameter) {
                return cases.dispatch((PipelineOptionsParameter)this);
            }
            if (this instanceof ElementParameter) {
                return cases.dispatch((ElementParameter)this);
            }
            if (this instanceof SchemaElementParameter) {
                return cases.dispatch((SchemaElementParameter)this);
            }
            if (this instanceof TimestampParameter) {
                return cases.dispatch((TimestampParameter)this);
            }
            if (this instanceof OutputReceiverParameter) {
                return cases.dispatch((OutputReceiverParameter)this);
            }
            if (this instanceof TaggedOutputReceiverParameter) {
                return cases.dispatch((TaggedOutputReceiverParameter)this);
            }
            if (this instanceof TimeDomainParameter) {
                return cases.dispatch((TimeDomainParameter)this);
            }
            if (this instanceof SideInputParameter) {
                return cases.dispatch((SideInputParameter)this);
            }
            if (this instanceof TimerFamilyParameter) {
                return cases.dispatch((TimerFamilyParameter)this);
            }
            if (this instanceof TimerIdParameter) {
                return cases.dispatch((TimerIdParameter)this);
            }
            if (this instanceof BundleFinalizerParameter) {
                return cases.dispatch((BundleFinalizerParameter)this);
            }
            if (this instanceof KeyParameter) {
                return cases.dispatch((KeyParameter)this);
            }
            throw new IllegalStateException(String.format("Attempt to case match on unknown %s subclass %s", Parameter.class.getCanonicalName(), this.getClass().getCanonicalName()));
        }

        public static ProcessContextParameter processContext() {
            return PROCESS_CONTEXT_PARAMETER;
        }

        public static StartBundleContextParameter startBundleContext() {
            return START_BUNDLE_CONTEXT_PARAMETER;
        }

        public static FinishBundleContextParameter finishBundleContext() {
            return FINISH_BUNDLE_CONTEXT_PARAMETER;
        }

        public static BundleFinalizerParameter bundleFinalizer() {
            return BUNDLE_FINALIZER_PARAMETER;
        }

        public static ElementParameter elementParameter(TypeDescriptor<?> elementT) {
            return new AutoValue_DoFnSignature_Parameter_ElementParameter(elementT);
        }

        public static SchemaElementParameter schemaElementParameter(TypeDescriptor<?> elementT, @Nullable String fieldAccessString, int index) {
            return new AutoValue_DoFnSignature_Parameter_SchemaElementParameter.Builder().setElementT(elementT).setFieldAccessString(fieldAccessString).setIndex(index).build();
        }

        public static TimestampParameter timestampParameter() {
            return TIMESTAMP_PARAMETER;
        }

        public static TimerIdParameter timerIdParameter() {
            return TIMER_ID_PARAMETER;
        }

        public static SideInputParameter sideInputParameter(TypeDescriptor<?> elementT, String sideInputId) {
            return new AutoValue_DoFnSignature_Parameter_SideInputParameter.Builder().setElementT(elementT).setSideInputId(sideInputId).build();
        }

        public static TimeDomainParameter timeDomainParameter() {
            return TIME_DOMAIN_PARAMETER;
        }

        public static OutputReceiverParameter outputReceiverParameter(boolean rowReceiver) {
            return new AutoValue_DoFnSignature_Parameter_OutputReceiverParameter(rowReceiver);
        }

        public static TaggedOutputReceiverParameter taggedOutputReceiverParameter() {
            return TAGGED_OUTPUT_RECEIVER_PARAMETER;
        }

        public static OnTimerContextParameter onTimerContext() {
            return ON_TIMER_CONTEXT_PARAMETER;
        }

        public static OnWindowExpirationContextParameter onWindowExpirationContext() {
            return ON_WINDOW_EXPIRATION_CONTEXT_PARAMETER;
        }

        public static PaneInfoParameter paneInfoParameter() {
            return PANE_INFO_PARAMETER;
        }

        public static WindowParameter boundedWindow(TypeDescriptor<? extends BoundedWindow> windowT) {
            return new AutoValue_DoFnSignature_Parameter_WindowParameter(windowT);
        }

        public static KeyParameter keyT(TypeDescriptor<?> keyT) {
            return new AutoValue_DoFnSignature_Parameter_KeyParameter(keyT);
        }

        public static PipelineOptionsParameter pipelineOptions() {
            return PIPELINE_OPTIONS_PARAMETER;
        }

        public static RestrictionParameter restrictionParameter(TypeDescriptor<?> restrictionT) {
            return new AutoValue_DoFnSignature_Parameter_RestrictionParameter(restrictionT);
        }

        public static RestrictionTrackerParameter restrictionTracker(TypeDescriptor<?> trackerT) {
            return new AutoValue_DoFnSignature_Parameter_RestrictionTrackerParameter(trackerT);
        }

        public static WatermarkEstimatorParameter watermarkEstimator(TypeDescriptor<?> watermarkEstimatorT) {
            return new AutoValue_DoFnSignature_Parameter_WatermarkEstimatorParameter(watermarkEstimatorT);
        }

        public static WatermarkEstimatorStateParameter watermarkEstimatorState(TypeDescriptor<?> watermarkEstimatorStateT) {
            return new AutoValue_DoFnSignature_Parameter_WatermarkEstimatorStateParameter(watermarkEstimatorStateT);
        }

        public static StateParameter stateParameter(StateDeclaration decl, boolean alwaysFetched) {
            return new AutoValue_DoFnSignature_Parameter_StateParameter(decl, alwaysFetched);
        }

        public static TimerParameter timerParameter(TimerDeclaration decl) {
            return new AutoValue_DoFnSignature_Parameter_TimerParameter(decl);
        }

        public static TimerFamilyParameter timerFamilyParameter(TimerFamilyDeclaration decl) {
            return new AutoValue_DoFnSignature_Parameter_TimerFamilyParameter(decl);
        }

        @AutoValue
        public static abstract class TimerFamilyParameter
        extends Parameter {
            TimerFamilyParameter() {
            }

            public abstract TimerFamilyDeclaration referent();
        }

        @AutoValue
        public static abstract class TimerParameter
        extends Parameter {
            TimerParameter() {
            }

            public abstract TimerDeclaration referent();
        }

        @AutoValue
        public static abstract class StateParameter
        extends Parameter {
            StateParameter() {
            }

            public abstract StateDeclaration referent();

            public abstract boolean alwaysFetched();
        }

        @AutoValue
        public static abstract class RestrictionTrackerParameter
        extends Parameter {
            RestrictionTrackerParameter() {
            }

            public abstract TypeDescriptor<?> trackerT();
        }

        @AutoValue
        public static abstract class WatermarkEstimatorParameter
        extends Parameter {
            WatermarkEstimatorParameter() {
            }

            public abstract TypeDescriptor<?> estimatorT();
        }

        @AutoValue
        public static abstract class WatermarkEstimatorStateParameter
        extends Parameter {
            WatermarkEstimatorStateParameter() {
            }

            public abstract TypeDescriptor<?> estimatorStateT();
        }

        @AutoValue
        public static abstract class RestrictionParameter
        extends Parameter {
            RestrictionParameter() {
            }

            public abstract TypeDescriptor<?> restrictionT();
        }

        @AutoValue
        public static abstract class PaneInfoParameter
        extends Parameter {
            PaneInfoParameter() {
            }
        }

        @AutoValue
        public static abstract class WindowParameter
        extends Parameter {
            WindowParameter() {
            }

            public abstract TypeDescriptor<? extends BoundedWindow> windowT();
        }

        @AutoValue
        public static abstract class OnWindowExpirationContextParameter
        extends Parameter {
            OnWindowExpirationContextParameter() {
            }
        }

        @AutoValue
        public static abstract class OnTimerContextParameter
        extends Parameter {
            OnTimerContextParameter() {
            }
        }

        @AutoValue
        public static abstract class TaggedOutputReceiverParameter
        extends Parameter {
            TaggedOutputReceiverParameter() {
            }
        }

        @AutoValue
        public static abstract class OutputReceiverParameter
        extends Parameter {
            OutputReceiverParameter() {
            }

            public abstract boolean isRowReceiver();
        }

        @AutoValue
        public static abstract class SideInputParameter
        extends Parameter {
            SideInputParameter() {
            }

            public abstract TypeDescriptor<?> elementT();

            public abstract String sideInputId();

            public abstract Builder toBuilder();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setElementT(TypeDescriptor<?> var1);

                public abstract Builder setSideInputId(String var1);

                public abstract SideInputParameter build();
            }
        }

        @AutoValue
        public static abstract class TimeDomainParameter
        extends Parameter {
            TimeDomainParameter() {
            }
        }

        @AutoValue
        public static abstract class KeyParameter
        extends Parameter {
            KeyParameter() {
            }

            public abstract TypeDescriptor<?> keyT();
        }

        @AutoValue
        public static abstract class TimerIdParameter
        extends Parameter {
            TimerIdParameter() {
            }
        }

        @AutoValue
        public static abstract class TimestampParameter
        extends Parameter {
            TimestampParameter() {
            }
        }

        @AutoValue
        public static abstract class SchemaElementParameter
        extends Parameter {
            SchemaElementParameter() {
            }

            public abstract TypeDescriptor<?> elementT();

            public abstract @Nullable String fieldAccessString();

            public abstract int index();

            public abstract Builder toBuilder();

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setElementT(TypeDescriptor<?> var1);

                public abstract Builder setFieldAccessString(@Nullable String var1);

                public abstract Builder setIndex(int var1);

                public abstract SchemaElementParameter build();
            }
        }

        @AutoValue
        public static abstract class ElementParameter
        extends Parameter {
            ElementParameter() {
            }

            public abstract TypeDescriptor<?> elementT();
        }

        @AutoValue
        public static abstract class BundleFinalizerParameter
        extends Parameter {
            BundleFinalizerParameter() {
            }
        }

        @AutoValue
        public static abstract class ProcessContextParameter
        extends Parameter {
            ProcessContextParameter() {
            }
        }

        @AutoValue
        public static abstract class FinishBundleContextParameter
        extends Parameter {
            FinishBundleContextParameter() {
            }
        }

        @AutoValue
        public static abstract class StartBundleContextParameter
        extends Parameter {
            StartBundleContextParameter() {
            }
        }

        @AutoValue
        public static abstract class PipelineOptionsParameter
        extends Parameter {
            PipelineOptionsParameter() {
            }
        }

        public static interface Cases<ResultT> {
            public ResultT dispatch(StartBundleContextParameter var1);

            public ResultT dispatch(FinishBundleContextParameter var1);

            public ResultT dispatch(ProcessContextParameter var1);

            public ResultT dispatch(ElementParameter var1);

            public ResultT dispatch(SchemaElementParameter var1);

            public ResultT dispatch(TimestampParameter var1);

            public ResultT dispatch(TimeDomainParameter var1);

            public ResultT dispatch(OutputReceiverParameter var1);

            public ResultT dispatch(TaggedOutputReceiverParameter var1);

            public ResultT dispatch(OnTimerContextParameter var1);

            public ResultT dispatch(WindowParameter var1);

            public ResultT dispatch(PaneInfoParameter var1);

            public ResultT dispatch(RestrictionParameter var1);

            public ResultT dispatch(RestrictionTrackerParameter var1);

            public ResultT dispatch(WatermarkEstimatorParameter var1);

            public ResultT dispatch(WatermarkEstimatorStateParameter var1);

            public ResultT dispatch(StateParameter var1);

            public ResultT dispatch(TimerParameter var1);

            public ResultT dispatch(PipelineOptionsParameter var1);

            public ResultT dispatch(SideInputParameter var1);

            public ResultT dispatch(TimerFamilyParameter var1);

            public ResultT dispatch(TimerIdParameter var1);

            public ResultT dispatch(BundleFinalizerParameter var1);

            public ResultT dispatch(KeyParameter var1);

            public static abstract class WithDefault<ResultT>
            implements Cases<ResultT> {
                protected abstract ResultT dispatchDefault(Parameter var1);

                @Override
                public ResultT dispatch(StartBundleContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(FinishBundleContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(ProcessContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(ElementParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(SchemaElementParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TaggedOutputReceiverParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(OutputReceiverParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimestampParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimerIdParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimeDomainParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(OnTimerContextParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(WindowParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(PaneInfoParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(RestrictionParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(RestrictionTrackerParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(WatermarkEstimatorParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(WatermarkEstimatorStateParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(BundleFinalizerParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(StateParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimerParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(PipelineOptionsParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(SideInputParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(TimerFamilyParameter p) {
                    return this.dispatchDefault(p);
                }

                @Override
                public ResultT dispatch(KeyParameter p) {
                    return this.dispatchDefault(p);
                }
            }
        }
    }

    public static interface MethodWithExtraParameters
    extends DoFnMethod {
        public List<Parameter> extraParameters();

        default public boolean observesWindow() {
            return this.extraParameters().stream().anyMatch(Predicates.or(Predicates.instanceOf(Parameter.WindowParameter.class), Predicates.instanceOf(Parameter.TimerParameter.class), Predicates.instanceOf(Parameter.TimerFamilyParameter.class), Predicates.instanceOf(Parameter.StateParameter.class), Predicates.instanceOf(Parameter.SideInputParameter.class))::apply);
        }

        public @Nullable TypeDescriptor<? extends BoundedWindow> windowT();
    }

    public static interface DoFnMethod {
        public Method targetMethod();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setFnClass(Class<? extends DoFn<?, ?>> var1);

        abstract Builder setIsBoundedPerElement(PCollection.IsBounded var1);

        abstract Builder setProcessElement(ProcessElementMethod var1);

        abstract Builder setStartBundle(BundleMethod var1);

        abstract Builder setFinishBundle(BundleMethod var1);

        abstract Builder setSetup(LifecycleMethod var1);

        abstract Builder setTeardown(LifecycleMethod var1);

        abstract Builder setOnWindowExpiration(OnWindowExpirationMethod var1);

        abstract Builder setGetInitialRestriction(GetInitialRestrictionMethod var1);

        abstract Builder setSplitRestriction(SplitRestrictionMethod var1);

        abstract Builder setTruncateRestriction(TruncateRestrictionMethod var1);

        abstract Builder setGetRestrictionCoder(GetRestrictionCoderMethod var1);

        abstract Builder setNewTracker(NewTrackerMethod var1);

        abstract Builder setGetSize(GetSizeMethod var1);

        abstract Builder setGetInitialWatermarkEstimatorState(GetInitialWatermarkEstimatorStateMethod var1);

        abstract Builder setNewWatermarkEstimator(NewWatermarkEstimatorMethod var1);

        abstract Builder setGetWatermarkEstimatorStateCoder(GetWatermarkEstimatorStateCoderMethod var1);

        abstract Builder setStateDeclarations(Map<String, StateDeclaration> var1);

        abstract Builder setTimerDeclarations(Map<String, TimerDeclaration> var1);

        abstract Builder setTimerFamilyDeclarations(Map<String, TimerFamilyDeclaration> var1);

        abstract Builder setFieldAccessDeclarations(Map<String, FieldAccessDeclaration> var1);

        abstract Builder setOnTimerMethods(Map<String, OnTimerMethod> var1);

        abstract Builder setOnTimerFamilyMethods(Map<String, OnTimerFamilyMethod> var1);

        abstract DoFnSignature build();
    }
}

