/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms.join;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.CustomCoder;
import org.apache.beam.sdk.coders.IterableCoder;
import org.apache.beam.sdk.transforms.join.CoGbkResultSchema;
import org.apache.beam.sdk.transforms.join.RawUnionValue;
import org.apache.beam.sdk.transforms.join.UnionCoder;
import org.apache.beam.sdk.util.common.Reiterator;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterators;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoGbkResult {
    private final List<Iterable<?>> valueMap;
    private final CoGbkResultSchema schema;
    private static final int DEFAULT_IN_MEMORY_ELEMENT_COUNT = 10000;
    private static final int DEFAULT_MIN_ELEMENTS_PER_TAG = 100;
    private static final Logger LOG = LoggerFactory.getLogger(CoGbkResult.class);
    private int nextTestUnionId = 0;

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues) {
        this(schema, taggedValues, 10000, 100);
    }

    public CoGbkResult(CoGbkResultSchema schema, Iterable<RawUnionValue> taggedValues, int inMemoryElementCount, int minElementsPerTag) {
        this.schema = schema;
        ArrayList valuesByTag = new ArrayList();
        for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
            valuesByTag.add(new ArrayList());
        }
        Iterator<RawUnionValue> taggedIter = taggedValues.iterator();
        int elementCount = 0;
        while (taggedIter.hasNext() && (elementCount++ < inMemoryElementCount || !(taggedIter instanceof Reiterator))) {
            RawUnionValue value = taggedIter.next();
            int unionTag = value.getUnionTag();
            if (schema.size() <= unionTag) {
                throw new IllegalStateException("union tag " + unionTag + " has no corresponding tuple tag in the result schema");
            }
            ((List)valuesByTag.get(unionTag)).add(value.getValue());
        }
        if (!taggedIter.hasNext()) {
            this.valueMap = valuesByTag;
            return;
        }
        LOG.info("CoGbkResult has more than {} elements, reiteration (which may be slow) is required.", (Object)inMemoryElementCount);
        Reiterator tail = (Reiterator)taggedIter;
        ObservingReiterator<RawUnionValue> tip = new ObservingReiterator<RawUnionValue>(tail, new ObservingReiterator.Observer<RawUnionValue>(){

            @Override
            public void observeAt(ObservingReiterator<RawUnionValue> reiterator) {
                ((TagIterable)CoGbkResult.this.valueMap.get(reiterator.peek().getUnionTag())).offer(reiterator);
            }

            @Override
            public void done() {
                for (Iterable iter : CoGbkResult.this.valueMap) {
                    ((TagIterable)iter).finish();
                }
            }
        });
        this.valueMap = new ArrayList();
        for (int unionTag = 0; unionTag < schema.size(); ++unionTag) {
            this.valueMap.add(new TagIterable((List)valuesByTag.get(unionTag), unionTag, minElementsPerTag, tip));
        }
    }

    public boolean isEmpty() {
        for (Iterable<?> tagValues : this.valueMap) {
            if (!tagValues.iterator().hasNext()) continue;
            return false;
        }
        return true;
    }

    public CoGbkResultSchema getSchema() {
        return this.schema;
    }

    public String toString() {
        return this.valueMap.toString();
    }

    public <V> Iterable<V> getAll(TupleTag<V> tag) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterable<?> unions = this.valueMap.get(index);
        return unions;
    }

    public <V> Iterable<V> getAll(String tag) {
        return this.getAll(new TupleTag(tag));
    }

    public <V> V getOnly(TupleTag<V> tag) {
        return this.innerGetOnly(tag, null, false);
    }

    public <V> V getOnly(String tag) {
        return this.getOnly(new TupleTag(tag));
    }

    public <V> @Nullable V getOnly(TupleTag<V> tag, @Nullable V defaultValue) {
        return this.innerGetOnly(tag, defaultValue, true);
    }

    public <V> @Nullable V getOnly(String tag, @Nullable V defaultValue) {
        return this.getOnly(new TupleTag(tag), defaultValue);
    }

    public static <V> CoGbkResult of(TupleTag<V> tag, List<V> data) {
        return CoGbkResult.empty().and(tag, data);
    }

    public <V> CoGbkResult and(TupleTag<V> tag, List<V> data) {
        if (this.nextTestUnionId != this.schema.size()) {
            throw new IllegalArgumentException("Attempting to call and() on a CoGbkResult apparently not created by of().");
        }
        ArrayList valueMap = new ArrayList(this.valueMap);
        valueMap.add(data);
        return new CoGbkResult(new CoGbkResultSchema(this.schema.getTupleTagList().and(tag)), valueMap, this.nextTestUnionId + 1);
    }

    public static <V> CoGbkResult empty() {
        return new CoGbkResult(new CoGbkResultSchema(TupleTagList.empty()), new ArrayList());
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap, int nextTestUnionId) {
        this(schema, valueMap);
        this.nextTestUnionId = nextTestUnionId;
    }

    private CoGbkResult(CoGbkResultSchema schema, List<Iterable<?>> valueMap) {
        this.schema = schema;
        this.valueMap = valueMap;
    }

    private <V> @Nullable V innerGetOnly(TupleTag<V> tag, @Nullable V defaultValue, boolean useDefault) {
        int index = this.schema.getIndex(tag);
        if (index < 0) {
            throw new IllegalArgumentException("TupleTag " + tag + " is not in the schema");
        }
        Iterator<?> unions = this.valueMap.get(index).iterator();
        if (!unions.hasNext()) {
            if (useDefault) {
                return defaultValue;
            }
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to an empty result, and no default was provided");
        }
        Object value = unions.next();
        if (unions.hasNext()) {
            throw new IllegalArgumentException("TupleTag " + tag + " corresponds to a non-singleton result");
        }
        return (V)value;
    }

    private static class TagIterable<T>
    implements Iterable<T> {
        int tag;
        int cacheSize;
        ObservingReiterator<RawUnionValue> tip;
        List<T> head;
        Reiterator<RawUnionValue> tail;
        boolean finished;

        public TagIterable(List<T> head, int tag, int cacheSize, ObservingReiterator<RawUnionValue> tip) {
            this.tag = tag;
            this.cacheSize = cacheSize;
            this.head = head;
            this.tip = tip;
        }

        void offer(ObservingReiterator<RawUnionValue> tail) {
            assert (!this.finished);
            assert (tail.peek().getUnionTag() == this.tag);
            if (this.head.size() < this.cacheSize) {
                this.head.add(tail.peek().getValue());
            } else if (this.tail == null) {
                this.tail = tail.copy();
            }
        }

        void finish() {
            this.finished = true;
        }

        void seek(int tag) {
            while (this.tip.hasNext() && this.tip.peek().getUnionTag() != tag) {
                this.tip.next();
            }
        }

        @Override
        public Iterator<T> iterator() {
            return new Iterator<T>(){
                boolean isDone;
                boolean advanced;
                T next;
                int index = -1;
                Iterator<T> tailIter;

                @Override
                public boolean hasNext() {
                    if (!this.advanced) {
                        this.advance();
                    }
                    return !this.isDone;
                }

                @Override
                public T next() {
                    if (!this.advanced) {
                        this.advance();
                    }
                    if (this.isDone) {
                        throw new NoSuchElementException();
                    }
                    this.advanced = false;
                    return this.next;
                }

                private void advance() {
                    assert (!this.advanced);
                    assert (!this.isDone);
                    this.advanced = true;
                    ++this.index;
                    if (this.maybeAdvance()) {
                        return;
                    }
                    tip.fastForward();
                    if (tip.hasNext()) {
                        tip.next();
                        this.seek(tag);
                    }
                    assert (this.maybeAdvance());
                }

                private boolean maybeAdvance() {
                    if (this.index < head.size()) {
                        assert (this.tailIter == null);
                        this.next = head.get(this.index);
                        return true;
                    }
                    if (tail != null) {
                        if (this.tailIter == null) {
                            this.tailIter = Iterators.transform(Iterators.filter(tail.copy(), taggedUnion -> taggedUnion.getUnionTag() == tag), taggedUnion -> taggedUnion.getValue());
                        }
                        if (this.tailIter.hasNext()) {
                            this.next = this.tailIter.next();
                        } else {
                            this.isDone = true;
                        }
                        return true;
                    }
                    if (finished) {
                        this.isDone = true;
                        return true;
                    }
                    return false;
                }
            };
        }
    }

    private static class PeekingReiterator<T>
    implements Reiterator<T> {
        private Reiterator<T> underlying;
        private T next;
        private boolean nextIsValid;

        public PeekingReiterator(Reiterator<T> underlying) {
            this(underlying, null, false);
        }

        private PeekingReiterator(Reiterator<T> underlying, T next, boolean nextIsValid) {
            this.underlying = underlying;
            this.next = next;
            this.nextIsValid = nextIsValid;
        }

        @Override
        public PeekingReiterator<T> copy() {
            return new PeekingReiterator<T>(this.underlying.copy(), this.next, this.nextIsValid);
        }

        @Override
        public boolean hasNext() {
            return this.nextIsValid || this.underlying.hasNext();
        }

        @Override
        public T next() {
            if (this.nextIsValid) {
                this.nextIsValid = false;
                return this.next;
            }
            return (T)this.underlying.next();
        }

        public T peek() {
            if (!this.nextIsValid) {
                this.next = this.underlying.next();
                this.nextIsValid = true;
            }
            return this.next;
        }
    }

    private static class IndexingReiterator<T>
    implements Reiterator<Indexed<T>> {
        private Reiterator<T> underlying;
        private int index;

        public IndexingReiterator(Reiterator<T> underlying) {
            this(underlying, 0);
        }

        public IndexingReiterator(Reiterator<T> underlying, int start) {
            this.underlying = underlying;
            this.index = start;
        }

        @Override
        public IndexingReiterator<T> copy() {
            return new IndexingReiterator<T>(this.underlying.copy(), this.index);
        }

        @Override
        public boolean hasNext() {
            return this.underlying.hasNext();
        }

        @Override
        public Indexed<T> next() {
            return new Indexed(this.index++, this.underlying.next());
        }

        public static class Indexed<T> {
            public final int index;
            public final T value;

            public Indexed(int index, T value) {
                this.index = index;
                this.value = value;
            }
        }
    }

    private static class ObservingReiterator<T>
    implements Reiterator<T> {
        private PeekingReiterator<IndexingReiterator.Indexed<T>> underlying;
        private Observer<T> observer;
        private final int[] lastObserved;
        private final boolean[] doneHasRun;
        private final PeekingReiterator[] mostAdvanced;

        public ObservingReiterator(Reiterator<T> underlying, Observer<T> observer) {
            this(new PeekingReiterator<IndexingReiterator.Indexed<T>>(new IndexingReiterator<T>(underlying)), observer);
        }

        public ObservingReiterator(PeekingReiterator<IndexingReiterator.Indexed<T>> underlying, Observer<T> observer) {
            this(underlying, observer, new int[]{-1}, new boolean[]{false}, new PeekingReiterator[]{underlying});
        }

        private ObservingReiterator(PeekingReiterator<IndexingReiterator.Indexed<T>> underlying, Observer<T> observer, int[] lastObserved, boolean[] doneHasRun, PeekingReiterator[] mostAdvanced) {
            this.underlying = underlying;
            this.observer = observer;
            this.lastObserved = lastObserved;
            this.doneHasRun = doneHasRun;
            this.mostAdvanced = mostAdvanced;
        }

        @Override
        public Reiterator<T> copy() {
            return new ObservingReiterator<T>(this.underlying.copy(), this.observer, this.lastObserved, this.doneHasRun, this.mostAdvanced);
        }

        @Override
        public boolean hasNext() {
            boolean hasNext = this.underlying.hasNext();
            if (!hasNext && !this.doneHasRun[0]) {
                this.mostAdvanced[0] = this.underlying;
                this.observer.done();
                this.doneHasRun[0] = true;
            }
            return hasNext;
        }

        @Override
        public T next() {
            this.peek();
            return this.underlying.next().value;
        }

        public T peek() {
            IndexingReiterator.Indexed<T> next = this.underlying.peek();
            if (next.index > this.lastObserved[0]) {
                assert (next.index == this.lastObserved[0] + 1);
                this.mostAdvanced[0] = this.underlying;
                this.lastObserved[0] = next.index;
                this.observer.observeAt(this);
            }
            return next.value;
        }

        public void fastForward() {
            if (this.underlying != this.mostAdvanced[0]) {
                this.underlying = this.mostAdvanced[0].copy();
            }
        }

        public static interface Observer<T> {
            public void observeAt(ObservingReiterator<T> var1);

            public void done();
        }
    }

    public static class CoGbkResultCoder
    extends CustomCoder<CoGbkResult> {
        private final CoGbkResultSchema schema;
        private final UnionCoder unionCoder;

        public static CoGbkResultCoder of(CoGbkResultSchema schema, UnionCoder unionCoder) {
            return new CoGbkResultCoder(schema, unionCoder);
        }

        private CoGbkResultCoder(CoGbkResultSchema tupleTags, UnionCoder unionCoder) {
            this.schema = tupleTags;
            this.unionCoder = unionCoder;
        }

        @Override
        public List<? extends Coder<?>> getCoderArguments() {
            return ImmutableList.of(this.unionCoder);
        }

        public CoGbkResultSchema getSchema() {
            return this.schema;
        }

        public UnionCoder getUnionCoder() {
            return this.unionCoder;
        }

        @Override
        public void encode(CoGbkResult value, OutputStream outStream) throws CoderException, IOException {
            if (!this.schema.equals(value.getSchema())) {
                throw new CoderException("input schema does not match coder schema");
            }
            if (this.schema.size() == 0) {
                return;
            }
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                this.tagListCoder(unionTag).encode((Iterable)value.valueMap.get(unionTag), outStream);
            }
        }

        @Override
        public CoGbkResult decode(InputStream inStream) throws CoderException, IOException {
            if (this.schema.size() == 0) {
                return new CoGbkResult(this.schema, ImmutableList.of());
            }
            ArrayList<Object> valueMap = Lists.newArrayListWithExpectedSize(this.schema.size());
            for (int unionTag = 0; unionTag < this.schema.size(); ++unionTag) {
                valueMap.add(this.tagListCoder(unionTag).decode(inStream));
            }
            return new CoGbkResult(this.schema, valueMap);
        }

        private IterableCoder tagListCoder(int unionTag) {
            return IterableCoder.of(this.unionCoder.getElementCoders().get(unionTag));
        }

        public boolean equals(@Nullable Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof CoGbkResultCoder)) {
                return false;
            }
            CoGbkResultCoder other = (CoGbkResultCoder)object;
            return this.schema.equals(other.schema) && this.unionCoder.equals(other.unionCoder);
        }

        public int hashCode() {
            return Objects.hashCode(this.schema);
        }

        @Override
        public void verifyDeterministic() throws Coder.NonDeterministicException {
            CoGbkResultCoder.verifyDeterministic(this, "CoGbkResult requires the union coder to be deterministic", this.unionCoder);
        }
    }
}

