/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;

public final class ToString {
    private ToString() {
    }

    public static PTransform<PCollection<?>, PCollection<String>> elements() {
        return new Elements();
    }

    public static PTransform<PCollection<? extends KV<?, ?>>, PCollection<String>> kvs() {
        return ToString.kvs(",");
    }

    public static PTransform<PCollection<? extends KV<?, ?>>, PCollection<String>> kvs(String delimiter) {
        return new KVs(delimiter);
    }

    public static PTransform<PCollection<? extends Iterable<?>>, PCollection<String>> iterables() {
        return ToString.iterables(",");
    }

    public static PTransform<PCollection<? extends Iterable<?>>, PCollection<String>> iterables(String delimiter) {
        return new Iterables(delimiter);
    }

    private static final class Iterables
    extends PTransform<PCollection<? extends Iterable<?>>, PCollection<String>> {
        private final String delimiter;

        public Iterables(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public PCollection<String> expand(PCollection<? extends Iterable<?>> input) {
            return (PCollection)input.apply(MapElements.via(new SimpleFunction<Iterable<?>, String>(){

                @Override
                public String apply(Iterable<?> input) {
                    return Joiner.on(delimiter).join(input);
                }
            }));
        }
    }

    private static final class KVs
    extends PTransform<PCollection<? extends KV<?, ?>>, PCollection<String>> {
        private final String delimiter;

        public KVs(String delimiter) {
            this.delimiter = delimiter;
        }

        @Override
        public PCollection<String> expand(PCollection<? extends KV<?, ?>> input) {
            return (PCollection)input.apply(MapElements.via(new SimpleFunction<KV<?, ?>, String>(){

                @Override
                public String apply(KV<?, ?> input) {
                    return input.getKey().toString() + delimiter + input.getValue().toString();
                }
            }));
        }
    }

    private static final class Elements
    extends PTransform<PCollection<?>, PCollection<String>> {
        private Elements() {
        }

        @Override
        public PCollection<String> expand(PCollection<?> input) {
            return (PCollection)((Object)input.apply(MapElements.via(new SimpleFunction<Object, String>(){

                @Override
                public String apply(Object input) {
                    return input.toString();
                }
            })));
        }
    }
}

