/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import org.apache.beam.sdk.transforms.Contextful;
import org.apache.beam.sdk.transforms.InferableFunction;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.Requirements;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleMapWithFailures;
import org.apache.beam.sdk.transforms.WithFailures;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.RequiresNonNull;

public class MapKeys<K1, K2, V>
extends PTransform<PCollection<KV<K1, V>>, PCollection<KV<K2, V>>> {
    private final transient TypeDescriptor<K2> outputType;
    private final @Nullable Contextful<Contextful.Fn<KV<K1, V>, KV<K2, V>>> fn;

    public <NewValueT, NewKeyT> MapKeys<NewKeyT, K2, NewValueT> via(SerializableFunction<NewKeyT, K2> fn) {
        return new MapKeys<K1, K2, V>(Contextful.fn((element, c) -> KV.of(fn.apply(element.getKey()), element.getValue()), Requirements.empty()), this.outputType);
    }

    public static <K2> MapKeys<?, K2, ?> into(TypeDescriptor<K2> outputType) {
        return new MapKeys(null, outputType);
    }

    private MapKeys(@Nullable Contextful<Contextful.Fn<KV<K1, V>, KV<K2, V>>> fn, TypeDescriptor<K2> outputType) {
        this.fn = fn;
        this.outputType = outputType;
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> SimpleMapWithFailures<KV<K1, V>, KV<K2, V>, FailureT> exceptionsInto(TypeDescriptor<FailureT> failureTypeDescriptor) {
        return new SimpleMapWithFailures("MapKeysWithFailures", this.fn, this.getKvTypeDescriptor(), null, failureTypeDescriptor);
    }

    @RequiresNonNull(value={"fn"})
    public <FailureT> SimpleMapWithFailures<KV<K1, V>, KV<K2, V>, FailureT> exceptionsVia(InferableFunction<WithFailures.ExceptionElement<KV<K1, V>>, FailureT> exceptionHandler) {
        return new SimpleMapWithFailures<KV<K1, V>, KV<K2, V>, FailureT>("MapKeysWithFailures", this.fn, this.getKvTypeDescriptor(), exceptionHandler, exceptionHandler.getOutputTypeDescriptor());
    }

    @Override
    public PCollection<KV<K2, V>> expand(PCollection<KV<K1, V>> input) {
        return (PCollection)((Object)input.apply("MapKeys", MapElements.into(this.getKvTypeDescriptor()).via(Preconditions.checkNotNull(this.fn, "Must specify a function on MapKeys using .via()"))));
    }

    private TypeDescriptor<KV<K2, V>> getKvTypeDescriptor() {
        return new TypeDescriptor<KV<K2, V>>(){}.where(new TypeParameter<K2>(){}, this.outputType);
    }
}

