/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedMap;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ArrayUtils;
import org.apache.beam.repackaged.core.org.apache.commons.lang3.ClassUtils;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueSetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.sdk.values.TypeParameter;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.ByteBuddy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.NamingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.asm.AsmVisitorWrapper;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.field.FieldList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.DynamicType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.loading.ClassLoadingStrategy;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.dynamic.scaffold.InstrumentedType;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.Implementation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.ByteCodeAppender;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.Assigner;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.collection.ArrayAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.collection.ArrayFactory;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.IntegerConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.constant.NullConstant;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.FieldAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodReturn;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodVariableAccess;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.Label;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.jar.asm.MethodVisitor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.utility.RandomString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Function;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Collections2;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.primitives.Primitives;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.DateTimeZone;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.ReadablePartial;
import org.joda.time.base.BaseLocal;

@Internal
public class ByteBuddyUtils {
    private static final TypeDescription.ForLoadedType ARRAYS_TYPE = new TypeDescription.ForLoadedType(Arrays.class);
    private static final TypeDescription.ForLoadedType ARRAY_UTILS_TYPE = new TypeDescription.ForLoadedType(ArrayUtils.class);
    private static final TypeDescription.ForLoadedType BYTE_ARRAY_TYPE = new TypeDescription.ForLoadedType(byte[].class);
    private static final TypeDescription.ForLoadedType BYTE_BUFFER_TYPE = new TypeDescription.ForLoadedType(ByteBuffer.class);
    private static final TypeDescription.ForLoadedType CHAR_SEQUENCE_TYPE = new TypeDescription.ForLoadedType(CharSequence.class);
    private static final TypeDescription.ForLoadedType INSTANT_TYPE = new TypeDescription.ForLoadedType(Instant.class);
    private static final TypeDescription.ForLoadedType DATE_TIME_ZONE_TYPE = new TypeDescription.ForLoadedType(DateTimeZone.class);
    private static final TypeDescription.ForLoadedType COLLECTION_TYPE = new TypeDescription.ForLoadedType(Collection.class);
    private static final TypeDescription.ForLoadedType READABLE_INSTANT_TYPE = new TypeDescription.ForLoadedType(ReadableInstant.class);
    private static final TypeDescription.ForLoadedType READABLE_PARTIAL_TYPE = new TypeDescription.ForLoadedType(ReadablePartial.class);
    private static final TypeDescription.ForLoadedType INTEGER_TYPE = new TypeDescription.ForLoadedType(Integer.class);
    private static final TypeDescription.ForLoadedType ENUM_TYPE = new TypeDescription.ForLoadedType(Enum.class);
    private static final TypeDescription.ForLoadedType BYTE_BUDDY_UTILS_TYPE = new TypeDescription.ForLoadedType(ByteBuddyUtils.class);
    private static final ByteBuddy BYTE_BUDDY = new ByteBuddy();

    public static DynamicType.Builder<FieldValueGetter> subclassGetterInterface(ByteBuddy byteBuddy, Type objectType, Type fieldType) {
        TypeDescription.Generic getterGenericType = TypeDescription.Generic.Builder.parameterizedType(FieldValueGetter.class, objectType, fieldType).build();
        return byteBuddy.with(new InjectPackageStrategy((Class)objectType)).subclass(getterGenericType);
    }

    public static DynamicType.Builder<FieldValueSetter> subclassSetterInterface(ByteBuddy byteBuddy, Type objectType, Type fieldType) {
        TypeDescription.Generic setterGenericType = TypeDescription.Generic.Builder.parameterizedType(FieldValueSetter.class, objectType, fieldType).build();
        return byteBuddy.with(new InjectPackageStrategy((Class)objectType)).subclass(setterGenericType);
    }

    static Class createCollectionTransformFunction(Type fromType, Type toType, final Function<StackManipulation, StackManipulation> convertElement) {
        TypeDescription.Generic functionGenericType = TypeDescription.Generic.Builder.parameterizedType(Function.class, Primitives.wrap((Class)fromType), Primitives.wrap((Class)toType)).build();
        DynamicType.Builder.MethodDefinition.ReceiverTypeDefinition<?> builder = BYTE_BUDDY.with(new InjectPackageStrategy((Class)fromType)).subclass(functionGenericType).method(ElementMatchers.named("apply")).intercept(new Implementation(){

            @Override
            public ByteCodeAppender appender(Implementation.Target target) {
                return (methodVisitor, implementationContext, instrumentedMethod) -> {
                    int numLocals = 1 + instrumentedMethod.getParameters().size();
                    StackManipulation readValue = MethodVariableAccess.REFERENCE.loadFrom(1);
                    StackManipulation.Compound stackManipulation = new StackManipulation.Compound((StackManipulation)convertElement.apply(readValue), MethodReturn.REFERENCE);
                    StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                    return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
                };
            }

            @Override
            public InstrumentedType prepare(InstrumentedType instrumentedType) {
                return instrumentedType;
            }
        });
        return builder.visit(new AsmVisitorWrapper.ForDeclaredMethods().writerFlags(2)).make().load(ReflectHelpers.findClassLoader(((Class)fromType).getClassLoader()), ClassLoadingStrategy.Default.INJECTION).getLoaded();
    }

    public static <FromT, DestT> Iterable<DestT> transformContainer(Iterable<FromT> iterable, Function<FromT, DestT> function) {
        if (iterable instanceof List) {
            return Lists.transform((List)iterable, function);
        }
        if (iterable instanceof Collection) {
            return Collections2.transform((Collection)iterable, function);
        }
        return Iterables.transform(iterable, function);
    }

    static StackManipulation createTransformingContainer(TypeDescription.ForLoadedType functionType, StackManipulation readValue) {
        StackManipulation.Compound stackManipulation = new StackManipulation.Compound(readValue, TypeCreation.of(functionType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)functionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUDDY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.named("transformContainer"))).getOnly()));
        return stackManipulation;
    }

    public static <K1, V1, K2, V2> TransformingMap<K1, V1, K2, V2> getTransformingMap(Map<K1, V1> sourceMap, Function<K1, K2> keyFunction, Function<V1, V2> valueFunction) {
        return new TransformingMap<K1, V1, K2, V2>(sourceMap, keyFunction, valueFunction);
    }

    static class InvokeUserCreateInstruction
    implements Implementation {
        protected final List<FieldValueTypeInformation> fields;
        protected final Class targetClass;
        protected final List<Parameter> parameters;
        protected final Map<Integer, Integer> fieldMapping;
        private final TypeConversionsFactory typeConversionsFactory;

        protected InvokeUserCreateInstruction(List<FieldValueTypeInformation> fields, Class targetClass, List<Parameter> parameters, TypeConversionsFactory typeConversionsFactory) {
            int i;
            this.fields = fields;
            this.targetClass = targetClass;
            this.parameters = parameters;
            this.typeConversionsFactory = typeConversionsFactory;
            HashMap<String, Integer> fieldsByLogicalName = Maps.newHashMap();
            HashMap<String, Integer> fieldsByJavaClassMember = Maps.newHashMap();
            for (i = 0; i < fields.size(); ++i) {
                FieldValueTypeInformation fieldValue = Preconditions.checkNotNull(fields.get(i));
                fieldsByLogicalName.put(fieldValue.getName(), i);
                if (fieldValue.getField() != null) {
                    fieldsByJavaClassMember.put(fieldValue.getField().getName(), i);
                    continue;
                }
                if (fieldValue.getMethod() == null) continue;
                String name = ReflectUtils.stripGetterPrefix(fieldValue.getMethod().getName());
                fieldsByJavaClassMember.put(name, i);
            }
            this.fieldMapping = Maps.newHashMap();
            for (i = 0; i < parameters.size(); ++i) {
                Parameter parameter = parameters.get(i);
                String paramName = parameter.getName();
                Integer index = (Integer)fieldsByLogicalName.get(paramName);
                if (index == null) {
                    index = (Integer)fieldsByJavaClassMember.get(paramName);
                }
                if (index == null) {
                    throw new RuntimeException("Creator parameter " + paramName + " Doesn't correspond to a schema field");
                }
                this.fieldMapping.put(i, index);
            }
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        public ByteCodeAppender appender(Implementation.Target implementationTarget) {
            return (methodVisitor, implementationContext, instrumentedMethod) -> {
                int numLocals = 1 + instrumentedMethod.getParameters().size();
                StackManipulation stackManipulation = this.beforePushingParameters();
                TypeConversion<Type> convertType = this.typeConversionsFactory.createTypeConversion(true);
                for (int i = 0; i < this.parameters.size(); ++i) {
                    Parameter parameter = this.parameters.get(i);
                    TypeDescription.ForLoadedType convertedType = new TypeDescription.ForLoadedType((Class)convertType.convert(TypeDescriptor.of(parameter.getType())));
                    StackManipulation.Compound readParameter = new StackManipulation.Compound(MethodVariableAccess.REFERENCE.loadFrom(1), IntegerConstant.forValue(this.fieldMapping.get(i)), ArrayAccess.REFERENCE.load(), TypeCasting.to(convertedType));
                    stackManipulation = new StackManipulation.Compound(stackManipulation, this.typeConversionsFactory.createSetterConversions(readParameter).convert(TypeDescriptor.of(parameter.getParameterizedType())));
                }
                stackManipulation = new StackManipulation.Compound(stackManipulation, this.afterPushingParameters(), MethodReturn.REFERENCE);
                StackManipulation.Size size = stackManipulation.apply(methodVisitor, implementationContext);
                return new ByteCodeAppender.Size(size.getMaximalSize(), numLocals);
            };
        }

        protected StackManipulation beforePushingParameters() {
            return new StackManipulation.Compound(new StackManipulation[0]);
        }

        protected StackManipulation afterPushingParameters() {
            return new StackManipulation.Compound(new StackManipulation[0]);
        }
    }

    static class StaticFactoryMethodInstruction
    extends InvokeUserCreateInstruction {
        private final Method creator;

        StaticFactoryMethodInstruction(List<FieldValueTypeInformation> fields, Class targetClass, Method creator, TypeConversionsFactory typeConversionsFactory) {
            super(fields, targetClass, Lists.newArrayList(creator.getParameters()), typeConversionsFactory);
            if (!Modifier.isStatic(creator.getModifiers())) {
                throw new IllegalArgumentException("Method " + creator + " is not static");
            }
            this.creator = creator;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        protected StackManipulation afterPushingParameters() {
            return MethodInvocation.invoke(new MethodDescription.ForLoadedMethod(this.creator));
        }
    }

    static class ConstructorCreateInstruction
    extends InvokeUserCreateInstruction {
        private final Constructor constructor;

        ConstructorCreateInstruction(List<FieldValueTypeInformation> fields, Class targetClass, Constructor constructor, TypeConversionsFactory typeConversionsFactory) {
            super(fields, targetClass, Lists.newArrayList(constructor.getParameters()), typeConversionsFactory);
            this.constructor = constructor;
        }

        @Override
        public InstrumentedType prepare(InstrumentedType instrumentedType) {
            return instrumentedType;
        }

        @Override
        protected StackManipulation beforePushingParameters() {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(this.targetClass);
            return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE);
        }

        @Override
        protected StackManipulation afterPushingParameters() {
            return MethodInvocation.invoke(new MethodDescription.ForLoadedConstructor(this.constructor));
        }
    }

    public static class ConvertValueForSetter
    extends TypeConversion<StackManipulation> {
        protected StackManipulation readValue;

        protected ConvertValueForSetter(StackManipulation readValue) {
            this.readValue = readValue;
        }

        protected TypeConversionsFactory getFactory() {
            return new DefaultTypeConversionsFactory();
        }

        @Override
        protected StackManipulation convertArray(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            TypeDescription arrayType = TypeDescription.Generic.Builder.rawType(loadedType.getComponentType().asBoxed()).asArray().build().asErasure();
            Type rowElementType = this.getFactory().createTypeConversion(false).convert(type.getComponentType());
            TypeDescriptor arrayElementType = ReflectUtils.boxIfPrimitive(type.getComponentType());
            StackManipulation readTransformedValue = this.readValue;
            if (!arrayElementType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType conversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowElementType).getRawType(), Primitives.wrap(arrayElementType.getRawType()), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(arrayElementType)));
                readTransformedValue = ByteBuddyUtils.createTransformingContainer(conversionFunction, this.readValue);
            }
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(readTransformedValue, TypeCasting.to(COLLECTION_TYPE), ArrayFactory.forType(loadedType.getComponentType().asBoxed().asGenericType()).withValues(Collections.emptyList()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)COLLECTION_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toArray").and(ElementMatchers.takesArguments(TypeDescription.Generic.Builder.rawType(Object.class).asArray().build().asErasure())))).getOnly()), TypeCasting.to(arrayType));
            if (loadedType.getComponentType().isPrimitive()) {
                stackManipulation = new StackManipulation.Compound(stackManipulation, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toPrimitive").and(ElementMatchers.takesArguments(arrayType)))).getOnly()));
            }
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertIterable(TypeDescriptor<?> type) {
            Type rowElementType = this.getFactory().createTypeConversion(false).convert(ReflectUtils.getIterableComponentType(type));
            TypeDescriptor iterableElementType = ReflectUtils.getIterableComponentType(type);
            if (!iterableElementType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType conversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowElementType).getRawType(), iterableElementType.getRawType(), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(iterableElementType)));
                StackManipulation transformedContainer = ByteBuddyUtils.createTransformingContainer(conversionFunction, this.readValue);
                return new ShortCircuitReturnNull(this.readValue, transformedContainer);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertCollection(TypeDescriptor<?> type) {
            Type rowElementType = this.getFactory().createTypeConversion(false).convert(ReflectUtils.getIterableComponentType(type));
            TypeDescriptor collectionElementType = ReflectUtils.getIterableComponentType(type);
            if (!collectionElementType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType conversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowElementType).getRawType(), collectionElementType.getRawType(), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(collectionElementType)));
                StackManipulation transformedContainer = ByteBuddyUtils.createTransformingContainer(conversionFunction, this.readValue);
                return new ShortCircuitReturnNull(this.readValue, transformedContainer);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertList(TypeDescriptor<?> type) {
            Type rowElementType = this.getFactory().createTypeConversion(false).convert(ReflectUtils.getIterableComponentType(type));
            TypeDescriptor collectionElementType = ReflectUtils.getIterableComponentType(type);
            StackManipulation readTrasformedValue = this.readValue;
            if (!collectionElementType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType conversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowElementType).getRawType(), collectionElementType.getRawType(), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(collectionElementType)));
                readTrasformedValue = ByteBuddyUtils.createTransformingContainer(conversionFunction, this.readValue);
            }
            StackManipulation.Compound transformedList = new StackManipulation.Compound(readTrasformedValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(Lists.class).getDeclaredMethods().filter(ElementMatchers.named("newArrayList").and(ElementMatchers.takesArguments(Iterable.class)))).getOnly()));
            return new ShortCircuitReturnNull(this.readValue, transformedList);
        }

        @Override
        protected StackManipulation convertMap(TypeDescriptor<?> type) {
            Type rowKeyType = this.getFactory().createTypeConversion(false).convert(ReflectUtils.getMapType(type, 0));
            TypeDescriptor keyElementType = ReflectUtils.getMapType(type, 0);
            Type rowValueType = this.getFactory().createTypeConversion(false).convert(ReflectUtils.getMapType(type, 1));
            TypeDescriptor valueElementType = ReflectUtils.getMapType(type, 1);
            StackManipulation readTrasformedValue = this.readValue;
            if (!keyElementType.hasUnresolvedParameters() && !valueElementType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType keyConversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowKeyType).getRawType(), keyElementType.getRawType(), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(keyElementType)));
                TypeDescription.ForLoadedType valueConversionFunction = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(TypeDescriptor.of(rowValueType).getRawType(), valueElementType.getRawType(), s2 -> this.getFactory().createSetterConversions((StackManipulation)s2).convert(valueElementType)));
                readTrasformedValue = new StackManipulation.Compound(this.readValue, TypeCreation.of(keyConversionFunction), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)keyConversionFunction.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), TypeCreation.of(valueConversionFunction), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)valueConversionFunction.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUDDY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getTransformingMap"))).getOnly()));
            }
            return new ShortCircuitReturnNull(this.readValue, readTrasformedValue);
        }

        @Override
        protected StackManipulation convertDateTime(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();
            stackManipulations.add(TypeCreation.of(loadedType));
            stackManipulations.add(Duplication.SINGLE);
            stackManipulations.add(this.readValue);
            stackManipulations.add(TypeCasting.to(READABLE_INSTANT_TYPE));
            stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)READABLE_INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getMillis"))).getOnly()));
            if (type.isSubtypeOf(TypeDescriptor.of(BaseLocal.class))) {
                stackManipulations.add(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)DATE_TIME_ZONE_TYPE.getDeclaredFields().filter(ElementMatchers.named("UTC"))).getOnly()).read());
                stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Long.TYPE), DATE_TIME_ZONE_TYPE)))).getOnly()));
            } else {
                stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Long.TYPE))))).getOnly()));
            }
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(stackManipulations);
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertByteBuffer(TypeDescriptor<?> type) {
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, TypeCasting.to(BYTE_ARRAY_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUFFER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("wrap").and(ElementMatchers.takesArguments(new TypeDescription[]{BYTE_ARRAY_TYPE})))).getOnly()));
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertCharSequence(TypeDescriptor<?> type) {
            if (type.getRawType().isAssignableFrom(String.class)) {
                return this.readValue;
            }
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to(CHAR_SEQUENCE_TYPE), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(new TypeDescription[]{CHAR_SEQUENCE_TYPE})))).getOnly()));
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertPrimitive(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType valueType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(this.readValue, Assigner.DEFAULT.assign(valueType.asBoxed().asGenericType(), valueType.asUnboxed().asGenericType(), Assigner.Typing.STATIC));
        }

        @Override
        protected StackManipulation convertEnum(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.named("values").and(ElementMatchers.isStatic().and(ElementMatchers.takesArguments(0))))).getOnly()), this.readValue, Assigner.DEFAULT.assign(INTEGER_TYPE.asBoxed().asGenericType(), INTEGER_TYPE.asUnboxed().asGenericType(), Assigner.Typing.STATIC), ArrayAccess.REFERENCE.load());
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            return this.readValue;
        }
    }

    public static class ConvertValueForGetter
    extends TypeConversion<StackManipulation> {
        protected final StackManipulation readValue;

        protected ConvertValueForGetter(StackManipulation readValue) {
            this.readValue = readValue;
        }

        protected TypeConversionsFactory getFactory() {
            return new DefaultTypeConversionsFactory();
        }

        @Override
        protected StackManipulation convertArray(TypeDescriptor<?> type) {
            StackManipulation stackManipulation;
            TypeDescriptor<?> componentType = type.getComponentType();
            TypeDescription.ForLoadedType loadedArrayType = new TypeDescription.ForLoadedType(type.getRawType());
            StackManipulation readArrayValue = this.readValue;
            if (loadedArrayType.getComponentType().isPrimitive()) {
                readArrayValue = new StackManipulation.Compound(readArrayValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("toObject")).and(ElementMatchers.takesArguments(new TypeDescription[]{loadedArrayType})))).getOnly()));
                componentType = TypeDescriptor.of(Primitives.wrap(componentType.getRawType()));
            }
            StackManipulation.Compound readListValue = new StackManipulation.Compound(readArrayValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ARRAYS_TYPE.getDeclaredMethods().filter(ElementMatchers.isStatic().and(ElementMatchers.named("asList")))).getOnly()));
            TypeDescriptor finalComponentType = ReflectUtils.boxIfPrimitive(componentType);
            if (!finalComponentType.hasUnresolvedParameters()) {
                Type convertedComponentType = this.getFactory().createTypeConversion(true).convert(componentType);
                TypeDescription.ForLoadedType functionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(componentType.getRawType(), convertedComponentType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(finalComponentType)));
                stackManipulation = ByteBuddyUtils.createTransformingContainer(functionType, readListValue);
            } else {
                stackManipulation = readListValue;
            }
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertIterable(TypeDescriptor<?> type) {
            TypeDescriptor componentType = ReflectUtils.getIterableComponentType(type);
            Type convertedComponentType = this.getFactory().createTypeConversion(true).convert(componentType);
            TypeDescriptor finalComponentType = ReflectUtils.boxIfPrimitive(componentType);
            if (!finalComponentType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType functionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(componentType.getRawType(), convertedComponentType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(finalComponentType)));
                StackManipulation stackManipulation = ByteBuddyUtils.createTransformingContainer(functionType, this.readValue);
                return new ShortCircuitReturnNull(this.readValue, stackManipulation);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertCollection(TypeDescriptor<?> type) {
            TypeDescriptor componentType = ReflectUtils.getIterableComponentType(type);
            Type convertedComponentType = this.getFactory().createTypeConversion(true).convert(componentType);
            TypeDescriptor finalComponentType = ReflectUtils.boxIfPrimitive(componentType);
            if (!finalComponentType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType functionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(componentType.getRawType(), convertedComponentType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(finalComponentType)));
                StackManipulation stackManipulation = ByteBuddyUtils.createTransformingContainer(functionType, this.readValue);
                return new ShortCircuitReturnNull(this.readValue, stackManipulation);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertList(TypeDescriptor<?> type) {
            TypeDescriptor componentType = ReflectUtils.getIterableComponentType(type);
            Type convertedComponentType = this.getFactory().createTypeConversion(true).convert(componentType);
            TypeDescriptor finalComponentType = ReflectUtils.boxIfPrimitive(componentType);
            if (!finalComponentType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType functionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(componentType.getRawType(), convertedComponentType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(finalComponentType)));
                StackManipulation stackManipulation = ByteBuddyUtils.createTransformingContainer(functionType, this.readValue);
                return new ShortCircuitReturnNull(this.readValue, stackManipulation);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertMap(TypeDescriptor<?> type) {
            TypeDescriptor keyType = ReflectUtils.getMapType(type, 0);
            TypeDescriptor valueType = ReflectUtils.getMapType(type, 1);
            Type convertedKeyType = this.getFactory().createTypeConversion(true).convert(keyType);
            Type convertedValueType = this.getFactory().createTypeConversion(true).convert(valueType);
            if (!keyType.hasUnresolvedParameters() && !valueType.hasUnresolvedParameters()) {
                TypeDescription.ForLoadedType keyFunctionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(keyType.getRawType(), convertedKeyType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(keyType)));
                TypeDescription.ForLoadedType valueFunctionType = new TypeDescription.ForLoadedType(ByteBuddyUtils.createCollectionTransformFunction(valueType.getRawType(), convertedValueType, s2 -> this.getFactory().createGetterConversions((StackManipulation)s2).convert(valueType)));
                StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, TypeCreation.of(keyFunctionType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)keyFunctionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), TypeCreation.of(valueFunctionType), Duplication.SINGLE, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)valueFunctionType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(0)))).getOnly()), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUDDY_UTILS_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getTransformingMap"))).getOnly()));
                return new ShortCircuitReturnNull(this.readValue, stackManipulation);
            }
            return this.readValue;
        }

        @Override
        protected StackManipulation convertDateTime(TypeDescriptor<?> type) {
            if (Instant.class.isAssignableFrom(type.getRawType())) {
                return this.readValue;
            }
            ArrayList<StackManipulation> stackManipulations = new ArrayList<StackManipulation>();
            stackManipulations.add(TypeCreation.of(INSTANT_TYPE));
            stackManipulations.add(Duplication.SINGLE);
            if (ReadablePartial.class.isAssignableFrom(type.getRawType())) {
                stackManipulations.add(this.readValue);
                stackManipulations.add(TypeCasting.to(READABLE_PARTIAL_TYPE));
                stackManipulations.add(FieldAccess.forField((FieldDescription.InDefinedShape)((FieldList)INSTANT_TYPE.getDeclaredFields().filter(ElementMatchers.named("EPOCH"))).getOnly()).read());
                stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)READABLE_PARTIAL_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toDateTime").and(ElementMatchers.takesArguments(new TypeDescription[]{READABLE_INSTANT_TYPE})))).getOnly()));
            } else {
                stackManipulations.add(this.readValue);
                stackManipulations.add(TypeCasting.to(READABLE_INSTANT_TYPE));
            }
            stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)READABLE_INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.named("getMillis"))).getOnly()));
            stackManipulations.add(MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)INSTANT_TYPE.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(TypeDescription.ForLoadedType.of(Long.TYPE))))).getOnly()));
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(stackManipulations);
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertByteBuffer(TypeDescriptor<?> type) {
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)BYTE_BUFFER_TYPE.getDeclaredMethods().filter(ElementMatchers.named("array").and(ElementMatchers.returns(BYTE_ARRAY_TYPE)))).getOnly()));
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertCharSequence(TypeDescriptor<?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(String.class))) {
                return this.readValue;
            }
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)CHAR_SEQUENCE_TYPE.getDeclaredMethods().filter(ElementMatchers.named("toString").and(ElementMatchers.takesArguments(0)))).getOnly()));
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertPrimitive(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
            return new StackManipulation.Compound(this.readValue, Assigner.DEFAULT.assign(loadedType.asGenericType(), loadedType.asBoxed().asGenericType(), Assigner.Typing.STATIC));
        }

        @Override
        protected StackManipulation convertEnum(TypeDescriptor<?> type) {
            StackManipulation.Compound stackManipulation = new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)ENUM_TYPE.getDeclaredMethods().filter(ElementMatchers.named("ordinal").and(ElementMatchers.takesArguments(0)))).getOnly()), Assigner.DEFAULT.assign(INTEGER_TYPE.asUnboxed().asGenericType(), INTEGER_TYPE.asGenericType(), Assigner.Typing.STATIC));
            return new ShortCircuitReturnNull(this.readValue, stackManipulation);
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            return this.readValue;
        }
    }

    public static class TransformingMap<K1, V1, K2, V2>
    implements Map<K2, V2> {
        private final Map<K2, V2> delegateMap;

        public TransformingMap(Map<K1, V1> sourceMap, Function<K1, K2> keyFunction, Function<V1, V2> valueFunction) {
            this.delegateMap = sourceMap instanceof SortedMap ? Maps.newTreeMap() : Maps.newHashMap();
            for (Map.Entry<K1, V1> entry : sourceMap.entrySet()) {
                this.delegateMap.put(keyFunction.apply(entry.getKey()), valueFunction.apply(entry.getValue()));
            }
        }

        @Override
        public int size() {
            return this.delegateMap.size();
        }

        @Override
        public boolean isEmpty() {
            return this.delegateMap.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.delegateMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.delegateMap.containsValue(value);
        }

        @Override
        public V2 get(Object key) {
            return this.delegateMap.get(key);
        }

        @Override
        public V2 put(K2 key, V2 value) {
            return this.delegateMap.put(key, value);
        }

        @Override
        public V2 remove(Object key) {
            return this.delegateMap.remove(key);
        }

        @Override
        public void putAll(Map<? extends K2, ? extends V2> m3) {
            this.delegateMap.putAll(m3);
        }

        @Override
        public void clear() {
            this.delegateMap.clear();
        }

        @Override
        public Set<K2> keySet() {
            return this.delegateMap.keySet();
        }

        @Override
        public Collection<V2> values() {
            return this.delegateMap.values();
        }

        @Override
        public Set<Map.Entry<K2, V2>> entrySet() {
            return this.delegateMap.entrySet();
        }

        @Override
        public boolean equals(@Nullable Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            TransformingMap that = (TransformingMap)o;
            return Objects.equals(this.delegateMap, that.delegateMap);
        }

        @Override
        public int hashCode() {
            return Objects.hash(this.delegateMap);
        }

        public String toString() {
            return this.delegateMap.toString();
        }
    }

    public static class ConvertType
    extends TypeConversion<Type> {
        private boolean returnRawTypes;

        protected ConvertType(boolean returnRawTypes) {
            this.returnRawTypes = returnRawTypes;
        }

        @Override
        protected Type convertArray(TypeDescriptor<?> type) {
            TypeDescriptor ret = this.createCollectionType(type.getComponentType());
            return this.returnRawTypes ? ret.getRawType() : ret.getType();
        }

        @Override
        protected Type convertCollection(TypeDescriptor<?> type) {
            TypeDescriptor ret = this.createCollectionType(ReflectUtils.getIterableComponentType(type));
            return this.returnRawTypes ? ret.getRawType() : ret.getType();
        }

        @Override
        protected Type convertList(TypeDescriptor<?> type) {
            TypeDescriptor ret = this.createCollectionType(ReflectUtils.getIterableComponentType(type));
            return this.returnRawTypes ? ret.getRawType() : ret.getType();
        }

        @Override
        protected Type convertIterable(TypeDescriptor<?> type) {
            TypeDescriptor ret = this.createIterableType(ReflectUtils.getIterableComponentType(type));
            return this.returnRawTypes ? ret.getRawType() : ret.getType();
        }

        @Override
        protected Type convertMap(TypeDescriptor<?> type) {
            return Map.class;
        }

        @Override
        protected Type convertDateTime(TypeDescriptor<?> type) {
            return Instant.class;
        }

        @Override
        protected Type convertByteBuffer(TypeDescriptor<?> type) {
            return byte[].class;
        }

        @Override
        protected Type convertCharSequence(TypeDescriptor<?> type) {
            return String.class;
        }

        @Override
        protected Type convertPrimitive(TypeDescriptor<?> type) {
            return ClassUtils.primitiveToWrapper(type.getRawType());
        }

        @Override
        protected Type convertEnum(TypeDescriptor<?> type) {
            return Integer.class;
        }

        @Override
        protected Type convertDefault(TypeDescriptor<?> type) {
            return this.returnRawTypes ? type.getRawType() : type.getType();
        }

        private <ElementT> TypeDescriptor<Collection<ElementT>> createCollectionType(TypeDescriptor<?> componentType) {
            TypeDescriptor<?> wrappedComponentType = TypeDescriptor.of(ClassUtils.primitiveToWrapper(componentType.getRawType()));
            return new TypeDescriptor<Collection<ElementT>>(){}.where(new TypeParameter<ElementT>(){}, wrappedComponentType);
        }

        private <ElementT> TypeDescriptor<Iterable<ElementT>> createIterableType(TypeDescriptor<?> componentType) {
            TypeDescriptor<?> wrappedComponentType = TypeDescriptor.of(ClassUtils.primitiveToWrapper(componentType.getRawType()));
            return new TypeDescriptor<Iterable<ElementT>>(){}.where(new TypeParameter<ElementT>(){}, wrappedComponentType);
        }
    }

    public static abstract class TypeConversion<T> {
        public T convert(TypeDescriptor typeDescriptor) {
            if (typeDescriptor.isArray() && !typeDescriptor.getComponentType().getRawType().equals(Byte.TYPE)) {
                return this.convertArray(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Map.class))) {
                return this.convertMap(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ReadableInstant.class))) {
                return this.convertDateTime(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ReadablePartial.class))) {
                return this.convertDateTime(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(ByteBuffer.class))) {
                return this.convertByteBuffer(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(CharSequence.class))) {
                return this.convertCharSequence(typeDescriptor);
            }
            if (typeDescriptor.getRawType().isPrimitive()) {
                return this.convertPrimitive(typeDescriptor);
            }
            if (typeDescriptor.getRawType().isEnum()) {
                return this.convertEnum(typeDescriptor);
            }
            if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Iterable.class))) {
                if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(List.class))) {
                    return this.convertList(typeDescriptor);
                }
                if (typeDescriptor.isSubtypeOf(TypeDescriptor.of(Collection.class))) {
                    return this.convertCollection(typeDescriptor);
                }
                return this.convertIterable(typeDescriptor);
            }
            return this.convertDefault(typeDescriptor);
        }

        protected abstract T convertArray(TypeDescriptor<?> var1);

        protected abstract T convertIterable(TypeDescriptor<?> var1);

        protected abstract T convertCollection(TypeDescriptor<?> var1);

        protected abstract T convertList(TypeDescriptor<?> var1);

        protected abstract T convertMap(TypeDescriptor<?> var1);

        protected abstract T convertDateTime(TypeDescriptor<?> var1);

        protected abstract T convertByteBuffer(TypeDescriptor<?> var1);

        protected abstract T convertCharSequence(TypeDescriptor<?> var1);

        protected abstract T convertPrimitive(TypeDescriptor<?> var1);

        protected abstract T convertEnum(TypeDescriptor<?> var1);

        protected abstract T convertDefault(TypeDescriptor<?> var1);
    }

    public static class DefaultTypeConversionsFactory
    implements TypeConversionsFactory {
        @Override
        public TypeConversion<Type> createTypeConversion(boolean returnRawTypes) {
            return new ConvertType(returnRawTypes);
        }

        @Override
        public TypeConversion<StackManipulation> createGetterConversions(StackManipulation readValue) {
            return new ConvertValueForGetter(readValue);
        }

        @Override
        public TypeConversion<StackManipulation> createSetterConversions(StackManipulation readValue) {
            return new ConvertValueForSetter(readValue);
        }
    }

    public static interface TypeConversionsFactory {
        public TypeConversion<Type> createTypeConversion(boolean var1);

        public TypeConversion<StackManipulation> createGetterConversions(StackManipulation var1);

        public TypeConversion<StackManipulation> createSetterConversions(StackManipulation var1);
    }

    static class ShortCircuitReturnNull
    extends IfNullElse {
        ShortCircuitReturnNull(StackManipulation readValue, StackManipulation onNotNull) {
            super(readValue, NullConstant.INSTANCE, onNotNull);
        }
    }

    static class IfNullElse
    implements StackManipulation {
        private final StackManipulation readValue;
        private final StackManipulation onNull;
        private final StackManipulation onNotNull;

        IfNullElse(StackManipulation readValue, StackManipulation onNull, StackManipulation onNotNull) {
            this.readValue = readValue;
            this.onNull = onNull;
            this.onNotNull = onNotNull;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public StackManipulation.Size apply(MethodVisitor methodVisitor, Implementation.Context context) {
            StackManipulation.Size size = new StackManipulation.Size(0, 0);
            size = size.aggregate(this.readValue.apply(methodVisitor, context));
            Label label = new Label();
            Label skipLabel = new Label();
            methodVisitor.visitJumpInsn(199, label);
            size = size.aggregate(new StackManipulation.Size(-1, 0));
            size = size.aggregate(this.onNull.apply(methodVisitor, context));
            methodVisitor.visitJumpInsn(167, skipLabel);
            size = size.aggregate(new StackManipulation.Size(0, 1));
            methodVisitor.visitLabel(label);
            size = size.aggregate(this.onNotNull.apply(methodVisitor, context));
            methodVisitor.visitLabel(skipLabel);
            return size;
        }
    }

    public static class InjectPackageStrategy
    extends NamingStrategy.AbstractBase {
        private static final NamingStrategy.SuffixingRandom.BaseNameResolver baseNameResolver = NamingStrategy.SuffixingRandom.BaseNameResolver.ForUnnamedType.INSTANCE;
        private static final String SUFFIX = "SchemaCodeGen";
        private final RandomString randomString = new RandomString();
        private final @Nullable String targetPackage;

        public InjectPackageStrategy(Class<?> baseType) {
            this.targetPackage = baseType.getPackage() != null ? baseType.getPackage().getName() : null;
        }

        @Override
        protected String name(TypeDescription superClass) {
            String baseName = baseNameResolver.resolve(superClass);
            int lastDot = baseName.lastIndexOf(46);
            String className = baseName.substring(lastDot, baseName.length());
            String realPackage = InjectPackageStrategy.overridePackage(this.targetPackage) ? this.targetPackage : superClass.getPackage().getName();
            return realPackage + className + "$" + SUFFIX + "$" + this.randomString.nextString();
        }

        private static boolean overridePackage(@Nullable String targetPackage) {
            return targetPackage != null && !targetPackage.startsWith("java.");
        }
    }
}

