/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericFixed;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.avro.reflect.AvroIgnore;
import org.apache.avro.reflect.AvroName;
import org.apache.avro.reflect.ReflectData;
import org.apache.avro.specific.SpecificData;
import org.apache.avro.specific.SpecificRecord;
import org.apache.avro.util.Utf8;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.schemas.AvroRecordSchema;
import org.apache.beam.sdk.schemas.FieldValueGetter;
import org.apache.beam.sdk.schemas.FieldValueTypeInformation;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaUserTypeCreator;
import org.apache.beam.sdk.schemas.logicaltypes.EnumerationType;
import org.apache.beam.sdk.schemas.logicaltypes.FixedBytes;
import org.apache.beam.sdk.schemas.logicaltypes.OneOfType;
import org.apache.beam.sdk.schemas.utils.AvroByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.ByteBuddyUtils;
import org.apache.beam.sdk.schemas.utils.FieldValueTypeSupplier;
import org.apache.beam.sdk.schemas.utils.JavaBeanUtils;
import org.apache.beam.sdk.schemas.utils.POJOUtils;
import org.apache.beam.sdk.schemas.utils.ReflectUtils;
import org.apache.beam.sdk.schemas.utils.StaticSchemaInference;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.method.MethodList;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.description.type.TypeDescription;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.Duplication;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.StackManipulation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.TypeCreation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.assign.TypeCasting;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.implementation.bytecode.member.MethodInvocation;
import org.apache.beam.vendor.bytebuddy.v1_11_0.net.bytebuddy.matcher.ElementMatchers;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.CaseFormat;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Strings;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Days;
import org.joda.time.Duration;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class AvroUtils {
    public static Schema.Field toBeamField(Schema.Field field) {
        TypeWithNullability nullableType = new TypeWithNullability(field.schema());
        Schema.FieldType beamFieldType = AvroUtils.toFieldType(nullableType);
        return Schema.Field.of(field.name(), beamFieldType);
    }

    public static Schema.Field toAvroField(Schema.Field field, String namespace) {
        org.apache.avro.Schema fieldSchema = AvroUtils.getFieldSchema(field.getType(), field.getName(), namespace);
        return new Schema.Field(field.getName(), fieldSchema, field.getDescription(), (Object)null);
    }

    private AvroUtils() {
    }

    public static Schema toBeamSchema(org.apache.avro.Schema schema) {
        Schema.Builder builder = Schema.builder();
        for (Schema.Field field : schema.getFields()) {
            Schema.Field beamField = AvroUtils.toBeamField(field);
            if (field.doc() != null) {
                beamField = beamField.withDescription(field.doc());
            }
            builder.addField(beamField);
        }
        return builder.build();
    }

    public static org.apache.avro.Schema toAvroSchema(Schema beamSchema, @Nullable String name, @Nullable String namespace) {
        String schemaName = Strings.isNullOrEmpty(name) ? "topLevelRecord" : name;
        String schemaNamespace = namespace == null ? "" : namespace;
        String childNamespace = !"".equals(schemaNamespace) ? schemaNamespace + "." + schemaName : schemaName;
        ArrayList<Schema.Field> fields = Lists.newArrayList();
        for (Schema.Field field : beamSchema.getFields()) {
            Schema.Field recordField = AvroUtils.toAvroField(field, childNamespace);
            fields.add(recordField);
        }
        return org.apache.avro.Schema.createRecord(schemaName, null, schemaNamespace, false, fields);
    }

    public static org.apache.avro.Schema toAvroSchema(Schema beamSchema) {
        return AvroUtils.toAvroSchema(beamSchema, null, null);
    }

    public static Row toBeamRowStrict(GenericRecord record, @Nullable Schema schema) {
        if (schema == null) {
            schema = AvroUtils.toBeamSchema(record.getSchema());
        }
        Row.Builder builder = Row.withSchema(schema);
        org.apache.avro.Schema avroSchema = record.getSchema();
        for (Schema.Field field : schema.getFields()) {
            Object value = record.get(field.getName());
            org.apache.avro.Schema fieldAvroSchema = avroSchema.getField(field.getName()).schema();
            builder.addValue(AvroUtils.convertAvroFieldStrict(value, fieldAvroSchema, field.getType()));
        }
        return builder.build();
    }

    public static GenericRecord toGenericRecord(Row row) {
        return AvroUtils.toGenericRecord(row, null);
    }

    public static GenericRecord toGenericRecord(Row row, @Nullable org.apache.avro.Schema avroSchema) {
        Schema beamSchema = row.getSchema();
        if (avroSchema != null && avroSchema.getFields().size() != beamSchema.getFieldCount()) {
            throw new IllegalArgumentException("AVRO schema doesn't match row schema. Row schema " + beamSchema + ". AVRO schema + " + avroSchema);
        }
        if (avroSchema == null) {
            avroSchema = AvroUtils.toAvroSchema(beamSchema);
        }
        GenericRecordBuilder builder = new GenericRecordBuilder(avroSchema);
        for (int i = 0; i < beamSchema.getFieldCount(); ++i) {
            Schema.Field field = beamSchema.getField(i);
            builder.set(field.getName(), AvroUtils.genericFromBeamField(field.getType(), avroSchema.getField(field.getName()).schema(), row.getValue(i)));
        }
        return builder.build();
    }

    public static <T> SerializableFunction<T, Row> getToRowFunction(Class<T> clazz, @Nullable org.apache.avro.Schema schema) {
        if (GenericRecord.class.equals(clazz)) {
            Schema beamSchema = AvroUtils.toBeamSchema(schema);
            return AvroUtils.getGenericRecordToRowFunction(beamSchema);
        }
        return new AvroRecordSchema().toRowFunction(TypeDescriptor.of(clazz));
    }

    public static <T> SerializableFunction<Row, T> getFromRowFunction(Class<T> clazz) {
        return GenericRecord.class.equals(clazz) ? AvroUtils.getRowToGenericRecordFunction(null) : new AvroRecordSchema().fromRowFunction(TypeDescriptor.of(clazz));
    }

    public static <T> @Nullable Schema getSchema(Class<T> clazz, @Nullable org.apache.avro.Schema schema) {
        if (schema != null) {
            return schema.getType().equals((Object)Schema.Type.RECORD) ? AvroUtils.toBeamSchema(schema) : null;
        }
        if (GenericRecord.class.equals(clazz)) {
            throw new IllegalArgumentException("No schema provided for getSchema(GenericRecord)");
        }
        return new AvroRecordSchema().schemaFor(TypeDescriptor.of(clazz));
    }

    public static SimpleFunction<byte[], Row> getAvroBytesToRowFunction(Schema beamSchema) {
        return new AvroBytesToRowFn(beamSchema);
    }

    public static SimpleFunction<Row, byte[]> getRowToAvroBytesFunction(Schema beamSchema) {
        return new RowToAvroBytesFn(beamSchema);
    }

    public static SerializableFunction<GenericRecord, Row> getGenericRecordToRowFunction(@Nullable Schema schema) {
        return new GenericRecordToRowFn(schema);
    }

    public static SerializableFunction<Row, GenericRecord> getRowToGenericRecordFunction(@Nullable org.apache.avro.Schema avroSchema) {
        return new RowToGenericRecordFn(avroSchema);
    }

    public static <T> SchemaCoder<T> schemaCoder(TypeDescriptor<T> type) {
        Class<T> clazz = type.getRawType();
        org.apache.avro.Schema avroSchema = new ReflectData(clazz.getClassLoader()).getSchema(clazz);
        Schema beamSchema = AvroUtils.toBeamSchema(avroSchema);
        return SchemaCoder.of(beamSchema, type, AvroUtils.getToRowFunction(clazz, avroSchema), AvroUtils.getFromRowFunction(clazz));
    }

    public static <T> SchemaCoder<T> schemaCoder(Class<T> clazz) {
        return AvroUtils.schemaCoder(TypeDescriptor.of(clazz));
    }

    public static SchemaCoder<GenericRecord> schemaCoder(org.apache.avro.Schema schema) {
        Schema beamSchema = AvroUtils.toBeamSchema(schema);
        return SchemaCoder.of(beamSchema, TypeDescriptor.of(GenericRecord.class), AvroUtils.getGenericRecordToRowFunction(beamSchema), AvroUtils.getRowToGenericRecordFunction(schema));
    }

    public static <T> SchemaCoder<T> schemaCoder(Class<T> clazz, org.apache.avro.Schema schema) {
        return SchemaCoder.of(AvroUtils.getSchema(clazz, schema), TypeDescriptor.of(clazz), AvroUtils.getToRowFunction(clazz, schema), AvroUtils.getFromRowFunction(clazz));
    }

    public static <T> SchemaCoder<T> schemaCoder(AvroCoder<T> avroCoder) {
        return AvroUtils.schemaCoder(avroCoder.getType(), avroCoder.getSchema());
    }

    public static <T> List<FieldValueTypeInformation> getFieldTypes(Class<T> clazz, Schema schema) {
        if (TypeDescriptor.of(clazz).isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return JavaBeanUtils.getFieldTypes(clazz, schema, new AvroSpecificRecordFieldValueTypeSupplier());
        }
        return POJOUtils.getFieldTypes(clazz, schema, new AvroPojoFieldValueTypeSupplier());
    }

    public static <T> List<FieldValueGetter> getGetters(Class<T> clazz, Schema schema) {
        if (TypeDescriptor.of(clazz).isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return JavaBeanUtils.getGetters(clazz, schema, new AvroSpecificRecordFieldValueTypeSupplier(), new AvroTypeConversionFactory());
        }
        return POJOUtils.getGetters(clazz, schema, new AvroPojoFieldValueTypeSupplier(), new AvroTypeConversionFactory());
    }

    public static <T> SchemaUserTypeCreator getCreator(Class<T> clazz, Schema schema) {
        if (TypeDescriptor.of(clazz).isSubtypeOf(TypeDescriptor.of(SpecificRecord.class))) {
            return AvroByteBuddyUtils.getCreator(clazz, schema);
        }
        return POJOUtils.getSetFieldCreator(clazz, schema, new AvroPojoFieldValueTypeSupplier(), new AvroTypeConversionFactory());
    }

    private static Schema.FieldType toFieldType(TypeWithNullability type) {
        Schema.FieldType fieldType = null;
        org.apache.avro.Schema avroSchema = type.type;
        LogicalType logicalType = LogicalTypes.fromSchema(avroSchema);
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypes.Decimal) {
                fieldType = Schema.FieldType.DECIMAL;
            } else if (logicalType instanceof LogicalTypes.TimestampMillis) {
                fieldType = Schema.FieldType.DATETIME;
            } else if (logicalType instanceof LogicalTypes.Date) {
                fieldType = Schema.FieldType.DATETIME;
            }
        }
        if (fieldType == null) {
            switch (type.type.getType()) {
                case RECORD: {
                    fieldType = Schema.FieldType.row(AvroUtils.toBeamSchema(avroSchema));
                    break;
                }
                case ENUM: {
                    fieldType = Schema.FieldType.logicalType(EnumerationType.create(type.type.getEnumSymbols()));
                    break;
                }
                case ARRAY: {
                    Schema.FieldType elementType = AvroUtils.toFieldType(new TypeWithNullability(avroSchema.getElementType()));
                    fieldType = Schema.FieldType.array(elementType);
                    break;
                }
                case MAP: {
                    fieldType = Schema.FieldType.map(Schema.FieldType.STRING, AvroUtils.toFieldType(new TypeWithNullability(avroSchema.getValueType())));
                    break;
                }
                case FIXED: {
                    fieldType = FixedBytesField.fromAvroType(type.type).toBeamType();
                    break;
                }
                case STRING: {
                    fieldType = Schema.FieldType.STRING;
                    break;
                }
                case BYTES: {
                    fieldType = Schema.FieldType.BYTES;
                    break;
                }
                case INT: {
                    fieldType = Schema.FieldType.INT32;
                    break;
                }
                case LONG: {
                    fieldType = Schema.FieldType.INT64;
                    break;
                }
                case FLOAT: {
                    fieldType = Schema.FieldType.FLOAT;
                    break;
                }
                case DOUBLE: {
                    fieldType = Schema.FieldType.DOUBLE;
                    break;
                }
                case BOOLEAN: {
                    fieldType = Schema.FieldType.BOOLEAN;
                    break;
                }
                case UNION: {
                    fieldType = Schema.FieldType.logicalType(OneOfType.create(avroSchema.getTypes().stream().map(x -> Schema.Field.of(x.getName(), AvroUtils.toFieldType(new TypeWithNullability((org.apache.avro.Schema)x)))).collect(Collectors.toList())));
                    break;
                }
                case NULL: {
                    throw new IllegalArgumentException("Can't convert 'null' to FieldType");
                }
                default: {
                    throw new AssertionError((Object)("Unexpected AVRO Schema.Type: " + (Object)((Object)avroSchema.getType())));
                }
            }
        }
        fieldType = fieldType.withNullable(type.nullable);
        return fieldType;
    }

    private static org.apache.avro.Schema getFieldSchema(Schema.FieldType fieldType, String fieldName, String namespace) {
        org.apache.avro.Schema baseType;
        block0 : switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: {
                baseType = org.apache.avro.Schema.create(Schema.Type.INT);
                break;
            }
            case INT64: {
                baseType = org.apache.avro.Schema.create(Schema.Type.LONG);
                break;
            }
            case DECIMAL: {
                baseType = LogicalTypes.decimal(Integer.MAX_VALUE).addToSchema(org.apache.avro.Schema.create(Schema.Type.BYTES));
                break;
            }
            case FLOAT: {
                baseType = org.apache.avro.Schema.create(Schema.Type.FLOAT);
                break;
            }
            case DOUBLE: {
                baseType = org.apache.avro.Schema.create(Schema.Type.DOUBLE);
                break;
            }
            case STRING: {
                baseType = org.apache.avro.Schema.create(Schema.Type.STRING);
                break;
            }
            case DATETIME: {
                baseType = LogicalTypes.timestampMillis().addToSchema(org.apache.avro.Schema.create(Schema.Type.LONG));
                break;
            }
            case BOOLEAN: {
                baseType = org.apache.avro.Schema.create(Schema.Type.BOOLEAN);
                break;
            }
            case BYTES: {
                baseType = org.apache.avro.Schema.create(Schema.Type.BYTES);
                break;
            }
            case LOGICAL_TYPE: {
                switch (fieldType.getLogicalType().getIdentifier()) {
                    case "FixedBytes": {
                        FixedBytesField fixedBytesField = Preconditions.checkNotNull(FixedBytesField.fromBeamFieldType(fieldType));
                        baseType = fixedBytesField.toAvroType("fixed", namespace + "." + fieldName);
                        break block0;
                    }
                    case "Enum": {
                        EnumerationType enumerationType = fieldType.getLogicalType(EnumerationType.class);
                        baseType = org.apache.avro.Schema.createEnum(fieldName, "", "", enumerationType.getValues());
                        break block0;
                    }
                    case "OneOf": {
                        OneOfType oneOfType = fieldType.getLogicalType(OneOfType.class);
                        baseType = org.apache.avro.Schema.createUnion(oneOfType.getOneOfSchema().getFields().stream().map(x -> AvroUtils.getFieldSchema(x.getType(), x.getName(), namespace)).collect(Collectors.toList()));
                        break block0;
                    }
                    case "CHAR": 
                    case "NCHAR": {
                        baseType = AvroUtils.buildHiveLogicalTypeSchema("char", (Integer)fieldType.getLogicalType().getArgument());
                        break block0;
                    }
                    case "NVARCHAR": 
                    case "VARCHAR": 
                    case "LONGNVARCHAR": 
                    case "LONGVARCHAR": {
                        baseType = AvroUtils.buildHiveLogicalTypeSchema("varchar", (Integer)fieldType.getLogicalType().getArgument());
                        break block0;
                    }
                    case "DATE": {
                        baseType = LogicalTypes.date().addToSchema(org.apache.avro.Schema.create(Schema.Type.INT));
                        break block0;
                    }
                    case "TIME": {
                        baseType = LogicalTypes.timeMillis().addToSchema(org.apache.avro.Schema.create(Schema.Type.INT));
                        break block0;
                    }
                }
                throw new RuntimeException("Unhandled logical type " + fieldType.getLogicalType().getIdentifier());
            }
            case ARRAY: 
            case ITERABLE: {
                baseType = org.apache.avro.Schema.createArray(AvroUtils.getFieldSchema(fieldType.getCollectionElementType(), fieldName, namespace));
                break;
            }
            case MAP: {
                if (fieldType.getMapKeyType().getTypeName().isStringType()) {
                    baseType = org.apache.avro.Schema.createMap(AvroUtils.getFieldSchema(fieldType.getMapValueType(), fieldName, namespace));
                    break;
                }
                throw new IllegalArgumentException("Avro only supports maps with string keys");
            }
            case ROW: {
                baseType = AvroUtils.toAvroSchema(fieldType.getRowSchema(), fieldName, namespace);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unexpected type " + fieldType);
            }
        }
        return fieldType.getNullable() != false ? ReflectData.makeNullable(baseType) : baseType;
    }

    private static @Nullable Object genericFromBeamField(Schema.FieldType fieldType, org.apache.avro.Schema avroSchema, @Nullable Object value) {
        TypeWithNullability typeWithNullability = new TypeWithNullability(avroSchema);
        if (!fieldType.getNullable().equals(typeWithNullability.nullable)) {
            throw new IllegalArgumentException("FieldType " + fieldType + " and AVRO schema " + avroSchema + " don't have matching nullability");
        }
        if (value == null) {
            return value;
        }
        switch (fieldType.getTypeName()) {
            case BYTE: 
            case INT16: 
            case INT32: 
            case INT64: 
            case FLOAT: 
            case DOUBLE: 
            case BOOLEAN: {
                return value;
            }
            case STRING: {
                return new Utf8((String)value);
            }
            case DECIMAL: {
                BigDecimal decimal = (BigDecimal)value;
                LogicalType logicalType = typeWithNullability.type.getLogicalType();
                return new Conversions.DecimalConversion().toBytes(decimal, (org.apache.avro.Schema)null, logicalType);
            }
            case DATETIME: {
                if (typeWithNullability.type.getType() == Schema.Type.INT) {
                    ReadableInstant instant = (ReadableInstant)value;
                    return Days.daysBetween(Instant.EPOCH, instant).getDays();
                }
                if (typeWithNullability.type.getType() == Schema.Type.LONG) {
                    ReadableInstant instant = (ReadableInstant)value;
                    return instant.getMillis();
                }
                throw new IllegalArgumentException("Can't represent " + fieldType + " as " + (Object)((Object)typeWithNullability.type.getType()));
            }
            case BYTES: {
                return ByteBuffer.wrap((byte[])value);
            }
            case LOGICAL_TYPE: {
                switch (fieldType.getLogicalType().getIdentifier()) {
                    case "FixedBytes": {
                        FixedBytesField fixedBytesField = Preconditions.checkNotNull(FixedBytesField.fromBeamFieldType(fieldType));
                        byte[] byteArray = (byte[])value;
                        if (byteArray.length != fixedBytesField.getSize()) {
                            throw new IllegalArgumentException("Incorrectly sized byte array.");
                        }
                        return GenericData.get().createFixed(null, (byte[])value, typeWithNullability.type);
                    }
                    case "Enum": {
                        EnumerationType enumerationType = fieldType.getLogicalType(EnumerationType.class);
                        return GenericData.get().createEnum(enumerationType.toString((EnumerationType.Value)value), typeWithNullability.type);
                    }
                    case "OneOf": {
                        OneOfType oneOfType = fieldType.getLogicalType(OneOfType.class);
                        OneOfType.Value oneOfValue = (OneOfType.Value)value;
                        Schema.FieldType innerFieldType = oneOfType.getFieldType(oneOfValue);
                        if (typeWithNullability.nullable && oneOfValue.getValue() == null) {
                            return null;
                        }
                        return AvroUtils.genericFromBeamField(innerFieldType.withNullable(false), typeWithNullability.type.getTypes().get(oneOfValue.getCaseType().getValue()), oneOfValue.getValue());
                    }
                    case "NVARCHAR": 
                    case "VARCHAR": 
                    case "LONGNVARCHAR": 
                    case "LONGVARCHAR": {
                        return new Utf8((String)value);
                    }
                    case "DATE": {
                        return Days.daysBetween(Instant.EPOCH, (Instant)value).getDays();
                    }
                    case "TIME": {
                        return (int)((Instant)value).getMillis();
                    }
                }
                throw new RuntimeException("Unhandled logical type " + fieldType.getLogicalType().getIdentifier());
            }
            case ARRAY: 
            case ITERABLE: {
                Iterable iterable = (Iterable)value;
                ArrayList<Object> translatedArray = Lists.newArrayListWithExpectedSize(Iterables.size(iterable));
                for (Object arrayElement : iterable) {
                    translatedArray.add(AvroUtils.genericFromBeamField(fieldType.getCollectionElementType(), typeWithNullability.type.getElementType(), arrayElement));
                }
                return translatedArray;
            }
            case MAP: {
                HashMap<Utf8, Object> map = Maps.newHashMap();
                Map valueMap = (Map)value;
                for (Map.Entry entry : valueMap.entrySet()) {
                    Utf8 key = new Utf8((String)entry.getKey());
                    map.put(key, AvroUtils.genericFromBeamField(fieldType.getMapValueType(), typeWithNullability.type.getValueType(), entry.getValue()));
                }
                return map;
            }
            case ROW: {
                return AvroUtils.toGenericRecord((Row)value, typeWithNullability.type);
            }
        }
        throw new IllegalArgumentException("Unsupported type " + fieldType);
    }

    public static @Nullable Object convertAvroFieldStrict(@Nullable Object value, @Nonnull org.apache.avro.Schema avroSchema, @Nonnull Schema.FieldType fieldType) {
        if (value == null) {
            return null;
        }
        TypeWithNullability type = new TypeWithNullability(avroSchema);
        LogicalType logicalType = LogicalTypes.fromSchema(type.type);
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypes.Decimal) {
                ByteBuffer byteBuffer = (ByteBuffer)value;
                BigDecimal bigDecimal = new Conversions.DecimalConversion().fromBytes(byteBuffer.duplicate(), type.type, logicalType);
                return AvroUtils.convertDecimal(bigDecimal, fieldType);
            }
            if (logicalType instanceof LogicalTypes.TimestampMillis) {
                if (value instanceof ReadableInstant) {
                    return AvroUtils.convertDateTimeStrict(((ReadableInstant)value).getMillis(), fieldType);
                }
                return AvroUtils.convertDateTimeStrict((Long)value, fieldType);
            }
            if (logicalType instanceof LogicalTypes.Date) {
                if (value instanceof ReadableInstant) {
                    int epochDays = Days.daysBetween(Instant.EPOCH, (ReadableInstant)value).getDays();
                    return AvroUtils.convertDateStrict(epochDays, fieldType);
                }
                return AvroUtils.convertDateStrict((Integer)value, fieldType);
            }
        }
        switch (type.type.getType()) {
            case FIXED: {
                return AvroUtils.convertFixedStrict((GenericFixed)value, fieldType);
            }
            case BYTES: {
                return AvroUtils.convertBytesStrict((ByteBuffer)value, fieldType);
            }
            case STRING: {
                return AvroUtils.convertStringStrict((CharSequence)value, fieldType);
            }
            case INT: {
                return AvroUtils.convertIntStrict((Integer)value, fieldType);
            }
            case LONG: {
                return AvroUtils.convertLongStrict((Long)value, fieldType);
            }
            case FLOAT: {
                return AvroUtils.convertFloatStrict((Float)value, fieldType);
            }
            case DOUBLE: {
                return AvroUtils.convertDoubleStrict((Double)value, fieldType);
            }
            case BOOLEAN: {
                return AvroUtils.convertBooleanStrict((Boolean)value, fieldType);
            }
            case RECORD: {
                return AvroUtils.convertRecordStrict((GenericRecord)value, fieldType);
            }
            case ENUM: {
                return AvroUtils.convertEnumStrict(value, fieldType);
            }
            case ARRAY: {
                return AvroUtils.convertArrayStrict((List)value, type.type.getElementType(), fieldType);
            }
            case MAP: {
                return AvroUtils.convertMapStrict((Map)value, type.type.getValueType(), fieldType);
            }
            case UNION: {
                return AvroUtils.convertUnionStrict(value, type.type, fieldType);
            }
            case NULL: {
                throw new IllegalArgumentException("Can't convert 'null' to non-nullable field");
            }
        }
        throw new AssertionError((Object)("Unexpected AVRO Schema.Type: " + (Object)((Object)type.type.getType())));
    }

    private static Object convertRecordStrict(GenericRecord record, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.ROW, "record");
        return AvroUtils.toBeamRowStrict(record, fieldType.getRowSchema());
    }

    private static Object convertBytesStrict(ByteBuffer bb, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.BYTES, "bytes");
        byte[] bytes = new byte[bb.remaining()];
        bb.duplicate().get(bytes);
        return bytes;
    }

    private static Object convertFixedStrict(GenericFixed fixed, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "fixed");
        Preconditions.checkArgument("FixedBytes".equals(fieldType.getLogicalType().getIdentifier()));
        return fixed.bytes().clone();
    }

    private static Object convertStringStrict(CharSequence value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.STRING, "string");
        return value.toString();
    }

    private static Object convertIntStrict(Integer value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.INT32, "int");
        return value;
    }

    private static Object convertLongStrict(Long value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.INT64, "long");
        return value;
    }

    private static Object convertDecimal(BigDecimal value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DECIMAL, "decimal");
        return value;
    }

    private static Object convertDateStrict(Integer epochDays, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DATETIME, "date");
        return Instant.EPOCH.plus(Duration.standardDays(epochDays.intValue()));
    }

    private static Object convertDateTimeStrict(Long value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DATETIME, "dateTime");
        return new Instant(value);
    }

    private static Object convertFloatStrict(Float value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.FLOAT, "float");
        return value;
    }

    private static Object convertDoubleStrict(Double value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.DOUBLE, "double");
        return value;
    }

    private static Object convertBooleanStrict(Boolean value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.BOOLEAN, "boolean");
        return value;
    }

    private static Object convertEnumStrict(Object value, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "enum");
        Preconditions.checkArgument(fieldType.getLogicalType().getIdentifier().equals("Enum"));
        EnumerationType enumerationType = fieldType.getLogicalType(EnumerationType.class);
        return enumerationType.valueOf(value.toString());
    }

    private static Object convertUnionStrict(Object value, org.apache.avro.Schema unionAvroSchema, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.LOGICAL_TYPE, "oneOfType");
        Preconditions.checkArgument(fieldType.getLogicalType().getIdentifier().equals("OneOf"));
        OneOfType oneOfType = fieldType.getLogicalType(OneOfType.class);
        int fieldNumber = GenericData.get().resolveUnion(unionAvroSchema, value);
        Schema.FieldType baseFieldType = oneOfType.getOneOfSchema().getField(fieldNumber).getType();
        Object convertedValue = AvroUtils.convertAvroFieldStrict(value, unionAvroSchema.getTypes().get(fieldNumber), baseFieldType);
        return oneOfType.createValue(fieldNumber, convertedValue);
    }

    private static Object convertArrayStrict(List<Object> values, org.apache.avro.Schema elemAvroSchema, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.ARRAY, "array");
        ArrayList<Object> ret = new ArrayList<Object>(values.size());
        Schema.FieldType elemFieldType = fieldType.getCollectionElementType();
        for (Object value : values) {
            ret.add(AvroUtils.convertAvroFieldStrict(value, elemAvroSchema, elemFieldType));
        }
        return ret;
    }

    private static Object convertMapStrict(Map<CharSequence, Object> values, org.apache.avro.Schema valueAvroSchema, Schema.FieldType fieldType) {
        AvroUtils.checkTypeName(fieldType.getTypeName(), Schema.TypeName.MAP, "map");
        Preconditions.checkNotNull(fieldType.getMapKeyType());
        Preconditions.checkNotNull(fieldType.getMapValueType());
        if (!fieldType.getMapKeyType().equals(Schema.FieldType.STRING)) {
            throw new IllegalArgumentException("Can't convert 'string' map keys to " + fieldType.getMapKeyType());
        }
        HashMap<Object, Object> ret = new HashMap<Object, Object>();
        for (Map.Entry<CharSequence, Object> value : values.entrySet()) {
            ret.put(AvroUtils.convertStringStrict(value.getKey(), fieldType.getMapKeyType()), AvroUtils.convertAvroFieldStrict(value.getValue(), valueAvroSchema, fieldType.getMapValueType()));
        }
        return ret;
    }

    private static void checkTypeName(Schema.TypeName got, Schema.TypeName expected, String label) {
        Preconditions.checkArgument(got.equals((Object)expected), "Can't convert '%s' to %s, expected: %s", (Object)label, (Object)got, (Object)expected);
    }

    private static org.apache.avro.Schema buildHiveLogicalTypeSchema(String hiveLogicalType, int size) {
        String schemaJson = String.format("{\"type\": \"string\", \"logicalType\": \"%s\", \"maxLength\": %s}", hiveLogicalType, size);
        return new Schema.Parser().parse(schemaJson);
    }

    static {
        SpecificData.get().addLogicalTypeConversion(new AvroCoder.JodaTimestampConversion());
        GenericData.get().addLogicalTypeConversion(new AvroCoder.JodaTimestampConversion());
    }

    private static final class AvroPojoFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private AvroPojoFieldValueTypeSupplier() {
        }

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            List<Field> classFields = ReflectUtils.getFields(clazz);
            HashMap<String, FieldValueTypeInformation> types = Maps.newHashMap();
            for (int i = 0; i < classFields.size(); ++i) {
                Field f = classFields.get(i);
                if (f.isAnnotationPresent(AvroIgnore.class)) continue;
                FieldValueTypeInformation typeInformation = FieldValueTypeInformation.forField(f, i);
                AvroName avroname = f.getAnnotation(AvroName.class);
                if (avroname != null) {
                    typeInformation = typeInformation.withName(avroname.value());
                }
                types.put(typeInformation.getName(), typeInformation);
            }
            return Lists.newArrayList(types.values());
        }
    }

    private static final class AvroSpecificRecordFieldValueTypeSupplier
    implements FieldValueTypeSupplier {
        private AvroSpecificRecordFieldValueTypeSupplier() {
        }

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz) {
            throw new RuntimeException("Unexpected call.");
        }

        @Override
        public List<FieldValueTypeInformation> get(Class<?> clazz, Schema schema) {
            Map<String, String> mapping = this.getMapping(schema);
            List<Method> methods = ReflectUtils.getMethods(clazz);
            ArrayList<FieldValueTypeInformation> types = Lists.newArrayList();
            for (int i = 0; i < methods.size(); ++i) {
                FieldValueTypeInformation fieldValueTypeInformation;
                String name;
                Method method = methods.get(i);
                if (!ReflectUtils.isGetter(method) || (name = mapping.get((fieldValueTypeInformation = FieldValueTypeInformation.forGetter(method, i)).getName())) == null) continue;
                types.add(fieldValueTypeInformation.withName(name));
            }
            return StaticSchemaInference.sortBySchema(types, schema);
        }

        private Map<String, String> getMapping(Schema schema) {
            HashMap<String, String> mapping = Maps.newHashMap();
            for (Schema.Field field : schema.getFields()) {
                String fieldName = field.getName();
                String getter = fieldName.contains("_") ? (Character.isLowerCase(fieldName.charAt(0)) ? CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, fieldName) : CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, fieldName.replace("_", ""))) : (Character.isUpperCase(fieldName.charAt(0)) ? CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, fieldName) : fieldName);
                mapping.put(getter, fieldName);
                mapping.put(getter + "$", fieldName);
            }
            return mapping;
        }
    }

    private static class RowToGenericRecordFn
    implements SerializableFunction<Row, GenericRecord> {
        private transient org.apache.avro.Schema avroSchema;

        RowToGenericRecordFn(@Nullable org.apache.avro.Schema avroSchema) {
            this.avroSchema = avroSchema;
        }

        @Override
        public GenericRecord apply(Row input) {
            return AvroUtils.toGenericRecord(input, this.avroSchema);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            RowToGenericRecordFn that = (RowToGenericRecordFn)other;
            return Objects.equals(this.avroSchema, that.avroSchema);
        }

        public int hashCode() {
            return Objects.hash(this.avroSchema);
        }

        private void writeObject(ObjectOutputStream out) throws IOException {
            String avroSchemaAsString = this.avroSchema == null ? null : this.avroSchema.toString();
            out.writeObject(avroSchemaAsString);
        }

        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            String avroSchemaAsString = (String)in.readObject();
            this.avroSchema = avroSchemaAsString == null ? null : new Schema.Parser().parse(avroSchemaAsString);
        }
    }

    private static class GenericRecordToRowFn
    implements SerializableFunction<GenericRecord, Row> {
        private final Schema schema;

        GenericRecordToRowFn(Schema schema) {
            this.schema = schema;
        }

        @Override
        public Row apply(GenericRecord input) {
            return AvroUtils.toBeamRowStrict(input, this.schema);
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (other == null || this.getClass() != other.getClass()) {
                return false;
            }
            GenericRecordToRowFn that = (GenericRecordToRowFn)other;
            return Objects.equals(this.schema, that.schema);
        }

        public int hashCode() {
            return Objects.hash(this.schema);
        }
    }

    private static class RowToAvroBytesFn
    extends SimpleFunction<Row, byte[]> {
        private final transient org.apache.avro.Schema avroSchema;
        private final AvroCoder<GenericRecord> coder;

        RowToAvroBytesFn(Schema beamSchema) {
            this.avroSchema = AvroUtils.toAvroSchema(beamSchema);
            this.coder = AvroCoder.of(this.avroSchema);
        }

        @Override
        public byte[] apply(Row row) {
            try {
                GenericRecord record = AvroUtils.toGenericRecord(row, this.avroSchema);
                ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                this.coder.encode(record, outputStream);
                return outputStream.toByteArray();
            }
            catch (Exception e) {
                throw new AvroRuntimeException(String.format("Could not encode avro from given row: %s", row), e);
            }
        }
    }

    private static class AvroBytesToRowFn
    extends SimpleFunction<byte[], Row> {
        private final AvroCoder<GenericRecord> coder;
        private final Schema beamSchema;

        AvroBytesToRowFn(Schema beamSchema) {
            org.apache.avro.Schema avroSchema = AvroUtils.toAvroSchema(beamSchema);
            this.coder = AvroCoder.of(avroSchema);
            this.beamSchema = beamSchema;
        }

        @Override
        public Row apply(byte[] bytes) {
            try {
                ByteArrayInputStream inputStream = new ByteArrayInputStream(bytes);
                GenericRecord record = this.coder.decode(inputStream);
                return AvroUtils.toBeamRowStrict(record, this.beamSchema);
            }
            catch (Exception e) {
                throw new AvroRuntimeException("Could not decode avro record from given bytes " + new String(bytes, StandardCharsets.UTF_8), e);
            }
        }
    }

    static class AvroTypeConversionFactory
    implements ByteBuddyUtils.TypeConversionsFactory {
        AvroTypeConversionFactory() {
        }

        @Override
        public ByteBuddyUtils.TypeConversion<Type> createTypeConversion(boolean returnRawTypes) {
            return new AvroConvertType(returnRawTypes);
        }

        @Override
        public ByteBuddyUtils.TypeConversion<StackManipulation> createGetterConversions(StackManipulation readValue) {
            return new AvroConvertValueForGetter(readValue);
        }

        @Override
        public ByteBuddyUtils.TypeConversion<StackManipulation> createSetterConversions(StackManipulation readValue) {
            return new AvroConvertValueForSetter(readValue);
        }
    }

    public static class AvroConvertValueForSetter
    extends ByteBuddyUtils.ConvertValueForSetter {
        AvroConvertValueForSetter(StackManipulation readValue) {
            super(readValue);
        }

        @Override
        protected ByteBuddyUtils.TypeConversionsFactory getFactory() {
            return new AvroTypeConversionFactory();
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            TypeDescription.ForLoadedType byteArrayType = new TypeDescription.ForLoadedType(byte[].class);
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                TypeDescription.ForLoadedType loadedType = new TypeDescription.ForLoadedType(type.getRawType());
                return new StackManipulation.Compound(TypeCreation.of(loadedType), Duplication.SINGLE, this.readValue, TypeCasting.to(byteArrayType), MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)loadedType.getDeclaredMethods().filter(ElementMatchers.isConstructor().and(ElementMatchers.takesArguments(new TypeDescription[]{byteArrayType})))).getOnly()));
            }
            return super.convertDefault((TypeDescriptor)type);
        }
    }

    public static class AvroConvertValueForGetter
    extends ByteBuddyUtils.ConvertValueForGetter {
        AvroConvertValueForGetter(StackManipulation readValue) {
            super(readValue);
        }

        @Override
        protected ByteBuddyUtils.TypeConversionsFactory getFactory() {
            return new AvroTypeConversionFactory();
        }

        @Override
        protected StackManipulation convertDefault(TypeDescriptor<?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                return new StackManipulation.Compound(this.readValue, MethodInvocation.invoke((MethodDescription.InDefinedShape)((MethodList)new TypeDescription.ForLoadedType(GenericFixed.class).getDeclaredMethods().filter(ElementMatchers.named("bytes").and(ElementMatchers.returns(new TypeDescription.ForLoadedType(byte[].class))))).getOnly()));
            }
            return super.convertDefault((TypeDescriptor)type);
        }
    }

    public static class AvroConvertType
    extends ByteBuddyUtils.ConvertType {
        public AvroConvertType(boolean returnRawType) {
            super(returnRawType);
        }

        @Override
        protected Type convertDefault(TypeDescriptor<?> type) {
            if (type.isSubtypeOf(TypeDescriptor.of(GenericFixed.class))) {
                return byte[].class;
            }
            return super.convertDefault((TypeDescriptor)type);
        }
    }

    public static class FixedBytesField {
        private final int size;

        private FixedBytesField(int size) {
            this.size = size;
        }

        public static FixedBytesField withSize(int size) {
            return new FixedBytesField(size);
        }

        public static @Nullable FixedBytesField fromBeamFieldType(Schema.FieldType fieldType) {
            if (fieldType.getTypeName().isLogicalType() && fieldType.getLogicalType().getIdentifier().equals("FixedBytes")) {
                int length = fieldType.getLogicalType(FixedBytes.class).getLength();
                return new FixedBytesField(length);
            }
            return null;
        }

        public static @Nullable FixedBytesField fromAvroType(org.apache.avro.Schema type) {
            if (type.getType().equals((Object)Schema.Type.FIXED)) {
                return new FixedBytesField(type.getFixedSize());
            }
            return null;
        }

        public int getSize() {
            return this.size;
        }

        public Schema.FieldType toBeamType() {
            return Schema.FieldType.logicalType(FixedBytes.of(this.size));
        }

        public org.apache.avro.Schema toAvroType(String name, String namespace) {
            return org.apache.avro.Schema.createFixed(name, null, namespace, this.size);
        }
    }

    static class TypeWithNullability {
        public final org.apache.avro.Schema type;
        public final boolean nullable;

        TypeWithNullability(org.apache.avro.Schema avroSchema) {
            if (avroSchema.getType() == Schema.Type.UNION) {
                List<org.apache.avro.Schema> types = avroSchema.getTypes();
                List<org.apache.avro.Schema> nonNullTypes = types.stream().filter(x -> x.getType() != Schema.Type.NULL).collect(Collectors.toList());
                if (nonNullTypes.size() == types.size() || nonNullTypes.isEmpty()) {
                    this.type = avroSchema;
                    this.nullable = false;
                } else if (nonNullTypes.size() > 1) {
                    this.type = org.apache.avro.Schema.createUnion(nonNullTypes);
                    this.nullable = true;
                } else {
                    this.type = nonNullTypes.get(0);
                    this.nullable = true;
                }
            } else {
                this.type = avroSchema;
                this.nullable = false;
            }
        }
    }
}

