/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Select_Fields;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Select_Flattened;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.MoreObjects;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Select {
    public static <T> Fields<T> create() {
        return Select.fieldAccess(FieldAccessDescriptor.create());
    }

    public static <T> Fields<T> fieldIds(Integer ... ids) {
        return Select.fieldAccess(FieldAccessDescriptor.withFieldIds(ids));
    }

    public static <T> Fields<T> fieldNames(String ... names) {
        return Select.fieldAccess(FieldAccessDescriptor.withFieldNames(names));
    }

    public static <T> Fields<T> fieldAccess(FieldAccessDescriptor fieldAccessDescriptor) {
        return new AutoValue_Select_Fields.Builder().setFieldAccessDescriptor(fieldAccessDescriptor).build();
    }

    public static <T> Flattened<T> flattenedSchema() {
        return new AutoValue_Select_Flattened.Builder().setNameFn(SelectHelpers.CONCAT_FIELD_NAMES).setNameOverrides(Collections.emptyMap()).build();
    }

    private static Schema uniquifyNames(Schema schema) {
        Schema.Builder builder = new Schema.Builder();
        for (Schema.Field field : schema.getFields()) {
            builder.addField(UUID.randomUUID().toString(), Select.uniquifyNames(field.getType()));
        }
        return builder.build();
    }

    private static Schema.FieldType uniquifyNames(Schema.FieldType fieldType) {
        switch (fieldType.getTypeName()) {
            case ROW: {
                return Schema.FieldType.row(Select.uniquifyNames(fieldType.getRowSchema())).withNullable(fieldType.getNullable()).withMetadata(fieldType.getAllMetadata());
            }
            case ARRAY: {
                return Schema.FieldType.array(Select.uniquifyNames(fieldType.getCollectionElementType())).withNullable(fieldType.getNullable());
            }
            case ITERABLE: {
                return Schema.FieldType.iterable(Select.uniquifyNames(fieldType.getCollectionElementType())).withNullable(fieldType.getNullable());
            }
            case MAP: {
                return Schema.FieldType.map(Select.uniquifyNames(fieldType.getMapKeyType()), Select.uniquifyNames(fieldType.getMapValueType())).withNullable(fieldType.getNullable());
            }
        }
        return fieldType;
    }

    @AutoValue
    public static abstract class Flattened<T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        abstract SerializableFunction<List<String>, String> getNameFn();

        abstract Map<String, String> getNameOverrides();

        abstract @Nullable Schema getOutputSchema();

        abstract Builder<T> toBuilder();

        public Flattened<T> concatFieldNames() {
            return this.toBuilder().setNameFn(SelectHelpers.CONCAT_FIELD_NAMES).build();
        }

        public Flattened<T> keepMostNestedFieldName() {
            return this.toBuilder().setNameFn(SelectHelpers.KEEP_NESTED_NAME).build();
        }

        public Flattened<T> withFieldNameAs(String fieldName, String fieldRename) {
            ImmutableMap<String, String> overrides = ImmutableMap.builder().putAll(this.getNameOverrides()).put(fieldName, fieldRename).build();
            return this.toBuilder().setNameOverrides(overrides).build();
        }

        public Flattened<T> withOutputSchema(Schema schema) {
            return this.toBuilder().setOutputSchema(schema).build();
        }

        @Override
        public PCollection<Row> expand(PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            FieldAccessDescriptor fieldAccessDescriptor = SelectHelpers.allLeavesDescriptor(inputSchema, n -> MoreObjects.firstNonNull(this.getNameOverrides().get(String.join((CharSequence)".", n)), this.getNameFn().apply((List<String>)n)));
            Schema inferredOutputSchema = SelectHelpers.getOutputSchema(inputSchema, fieldAccessDescriptor);
            Schema outputSchema = this.getOutputSchema();
            if (outputSchema != null) {
                Preconditions.checkArgument(outputSchema.typesEqual(inferredOutputSchema));
            } else {
                outputSchema = inferredOutputSchema;
            }
            return ((PCollection)input.apply(ParDo.of(new SelectDoFn(fieldAccessDescriptor, inputSchema, outputSchema)))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setNameFn(SerializableFunction<List<String>, String> var1);

            abstract Builder<T> setNameOverrides(Map<String, String> var1);

            abstract Builder<T> setOutputSchema(@Nullable Schema var1);

            abstract Flattened<T> build();
        }
    }

    @AutoValue
    public static abstract class Fields<T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        abstract FieldAccessDescriptor getFieldAccessDescriptor();

        abstract @Nullable Schema getOutputSchema();

        abstract Builder<T> toBuilder();

        public Fields<T> withFieldNameAs(String fieldName, String fieldRename) {
            return this.toBuilder().setFieldAccessDescriptor(this.getFieldAccessDescriptor().withFieldNameAs(fieldName, fieldRename)).build();
        }

        public Fields<T> withOutputSchema(Schema schema) {
            return this.toBuilder().setOutputSchema(schema).build();
        }

        @Override
        public PCollection<Row> expand(PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            FieldAccessDescriptor resolved = this.getFieldAccessDescriptor().resolve(inputSchema);
            Schema outputSchema = this.getOutputSchema();
            if (outputSchema == null) {
                outputSchema = SelectHelpers.getOutputSchema(inputSchema, resolved);
            } else {
                inputSchema = Select.uniquifyNames(inputSchema);
                Schema inferredSchema = SelectHelpers.getOutputSchema(inputSchema, resolved);
                Preconditions.checkArgument(outputSchema.typesEqual(inferredSchema), "Types not equal. provided output schema: " + outputSchema + " Schema inferred from select: " + inferredSchema + " from input type: " + input.getSchema());
            }
            return ((PCollection)input.apply(ParDo.of(new SelectDoFn(resolved, inputSchema, outputSchema)))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFieldAccessDescriptor(FieldAccessDescriptor var1);

            abstract Builder<T> setOutputSchema(Schema var1);

            abstract Fields<T> build();
        }
    }

    private static class SelectDoFn<T>
    extends DoFn<T, Row> {
        RowSelector rowSelector;
        @DoFn.FieldAccess(value="selectFields")
        final FieldAccessDescriptor fieldAccess = FieldAccessDescriptor.withAllFields();

        public SelectDoFn(FieldAccessDescriptor fieldAccessDescriptor, Schema inputSchema, Schema outputSchema) {
            this.rowSelector = new SelectHelpers.RowSelectorContainer(inputSchema, fieldAccessDescriptor, true);
        }

        @DoFn.ProcessElement
        public void process(@DoFn.FieldAccess(value="selectFields") @DoFn.Element Row row, DoFn.OutputReceiver<Row> r) {
            r.output(this.rowSelector.select(row));
        }
    }
}

