/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import com.google.auto.value.AutoValue;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.KvCoder;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Group_ByFields;
import org.apache.beam.sdk.schemas.transforms.AutoValue_Group_CombineFieldsByFields;
import org.apache.beam.sdk.schemas.transforms.Convert;
import org.apache.beam.sdk.schemas.transforms.SchemaAggregateFn;
import org.apache.beam.sdk.schemas.utils.RowSelector;
import org.apache.beam.sdk.schemas.utils.SelectHelpers;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.GroupByKey;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.WithKeys;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.values.KV;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class Group {
    public static <T> Global<T> globally() {
        return new Global();
    }

    public static <T> ByFields<T> byFieldNames(String ... fieldNames) {
        return ByFields.of(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> ByFields<T> byFieldNames(Iterable<String> fieldNames) {
        return ByFields.of(FieldAccessDescriptor.withFieldNames(fieldNames));
    }

    public static <T> ByFields<T> byFieldIds(Integer ... fieldIds) {
        return ByFields.of(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> ByFields<T> byFieldIds(Iterable<Integer> fieldIds) {
        return ByFields.of(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> ByFields<T> byFieldAccessDescriptor(FieldAccessDescriptor fieldAccess) {
        return ByFields.of(fieldAccess);
    }

    @AutoValue
    public static abstract class CombineFieldsByFields<InputT>
    extends AggregateCombiner<InputT> {
        abstract ByFields<InputT> getByFields();

        abstract SchemaAggregateFn.Inner getSchemaAggregateFn();

        abstract String getKeyField();

        abstract String getValueField();

        abstract Builder<InputT> toBuilder();

        static <InputT> CombineFieldsByFields<InputT> of(ByFields<InputT> byFields, SchemaAggregateFn.Inner schemaAggregateFn, String keyField, String valueField) {
            return new AutoValue_Group_CombineFieldsByFields.Builder<InputT>().setByFields(byFields).setSchemaAggregateFn(schemaAggregateFn).setKeyField(keyField).setValueField(valueField).build();
        }

        public CombineFieldsByFields<InputT> withKeyField(String keyField) {
            return this.toBuilder().setKeyField(keyField).build();
        }

        public CombineFieldsByFields<InputT> witValueField(String valueField) {
            return this.toBuilder().setValueField(valueField).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName)).build();
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField)).build();
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(fieldsToAggregate, false, fn, outputFieldName)).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.toBuilder().setSchemaAggregateFn(this.getSchemaAggregateFn().aggregateFields(fieldsToAggregate, false, fn, outputField)).build();
        }

        @Override
        public PCollection<Row> expand(PCollection<InputT> input) {
            SchemaAggregateFn.Inner fn = this.getSchemaAggregateFn().withSchema(input.getSchema());
            Schema keySchema = this.getByFields().getKeySchema(input.getSchema());
            final Schema outputSchema = Schema.builder().addRowField(this.getKeyField(), keySchema).addRowField(this.getValueField(), this.getSchemaAggregateFn().getOutputSchema()).build();
            return ((PCollection)((Object)((PCollection)((PCollection)input.apply("ToKvs", this.getByFields().getToKvs())).apply("Combine", Combine.groupedValues(fn))).apply("ToRow", ParDo.of(new DoFn<KV<Row, Row>, Row>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element KV<Row, Row> element, DoFn.OutputReceiver<Row> o) {
                    o.output(Row.withSchema(outputSchema).attachValues(Lists.newArrayList(element.getKey(), element.getValue())));
                }
            })))).setRowSchema(outputSchema);
        }

        @AutoValue.Builder
        static abstract class Builder<InputT> {
            Builder() {
            }

            abstract Builder<InputT> setByFields(ByFields<InputT> var1);

            abstract Builder<InputT> setSchemaAggregateFn(SchemaAggregateFn.Inner var1);

            abstract Builder<InputT> setKeyField(String var1);

            abstract Builder<InputT> setValueField(String var1);

            abstract CombineFieldsByFields<InputT> build();
        }
    }

    @AutoValue
    public static abstract class ByFields<InputT>
    extends AggregateCombiner<InputT> {
        abstract FieldAccessDescriptor getFieldAccessDescriptor();

        abstract String getKeyField();

        abstract String getValueField();

        abstract Builder<InputT> toBuilder();

        public ToKv getToKvs() {
            return new ToKv();
        }

        private static <InputT> ByFields<InputT> of(FieldAccessDescriptor fieldAccessDescriptor) {
            return new AutoValue_Group_ByFields.Builder().setFieldAccessDescriptor(fieldAccessDescriptor).setKeyField("key").setValueField("value").build();
        }

        public ByFields<InputT> withKeyField(String keyField) {
            return this.toBuilder().setKeyField(keyField).build();
        }

        public ByFields<InputT> withValueField(String valueField) {
            return this.toBuilder().setValueField(valueField).build();
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField), this.getKeyField(), this.getValueField());
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputFieldName), this.getKeyField(), this.getValueField());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsByFields<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return CombineFieldsByFields.of(this, SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputField), this.getKeyField(), this.getValueField());
        }

        Schema getKeySchema(Schema inputSchema) {
            FieldAccessDescriptor resolved = this.getFieldAccessDescriptor().resolve(inputSchema);
            return SelectHelpers.getOutputSchema(inputSchema, resolved);
        }

        @Override
        public PCollection<Row> expand(PCollection<InputT> input) {
            Schema schema = input.getSchema();
            Schema keySchema = this.getKeySchema(schema);
            final Schema outputSchema = Schema.builder().addRowField(this.getKeyField(), keySchema).addIterableField(this.getValueField(), Schema.FieldType.row(schema)).build();
            return ((PCollection)((Object)((PCollection)input.apply("ToKvs", this.getToKvs())).apply("ToRow", ParDo.of(new DoFn<KV<Row, Iterable<Row>>, Row>(){

                @DoFn.ProcessElement
                public void process(@DoFn.Element KV<Row, Iterable<Row>> e, DoFn.OutputReceiver<Row> o) {
                    o.output(Row.withSchema(outputSchema).attachValues(Lists.newArrayList(e.getKey(), e.getValue())));
                }
            })))).setRowSchema(outputSchema);
        }

        class ToKv
        extends PTransform<PCollection<InputT>, PCollection<KV<Row, Iterable<Row>>>> {
            private RowSelector rowSelector;

            ToKv() {
            }

            @Override
            public PCollection<KV<Row, Iterable<Row>>> expand(PCollection<InputT> input) {
                Schema schema = input.getSchema();
                FieldAccessDescriptor resolved = ByFields.this.getFieldAccessDescriptor().resolve(schema);
                this.rowSelector = new SelectHelpers.RowSelectorContainer(schema, resolved, true);
                Schema keySchema = ByFields.this.getKeySchema(schema);
                return (PCollection)((PCollection)input.apply("toRow", Convert.toRows()).apply("selectKeys", WithKeys.of(e -> this.rowSelector.select((Row)e)).withKeyType(TypeDescriptors.rows()))).setCoder(KvCoder.of(SchemaCoder.of(keySchema), SchemaCoder.of(schema))).apply("GroupByKey", GroupByKey.create());
            }
        }

        @AutoValue.Builder
        static abstract class Builder<InputT> {
            Builder() {
            }

            abstract Builder<InputT> setFieldAccessDescriptor(FieldAccessDescriptor var1);

            abstract Builder<InputT> setKeyField(String var1);

            abstract Builder<InputT> setValueField(String var1);

            abstract ByFields<InputT> build();
        }
    }

    public static class CombineFieldsGlobally<InputT>
    extends AggregateCombiner<InputT> {
        private final SchemaAggregateFn.Inner schemaAggregateFn;

        CombineFieldsGlobally(SchemaAggregateFn.Inner schemaAggregateFn) {
            this.schemaAggregateFn = schemaAggregateFn;
        }

        public static CombineFieldsGlobally create() {
            return new CombineFieldsGlobally(SchemaAggregateFn.create());
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName));
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField));
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldAccessDescriptor, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        @Override
        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldAccessDescriptor, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally<InputT>(this.schemaAggregateFn.aggregateFields(fieldAccessDescriptor, false, fn, outputField));
        }

        @Override
        public PCollection<Row> expand(PCollection<InputT> input) {
            SchemaAggregateFn.Inner fn = this.schemaAggregateFn.withSchema(input.getSchema());
            Combine.Globally<Row, Row> combineFn = Combine.globally(fn);
            if (!(input.getWindowingStrategy().getWindowFn() instanceof GlobalWindows)) {
                combineFn = combineFn.withoutDefaults();
            }
            return ((PCollection)((Object)input.apply("toRows", Convert.toRows()).apply("Global Combine", combineFn))).setRowSchema(fn.getOutputSchema());
        }
    }

    public static abstract class AggregateCombiner<InputT>
    extends PTransform<PCollection<InputT>, PCollection<Row>> {
        public abstract <CombineInputT, AccumT, CombineOutputT> AggregateCombiner<InputT> aggregateField(int var1, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, Schema.Field var3);

        public abstract <CombineInputT, AccumT, CombineOutputT> AggregateCombiner<InputT> aggregateField(String var1, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, Schema.Field var3);

        public abstract <CombineInputT, AccumT, CombineOutputT> AggregateCombiner<InputT> aggregateFieldsById(List<Integer> var1, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> var2, Schema.Field var3);
    }

    public static class CombineGlobally<InputT, OutputT>
    extends PTransform<PCollection<InputT>, PCollection<OutputT>> {
        final Combine.CombineFn<InputT, ?, OutputT> combineFn;

        CombineGlobally(Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            this.combineFn = combineFn;
        }

        @Override
        public PCollection<OutputT> expand(PCollection<InputT> input) {
            return (PCollection)input.apply("globalCombine", Combine.globally(this.combineFn));
        }
    }

    public static class Global<InputT>
    extends PTransform<PCollection<InputT>, PCollection<Iterable<InputT>>> {
        public <OutputT> CombineGlobally<InputT, OutputT> aggregate(Combine.CombineFn<InputT, ?, OutputT> combineFn) {
            return new CombineGlobally<InputT, OutputT>(combineFn);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(int inputFieldId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldId), true, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), false, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(String inputFieldName, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldName), true, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateField(int inputFielId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFielId), false, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldBaseValue(int inputFielId, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(FieldAccessDescriptor.withFieldIds(inputFielId), true, fn, outputField));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputFieldName);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, String outputFieldName) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputFieldName));
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(List<String> inputFieldNames, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldNames(inputFieldNames), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFieldsById(List<Integer> inputFieldIds, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return this.aggregateFields(FieldAccessDescriptor.withFieldIds(inputFieldIds), fn, outputField);
        }

        public <CombineInputT, AccumT, CombineOutputT> CombineFieldsGlobally<InputT> aggregateFields(FieldAccessDescriptor fieldsToAggregate, Combine.CombineFn<CombineInputT, AccumT, CombineOutputT> fn, Schema.Field outputField) {
            return new CombineFieldsGlobally(SchemaAggregateFn.create().aggregateFields(fieldsToAggregate, false, fn, outputField));
        }

        @Override
        public PCollection<Iterable<InputT>> expand(PCollection<InputT> input) {
            return (PCollection)((PCollection)((PCollection)input.apply("addNullKey", WithKeys.of((Void)null))).apply("group", GroupByKey.create())).apply("extractValues", Values.create());
        }
    }
}

