/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.transforms;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.FieldAccessDescriptor;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.transforms.Select;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class DropFields {
    public static <T> Inner<T> fields(String ... fields) {
        return DropFields.fields(FieldAccessDescriptor.withFieldNames(fields));
    }

    public static <T> Inner<T> fields(Integer ... fieldIds) {
        return DropFields.fields(FieldAccessDescriptor.withFieldIds(fieldIds));
    }

    public static <T> Inner<T> fields(FieldAccessDescriptor fieldsToDrop) {
        return new Inner(fieldsToDrop);
    }

    public static class Inner<T>
    extends PTransform<PCollection<T>, PCollection<Row>> {
        private final FieldAccessDescriptor fieldsToDrop;

        private Inner(FieldAccessDescriptor fieldsToDrop) {
            this.fieldsToDrop = fieldsToDrop;
        }

        FieldAccessDescriptor complement(Schema inputSchema, FieldAccessDescriptor input) {
            ArrayList<String> fieldNamesToSelect = Lists.newArrayList();
            HashMap<FieldAccessDescriptor.FieldDescriptor, FieldAccessDescriptor> nestedFieldsToSelect = Maps.newHashMap();
            for (int i = 0; i < inputSchema.getFieldCount(); ++i) {
                if (input.fieldIdsAccessed().contains(i)) continue;
                Schema.Field field = inputSchema.getField(i);
                Map<Integer, FieldAccessDescriptor.FieldDescriptor> nestedFields = input.getNestedFieldsAccessed().keySet().stream().collect(Collectors.toMap(k -> k.getFieldId(), k -> k));
                FieldAccessDescriptor.FieldDescriptor fieldDescriptor = nestedFields.get(i);
                if (fieldDescriptor != null) {
                    Schema.FieldType fieldType = inputSchema.getField(i).getType();
                    block5: for (FieldAccessDescriptor.FieldDescriptor.Qualifier qualifier : fieldDescriptor.getQualifiers()) {
                        switch (qualifier.getKind()) {
                            case LIST: {
                                fieldType = fieldType.getCollectionElementType();
                                continue block5;
                            }
                            case MAP: {
                                fieldType = fieldType.getMapValueType();
                                continue block5;
                            }
                        }
                        throw new RuntimeException("Unexpected field descriptor type.");
                    }
                    Preconditions.checkArgument(fieldType.getTypeName().isCompositeType());
                    FieldAccessDescriptor nestedDescriptor = input.getNestedFieldsAccessed().get(fieldDescriptor);
                    nestedFieldsToSelect.put(fieldDescriptor, this.complement(fieldType.getRowSchema(), nestedDescriptor));
                    continue;
                }
                fieldNamesToSelect.add(field.getName());
            }
            FieldAccessDescriptor fieldAccess = FieldAccessDescriptor.withFieldNames(fieldNamesToSelect);
            for (Map.Entry entry : nestedFieldsToSelect.entrySet()) {
                fieldAccess = fieldAccess.withNestedField((FieldAccessDescriptor.FieldDescriptor)entry.getKey(), (FieldAccessDescriptor)entry.getValue());
            }
            return fieldAccess.resolve(inputSchema);
        }

        @Override
        public PCollection<Row> expand(PCollection<T> input) {
            Schema inputSchema = input.getSchema();
            FieldAccessDescriptor selectDescriptor = this.complement(inputSchema, this.fieldsToDrop.resolve(inputSchema));
            return (PCollection)input.apply(Select.fieldAccess(selectDescriptor));
        }
    }
}

