/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io.payloads;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializer;
import org.apache.beam.sdk.schemas.io.payloads.PayloadSerializerProvider;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public class JsonPayloadSerializerProvider
implements PayloadSerializerProvider {
    @Override
    public String identifier() {
        return "json";
    }

    @Override
    public PayloadSerializer getSerializer(Schema schema, Map<String, Object> tableParams) {
        ObjectMapper deserializeMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(schema));
        ObjectMapper serializeMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonSerializer.forSchema(schema));
        return PayloadSerializer.of(row -> RowJsonUtils.rowToJson(serializeMapper, row).getBytes(StandardCharsets.UTF_8), bytes -> RowJsonUtils.jsonToRow(deserializeMapper, new String((byte[])bytes, StandardCharsets.UTF_8)));
    }
}

