/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas.io;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.annotations.Internal;
import org.apache.beam.sdk.schemas.io.Failure;
import org.apache.beam.sdk.schemas.io.GenericDlqProvider;
import org.apache.beam.sdk.schemas.io.Providers;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;

@Internal
@Experimental(value=Experimental.Kind.SCHEMAS)
public final class GenericDlq {
    private static final Map<String, GenericDlqProvider> PROVIDERS = Providers.loadProviders(GenericDlqProvider.class);

    private GenericDlq() {
    }

    public static PTransform<PCollection<Failure>, PDone> getDlqTransform(String fullConfig) {
        List<String> strings = Splitter.on(":").limit(2).splitToList(fullConfig);
        Preconditions.checkArgument(strings.size() == 2, "Invalid config, must start with `identifier:`. %s", (Object)fullConfig);
        String key = strings.get(0);
        String config = strings.get(1).trim();
        GenericDlqProvider provider = PROVIDERS.get(key);
        Preconditions.checkArgument(provider != null, "Invalid config, no DLQ provider exists with identifier `%s`.", (Object)key);
        return provider.newDlqTransform(config);
    }
}

