/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.beam.model.pipeline.v1.SchemaApi;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.logicaltypes.MicrosInstant;
import org.apache.beam.sdk.schemas.logicaltypes.UnknownLogicalType;
import org.apache.beam.sdk.util.SerializableUtils;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.vendor.grpc.v1p43p2.com.google.protobuf.ByteString;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Iterables;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaTranslation {
    private static final String URN_BEAM_LOGICAL_DATETIME = "beam:logical_type:datetime:v1";
    private static final String URN_BEAM_LOGICAL_DECIMAL = "beam:logical_type:decimal:v1";
    private static final String URN_BEAM_LOGICAL_JAVASDK = "beam:logical_type:javasdk:v1";
    private static final ImmutableMap<String, Class<? extends Schema.LogicalType<?, ?>>> STANDARD_LOGICAL_TYPES = ImmutableMap.of("beam:logical_type:micros_instant:v1", MicrosInstant.class);

    public static SchemaApi.Schema schemaToProto(Schema schema, boolean serializeLogicalType) {
        String uuid = schema.getUUID() != null ? schema.getUUID().toString() : "";
        SchemaApi.Schema.Builder builder = SchemaApi.Schema.newBuilder().setId(uuid);
        for (Schema.Field field : schema.getFields()) {
            SchemaApi.Field protoField = SchemaTranslation.fieldToProto(field, schema.indexOf(field.getName()), schema.getEncodingPositions().get(field.getName()), serializeLogicalType);
            builder.addFields(protoField);
        }
        builder.addAllOptions(SchemaTranslation.optionsToProto(schema.getOptions()));
        return builder.build();
    }

    private static SchemaApi.Field fieldToProto(Schema.Field field, int fieldId, int position, boolean serializeLogicalType) {
        return SchemaApi.Field.newBuilder().setName(field.getName()).setDescription(field.getDescription()).setType(SchemaTranslation.fieldTypeToProto(field.getType(), serializeLogicalType)).setId(fieldId).setEncodingPosition(position).addAllOptions(SchemaTranslation.optionsToProto(field.getOptions())).build();
    }

    private static SchemaApi.FieldType fieldTypeToProto(Schema.FieldType fieldType, boolean serializeLogicalType) {
        SchemaApi.FieldType.Builder builder = SchemaApi.FieldType.newBuilder();
        switch (fieldType.getTypeName()) {
            case ROW: {
                builder.setRowType(SchemaApi.RowType.newBuilder().setSchema(SchemaTranslation.schemaToProto(fieldType.getRowSchema(), serializeLogicalType)));
                break;
            }
            case ARRAY: {
                builder.setArrayType(SchemaApi.ArrayType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType(), serializeLogicalType)));
                break;
            }
            case ITERABLE: {
                builder.setIterableType(SchemaApi.IterableType.newBuilder().setElementType(SchemaTranslation.fieldTypeToProto(fieldType.getCollectionElementType(), serializeLogicalType)));
                break;
            }
            case MAP: {
                builder.setMapType(SchemaApi.MapType.newBuilder().setKeyType(SchemaTranslation.fieldTypeToProto(fieldType.getMapKeyType(), serializeLogicalType)).setValueType(SchemaTranslation.fieldTypeToProto(fieldType.getMapValueType(), serializeLogicalType)).build());
                break;
            }
            case LOGICAL_TYPE: {
                SchemaApi.LogicalType.Builder logicalTypeBuilder;
                Schema.LogicalType logicalType = fieldType.getLogicalType();
                if (STANDARD_LOGICAL_TYPES.containsKey(logicalType.getIdentifier())) {
                    Preconditions.checkArgument(logicalType.getArgumentType() == null, "Logical type '%s' cannot be used as a logical type, it has a non-null argument type.", (Object)logicalType.getIdentifier());
                    logicalTypeBuilder = SchemaApi.LogicalType.newBuilder().setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType(), serializeLogicalType)).setUrn(logicalType.getIdentifier());
                } else if (logicalType instanceof UnknownLogicalType) {
                    logicalTypeBuilder = SchemaApi.LogicalType.newBuilder().setUrn(logicalType.getIdentifier()).setPayload(ByteString.copyFrom(((UnknownLogicalType)logicalType).getPayload())).setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType(), serializeLogicalType));
                    if (logicalType.getArgumentType() != null) {
                        logicalTypeBuilder.setArgumentType(SchemaTranslation.fieldTypeToProto(logicalType.getArgumentType(), serializeLogicalType)).setArgument(SchemaTranslation.fieldValueToProto(logicalType.getArgumentType(), logicalType.getArgument()));
                    }
                } else {
                    logicalTypeBuilder = SchemaApi.LogicalType.newBuilder().setRepresentation(SchemaTranslation.fieldTypeToProto(logicalType.getBaseType(), serializeLogicalType)).setUrn(URN_BEAM_LOGICAL_JAVASDK);
                    if (logicalType.getArgumentType() != null) {
                        logicalTypeBuilder = logicalTypeBuilder.setArgumentType(SchemaTranslation.fieldTypeToProto(logicalType.getArgumentType(), serializeLogicalType)).setArgument(SchemaTranslation.fieldValueToProto(logicalType.getArgumentType(), logicalType.getArgument()));
                    }
                    if (serializeLogicalType) {
                        logicalTypeBuilder = logicalTypeBuilder.setPayload(ByteString.copyFrom(SerializableUtils.serializeToByteArray(logicalType)));
                    }
                }
                builder.setLogicalType(logicalTypeBuilder.build());
                break;
            }
            case DATETIME: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DATETIME).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.INT64, serializeLogicalType)).build());
                break;
            }
            case DECIMAL: {
                builder.setLogicalType(SchemaApi.LogicalType.newBuilder().setUrn(URN_BEAM_LOGICAL_DECIMAL).setRepresentation(SchemaTranslation.fieldTypeToProto(Schema.FieldType.BYTES, serializeLogicalType)).build());
                break;
            }
            case BYTE: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTE);
                break;
            }
            case INT16: {
                builder.setAtomicType(SchemaApi.AtomicType.INT16);
                break;
            }
            case INT32: {
                builder.setAtomicType(SchemaApi.AtomicType.INT32);
                break;
            }
            case INT64: {
                builder.setAtomicType(SchemaApi.AtomicType.INT64);
                break;
            }
            case FLOAT: {
                builder.setAtomicType(SchemaApi.AtomicType.FLOAT);
                break;
            }
            case DOUBLE: {
                builder.setAtomicType(SchemaApi.AtomicType.DOUBLE);
                break;
            }
            case STRING: {
                builder.setAtomicType(SchemaApi.AtomicType.STRING);
                break;
            }
            case BOOLEAN: {
                builder.setAtomicType(SchemaApi.AtomicType.BOOLEAN);
                break;
            }
            case BYTES: {
                builder.setAtomicType(SchemaApi.AtomicType.BYTES);
            }
        }
        builder.setNullable(fieldType.getNullable());
        return builder.build();
    }

    public static Schema schemaFromProto(SchemaApi.Schema protoSchema) {
        Schema.Builder builder = Schema.builder();
        HashMap<String, Integer> encodingLocationMap = Maps.newHashMap();
        for (SchemaApi.Field protoField : protoSchema.getFieldsList()) {
            Schema.Field field;
            try {
                field = SchemaTranslation.fieldFromProto(protoField);
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to decode Schema due to an error decoding Field proto:\n\n" + protoField, e);
            }
            builder.addField(field);
            encodingLocationMap.put(protoField.getName(), protoField.getEncodingPosition());
        }
        builder.setOptions(SchemaTranslation.optionsFromProto(protoSchema.getOptionsList()));
        Schema schema = builder.build();
        Preconditions.checkState(encodingLocationMap.size() == schema.getFieldCount());
        long dinstictEncodingPositions = encodingLocationMap.values().stream().distinct().count();
        Preconditions.checkState(dinstictEncodingPositions <= (long)schema.getFieldCount());
        if (dinstictEncodingPositions < (long)schema.getFieldCount() && schema.getFieldCount() > 0) {
            Preconditions.checkState(dinstictEncodingPositions == 1L);
        } else if (protoSchema.getEncodingPositionsSet()) {
            schema.setEncodingPositions(encodingLocationMap);
        }
        if (!protoSchema.getId().isEmpty()) {
            schema.setUUID(UUID.fromString(protoSchema.getId()));
        }
        return schema;
    }

    private static Schema.Field fieldFromProto(SchemaApi.Field protoField) {
        return Schema.Field.of(protoField.getName(), SchemaTranslation.fieldTypeFromProto(protoField.getType())).withOptions(SchemaTranslation.optionsFromProto(protoField.getOptionsList())).withDescription(protoField.getDescription());
    }

    private static Schema.FieldType fieldTypeFromProto(SchemaApi.FieldType protoFieldType) {
        Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProtoWithoutNullable(protoFieldType);
        if (protoFieldType.getNullable()) {
            fieldType = fieldType.withNullable(true);
        }
        return fieldType;
    }

    private static Schema.FieldType fieldTypeFromProtoWithoutNullable(SchemaApi.FieldType protoFieldType) {
        switch (protoFieldType.getTypeInfoCase()) {
            case ATOMIC_TYPE: {
                switch (protoFieldType.getAtomicType()) {
                    case BYTE: {
                        return Schema.FieldType.of(Schema.TypeName.BYTE);
                    }
                    case INT16: {
                        return Schema.FieldType.of(Schema.TypeName.INT16);
                    }
                    case INT32: {
                        return Schema.FieldType.of(Schema.TypeName.INT32);
                    }
                    case INT64: {
                        return Schema.FieldType.of(Schema.TypeName.INT64);
                    }
                    case FLOAT: {
                        return Schema.FieldType.of(Schema.TypeName.FLOAT);
                    }
                    case DOUBLE: {
                        return Schema.FieldType.of(Schema.TypeName.DOUBLE);
                    }
                    case STRING: {
                        return Schema.FieldType.of(Schema.TypeName.STRING);
                    }
                    case BOOLEAN: {
                        return Schema.FieldType.of(Schema.TypeName.BOOLEAN);
                    }
                    case BYTES: {
                        return Schema.FieldType.of(Schema.TypeName.BYTES);
                    }
                    case UNSPECIFIED: {
                        throw new IllegalArgumentException("Encountered UNSPECIFIED AtomicType");
                    }
                }
                throw new IllegalArgumentException("Encountered unknown AtomicType: " + protoFieldType.getAtomicType());
            }
            case ROW_TYPE: {
                return Schema.FieldType.row(SchemaTranslation.schemaFromProto(protoFieldType.getRowType().getSchema()));
            }
            case ARRAY_TYPE: {
                return Schema.FieldType.array(SchemaTranslation.fieldTypeFromProto(protoFieldType.getArrayType().getElementType()));
            }
            case ITERABLE_TYPE: {
                return Schema.FieldType.iterable(SchemaTranslation.fieldTypeFromProto(protoFieldType.getIterableType().getElementType()));
            }
            case MAP_TYPE: {
                return Schema.FieldType.map(SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getKeyType()), SchemaTranslation.fieldTypeFromProto(protoFieldType.getMapType().getValueType()));
            }
            case LOGICAL_TYPE: {
                String urn = protoFieldType.getLogicalType().getUrn();
                Class<Schema.LogicalType<?, ?>> logicalTypeClass = STANDARD_LOGICAL_TYPES.get(urn);
                if (logicalTypeClass != null) {
                    try {
                        return Schema.FieldType.logicalType(logicalTypeClass.getConstructor(new Class[0]).newInstance(new Object[0]));
                    }
                    catch (NoSuchMethodException e) {
                        throw new RuntimeException(String.format("Standard logical type '%s' does not have a zero-argument constructor.", urn), e);
                    }
                    catch (IllegalAccessException e) {
                        throw new RuntimeException(String.format("Standard logical type '%s' has a zero-argument constructor, but it is not accessible.", urn), e);
                    }
                    catch (ReflectiveOperationException e) {
                        throw new RuntimeException(String.format("Error instantiating logical type '%s' with zero-argument constructor.", urn), e);
                    }
                }
                if (urn.equals(URN_BEAM_LOGICAL_DATETIME)) {
                    return Schema.FieldType.DATETIME;
                }
                if (urn.equals(URN_BEAM_LOGICAL_DECIMAL)) {
                    return Schema.FieldType.DECIMAL;
                }
                if (urn.equals(URN_BEAM_LOGICAL_JAVASDK)) {
                    return Schema.FieldType.logicalType((Schema.LogicalType)SerializableUtils.deserializeFromByteArray(protoFieldType.getLogicalType().getPayload().toByteArray(), "logicalType"));
                }
                @Nullable Schema.FieldType argumentType = null;
                Object argumentValue = null;
                if (protoFieldType.getLogicalType().hasArgumentType()) {
                    argumentType = SchemaTranslation.fieldTypeFromProto(protoFieldType.getLogicalType().getArgumentType());
                    argumentValue = SchemaTranslation.fieldValueFromProto(argumentType, protoFieldType.getLogicalType().getArgument());
                }
                return Schema.FieldType.logicalType(new UnknownLogicalType(urn, protoFieldType.getLogicalType().getPayload().toByteArray(), argumentType, argumentValue, SchemaTranslation.fieldTypeFromProto(protoFieldType.getLogicalType().getRepresentation())));
            }
        }
        throw new IllegalArgumentException("Unexpected type_info: " + protoFieldType.getTypeInfoCase());
    }

    public static SchemaApi.Row rowToProto(Row row) {
        SchemaApi.Row.Builder builder = SchemaApi.Row.newBuilder();
        for (int i = 0; i < row.getFieldCount(); ++i) {
            builder.addValues(SchemaTranslation.fieldValueToProto(row.getSchema().getField(i).getType(), row.getValue(i)));
        }
        return builder.build();
    }

    public static Object rowFromProto(SchemaApi.Row row, Schema.FieldType fieldType) {
        Row.Builder builder = Row.withSchema(fieldType.getRowSchema());
        for (int i = 0; i < row.getValuesCount(); ++i) {
            builder.addValue(SchemaTranslation.fieldValueFromProto(fieldType.getRowSchema().getField(i).getType(), row.getValues(i)));
        }
        return builder.build();
    }

    static SchemaApi.FieldValue fieldValueToProto(Schema.FieldType fieldType, Object value) {
        SchemaApi.FieldValue.Builder builder = SchemaApi.FieldValue.newBuilder();
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                return builder.setArrayValue(SchemaTranslation.arrayValueToProto(fieldType.getCollectionElementType(), (Iterable)value)).build();
            }
            case ITERABLE: {
                return builder.setIterableValue(SchemaTranslation.iterableValueToProto(fieldType.getCollectionElementType(), (Iterable)value)).build();
            }
            case MAP: {
                return builder.setMapValue(SchemaTranslation.mapToProto(fieldType.getMapKeyType(), fieldType.getMapValueType(), (Map)value)).build();
            }
            case ROW: {
                return builder.setRowValue(SchemaTranslation.rowToProto((Row)value)).build();
            }
        }
        return builder.setAtomicValue(SchemaTranslation.primitiveRowFieldToProto(fieldType, value)).build();
    }

    static Object fieldValueFromProto(Schema.FieldType fieldType, SchemaApi.FieldValue value) {
        switch (fieldType.getTypeName()) {
            case ARRAY: {
                return SchemaTranslation.arrayValueFromProto(fieldType.getCollectionElementType(), value.getArrayValue());
            }
            case ITERABLE: {
                return SchemaTranslation.iterableValueFromProto(fieldType.getCollectionElementType(), value.getIterableValue());
            }
            case MAP: {
                return SchemaTranslation.mapFromProto(fieldType.getMapKeyType(), fieldType.getMapValueType(), value.getMapValue());
            }
            case ROW: {
                return SchemaTranslation.rowFromProto(value.getRowValue(), fieldType);
            }
        }
        return SchemaTranslation.primitiveFromProto(fieldType, value.getAtomicValue());
    }

    private static SchemaApi.ArrayTypeValue arrayValueToProto(Schema.FieldType elementType, Iterable values) {
        return SchemaApi.ArrayTypeValue.newBuilder().addAllElement(Iterables.transform(values, e -> SchemaTranslation.fieldValueToProto(elementType, e))).build();
    }

    private static Iterable arrayValueFromProto(Schema.FieldType elementType, SchemaApi.ArrayTypeValue values) {
        return values.getElementList().stream().map(e -> SchemaTranslation.fieldValueFromProto(elementType, e)).collect(Collectors.toList());
    }

    private static SchemaApi.IterableTypeValue iterableValueToProto(Schema.FieldType elementType, Iterable values) {
        return SchemaApi.IterableTypeValue.newBuilder().addAllElement(Iterables.transform(values, e -> SchemaTranslation.fieldValueToProto(elementType, e))).build();
    }

    private static Object iterableValueFromProto(Schema.FieldType elementType, SchemaApi.IterableTypeValue values) {
        return values.getElementList().stream().map(e -> SchemaTranslation.fieldValueFromProto(elementType, e)).collect(Collectors.toList());
    }

    private static SchemaApi.MapTypeValue mapToProto(Schema.FieldType keyType, Schema.FieldType valueType, Map<Object, Object> map) {
        SchemaApi.MapTypeValue.Builder builder = SchemaApi.MapTypeValue.newBuilder();
        for (Map.Entry<Object, Object> entry : map.entrySet()) {
            SchemaApi.MapTypeEntry mapProtoEntry = SchemaApi.MapTypeEntry.newBuilder().setKey(SchemaTranslation.fieldValueToProto(keyType, entry.getKey())).setValue(SchemaTranslation.fieldValueToProto(valueType, entry.getValue())).build();
            builder.addEntries(mapProtoEntry);
        }
        return builder.build();
    }

    private static Object mapFromProto(Schema.FieldType mapKeyType, Schema.FieldType mapValueType, SchemaApi.MapTypeValue mapValue) {
        return mapValue.getEntriesList().stream().collect(Collectors.toMap(entry -> SchemaTranslation.fieldValueFromProto(mapKeyType, entry.getKey()), entry -> SchemaTranslation.fieldValueFromProto(mapValueType, entry.getValue())));
    }

    private static SchemaApi.AtomicTypeValue primitiveRowFieldToProto(Schema.FieldType fieldType, Object value) {
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return SchemaApi.AtomicTypeValue.newBuilder().setByte(((Byte)value).byteValue()).build();
            }
            case INT16: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt16(((Short)value).shortValue()).build();
            }
            case INT32: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt32((Integer)value).build();
            }
            case INT64: {
                return SchemaApi.AtomicTypeValue.newBuilder().setInt64((Long)value).build();
            }
            case FLOAT: {
                return SchemaApi.AtomicTypeValue.newBuilder().setFloat(((Float)value).floatValue()).build();
            }
            case DOUBLE: {
                return SchemaApi.AtomicTypeValue.newBuilder().setDouble((Double)value).build();
            }
            case STRING: {
                return SchemaApi.AtomicTypeValue.newBuilder().setString((String)value).build();
            }
            case BOOLEAN: {
                return SchemaApi.AtomicTypeValue.newBuilder().setBoolean((Boolean)value).build();
            }
            case BYTES: {
                return SchemaApi.AtomicTypeValue.newBuilder().setBytes(ByteString.copyFrom((byte[])value)).build();
            }
        }
        throw new RuntimeException("FieldType unexpected " + (Object)((Object)fieldType.getTypeName()));
    }

    private static Object primitiveFromProto(Schema.FieldType fieldType, SchemaApi.AtomicTypeValue value) {
        switch (fieldType.getTypeName()) {
            case BYTE: {
                return (byte)value.getByte();
            }
            case INT16: {
                return (short)value.getInt16();
            }
            case INT32: {
                return value.getInt32();
            }
            case INT64: {
                return value.getInt64();
            }
            case FLOAT: {
                return Float.valueOf(value.getFloat());
            }
            case DOUBLE: {
                return value.getDouble();
            }
            case STRING: {
                return value.getString();
            }
            case BOOLEAN: {
                return value.getBoolean();
            }
            case BYTES: {
                return value.getBytes().toByteArray();
            }
        }
        throw new RuntimeException("FieldType unexpected " + (Object)((Object)fieldType.getTypeName()));
    }

    private static List<SchemaApi.Option> optionsToProto(Schema.Options options) {
        ArrayList<SchemaApi.Option> protoOptions = new ArrayList<SchemaApi.Option>();
        for (String name : options.getOptionNames()) {
            protoOptions.add(SchemaApi.Option.newBuilder().setName(name).setType(SchemaTranslation.fieldTypeToProto(Objects.requireNonNull(options.getType(name)), false)).setValue(SchemaTranslation.fieldValueToProto(Objects.requireNonNull(options.getType(name)), options.getValue(name))).build());
        }
        return protoOptions;
    }

    private static Schema.Options optionsFromProto(List<SchemaApi.Option> protoOptions) {
        Schema.Options.Builder optionBuilder = Schema.Options.builder();
        for (SchemaApi.Option protoOption : protoOptions) {
            Schema.FieldType fieldType = SchemaTranslation.fieldTypeFromProto(protoOption.getType());
            optionBuilder.setOption(protoOption.getName(), fieldType, SchemaTranslation.fieldValueFromProto(fieldType, protoOption.getValue()));
        }
        return optionBuilder.build();
    }
}

