/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.schemas;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeSet;
import java.util.function.Function;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.JavaBeanSchema;
import org.apache.beam.sdk.schemas.JavaFieldSchema;
import org.apache.beam.sdk.schemas.NoSuchSchemaException;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.schemas.SchemaCoder;
import org.apache.beam.sdk.schemas.SchemaProvider;
import org.apache.beam.sdk.schemas.SchemaProviderRegistrar;
import org.apache.beam.sdk.schemas.annotations.DefaultSchema;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.util.common.ReflectHelpers;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Lists;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Sets;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class SchemaRegistry {
    private static final List<SchemaProvider> REGISTERED_SCHEMA_PROVIDERS;
    private final Map<TypeDescriptor, SchemaEntry> entries = Maps.newHashMap();
    private final ArrayDeque<SchemaProvider> providers;
    private final PerTypeRegisteredProvider perTypeRegisteredProviders = new PerTypeRegisteredProvider();

    private SchemaRegistry() {
        this.providers = new ArrayDeque<SchemaProvider>(REGISTERED_SCHEMA_PROVIDERS);
        this.providers.addFirst(this.perTypeRegisteredProviders);
    }

    public static SchemaRegistry createDefault() {
        return new SchemaRegistry();
    }

    public <T> void registerSchemaForClass(Class<T> clazz, Schema schema, SerializableFunction<T, Row> toRow, SerializableFunction<Row, T> fromRow) {
        this.registerSchemaForType(TypeDescriptor.of(clazz), schema, toRow, fromRow);
    }

    public <T> void registerSchemaForType(TypeDescriptor<T> type, Schema schema, SerializableFunction<T, Row> toRow, SerializableFunction<Row, T> fromRow) {
        this.entries.put(type, new SchemaEntry<T>(schema, toRow, fromRow));
    }

    public void registerSchemaProvider(SchemaProvider schemaProvider) {
        this.providers.addFirst(schemaProvider);
    }

    public <T> void registerSchemaProvider(Class<T> clazz, SchemaProvider schemaProvider) {
        this.registerSchemaProvider(TypeDescriptor.of(clazz), schemaProvider);
    }

    public <T> void registerSchemaProvider(TypeDescriptor<T> typeDescriptor, SchemaProvider schemaProvider) {
        this.perTypeRegisteredProviders.registerProvider(typeDescriptor, schemaProvider);
    }

    public <T> void registerPOJO(Class<T> clazz) {
        this.registerPOJO(TypeDescriptor.of(clazz));
    }

    public <T> void registerPOJO(TypeDescriptor<T> typeDescriptor) {
        this.registerSchemaProvider(typeDescriptor, (SchemaProvider)new JavaFieldSchema());
    }

    public <T> void registerJavaBean(Class<T> clazz) {
        this.registerJavaBean(TypeDescriptor.of(clazz));
    }

    public <T> void registerJavaBean(TypeDescriptor<T> typeDescriptor) {
        this.registerSchemaProvider(typeDescriptor, (SchemaProvider)new JavaBeanSchema());
    }

    public <T> Schema getSchema(Class<T> clazz) throws NoSuchSchemaException {
        return this.getSchema(TypeDescriptor.of(clazz));
    }

    public <T> Schema getSchema(TypeDescriptor<T> typeDescriptor) throws NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.schema;
        }
        return this.getProviderResult(p -> p.schemaFor(typeDescriptor));
    }

    public <T> SerializableFunction<T, Row> getToRowFunction(Class<T> clazz) throws NoSuchSchemaException {
        return this.getToRowFunction(TypeDescriptor.of(clazz));
    }

    public <T> SerializableFunction<T, Row> getToRowFunction(TypeDescriptor<T> typeDescriptor) throws NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.toRow;
        }
        return this.getProviderResult(p -> p.toRowFunction(typeDescriptor));
    }

    public <T> SerializableFunction<Row, T> getFromRowFunction(Class<T> clazz) throws NoSuchSchemaException {
        return this.getFromRowFunction(TypeDescriptor.of(clazz));
    }

    public <T> SerializableFunction<Row, T> getFromRowFunction(TypeDescriptor<T> typeDescriptor) throws NoSuchSchemaException {
        SchemaEntry entry = this.entries.get(typeDescriptor);
        if (entry != null) {
            return entry.fromRow;
        }
        return this.getProviderResult(p -> p.fromRowFunction(typeDescriptor));
    }

    public <T> SchemaCoder<T> getSchemaCoder(Class<T> clazz) throws NoSuchSchemaException {
        return this.getSchemaCoder(TypeDescriptor.of(clazz));
    }

    public <T> SchemaCoder<T> getSchemaCoder(TypeDescriptor<T> typeDescriptor) throws NoSuchSchemaException {
        return SchemaCoder.of(this.getSchema(typeDescriptor), typeDescriptor, this.getToRowFunction(typeDescriptor), this.getFromRowFunction(typeDescriptor));
    }

    private <ReturnT> ReturnT getProviderResult(Function<SchemaProvider, ReturnT> f) throws NoSuchSchemaException {
        for (SchemaProvider provider : this.providers) {
            ReturnT result = f.apply(provider);
            if (result == null) continue;
            return result;
        }
        throw new NoSuchSchemaException();
    }

    static {
        ArrayList<SchemaProvider> providersToRegister = Lists.newArrayList();
        TreeSet<Object> registrars = Sets.newTreeSet(ReflectHelpers.ObjectsClassComparator.INSTANCE);
        registrars.addAll(Lists.newArrayList(ServiceLoader.load(SchemaProviderRegistrar.class, ReflectHelpers.findClassLoader())));
        providersToRegister.addAll(new DefaultSchema.DefaultSchemaProviderRegistrar().getSchemaProviders());
        for (SchemaProviderRegistrar schemaProviderRegistrar : registrars) {
            providersToRegister.addAll(schemaProviderRegistrar.getSchemaProviders());
        }
        REGISTERED_SCHEMA_PROVIDERS = ImmutableList.copyOf(providersToRegister);
    }

    private static class PerTypeRegisteredProvider
    implements SchemaProvider {
        private final Map<TypeDescriptor, SchemaProvider> providers = Maps.newHashMap();

        private PerTypeRegisteredProvider() {
        }

        void registerProvider(TypeDescriptor typeDescriptor, SchemaProvider schemaProvider) {
            this.providers.put(typeDescriptor, schemaProvider);
        }

        @Override
        public <T> @Nullable Schema schemaFor(TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.schemaFor(type);
        }

        @Override
        public <T> @Nullable SerializableFunction<T, Row> toRowFunction(TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.toRowFunction(type);
        }

        @Override
        public <T> @Nullable SerializableFunction<Row, T> fromRowFunction(TypeDescriptor<T> typeDescriptor) {
            TypeDescriptor<T> type = typeDescriptor;
            SchemaProvider schemaProvider;
            while ((schemaProvider = this.providers.get(type)) == null) {
                Class<T> superClass = type.getRawType().getSuperclass();
                if (superClass == null || superClass.equals(Object.class)) {
                    return null;
                }
                type = TypeDescriptor.of(superClass);
            }
            return schemaProvider.fromRowFunction(type);
        }
    }

    private static class SchemaEntry<T> {
        private final Schema schema;
        private final SerializableFunction<T, Row> toRow;
        private final SerializableFunction<Row, T> fromRow;

        SchemaEntry(Schema schema, SerializableFunction<T, Row> toRow, SerializableFunction<Row, T> fromRow) {
            this.schema = schema;
            this.toRow = toRow;
            this.fromRow = fromRow;
        }
    }
}

